/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AccountViewHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.helper.DynamicObjectHelper;

public class MfgFeeAssgrpEditPlugin
extends AbstractBillPlugIn
implements ClickListener {
    private static final Log logger = LogFactory.getLog(MfgFeeAssgrpEditPlugin.class);
    private static final String FIELD_VALUESOURCENUMBER = "valuesource.number";
    private static final String ORG = "org";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_NAME = "fieldname";
    private static final String VALUE = "value";
    private static final String asstEntry = "bd_asstacttype";
    private static final String btnOk = "okbtn";
    private static final String entryEntity = "entryentity";

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{btnOk});
        BasedataEdit acc = (BasedataEdit)this.getControl(FIELD_NAME);
        acc.addBeforeF7SelectListener(e -> {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            ArrayList<String> ffList = new ArrayList<String>();
            DynamicObjectCollection dync = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject dyn : dync) {
                DynamicObject fieldname = dyn.getDynamicObject(FIELD_NAME);
                if (fieldname == null) continue;
                String flexfield = fieldname.getString("flexfield");
                ffList.add(flexfield);
            }
            qFilters.add(new QFilter("valuetype", "!=", (Object)"3"));
            qFilters.add(new QFilter("flexfield", "not in", ffList));
            String flexStr = this.getPageCache().get("flexfield");
            if (flexStr != null) {
                Set<String> flexSet = this.getAccountFlexField();
                QFilter fflex = new QFilter("flexfield", "in", flexSet);
                qFilters.add(fflex);
            }
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.setQFilters(qFilters);
        });
        BasedataEdit ass = (BasedataEdit)this.getControl(VALUE);
        ass.addBeforeF7SelectListener(e -> {
            String valuetype;
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dyn = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            DynamicObject assisType = dyn.getDynamicObject(FIELD_NAME);
            if (assisType == null) {
                e.setCancel(true);
                return;
            }
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            List<QFilter> orgFilters = this.getValueSourceFilterBeforeF7(assisType);
            if (orgFilters.size() > 0) {
                filterParam.getQFilters().addAll(orgFilters);
            }
            if (!"2".equals(valuetype = assisType.getString("valuetype"))) {
                return;
            }
            DynamicObject valueSource = assisType.getDynamicObject("assistanttype");
            String number = valueSource.getString("number");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("group.number", "=", (Object)number));
            filterParam.setQFilters(qFilters);
        });
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customValue = formShowParameter.getCustomParams();
        if (customValue == null) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue(ORG, customValue.get("orgId"));
        this.intialAssist();
        this.fillAssgrpValue((String)customValue.get("assgrp"), (String)customValue.get("assgrpcondition"));
    }

    private void fillAssgrpValue(String assgrp, String assgrpCondition) {
        if (StringUtils.isEmpty((CharSequence)assgrp)) {
            return;
        }
        Map assgrpMap = (Map)SerializationUtils.fromJsonString((String)assgrp, Map.class);
        if (CadEmptyUtils.isEmpty((Map)assgrpMap)) {
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entry)) {
            return;
        }
        Map assgrpConditionMap = CadEmptyUtils.isEmpty((String)assgrpCondition) ? new HashMap(8) : (Map)SerializationUtils.fromJsonString((String)assgrpCondition, Map.class);
        MainEntityType type = this.getModel().getDataEntityType();
        for (DynamicObject row : entry) {
            String flexField = row.getString("fieldname.flexfield");
            List valueList = (List)assgrpMap.get(flexField);
            if (valueList == null || valueList.size() == 0) continue;
            this.getModel().setValue("condition", assgrpConditionMap.get(flexField), row.getInt("seq") - 1);
            this.setValueProp(row.getDynamicObject(FIELD_NAME), type);
            ArrayList<Long> valList = new ArrayList<Long>(10);
            for (String id : valueList) {
                valList.add(Long.parseLong(id));
            }
            this.getModel().setValue(VALUE, (Object)valList.toArray(), row.getInt("seq") - 1);
        }
    }

    private void intialAssist() {
        Set<String> flexSet = this.getAccountFlexField();
        if (flexSet.size() > 0) {
            IDataModel model = this.getModel();
            HashSet<String> selFlexSet = new HashSet<String>();
            DynamicObjectCollection coll = model.getEntryEntity("entryentity");
            for (DynamicObject row : coll) {
                DynamicObject fieldname = row.getDynamicObject(FIELD_NAME);
                if (fieldname == null) continue;
                String flexfield = fieldname.getString("flexfield");
                selFlexSet.add(flexfield);
            }
            flexSet.removeAll(selFlexSet);
            ArrayList<Long> asstIds = new ArrayList<Long>();
            if (flexSet.size() < 1) {
                return;
            }
            QFilter filter = new QFilter("flexfield", "in", flexSet);
            DataSet asstSet = QueryServiceHelper.queryDataSet((String)"intialAssist", (String)asstEntry, (String)"id", (QFilter[])new QFilter[]{filter}, null);
            for (Row row : asstSet) {
                asstIds.add(row.getLong("id"));
            }
            if (asstIds.size() > 0) {
                int[] newEntryRows;
                int idIndex = 0;
                for (int rowIndex : newEntryRows = model.batchCreateNewEntryRow("entryentity", asstIds.size())) {
                    model.setValue(FIELD_NAME, asstIds.get(idIndex), rowIndex);
                    ++idIndex;
                }
            }
        }
    }

    private Set<String> getAccountFlexField() {
        Map customValue = this.getView().getFormShowParameter().getCustomParams();
        HashSet<Long> accountIdSet = new HashSet<Long>();
        String accountId = (String)customValue.get("accountId");
        if (StringUtils.isBlank((CharSequence)accountId)) {
            accountIdSet.add(-1L);
        } else {
            for (String id : accountId.split(",")) {
                accountIdSet.add(Long.parseLong(id));
            }
        }
        Set resultAccountViewIds = AccountViewHelper.getLeafAccountViewByIds(accountIdSet);
        return this.getAssistByAcc(resultAccountViewIds);
    }

    private Set<String> getAssistByAcc(Set<Long> accountIdSet) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        QFilter accFilter = new QFilter("id", "in", accountIdSet);
        String fields = "checkitementry.asstactitem.flexfield AS flexfield, checkitementry.asstactitem.valuesource.number AS entityNum";
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_accountview", (String)fields, (QFilter[])new QFilter[]{accFilter});
        for (DynamicObject col : cols) {
            result.add(col.getString("flexfield"));
        }
        return result;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(btnOk)) {
            this.returnToData();
        }
    }

    public void returnToData() {
        HashMap<String, String> para = new HashMap<String, String>();
        IFormView view = this.getView();
        para.put(VALUE, DynamicObjectHelper.toDynamicObjectJson(this.getModel().getDataEntity(true)));
        para.put("express", this.parseExp());
        String type = (String)view.getFormShowParameter().getCustomParams().get("type");
        String index = (String)view.getFormShowParameter().getCustomParams().get("index");
        para.put("type", type);
        para.put("index", index);
        view.returnDataToParent(para);
        view.close();
    }

    private String parseExp() {
        IDataModel model = this.getModel();
        String expression = "";
        DynamicObjectCollection entryCollection = model.getEntryEntity("entryentity");
        for (int i = 0; i < entryCollection.size(); ++i) {
            DynamicObject rowDyn = (DynamicObject)entryCollection.get(i);
            DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, i);
            if (assisType == null) continue;
            DynamicObject valueSource = null;
            String entityId = null;
            String valuetype = assisType.getString("valuetype");
            if ("1".equals(valuetype)) {
                valueSource = assisType.getDynamicObject("valuesource");
                entityId = valueSource.getString("id");
            } else if ("2".equals(valuetype)) {
                valueSource = assisType.getDynamicObject("assistanttype");
                entityId = "bos_assistantdata_detail";
            }
            String condition = rowDyn.getString("condition");
            DynamicObjectCollection collValues = rowDyn.getDynamicObjectCollection(VALUE);
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)collValues)) continue;
            if (CadEmptyUtils.isEmpty((String)condition)) {
                condition = ":";
            }
            if (valueSource == null) continue;
            String fieldName = rowDyn.getDynamicObject(FIELD_NAME).getLocaleString("name").getLocaleValue();
            if (fieldName == null) {
                fieldName = "";
            }
            expression = expression.isEmpty() ? fieldName + " " + condition + " " : expression + "\uff1b" + fieldName + " " + condition + " ";
            String valName = " ";
            if (collValues != null && collValues.size() > 0) {
                ArrayList<Long> valIds = new ArrayList<Long>();
                for (DynamicObject value : collValues) {
                    long id = value.getLong("fbasedataid_id");
                    valIds.add(id);
                }
                QFilter fQFilter = new QFilter("id", "in", valIds);
                try {
                    DynamicObjectCollection coll = QueryServiceHelper.query((String)entityId, (String)"name", (QFilter[])new QFilter[]{fQFilter});
                    for (DynamicObject value : coll) {
                        String name = value.getString("name");
                        if (valName.trim().isEmpty()) {
                            valName = name;
                            continue;
                        }
                        valName = valName + "," + name;
                    }
                }
                catch (Exception e) {
                    logger.error("\u89e3\u6790\u8868\u8fbe\u5f0f\u5f02\u5e38", (Throwable)e);
                }
            }
            expression = expression + valName;
        }
        return expression;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        IDataModel model = this.getModel();
        MainEntityType type = model.getDataEntityType();
        int rowIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, rowIndex);
        this.setValueProp(assisType, type);
    }

    private void setValueProp(DynamicObject assisType, MainEntityType type) {
        EntryProp entry = (EntryProp)type.getProperty("entryentity");
        MulBasedataProp prop = (MulBasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(VALUE);
        if (assisType == null) {
            return;
        }
        DynamicObject valueSource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("valuesource");
            entityId = valueSource.getString("id");
        } else if ("2".equals(valuetype)) {
            valueSource = assisType.getDynamicObject("assistanttype");
            entityId = "bos_assistantdata_detail";
        }
        if (valueSource != null) {
            prop.setBaseEntityId(entityId);
            BasedataProp baseProp = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
            baseProp.setBaseEntityId(entityId);
            baseProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
        }
    }

    public List<QFilter> getValueSourceFilterBeforeF7(DynamicObject assisType) {
        ArrayList<QFilter> retFilters = new ArrayList<QFilter>();
        if (assisType == null) {
            return retFilters;
        }
        String entityNum = assisType.getString(FIELD_VALUESOURCENUMBER);
        if ("bos_costcenter".equals(entityNum)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            retFilters.add(new QFilter("accountorg", "=", org.get("id")));
        }
        return retFilters;
    }
}

