/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.feealloc;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.webapi.RowMapper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.enums.SrcBillEnum;
import kd.macc.cad.common.helper.AccountViewHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.ScaMfgFeeImpSchEnum;
import kd.macc.sca.common.helper.DynamicObjectHelper;

public class MfgFeeImpSchEditPlugin
extends AbstractBillPlugIn {
    private static final String amortAssgrpEntity = "sca_amortassgrp";

    public void initialize() {
        super.initialize();
        this.initFilter();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"showassgrp"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("showassgrp".equals(key)) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex("entryentity");
            this.showAssgrpValue(index);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map resultMap;
        super.closedCallBack(e);
        if (e.getReturnData() == null) {
            return;
        }
        if (amortAssgrpEntity.equals(e.getActionId()) && (resultMap = (Map)e.getReturnData()).get("value") != null) {
            String expression = (String)resultMap.get("express");
            String strObj = (String)resultMap.get("value");
            String indexStr = (String)resultMap.get("index");
            int index = 0;
            if (StringUtils.isBlank((CharSequence)indexStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u8868\u8fbe\u5f0f\u3002", (String)"MfgFeeImpSchEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            index = Integer.parseInt(indexStr);
            if (expression.length() > 100) {
                expression = expression.substring(0, 100) + "...";
            }
            this.getModel().setValue("showassgrp", (Object)expression, index);
            DynamicObject assgrpCollec = DynamicObjectHelper.fromDynamicString(strObj, EntityMetadataCache.getDataEntityType((String)amortAssgrpEntity));
            if (assgrpCollec != null) {
                HashMap<String, List> srcAssgrpMap = new HashMap<String, List>(16);
                HashMap<String, String> assgrpConditionMap = new HashMap<String, String>(16);
                DynamicObjectCollection assgrpRows = assgrpCollec.getDynamicObjectCollection("entryentity");
                for (DynamicObject assgrpRow : assgrpRows) {
                    DynamicObject assgrp = assgrpRow.getDynamicObject("fieldname");
                    DynamicObjectCollection assgrpValues = assgrpRow.getDynamicObjectCollection("value");
                    if (CadEmptyUtils.isEmpty((DynamicObjectCollection)assgrpValues)) continue;
                    String condition = assgrpRow.getString("condition");
                    String assgrpFlexField = assgrp.getString("flexfield");
                    assgrpConditionMap.put(assgrpFlexField, condition);
                    for (int i = 0; i < assgrpValues.size(); ++i) {
                        srcAssgrpMap.computeIfAbsent(assgrpFlexField, s -> new ArrayList()).add(((DynamicObject)assgrpValues.get(i)).getString("fbasedataid_id"));
                    }
                }
                String jsonString = SerializationUtils.toJsonString(srcAssgrpMap);
                this.getModel().setValue("assgrpcondition", (Object)SerializationUtils.toJsonString(assgrpConditionMap));
                this.getModel().setValue("assgrp", (Object)jsonString, index);
            }
        }
    }

    public void afterBindData(EventObject e) {
        Long id = (Long)this.getModel().getValue("id");
        QFilter accFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"sca_mfgfeeimpsch", (String)"id", (QFilter[])new QFilter[]{accFilter});
        this.setManuOrg();
        this.fillComboBox();
        if (!CadEmptyUtils.isEmpty((Long)id) && dynamicObject != null) {
            this.fillAssgrp();
            this.limitValueEdit();
            this.setEntryInputEnable();
        } else {
            if (!"copy".equals(this.getView().getFormShowParameter().getCustomParam("operate"))) {
                this.initByListData();
            }
            this.initBill();
            AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        }
        this.hideAcaFields();
        this.setSrcField();
        this.getModel().setDataChanged(false);
    }

    private void setSrcField() {
        String groupField = (String)this.getModel().getValue("groupfield");
        boolean mustInputSrcField = !CadEmptyUtils.isEmpty((String)groupField);
        this.getView().setVisible(Boolean.valueOf(mustInputSrcField), new String[]{"srcfield"});
        TextEdit textEdit = (TextEdit)this.getControl("srcfield");
        textEdit.setMustInput(mustInputSrcField);
    }

    private void hideAcaFields() {
        String curAppNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
        if ("aca".equalsIgnoreCase(curAppNum)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"benefcostcenter", "benefcostcentertype"});
        }
        if ("sca".equalsIgnoreCase(curAppNum) || "eca".equalsIgnoreCase(curAppNum)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"productgroup"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        switch (proName = e.getProperty().getName()) {
            case "srcbizsys": {
                this.cleanFieldValue();
                this.fillAmountItem();
                this.setFieldVisibleBySys();
                this.setSrcBill();
                this.setCenterAndExp();
                break;
            }
            case "costaccount": {
                this.setAccountBook();
                this.setManuOrg();
                break;
            }
            case "srcbill": {
                this.setCenterAndExp();
                break;
            }
            case "accountbook": {
                this.getModel().setValue("accountviews", null);
                break;
            }
            case "accountviews": {
                this.limitEntryEntity();
                this.cleanShowAssgrp();
                break;
            }
            case "showassgrp": {
                this.cleanAssgrp();
                break;
            }
            case "costcentertype": {
                this.setInputEnable(rowIndex, "costcentertype", "costcenter");
                break;
            }
            case "expenseitemtype": {
                this.setInputEnable(rowIndex, "expenseitemtype", "expenseitem");
                break;
            }
            case "benefcostcentertype": {
                this.setInputEnable(rowIndex, "benefcostcentertype", "benefcostcenter");
                break;
            }
            case "groupfield": {
                this.setSrcField();
            }
        }
    }

    private void cleanFieldValue() {
        this.getModel().setValue("amount", null);
    }

    public void setManuOrg() {
        long costId = this.getModel().getDataEntity().getLong("costaccount.id");
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costId);
        this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
        this.getView().setEnable(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
    }

    private void setEntryInputEnable() {
        this.setInputEnable(0, "costcentertype", "costcenter");
        this.setInputEnable(0, "expenseitemtype", "expenseitem");
        this.setInputEnable(0, "benefcostcentertype", "benefcostcenter");
    }

    private void cleanAssgrp() {
        String showAssgrp = (String)this.getModel().getValue("showassgrp");
        if (StringUtils.isEmpty((CharSequence)showAssgrp)) {
            this.getModel().setValue("assgrp", null);
            this.getModel().setValue("assgrpcondition", null);
        }
    }

    private void cleanShowAssgrp() {
        this.getModel().setValue("showassgrp", null);
        this.cleanAssgrp();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.checkAccountView(e);
                break;
            }
            case "submit": {
                this.checkAccountView(e);
                break;
            }
            case "submitandnew": {
                this.checkAccountView(e);
                this.checkEntryEntity(e);
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put("addtype", "execl");
        sourceData.put("appnum", AppIdHelper.getCurAppNum((IFormView)this.getView()));
        sourceData.put("billstatus", "A");
    }

    private void checkAccountView(BeforeDoOperationEventArgs e) {
        DynamicObject srcBizSys = (DynamicObject)this.getModel().getValue("srcbizsys");
        if (srcBizSys == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6765\u6e90\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgFeeImpSchEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
            e.setCancel(true);
        } else if ("gl".equals(srcBizSys.get("number"))) {
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("accountviews");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6765\u6e90\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MfgFeeImpSchEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else {
            long orgId = this.getModel().getDataEntity().getLong("org.id");
            long costAccountId = this.getModel().getDataEntity().getLong("costaccount.id");
            DynamicObject manuOrg = this.getModel().getDataEntity().getDynamicObject("manuorg");
            long manuOrgId = manuOrg == null ? 0L : manuOrg.getLong("id");
            String srcBill = this.getModel().getDataEntity().getString("srcbill");
            String appId = this.getView().getFormShowParameter().getAppId();
            QFilter qFilter = new QFilter("org", "=", (Object)orgId).and("srcbill", "=", (Object)srcBill).and("costaccount", "=", (Object)costAccountId).and("manuorg", "=", (Object)manuOrgId).and("appnum", "=", (Object)appId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"sca_mfgfeeimpsch", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObject != null) {
                long billId = this.getModel().getDataEntity().getLong("id");
                if (!CadEmptyUtils.isEmpty((Long)billId)) {
                    long pageId = dynamicObject.getLong("id");
                    if (billId != pageId) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u5df2\u6709\u5bf9\u5e94\u6765\u6e90\u5355\u636e\u7684\u5bfc\u5165\u65b9\u6848\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"MfgFeeImpSchEditPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u5df2\u6709\u5bf9\u5e94\u6765\u6e90\u5355\u636e\u7684\u5bfc\u5165\u65b9\u6848\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"MfgFeeImpSchEditPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]));
                    e.setCancel(true);
                }
            }
        }
    }

    private void limitEntryEntity() {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("accountviews");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return;
        }
        HashSet<String> valueSource = new HashSet<String>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (valueSource.size() == 2) break;
            Long id = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
            HashSet<Long> setIds = new HashSet<Long>();
            setIds.add(id);
            Set ids = AccountViewHelper.getLeafAccountViewByIds(setIds);
            for (Long accountViewId : ids) {
                Set<String> assValueSourceByAcc = this.getAssValueSourceByAcc(accountViewId);
                valueSource.addAll(assValueSourceByAcc);
            }
        }
        this.limitValueEdit(valueSource);
        this.setDefaultValue(valueSource);
    }

    private void setDefaultValue(Set<String> valueSourceNumSet) {
        IDataModel m = this.getModel();
        if (valueSourceNumSet.contains("bos_costcenter")) {
            m.setValue("costcentertype", (Object)ScaMfgFeeImpSchEnum.VALUETYPE_MATCH.getValue(), 0);
        } else {
            m.setValue("costcentertype", (Object)ScaMfgFeeImpSchEnum.VALUETYPE_FIXED.getValue(), 0);
        }
        if (valueSourceNumSet.contains("er_expenseitemedit")) {
            m.setValue("expenseitemtype", (Object)ScaMfgFeeImpSchEnum.VALUETYPE_MATCH.getValue(), 0);
        } else {
            m.setValue("expenseitemtype", (Object)ScaMfgFeeImpSchEnum.VALUETYPE_FIXED.getValue(), 0);
        }
    }

    private void limitValueEdit(Set<String> valueSourceNumSet) {
        IFormView v = this.getView();
        Boolean hasCostCenter = valueSourceNumSet.contains("bos_costcenter");
        boolean hasCostCenterSource = valueSourceNumSet.contains("mpdm_workcentre") || valueSourceNumSet.contains("bos_org") || valueSourceNumSet.contains("bos_adminorg");
        v.setEnable(Boolean.valueOf(hasCostCenter != false || hasCostCenterSource), 0, new String[]{"costcentertype"});
        Boolean hasExpenseItem = valueSourceNumSet.contains("er_expenseitemedit");
        v.setEnable(hasExpenseItem, 0, new String[]{"expenseitemtype"});
    }

    private void limitValueEdit() {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("accountviews");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
            return;
        }
        HashSet<String> valueSource = new HashSet<String>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (valueSource.size() == 2) break;
            Long id = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
            HashSet<Long> setIds = new HashSet<Long>();
            setIds.add(id);
            Set ids = AccountViewHelper.getLeafAccountViewByIds(setIds);
            for (Long accountViewId : ids) {
                Set<String> assValueSourceByAcc = this.getAssValueSourceByAcc(accountViewId);
                valueSource.addAll(assValueSourceByAcc);
            }
        }
        this.limitValueEdit(valueSource);
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            this.setDefaultValue(valueSource);
        }
    }

    private Set<String> getAssValueSourceByAcc(Long accountId) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(16);
        QFilter accFilter = new QFilter("id", "=", (Object)accountId);
        String fields = "checkitementry.asstactitem.valuesource.number AS valueSourceNum";
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_accountview", (String)fields, (QFilter[])new QFilter[]{accFilter});
        for (DynamicObject col : cols) {
            if (!"bos_costcenter".equals(col.getString("valueSourceNum")) && !"er_expenseitemedit".equals(col.getString("valueSourceNum"))) continue;
            result.add(col.getString("valueSourceNum"));
        }
        return result;
    }

    private void checkEntryEntity(BeforeDoOperationEventArgs e) {
        boolean isEmpty;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u7ef4\u62a4\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u3002", (String)"MfgFeeImpSchEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            e.setCancel(true);
        }
        DynamicObject entryEntityRow = (DynamicObject)entryEntity.get(0);
        String bizDate = entryEntityRow.getString("bizdate");
        String costcentertype = entryEntityRow.getString("costcentertype");
        String costcenter = entryEntityRow.getString("costcenter");
        String expenseitemtype = entryEntityRow.getString("expenseitemtype");
        String expenseitem = entryEntityRow.getString("expenseitem");
        String amount = entryEntityRow.getString("amount");
        DynamicObjectCollection benefcostcenter = entryEntityRow.getDynamicObjectCollection("benefcostcenter");
        boolean bl = isEmpty = StringUtils.isEmpty((CharSequence)bizDate) && StringUtils.isEmpty((CharSequence)costcentertype) && StringUtils.isEmpty((CharSequence)costcenter) && StringUtils.isEmpty((CharSequence)expenseitemtype) && StringUtils.isEmpty((CharSequence)expenseitem) && StringUtils.isEmpty((CharSequence)amount);
        if ("sca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            boolean bl2 = isEmpty = isEmpty && CadEmptyUtils.isEmpty((DynamicObjectCollection)benefcostcenter);
        }
        if (isEmpty) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u7ef4\u62a4\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u3002", (String)"MfgFeeImpSchEditPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void fillAssgrp() {
        String assgrp = (String)this.getModel().getValue("assgrp");
        if (StringUtils.isEmpty((CharSequence)assgrp)) {
            return;
        }
        Map assgrpMap = (Map)SerializationUtils.fromJsonString((String)assgrp, Map.class);
        if (CadEmptyUtils.isEmpty((Map)assgrpMap)) {
            return;
        }
        String assgrpCondition = (String)this.getModel().getValue("assgrpcondition");
        Map assgrpConditionMap = CadEmptyUtils.isEmpty((String)assgrpCondition) ? new HashMap(8) : (Map)SerializationUtils.fromJsonString((String)assgrpCondition, Map.class);
        StringBuilder sb = new StringBuilder();
        Map<String, String> asstactTypeMap = this.getAsstactTypeMap(assgrpMap);
        for (Map.Entry entrySet : assgrpMap.entrySet()) {
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (String value : (List)entrySet.getValue()) {
                ids.add(Long.parseLong(value));
            }
            String valuesourceStr = asstactTypeMap.get(entrySet.getKey());
            if (valuesourceStr == null) continue;
            String[] valuesourceArr = valuesourceStr.split("@");
            DynamicObjectCollection valueCollec = QueryServiceHelper.query((String)valuesourceArr[0], (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)valueCollec)) continue;
            String condition = (String)assgrpConditionMap.get(entrySet.getKey());
            if (CadEmptyUtils.isEmpty((String)condition)) {
                condition = ":";
            }
            sb.append(valuesourceArr[1]).append(" ").append(condition).append(" ");
            for (int i = 0; i < valueCollec.size(); ++i) {
                if (i + 1 < valueCollec.size()) {
                    sb.append(((DynamicObject)valueCollec.get(i)).getString("name")).append(',');
                    continue;
                }
                sb.append(((DynamicObject)valueCollec.get(i)).getString("name")).append(';');
            }
        }
        this.getModel().setValue("showassgrp", (Object)sb.toString());
    }

    private Map<String, String> getAsstactTypeMap(Map<String, List<String>> assgrpMap) {
        Set<String> srcAssgrpNumSet = assgrpMap.keySet();
        DynamicObjectCollection asstactTypes = QueryServiceHelper.query((String)"bd_asstacttype", (String)"id, flexfield,valuetype,name, valuesource.number AS valuesourceNum, valuesource.name AS valuesourceName", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", srcAssgrpNumSet)});
        HashMap<String, String> asstactTypeMap = new HashMap<String, String>();
        for (DynamicObject asstactType : asstactTypes) {
            String valueType = asstactType.getString("valuetype");
            String valueSourceNum = asstactType.getString("valuesourceNum");
            String valueSourceName = asstactType.getString("valuesourceName");
            if ("1".equals(valueType)) {
                asstactTypeMap.put(asstactType.getString("flexfield"), valueSourceNum + "@" + valueSourceName);
            }
            if (!"2".equals(valueType)) continue;
            asstactTypeMap.put(asstactType.getString("flexfield"), "bos_assistantdata_detail@" + asstactType.getString("name"));
        }
        return asstactTypeMap;
    }

    private void setInputEnable(int rowIndex, String fieldType, String field) {
        String type = (String)this.getModel().getValue(fieldType, rowIndex);
        boolean isFixedValue = ScaMfgFeeImpSchEnum.VALUETYPE_FIXED.getValue().equals(type);
        this.getView().setEnable(Boolean.valueOf(isFixedValue), rowIndex, new String[]{field});
        if (!isFixedValue) {
            this.getModel().setValue(field, null, rowIndex);
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("costcenter");
            basedataEdit.setMustInput(false);
        } else if (!StringUtils.equals((CharSequence)"expenseitemtype", (CharSequence)fieldType)) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("costcenter");
            basedataEdit.setMustInput(true);
        }
    }

    private void fillAmountItem() {
        DynamicObject srcbizsys = (DynamicObject)this.getModel().getValue("srcbizsys");
        if (srcbizsys == null) {
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        items.add(blankItem);
        if ("gl".equals(srcbizsys.getString("number"))) {
            for (ScaMfgFeeImpSchEnum value : ScaMfgFeeImpSchEnum.values()) {
                if (!value.getEnumName().contentEquals("amount")) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(ScaMfgFeeImpSchEnum.getName(value.getValue())));
                item.setValue(value.getValue());
                items.add(item);
            }
        } else {
            for (ScaMfgFeeImpSchEnum value : ScaMfgFeeImpSchEnum.values()) {
                if (!value.getEnumName().contentEquals("localamt")) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(ScaMfgFeeImpSchEnum.getName(value.getValue())));
                item.setValue(value.getValue());
                items.add(item);
            }
            this.getModel().setValue("amount", (Object)"e_localamt");
        }
        ComboEdit amountEditor = (ComboEdit)this.getView().getControl("amount");
        amountEditor.setComboItems(items);
    }

    public void showAssgrpValue(int index) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(amortAssgrpEntity);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue("org_id");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "entryentity");
        map.put("index", index + "");
        map.put("orgId", orgId);
        StringJoiner accountViewIds = new StringJoiner(",");
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)model.getValue("accountviews");
        for (DynamicObject dynamicObject : dynamicObjects) {
            accountViewIds.add(dynamicObject.getDynamicObject("fbasedataid").getString("id"));
        }
        map.put("accountId", accountViewIds.toString());
        map.put("assgrp", this.getModel().getValue("assgrp"));
        map.put("assgrpcondition", this.getModel().getValue("assgrpcondition"));
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, amortAssgrpEntity));
        this.getView().showForm(parameter);
    }

    private void fillComboBox() {
        this.setFieldVisibleBySys();
        this.setSrcBill();
        this.fillAmountItem();
        this.setCenterAndExp();
    }

    private void setCenterAndExp() {
        DynamicObject srcBizSys = (DynamicObject)this.getModel().getValue("srcbizsys");
        if (srcBizSys == null) {
            return;
        }
        if ("ap".equals(srcBizSys.getString("number"))) {
            this.getModel().setValue("accountviews", null);
            this.getModel().setValue("accountbook", null);
            this.getModel().setValue("showassgrp", null);
            this.getModel().setValue("costcentertype", (Object)ScaMfgFeeImpSchEnum.VALUETYPE_MATCH.getValue(), 0);
            this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"costcentertype"});
            this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"costcenter"});
            this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"amount"});
            String billType = (String)this.getModel().getValue("srcbill");
            if (billType != null) {
                if (billType.equals("ap_process")) {
                    this.getModel().setValue("expenseitemtype", (Object)ScaMfgFeeImpSchEnum.VALUETYPE_FIXED.getValue(), 0);
                    this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"expenseitemtype"});
                } else {
                    this.getModel().setValue("expenseitemtype", (Object)ScaMfgFeeImpSchEnum.VALUETYPE_MATCH.getValue(), 0);
                    this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"expenseitemtype"});
                    this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"expenseitem"});
                }
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{"costcenter"});
            this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{"costcentertype"});
            this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{"expenseitemtype"});
            this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{"expenseitem"});
            this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{"amount"});
        }
    }

    private void setSrcBill() {
        DynamicObject srcBizSys = (DynamicObject)this.getModel().getValue("srcbizsys");
        if (srcBizSys == null) {
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if ("gl".equals(srcBizSys.getString("number"))) {
            for (SrcBillEnum value : SrcBillEnum.values()) {
                if (!value.getEnumName().contentEquals("gl")) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(SrcBillEnum.getName((String)value.getValue())));
                item.setValue(value.getValue());
                items.add(item);
            }
            this.getModel().setValue("srcbill", (Object)"gl_voucher");
            this.setFiledEnable(false, "srcbill");
        } else if ("ap".equals(srcBizSys.getString("number"))) {
            String billType = this.getModel().getDataEntity().getString("srcbill");
            if ("gl_voucher".equals(billType)) {
                this.getModel().setValue("srcbill", null);
            }
            for (SrcBillEnum value : SrcBillEnum.values()) {
                if (!value.getEnumName().contentEquals("ap")) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(SrcBillEnum.getName((String)value.getValue())));
                item.setValue(value.getValue());
                items.add(item);
            }
            this.setFiledEnable(true, "srcbill");
        }
        ComboEdit amountEditor = (ComboEdit)this.getView().getControl("srcbill");
        amountEditor.setComboItems(items);
    }

    private void setFieldVisibleBySys() {
        DynamicObject srcBizSys = (DynamicObject)this.getModel().getValue("srcbizsys");
        if (srcBizSys == null) {
            return;
        }
        if ("gl".equals(srcBizSys.getString("number"))) {
            this.setFiledVisible(true, "accountbook", "bookstype", "accountviews", "showassgrp");
            BasedataEdit accountView = (BasedataEdit)this.getControl("accountviews");
            accountView.setMustInput(true);
        } else if ("ap".equals(srcBizSys.getString("number"))) {
            this.setFiledVisible(false, "accountbook", "bookstype", "accountviews", "showassgrp");
            BasedataEdit accountView = (BasedataEdit)this.getControl("accountviews");
            accountView.setMustInput(false);
        }
    }

    private void setFiledVisible(Boolean flag, String ... fields) {
        for (String field : fields) {
            this.getView().setVisible(flag, new String[]{field});
        }
    }

    private void setFiledEnable(Boolean flag, String ... fields) {
        for (String field : fields) {
            this.getView().setEnable(flag, new String[]{field});
        }
    }

    private void setAccountBook() {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costaccount)) {
            this.getModel().setValue("accountbook", null);
            return;
        }
        Object id = costaccount.get("id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cal_bd_costaccount");
        String fields = "id,number,bookstype.accounttype as accounttype";
        QFilter orgQF = new QFilter("accountingsys", "=", dynamicObject.get("calsystem.id"));
        QFilter costaccountQF = new QFilter("b_entry.b_relatebook.fbasedataid", "in", costaccount.get("id"));
        QFilter[] qf = new QFilter[]{orgQF, costaccountQF};
        DynamicObjectCollection accountBooks = QueryServiceHelper.query((String)"gl_accountbook", (String)fields, (QFilter[])qf, (String)"number asc");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)accountBooks)) {
            this.getModel().setValue("accountbook", null);
        } else {
            Long accountId = 0L;
            for (DynamicObject accountBook : accountBooks) {
                if (!"1".equals(accountBook.getString("accounttype"))) continue;
                accountId = accountBook.getLong("id");
                break;
            }
            if (CadEmptyUtils.isEmpty((Long)accountId)) {
                this.getModel().setValue("accountbook", (Object)((DynamicObject)accountBooks.get(0)).getLong("id"));
            } else {
                this.getModel().setValue("accountbook", (Object)accountId);
            }
        }
    }

    private void initByListData() {
        IDataModel model = this.getModel();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            List orgIds;
            String costaccountId = parentView.getPageCache().get("costaccount");
            String manuorgId = (String)fsp.getCustomParam("manuorg");
            String orgIdStr = (String)fsp.getCustomParam("org");
            if (!CadEmptyUtils.isEmpty((String)orgIdStr) && !CadEmptyUtils.isEmpty((List)(orgIds = (List)SerializationUtils.fromJsonString((String)orgIdStr, List.class)))) {
                model.setValue("org", orgIds.get(0));
            }
            if (!CadEmptyUtils.isEmpty((String)costaccountId)) {
                model.setValue("costaccount", (Object)Long.parseLong(costaccountId));
            }
            if (costaccountId != null) {
                boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)Long.valueOf(costaccountId));
                if (!CadEmptyUtils.isEmpty((String)manuorgId) && enableMulFactory) {
                    model.setValue("manuorg", (Object)manuorgId);
                } else {
                    model.setValue("manuorg", null);
                    this.getView().setVisible(Boolean.valueOf(enableMulFactory), new String[]{"manuorg"});
                }
            }
        }
    }

    private void initBill() {
        QFilter numberQF = new QFilter("number", "=", (Object)"gl");
        QFilter[] qf = new QFilter[]{numberQF};
        DynamicObjectCollection bizApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])qf);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)bizApps)) {
            return;
        }
        this.getModel().setValue("srcbizsys", ((DynamicObject)bizApps.get(0)).get("id"));
    }

    private void initFilter() {
        BasedataEdit costaccountInput = (BasedataEdit)this.getControl("costaccount");
        costaccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                return;
            }
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getEnableQfilterByOrg((Long)org.getLong("id"), null, (String)AppIdHelper.getCurAppNum((IFormView)this.getView())));
        });
        BasedataEdit accountTableInput = (BasedataEdit)this.getControl("accountview");
        accountTableInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qf = filterParameter.getQFilters();
            qf.add(new QFilter("status", "=", (Object)"C"));
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qf.add(new QFilter("id", "=", (Object)-1));
                return;
            }
            DynamicObject accountbook = (DynamicObject)this.getModel().getValue("accountbook");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountbook)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6210\u672c\u8d26\u7c3f\u4e0e\u4f1a\u8ba1\u8d26\u7c3f\u7684\u5173\u8054\u5173\u7cfb\u3002", (String)"MfgFeeImpSchEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            qf.add(new QFilter("accounttable", "=", accountbook.get("accounttable.id")));
        });
        BasedataEdit accountsTableInput = (BasedataEdit)this.getControl("accountviews");
        accountsTableInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qf = filterParameter.getQFilters();
            qf.add(new QFilter("status", "=", (Object)"C"));
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qf.add(new QFilter("id", "=", (Object)-1));
                return;
            }
            DynamicObject accountbook = (DynamicObject)this.getModel().getValue("accountbook");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountbook)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6210\u672c\u8d26\u7c3f\u4e0e\u4f1a\u8ba1\u8d26\u7c3f\u7684\u5173\u8054\u5173\u7cfb\u3002", (String)"MfgFeeImpSchEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            Date date = new Date();
            QFilter dateFilter = new QFilter("startdate", "<=", (Object)date);
            dateFilter.and("enddate", ">", (Object)date);
            qf.add(dateFilter);
            qf.add(new QFilter("accounttable", "=", accountbook.get("accounttable.id")));
        });
        BasedataEdit costCenterInput = (BasedataEdit)this.getControl("costcenter");
        costCenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            Long orgId = org.getLong("id");
            boolean enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
            if (enableMultiFactory) {
                Long manuorg = this.getModel().getDataEntity().getLong("manuorg.id");
                if (CadEmptyUtils.isEmpty((Long)manuorg)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5145\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MfgFeeImpSchEditPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                ArrayList<Long> manuOrgs = new ArrayList<Long>();
                manuOrgs.add(manuorg);
                Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)orgId, manuOrgs, (String)this.getView().getFormShowParameter().getAppId());
                if (centerIds.isEmpty()) {
                    qFilters.add(new QFilter("id", "=", (Object)-1));
                } else {
                    qFilters.add(new QFilter("id", "in", (Object)centerIds));
                }
            } else {
                QFilter orgQf = new QFilter("accountorg", "=", org.get("id"));
                qFilters.add(orgQf);
            }
        });
        BasedataEdit benefCostCenterInput = (BasedataEdit)this.getControl("benefcostcenter");
        if (benefCostCenterInput != null) {
            benefCostCenterInput.addBeforeF7SelectListener(evt -> {
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                    qFilters.add(new QFilter("id", "=", (Object)-1L));
                    return;
                }
                QFilter qf = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                qFilters.add(new QFilter("orgduty", "=", (Object)"4"));
                qFilters.add(qf);
            });
        }
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            Long org = this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
            if (CadEmptyUtils.isEmpty((Long)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeImpSchEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org, (String)this.getBillEntityId());
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
        BasedataEdit expInput = (BasedataEdit)this.getControl("expenseitem");
        if (expInput != null) {
            expInput.addBeforeF7SelectListener(evt -> {
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                QFilter isLeafFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
                qFilters.add(isLeafFilter);
            });
        }
        BasedataEdit srcBizSys = (BasedataEdit)this.getControl("srcbizsys");
        srcBizSys.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            HashSet<String> numbers = new HashSet<String>();
            numbers.add("gl");
            if (!"eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                numbers.add("ap");
            }
            QFilter numberFilter = new QFilter("number", "in", numbers);
            qFilters.add(numberFilter);
        });
        BasedataEdit accountBook = (BasedataEdit)this.getControl("accountbook");
        accountBook.addBeforeF7SelectListener(evt -> {
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u8584\u3002", (String)"MfgFeeImpSchEditPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long costId = costAccount.getLong("id");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)costId, (String)"cal_bd_costaccount");
            String fields = "id,number,bookstype.accounttype as accounttype";
            QFilter orgQF = new QFilter("accountingsys", "=", dynamicObject.get("calsystem.id"));
            QFilter costaccountQF = new QFilter("b_entry.b_relatebook.fbasedataid", "in", (Object)costId);
            QFilter[] qf = new QFilter[]{orgQF, costaccountQF};
            DynamicObjectCollection accountBooks = QueryServiceHelper.query((String)"gl_accountbook", (String)fields, (QFilter[])qf, (String)"number asc");
            HashSet<Long> ids = new HashSet<Long>(5);
            for (DynamicObject book : accountBooks) {
                ids.add(book.getLong("id"));
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            if (CadEmptyUtils.isEmpty(ids)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter filter = new QFilter("id", "in", ids);
            qFilters.add(filter);
        });
        BasedataEdit productGroup = (BasedataEdit)this.getControl("productgroup");
        productGroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long org = this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
            if (CadEmptyUtils.isEmpty((Long)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeImpSchEditPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("grouptype", "=", (Object)"3"));
            qFilters.add(new QFilter("calorg", "=", (Object)org));
        });
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        super.queryImportBasedata(e);
        Map searchResult = e.getSearchResult();
        for (Map.Entry entry : searchResult.entrySet()) {
            List accountViewsIds;
            List baseData = (List)entry.getValue();
            BasedataItem basedataItem = (BasedataItem)entry.getKey();
            if (CadEmptyUtils.isEmpty((List)baseData) || baseData.size() <= 1 || !"accountviews".equals(basedataItem.getFieldKey())) continue;
            Object source = e.getSource();
            Map sourceObj = ((RowMapper)source).getSourceObj();
            Map accountBookInfo = (Map)sourceObj.get("accountbook");
            long accountTableId = 0L;
            if (!CadEmptyUtils.isEmpty((Map)accountBookInfo)) {
                DynamicObject accountBook = null;
                if (accountBookInfo.get("id") != null) {
                    long accountBookId = (Long)accountBookInfo.get("id");
                    QFilter idQFilter = new QFilter("id", "=", (Object)accountBookId);
                    accountBook = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"accounttable", (QFilter[])idQFilter.toArray());
                } else {
                    String number = String.valueOf(accountBookInfo.get("number"));
                    QFilter numberQFilter = new QFilter("number", "=", (Object)number);
                    accountBook = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)"accounttable", (QFilter[])numberQFilter.toArray());
                }
                if (accountBook != null) {
                    accountTableId = accountBook.getLong("accounttable.id");
                }
            }
            Date date = new Date();
            QFilter qFilter = new QFilter("startdate", "<=", (Object)date);
            qFilter.and("enddate", ">", (Object)date);
            if (!CadEmptyUtils.isEmpty((Long)accountTableId)) {
                qFilter.and("accounttable", "=", (Object)accountTableId);
            }
            if ("number".equals(basedataItem.getSearchKey())) {
                qFilter.and("number", "=", (Object)basedataItem.getSearchValue());
            }
            if (CadEmptyUtils.isEmpty((List)(accountViewsIds = QueryServiceHelper.queryPrimaryKeys((String)basedataItem.getEntityNumber(), (QFilter[])qFilter.toArray(), null, (int)-1)))) continue;
            baseData.retainAll(accountViewsIds);
        }
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }
}

