/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.init;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import org.apache.commons.collections.CollectionUtils;

public class StartStdCostListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private Map<Long, Map<Long, String>> orgCostAccountIdAndCurrentPeriodMap = new HashMap<Long, Map<Long, String>>(16);
    protected static final Log logger = LogFactory.getLog(StartStdCostListPlugin.class);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
        ArrayList<Long> scaCostAccountId = new ArrayList<Long>(10);
        ArrayList<Long> acaCostAccountId = new ArrayList<Long>(10);
        ArrayList<Long> ecaCostAccountId = new ArrayList<Long>(10);
        this.getCostAccountByAppId(scaCostAccountId, acaCostAccountId, ecaCostAccountId);
        String appId = AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView());
        ArrayList<Long> notInApp = new ArrayList<Long>(16);
        switch (appId) {
            case "sca": {
                notInApp.addAll(acaCostAccountId);
                notInApp.addAll(ecaCostAccountId);
                break;
            }
            case "aca": {
                notInApp.addAll(scaCostAccountId);
                notInApp.addAll(ecaCostAccountId);
                break;
            }
            case "eca": {
                notInApp.addAll(acaCostAccountId);
                notInApp.addAll(scaCostAccountId);
                break;
            }
        }
        if (!notInApp.isEmpty()) {
            e.getQFilters().add(new QFilter("entryentity.costaccount.id", "not in", notInApp));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        if (!CadEmptyUtils.isEmpty((String)acctOrg)) {
            List orgList = (List)SerializationUtils.fromJsonString((String)acctOrg, List.class);
            if (CadEmptyUtils.isEmpty((List)orgList) || orgList.size() == 0 || orgList.size() == 1 && CadEmptyUtils.isEmpty((String)((String)orgList.get(0)))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"tblnew"});
                return;
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf((String)orgList.get(0)));
            orgFilter.and(AppIdHelper.getAppIdFilter((IFormView)this.getView()));
            boolean exists = QueryServiceHelper.exists((String)"sca_startstdcost", (QFilter[])new QFilter[]{orgFilter});
            this.getView().setVisible(Boolean.valueOf(!exists), new String[]{"tblnew"});
        }
    }

    private void getCostAccountByAppId(List<Long> scaCostAccountId, List<Long> acaCostAccountId, List<Long> ecaCostAccountId) {
        QFilter useFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        useFilter.or("entryentity.isinit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"appnum,entryentity.costaccount costaccount", (QFilter[])new QFilter[]{useFilter});
        for (DynamicObject startStdCost : startStdCosts) {
            switch (startStdCost.getString("appnum")) {
                case "sca": {
                    scaCostAccountId.add(startStdCost.getLong("costaccount"));
                    break;
                }
                case "aca": {
                    acaCostAccountId.add(startStdCost.getLong("costaccount"));
                    break;
                }
                case "eca": {
                    ecaCostAccountId.add(startStdCost.getLong("costaccount"));
                    break;
                }
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        this.setCurrentPeriod(e);
    }

    private void setCurrentPeriod(PackageDataEvent e) {
        ColumnDesc columnDesc;
        String key;
        if (e.getSource() instanceof ColumnDesc && "currentperiod.name".equals(key = (columnDesc = (ColumnDesc)e.getSource()).getKey()) && e.getRowData().get("entryentity.startperiod") != null) {
            Long orgId = (Long)e.getRowData().getDynamicObject("org").getPkValue();
            Long costAccountId = (Long)e.getRowData().getDynamicObject("entryentity.costaccount").getPkValue();
            if (this.orgCostAccountIdAndCurrentPeriodMap.get(orgId) == null) {
                return;
            }
            String currentPeriodName = this.orgCostAccountIdAndCurrentPeriodMap.get(orgId).get(costAccountId);
            e.setFormatValue((Object)currentPeriodName);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new CurrentPeriodDataProvider());
    }

    private Map<Long, Map<Long, String>> getOrgCostAccountIdAndCurrentPeriod(Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return null;
        }
        HashMap<Long, Map<Long, String>> resultMap = new HashMap<Long, Map<Long, String>>(16);
        for (Long orgId : orgIds) {
            if (orgId == null) {
                return null;
            }
            QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
            QFilter costAccountEnableFilter = new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE);
            String selectedFields = "id,entry.costaccount.id as cost_account_id, entry.currentperiod.name as currentperiod_name";
            QFilter[] filters = new QFilter[]{orgFilter, costAccountEnableFilter};
            DynamicObjectCollection costAccountList = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)selectedFields, (QFilter[])filters);
            if (CollectionUtils.isEmpty((Collection)costAccountList)) continue;
            resultMap.put(orgId, Maps.newHashMapWithExpectedSize((int)16));
            for (DynamicObject costAccount : costAccountList) {
                ((Map)resultMap.get(orgId)).put(costAccount.getLong("cost_account_id"), costAccount.getString("currentperiod_name"));
            }
        }
        return resultMap;
    }

    private class CurrentPeriodDataProvider
    extends ListDataProvider {
        private CurrentPeriodDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            HashSet<Long> orgIds = new HashSet<Long>();
            for (DynamicObject row : rows) {
                Long orgId = row.getLong("org.id");
                orgIds.add(orgId);
            }
            try {
                StartStdCostListPlugin.this.orgCostAccountIdAndCurrentPeriodMap = StartStdCostListPlugin.this.getOrgCostAccountIdAndCurrentPeriod(orgIds);
            }
            catch (Exception e) {
                logger.error("\u542f\u7528\u6807\u51c6\u6210\u672c\u6838\u7b97\u5217\u8868\u83b7\u53d6\u5f53\u524d\u671f\u95f4\u5931\u8d25" + e);
            }
            return rows;
        }
    }
}

