/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.EntityUtil;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.formplugin.base.BaseOrgAndCostAccountListPlugin;

public class WipCostInitListPlugin
extends BaseOrgAndCostAccountListPlugin {
    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey;
        super.beforeItemClick(e);
        switch (itemKey = e.getItemKey()) {
            case "tbldel": {
                Boolean initFlag = this.checkCostAccountInit();
                if (initFlag == null) {
                    e.setCancel(true);
                    return;
                }
                if (initFlag.booleanValue()) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002\u8be5\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"WipCostInitListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        Long orgId;
        List<Object> orgIdList;
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costaccount") && !CadEmptyUtils.isEmpty(orgIdList = this.getOrgCache()) && !CadEmptyUtils.isEmpty((Long)(orgId = Long.valueOf(String.valueOf(orgIdList.get(0)))))) {
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnableQfilterByOrg((Long)orgId, null, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().add(enabledCostAccountIdsFilter);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": 
            case "copy": {
                Boolean initFlag = this.checkCostAccountInit();
                if (initFlag == null) {
                    e.setCancel(true);
                    return;
                }
                if (initFlag.booleanValue()) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\u3002\u8be5\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"WipCostInitListPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
            }
        }
    }

    private void delSelectedRow() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"sca_wipcostinit", (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WipCostInitListPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private boolean existNotInitRow(ListSelectedRowCollection rows) {
        Object[] primaryKeyValues = rows.getPrimaryKeyValues();
        QFilter idQF = new QFilter("id", "in", (Object)primaryKeyValues);
        String fields = "org,costaccount";
        DynamicObjectCollection wipCosts = QueryServiceHelper.query((String)"sca_wipcostinit", (String)fields, (QFilter[])new QFilter[]{idQF});
        HashSet<String> wipCostIdSet = new HashSet<String>();
        for (DynamicObject wipCost : wipCosts) {
            wipCostIdSet.add(wipCost.getString("costaccount"));
        }
        QFilter orgQF = new QFilter("org", "=", ((DynamicObject)wipCosts.get(0)).get("org"));
        QFilter costAccountQF = new QFilter("entryentity.costaccount", "in", wipCostIdSet);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.FALSE);
        QFilter[] qf = new QFilter[]{orgQF, costAccountQF, isInitFilter};
        return QueryServiceHelper.exists((String)"sca_startstdcost", (QFilter[])qf);
    }

    @Override
    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        if (CadEmptyUtils.isEmpty(orgId)) {
            return null;
        }
        return StartCostHelper.getCostAccountItems((Long)Long.valueOf((String)orgId.get(0)), null, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
    }

    private Boolean checkCostAccountInit() {
        String costAccoutId = this.getPageCache().get("costaccount");
        if (CadEmptyUtils.isEmpty((String)costAccoutId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"WipCostInitListPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
            return null;
        }
        Boolean initCostAccount = this.isInitCostAccount(costAccoutId);
        if (initCostAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5237\u65b0\u6210\u672c\u8d26\u7c3f\u3002", (String)"WipCostInitListPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
            return null;
        }
        return initCostAccount == false;
    }

    private Boolean isInitCostAccount(String costAccoutId) {
        String orgId = this.getPageCache().get("org");
        List orgList = (List)SerializationUtils.fromJsonString((String)orgId, List.class);
        DynamicObject startstdCost = this.getStartstdCost((String)orgList.get(0), costAccoutId);
        return startstdCost != null ? Boolean.valueOf(startstdCost.getBoolean("isinit")) : null;
    }

    private DynamicObject getStartstdCost(String orgId, String costAccoutId) {
        String fields = "entryentity.costaccount AS costaccount,entryentity.isinit AS isinit";
        QFilter orgQF = new QFilter("org", "=", (Object)Long.valueOf(orgId));
        QFilter costAccoutQF = new QFilter("entryentity.costaccount", "=", (Object)Long.valueOf(costAccoutId));
        DynamicObjectCollection res = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])new QFilter[]{orgQF, costAccoutQF});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)res)) {
            return null;
        }
        return (DynamicObject)res.get(0);
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("costcenter.number ASC, billno ASC");
        e.getQFilters().add(new QFilter("entryentity.datatype", "=", (Object)"2"));
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        DynamicObject[] queryValues = e.getQueryValues();
        if (queryValues == null || queryValues.length == 0) {
            return;
        }
        List<Long> ids = this.getIds(queryValues);
        Map<Long, String> dataTypeMap = this.getDataTypeMap(ids);
        if (!dataTypeMap.values().contains("1")) {
            return;
        }
        ArrayList<DynamicObject> newValueList = new ArrayList<DynamicObject>(10);
        for (DynamicObject queryValue : queryValues) {
            DynamicObject newValue = BusinessDataServiceHelper.newDynamicObject((String)queryValue.getDataEntityType().getName());
            HashSet<String> ignoreKeys = new HashSet<String>(16);
            ignoreKeys.add("entryentity");
            EntityUtil.copyPropertiesWithOutId((DynamicObject)newValue, (DynamicObject)queryValue, ignoreKeys);
            newValue.set("id", queryValue.get("id"));
            DynamicObjectCollection rows = queryValue.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection newRows = newValue.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                if ("1".equals(dataTypeMap.get(row.get("id")))) continue;
                DynamicObject newRow = newRows.addNew();
                EntityUtil.copyPropertiesWithOutId((DynamicObject)newRow, (DynamicObject)row);
            }
            newValueList.add(newValue);
        }
        e.setQueryValues(newValueList.toArray(new DynamicObject[0]));
    }

    private Map<Long, String> getDataTypeMap(List<Long> ids) {
        DynamicObjectCollection res = QueryServiceHelper.query((String)"sca_wipcostinit", (String)"id, entryentity.id AS entryid, entryentity.datatype AS datatype", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<Long, String> dataTypeMap = new HashMap<Long, String>();
        res.forEach(s -> dataTypeMap.put(s.getLong("entryid"), s.getString("datatype")));
        return dataTypeMap;
    }

    private List<Long> getIds(DynamicObject[] queryValues) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (DynamicObject queryValue : queryValues) {
            ids.add(queryValue.getLong("id"));
        }
        return ids;
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        List orgList;
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get("org");
        String costCenter = this.getPageCache().get("costaccount");
        if (!StringUtils.isEmpty((String)acctOrg) && (orgList = (List)SerializationUtils.fromJsonString((String)acctOrg, List.class)) != null && !orgList.isEmpty()) {
            bsp.setCustomParam("org", orgList.get(0));
        }
        bsp.setCustomParam("costaccount", (Object)costCenter);
    }
}

