/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.restore;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.sca.common.helper.AccountingSysHelper;
import kd.macc.sca.common.helper.CommonSettingHelper;
import kd.macc.sca.common.helper.OrgHelper;
import kd.macc.sca.common.helper.SCMHelper;

public class CollEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private String COSTACCOUNT = "costaccount";
    private String BILLTYPE = "billtype";
    private String WAREHOUSE = "warehouse";
    private String LOCATION = "location";
    private String MATERIAL = "material";
    private String BIZTYPE = "biztype";
    private String BIZDATE = "bizdate";
    private String LOT = "lot";
    private String ENTRY = "entryentity";
    private String BASEUNIT = "baseunit";
    private String STORAGEORGUNIT = "storageorgunit";
    private String PURCHASE_SPREAD_PAGETYPE = "purchasespread";

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(this.BIZDATE, (Object)new Date());
        DynamicObject calOrg = (DynamicObject)this.getModel().getValue("calorg");
        if (calOrg != null) {
            long orgId = calOrg.getLong("id");
            this.getModel().setValue("owner", (Object)orgId, 0);
            String biztype = (String)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)orgId, (Long)0L, (String)"handcostadjustbiztype");
            DynamicObject billtype = (DynamicObject)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)orgId, (Long)0L, (String)"handcostadjustbilltype");
            if (biztype != null && billtype != null) {
                this.getModel().setValue("biztype", (Object)biztype);
                this.getModel().setValue("billtype", billtype.get("id"));
                if ("A".equals(biztype)) {
                    this.getModel().setValue("cstype", (Object)"bd_supplier");
                } else {
                    this.getModel().setValue("cstype", (Object)"bd_customer");
                }
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                Long calOrgId = OrgHelper.getCalOrgByUserOrg(userId, orgId, "cal_costadjustbill");
                this.setCostAccountByCalOrg(calOrgId);
                this.initDept(calOrgId);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u7ec4\u7ec7\u672a\u7ef4\u62a4\u6210\u672c\u8c03\u6574\u5355\u53c2\u6570\uff0c\u8bf7\u8fdb\u5165\u201c\u7cfb\u7edf\u4e91>\u914d\u7f6e\u5de5\u5177>\u7cfb\u7edf\u53c2\u6570>\u5b58\u8d27\u6838\u7b97\u201d\u4e0b,\u9009\u62e9\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u540e,\u5bf9\u624b\u5de5\u65b0\u589e\u6210\u672c\u8c03\u6574\u5355\u8fdb\u884c\u76f8\u5e94\u914d\u7f6e\u3002", (String)"CollEditPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
    }

    private void initDept(Long calOrgId) {
        long userId = UserServiceHelper.getCurrentUserId();
        List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)calOrgId, (boolean)true);
        if (deptids != null && deptids.size() > 0) {
            List userdeptIds = UserServiceHelper.getUserDepartment((long)userId, (boolean)false);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                for (Long deptId : userdeptIds) {
                    if (!deptids.contains(deptId)) continue;
                    this.getModel().setValue("adminorg", (Object)deptId);
                    break;
                }
            }
        } else {
            List userdeptIds = UserServiceHelper.getUserDepartment((long)userId, (boolean)false);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                this.getModel().setValue("adminorg", userdeptIds.get(0));
            }
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        for (Map sourceData : sourceDataList) {
            sourceData.put("billstatus", "A");
            sourceData.put("createtype", "O");
            sourceData.put("difftype", "B");
            sourceData.put("billcretype", "import");
            String biztype = (String)sourceData.get("biztype");
            if ("A".equals(biztype)) {
                sourceData.put("cstype", "bd_supplier");
                continue;
            }
            sourceData.put("cstype", "bd_customer");
        }
    }

    private void setCostAccountByCalOrg(Long calOrg) {
        DynamicObject costAccount = OrgHelper.getCostAccountByCalOrg(calOrg);
        if (costAccount != null) {
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"id,currency", (QFilter[])new QFilter("id", "=", (Object)costAccount.getLong("calpolicy")).toArray());
            this.getModel().setValue("costaccount", (Object)costAccount.getLong("id"));
            this.getModel().setValue("currency", ((DynamicObject)coll.get(0)).get("currency"));
        } else {
            this.getModel().setValue("costaccount", null);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject storageOrg = (DynamicObject)this.getModel().getValue("storageorgunit", rowIndex);
        for (RowDataEntity obj : e.getRowDataEntities()) {
            int currentRowIndex = obj.getRowIndex();
            this.getModel().setValue("owner", ((DynamicObject)this.getModel().getValue("calorg")).get("id"), currentRowIndex);
            if (storageOrg == null) continue;
            this.getModel().setValue("storageorgunit", storageOrg.getPkValue(), currentRowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        String pageType;
        this.setRowEnable();
        String parentPageId = ((BillView)e.getSource()).getFormShowParameter().getParentPageId();
        if (!StringUtils.isEmpty((String)parentPageId) && this.PURCHASE_SPREAD_PAGETYPE.equals(pageType = (String)this.getView().getViewNoPlugin(parentPageId).getFormShowParameter().getCustomParams().get("pageType"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_submit", "bar_audit"});
        }
        boolean calByCostelement = false;
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null) {
            DynamicObject costAccountDy = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.calbycostelement", (QFilter[])new QFilter("id", "=", costAccount.getPkValue()).toArray());
            calByCostelement = costAccountDy.getBoolean("calpolicy.calbycostelement");
        }
        this.getView().setVisible(Boolean.valueOf(calByCostelement), new String[]{"subentryentity"});
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (calByCostelement && "C".equals(billStatus)) {
            DynamicObjectCollection coll = this.getModel().getEntryEntity("entryentity");
            for (DynamicObject entry : coll) {
                DynamicObjectCollection subColl = entry.getDynamicObjectCollection("subentryentity");
                Iterator it = subColl.iterator();
                while (it.hasNext()) {
                    DynamicObject subEntry = (DynamicObject)it.next();
                    BigDecimal sub_adjustamt = subEntry.getBigDecimal("sub_adjustamt");
                    if (sub_adjustamt.compareTo(BigDecimal.ZERO) != 0) continue;
                    it.remove();
                }
            }
        }
        this.getView().updateView("subentryentity");
    }

    private void setRowEnable() {
        DynamicObject costAdjustBill = this.getModel().getDataEntity();
        DynamicObjectCollection entryColl = costAdjustBill.getDynamicObjectCollection(this.ENTRY);
        HashMap<Long, HashSet<Long>> storMaterialsMap = new HashMap<Long, HashSet<Long>>(16);
        HashSet<Long> warehouseIdSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : entryColl) {
            Long storageOrgId = dynamicObject.getLong("storageorgunit.id");
            Long materialId = dynamicObject.getLong("material.id");
            Long warehouseId = dynamicObject.getLong("warehouse.id");
            HashSet<Long> materialIds = (HashSet<Long>)storMaterialsMap.get(storageOrgId);
            if (materialIds == null) {
                materialIds = new HashSet<Long>(16);
                storMaterialsMap.put(storageOrgId, materialIds);
            }
            materialIds.add(materialId);
            warehouseIdSet.add(warehouseId);
        }
        QFilter warehouseFilter = new QFilter("id", "in", warehouseIdSet);
        warehouseFilter.and("enable", "=", (Object)"1");
        warehouseFilter.and("status", "=", (Object)"C");
        HashMap<Long, Boolean> warehouseEnableLocationMap = new HashMap<Long, Boolean>(16);
        try (DataSet warehouseDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "-warehous"), (String)"bd_warehouse", (String)"id,isopenlocation", (QFilter[])warehouseFilter.toArray(), (String)null);){
            for (Row row : warehouseDataSet) {
                Long warehouseId = row.getLong("id");
                Boolean isopenlocation = row.getBoolean("isopenlocation");
                warehouseEnableLocationMap.put(warehouseId, isopenlocation);
            }
        }
        HashMap<String, Boolean> privateEnableLotMap = new HashMap<String, Boolean>(16);
        HashMap<String, Boolean> publiceEnableLotMap = new HashMap<String, Boolean>(16);
        HashMap<Long, Boolean> enableAssistMap = new HashMap<Long, Boolean>(16);
        for (Map.Entry entry : storMaterialsMap.entrySet()) {
            Long stoId = (Long)entry.getKey();
            Set matIds = (Set)entry.getValue();
            QFilter qFilter = new QFilter("masterid", "in", (Object)matIds);
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)stoId, (QFilter)qFilter, (String)"id,masterid,createorg,enablelot,masterid.isuseauxpty");
            for (DynamicObject dynamicObject : stockMaterialInfos) {
                Object material = dynamicObject.get("masterid");
                if (material instanceof DynamicObject) {
                    material = ((DynamicObject)material).get("id");
                }
                boolean enableAssist = dynamicObject.getBoolean("masterid.isuseauxpty");
                Object createOrg = dynamicObject.get("createorg");
                if (createOrg instanceof DynamicObject) {
                    createOrg = ((DynamicObject)createOrg).get("id");
                }
                String key = stoId + "_" + material;
                boolean enableLot = dynamicObject.getBoolean("enablelot");
                if (stoId.equals(createOrg)) {
                    privateEnableLotMap.put(key, enableLot);
                } else {
                    publiceEnableLotMap.put(key, enableLot);
                }
                enableAssistMap.put((Long)material, enableAssist);
            }
        }
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            Boolean isopenlocation;
            DynamicObject entryRow = (DynamicObject)entryColl.get(i);
            Long storageOrgId = entryRow.getLong("storageorgunit.id");
            Long materialId = entryRow.getLong("material.id");
            Long warehouseId = entryRow.getLong("warehouse.id");
            if (storageOrgId != null && materialId != null) {
                String key = storageOrgId + "_" + materialId;
                Boolean enablelot = (Boolean)privateEnableLotMap.get(key);
                if (enablelot == null) {
                    enablelot = (Boolean)publiceEnableLotMap.get(key);
                }
                Boolean isuseauxpty = (Boolean)enableAssistMap.get(materialId);
                if (enablelot != null) {
                    this.getView().setEnable(enablelot, i, new String[]{this.LOT});
                }
                if (isuseauxpty != null) {
                    this.getView().setEnable(isuseauxpty, i, new String[]{"assist"});
                }
            }
            if ((isopenlocation = (Boolean)warehouseEnableLocationMap.get(warehouseId)) == null) continue;
            this.getView().setEnable(isopenlocation, i, new String[]{this.LOCATION});
        }
    }

    private void setBillType(boolean isChange) {
        Object biztype = this.getModel().getValue(this.BIZTYPE);
        this.getModel().beginInit();
        if ("A".equals(biztype)) {
            this.getModel().setValue(this.BILLTYPE, (Object)"366348248593474560");
            if (isChange) {
                this.getModel().setValue("custsupplier", null);
            }
            this.getModel().setValue("cstype", (Object)"bd_supplier");
        } else {
            this.getModel().setValue(this.BILLTYPE, (Object)"452682831861140480");
            this.getModel().setValue("cstype", (Object)"bd_customer");
        }
        this.getModel().endInit();
        this.getView().updateView(this.BILLTYPE);
        this.getView().updateView("cstype");
        this.getView().updateView("custsupplier");
    }

    public void registerListener(EventObject e) {
        BasedataEdit costaccount = (BasedataEdit)this.getControl(this.COSTACCOUNT);
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billtype = (BasedataEdit)this.getControl(this.BILLTYPE);
        billtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getControl(this.MATERIAL);
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit warehouseEdit = (BasedataEdit)this.getControl(this.WAREHOUSE);
        warehouseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit locationEdit = (BasedataEdit)this.getControl(this.LOCATION);
        locationEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit storageorgUnit = (BasedataEdit)this.getControl(this.STORAGEORGUNIT);
        storageorgUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit invType = (BasedataEdit)this.getControl("invtype");
        invType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ownerEdit = (BasedataEdit)this.getControl("owner");
        ownerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String sourceID = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if (this.COSTACCOUNT.equals(sourceID)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("calorg");
            if (costAccount != null) {
                QFilter qf = new QFilter("calorg.id", "=", costAccount.getPkValue());
                showParameter.getListFilterParameter().setFilter(qf);
            }
        } else if (this.BILLTYPE.equals(sourceID)) {
            Object biztype = this.getModel().getValue(this.BIZTYPE);
            DynamicObject warehouse = CommonSettingHelper.getSettingObj();
            HashSet<String> calBillTypeIds = new HashSet<String>();
            if ("A".equals(biztype)) {
                DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("calinbilltypes");
                if (locationCol.size() < 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u201c\u8d22\u52a1\u4e91>\u5b58\u8d27\u6838\u7b97>\u516c\u5171\u914d\u7f6e>\u6838\u7b97\u5355\u5355\u636e\u7c7b\u578b\u201d\u4e0b\u7ef4\u62a4\u5165\u5e93\u6838\u7b97\u5355\u636e\u3002", (String)"CollEditPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                }
                for (DynamicObject calInBillType : locationCol) {
                    if (calInBillType.getDynamicObject("fbasedataid") == null) continue;
                    calBillTypeIds.add(calInBillType.getDynamicObject("fbasedataid").getString("number"));
                }
            } else {
                DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("caloutbilltypes");
                if (locationCol.size() < 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u901a\u8fc7\u201c\u8d22\u52a1\u4e91>\u5b58\u8d27\u6838\u7b97>\u516c\u5171\u914d\u7f6e>\u6838\u7b97\u5355\u5355\u636e\u7c7b\u578b\u201d\u4e0b\u7ef4\u62a4\u51fa\u5e93\u6838\u7b97\u5355\u636e\u3002", (String)"CollEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                }
                for (DynamicObject calInBillType : locationCol) {
                    if (calInBillType.getDynamicObject("fbasedataid") == null) continue;
                    calBillTypeIds.add(calInBillType.getDynamicObject("fbasedataid").getString("number"));
                }
            }
            QFilter qf = new QFilter("number", "in", calBillTypeIds);
            showParameter.getListFilterParameter().setFilter(qf);
        } else if (this.WAREHOUSE.equals(sourceID)) {
            int rowIndex = event.getRow();
            DynamicObject warehouse = (DynamicObject)this.getModel().getValue("storageorgunit", rowIndex);
            Long[] ownerIds = new Long[]{688888L};
            if (warehouse != null) {
                ownerIds = SCMHelper.getAllWarehouseIDs(warehouse.getString("number"));
            }
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)ownerIds));
        } else if (this.LOCATION.equals(sourceID)) {
            int rowIndex = event.getRow();
            DynamicObject warehouse = (DynamicObject)this.getModel().getValue(this.WAREHOUSE, rowIndex);
            List<Long> ids = new ArrayList<Long>();
            ids.add(688888L);
            if (warehouse != null) {
                DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection(this.ENTRY);
                ids = this.getLoactionIds(locationCol);
            }
            QFilter qf = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(qf);
        } else if (this.STORAGEORGUNIT.equals(sourceID)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("calorg");
            List<Object> storageOrgIdList = new ArrayList();
            if (costAccount != null) {
                storageOrgIdList = OrgHelper.getStorageOrgUnitByCalOrg(costAccount.getLong("id"));
            }
            QFilter qf1 = new QFilter("id", "in", storageOrgIdList);
            showParameter.getListFilterParameter().setFilter(qf1);
        } else if (this.MATERIAL.equals(sourceID)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue(this.STORAGEORGUNIT);
            if (costAccount == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CollEditPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
        } else if ("owner".equals(sourceID)) {
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
            if (costAccount == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6210\u672c\u8d26\u7c3f\u3002", (String)"CollEditPlugin_4", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            Long costAccountId = costAccount.getLong("id");
            Long[] ownerIds = AccountingSysHelper.getOwners(costAccountId);
            QFilter qf = new QFilter("id", "in", (Object)ownerIds);
            showParameter.getListFilterParameter().setFilter(qf);
        } else if ("invtype".equals(sourceID)) {
            QFilter qFilter = new QFilter("isforwardamount", "=", (Object)true);
            qFilter.and("enable", "=", (Object)"1");
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol != null && locationCol.size() != 0) {
            for (DynamicObject locDym : locationCol) {
                ids.add(locDym.getLong("location.id"));
            }
            return ids;
        }
        return ids;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if (this.COSTACCOUNT.equals(propertyName)) {
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue(this.COSTACCOUNT);
            Object currecy = null;
            boolean isopenlocation = false;
            if (costaccount != null) {
                Object accountID = costaccount.getPkValue();
                DynamicObject rs = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"calpolicy.currency.id,calpolicy.calbycostelement", (QFilter[])new QFilter[]{new QFilter("id", "=", accountID)});
                currecy = rs.get("calpolicy.currency.id");
                isopenlocation = rs.getBoolean("calpolicy.calbycostelement");
            }
            this.getModel().beginInit();
            this.getModel().setValue("currency", currecy);
            this.getModel().endInit();
            this.getView().updateView(this.ENTRY);
            this.getView().updateView("currency");
            this.getView().setVisible(Boolean.valueOf(isopenlocation), new String[]{"subentryentity"});
            this.getView().updateView("subentryentity");
        } else if (this.BIZTYPE.equals(propertyName)) {
            this.setBillType(true);
        } else if (this.MATERIAL.equals(propertyName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject materialInfo = (DynamicObject)this.getModel().getValue(this.MATERIAL, rowIndex);
            if (materialInfo == null) {
                return;
            }
            DynamicObject storageorgunit = (DynamicObject)this.getModel().getValue("storageorgunit", rowIndex);
            if (storageorgunit == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"CollEditPlugin_3", (String)"fi-cal-formplugin", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("masterid", "=", materialInfo.getPkValue());
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)storageorgunit.getLong("id"), (QFilter)qFilter, (String)"id,enablelot");
            boolean isuseauxpty = materialInfo.getBoolean("isuseauxpty");
            boolean enablelot = false;
            if (stockMaterialInfos == null || stockMaterialInfos.size() <= 0) {
                this.getModel().setValue(this.MATERIAL, null, rowIndex);
                this.getView().updateView(this.MATERIAL, rowIndex);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8be5\u7269\u6599\u5728\u76f8\u5e94\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u7684\u7269\u6599\u5e93\u5b58\u7b56\u7565\u3002", (String)"CollEditPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
            }
            enablelot = ((DynamicObject)stockMaterialInfos.get(0)).getBoolean("enablelot");
            DynamicObject baseunit = materialInfo.getDynamicObject(this.BASEUNIT);
            this.getModel().beginInit();
            this.getModel().setValue(this.BASEUNIT, baseunit.get("id"), rowIndex);
            this.getView().setEnable(Boolean.valueOf(isuseauxpty), rowIndex, new String[]{"assist"});
            this.getView().setEnable(Boolean.valueOf(enablelot), rowIndex, new String[]{this.LOT});
            if (!isuseauxpty) {
                this.getModel().setValue("assist", null, rowIndex);
            }
            if (!enablelot) {
                this.getModel().setValue(this.LOT, null, rowIndex);
            }
            this.getView().updateView(this.LOT, rowIndex);
            this.getView().updateView("assist", rowIndex);
            this.getView().updateView(this.BASEUNIT, rowIndex);
            this.getModel().endInit();
        } else if (this.WAREHOUSE.equals(propertyName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject materialInfo = (DynamicObject)this.getModel().getValue(this.WAREHOUSE, rowIndex);
            if (materialInfo == null) {
                return;
            }
            boolean isopenlocation = materialInfo.getBoolean("isopenlocation");
            this.getModel().beginInit();
            this.getView().setEnable(Boolean.valueOf(isopenlocation), rowIndex, new String[]{this.LOCATION});
            if (!isopenlocation) {
                this.getModel().setValue(this.LOCATION, null, rowIndex);
            }
            this.getView().updateView(this.LOCATION, rowIndex);
            this.getModel().endInit();
        } else if ("createtype".equals(propertyName)) {
            String createType = (String)this.getModel().getValue("createtype");
            if (!(StringUtils.isNotEmpty((String)createType) && (createType.equals("M") || createType.equals("G") || createType.equals("H") || createType.equals("K") || createType.equals("P") || createType.equals("Q") || createType.equals("R") || createType.equals("S") || createType.equals("T")))) {
                this.getModel().setValue("difftype", (Object)"B");
            } else {
                this.getModel().setValue("difftype", (Object)"A");
            }
        }
    }

    public void afterCopyData(EventObject e) {
        for (DynamicObject entry : this.getModel().getEntryEntity("entryentity")) {
            entry.getDynamicObjectCollection("subentryentity").clear();
        }
    }
}

