/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.restore;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.algox.constants.RestoreCalcCheck;
import kd.macc.sca.algox.utils.TimeUtils;
import kd.macc.sca.algox.wip.CalcMutexHelper;
import kd.macc.sca.common.enums.RstoreCalcEnum;
import kd.macc.sca.formplugin.restore.RestoreTaskHelper;
import net.sf.json.JSONObject;

public class DiffCalcWizards
extends AbstractBillPlugIn {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Log logger = LogFactory.getLog(DiffCalcWizards.class);

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl("org");
        orgControl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIdsByPermItem((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"4730fc9f000025ae");
            QFilter orgIdsFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
            listFilterParameter.setFilter(orgIdsFilter);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCalcWizards_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            filters.add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)"sca"));
        });
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject groupstandard = (DynamicObject)this.getModel().getValue("groupstandard");
            if (groupstandard == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"DiffCalcWizards_17", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCalcWizards_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)org.getLong("id")));
            if (groupstandard.getLong("id") != 730148448254487552L) {
                QFilter classifiedMaterialIdFilter = new QFilter("id", "in", (Object)MaterialGroupHelper.getClassifiedMaterialId(null, (boolean)false, (DynamicObject)groupstandard));
                qFilters.add(classifiedMaterialIdFilter);
            }
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit materialgroup = (BasedataEdit)this.getControl("materialgroup");
        materialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("groupstandard");
            if (materialgrpstd == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"DiffCalcWizards_17", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCalcWizards_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            ArrayList<Long> orgIds = new ArrayList<Long>(10);
            orgIds.add(org.getLong("id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, materialgrpstd.getPkValue(), true});
            qFilters.add(serviceResponse);
            List<Long> selectIds = this.getSpecifyMatSelectIds("materialgroup");
            if (!CadEmptyUtils.isEmpty(selectIds)) {
                qFilters.add(new QFilter("id", "not in", selectIds));
            }
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", orgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstd.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData();
    }

    private void initData() {
        Long accountOrgId = this.getDefaultOrg();
        this.getModel().setValue("org", (Object)accountOrgId);
        Long costAccountId = this.getCostAccountByAccoutOrg(accountOrgId);
        if (costAccountId != 0L && StartCostHelper.isInit((Long)costAccountId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getModel().setValue("costaccount", (Object)costAccountId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        DynamicObject periodId = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        this.getModel().setValue("period", (Object)periodId);
        this.setCurrency();
        this.setCloseAccount();
        this.viewSpecifyMaterialControl(null);
        this.viewMaterialField(accountOrgId);
    }

    private void viewSpecifyMaterialControl(Boolean flag) {
        if (flag == null) {
            flag = this.getModel().getDataEntity().getBoolean("isspecifymaterial");
        }
        this.getView().setVisible(flag, new String[]{"groupstandard", "sp_specifymat"});
        DynamicObjectCollection dyns = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (int i = 0; i < dyns.size(); ++i) {
            DynamicObject dyn = (DynamicObject)dyns.get(i);
            DynamicObject material = dyn.getDynamicObject("material");
            boolean enable = material != null;
            this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"configuredcode", "tracknumber", "project", "lot"});
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"auxpty"});
            if (material == null) continue;
            boolean isuseauxptyFlag = material.getBoolean("isuseauxpty");
            this.getView().setEnable(Boolean.valueOf(isuseauxptyFlag), i, new String[]{"auxpty"});
        }
    }

    private List<Long> getSpecifyMatSelectIds(String field) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        DynamicObjectCollection dynCols = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dyn : dynCols) {
            if (dyn.getDynamicObject(field) == null) continue;
            ids.add(dyn.getDynamicObject(field).getLong("id"));
        }
        return ids;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.viewSpecifyMaterialControl(null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection dynCols;
        DynamicObject periodId;
        Long costAccountId;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object na = e.getChangeSet()[0].getNewValue();
        int index = e.getChangeSet()[0].getRowIndex();
        if (name.equals("org")) {
            if (na != null) {
                costAccountId = this.getCostAccountByAccoutOrg(((DynamicObject)na).getLong("id"));
                if (costAccountId != 0L && StartCostHelper.isInit((Long)costAccountId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                    this.getModel().setValue("costaccount", (Object)costAccountId);
                    periodId = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                    this.getModel().setValue("period", (Object)periodId);
                    this.setCurrency();
                    this.setCloseAccount();
                } else {
                    this.getModel().setValue("costaccount", null);
                    this.getModel().setValue("currency", null);
                    this.getModel().setValue("period", (Object)"");
                    this.getModel().setValue("status", (Object)"");
                }
                this.viewMaterialField(((DynamicObject)na).getLong("id"));
            } else {
                this.getModel().setValue("costaccount", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("period", (Object)"");
                this.getModel().setValue("status", (Object)"");
                this.viewMaterialField(null);
            }
            this.getModel().setValue("isspecifymaterial", (Object)Boolean.FALSE);
            this.getModel().deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            this.viewSpecifyMaterialControl(Boolean.FALSE);
        }
        if (name.equals("costaccount")) {
            if (na == null) {
                this.getModel().setValue("currency", null);
                this.getModel().setValue("period", (Object)"");
                this.getModel().setValue("status", (Object)"");
            } else {
                costAccountId = ((DynamicObject)na).getLong("id");
                periodId = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                this.getModel().setValue("period", (Object)periodId);
                this.setCurrency();
                this.setCloseAccount();
            }
        }
        if ("isspecifymaterial".equals(name)) {
            boolean flag = false;
            if (na != null) {
                flag = (Boolean)na;
            }
            if (flag) {
                boolean isCanSpMatFlag = this.verifySpecifyMaterial();
                if (!isCanSpMatFlag) {
                    flag = false;
                    this.getModel().setValue("isspecifymaterial", (Object)Boolean.FALSE);
                }
                this.viewSpecifyMaterialControl(flag);
            } else {
                this.viewSpecifyMaterialControl(flag);
            }
        }
        if ("material".equals(name)) {
            this.getView().setEnable(Boolean.valueOf(na == null), index, new String[]{"materialgroup"});
            this.getView().setEnable(Boolean.valueOf(na != null), index, new String[]{"configuredcode", "tracknumber", "project", "lot"});
            this.getModel().setValue("auxpty", null, index);
            boolean auxptyFlag = false;
            if (na == null) {
                this.getModel().setValue("configuredcode", null, index);
                this.getModel().setValue("tracknumber", null, index);
                this.getModel().setValue("project", null, index);
                this.getModel().setValue("lot", null, index);
            } else {
                DynamicObject material = (DynamicObject)na;
                if (material != null) {
                    auxptyFlag = material.getBoolean("isuseauxpty");
                }
            }
            this.getView().setEnable(Boolean.valueOf(auxptyFlag), index, new String[]{"auxpty"});
        }
        if ("materialgroup".equals(name)) {
            this.getView().setEnable(Boolean.valueOf(na == null), index, new String[]{"material"});
        }
        if ("groupstandard".equals(name) && !(dynCols = this.getModel().getEntryEntity("entryentity")).isEmpty()) {
            for (int i = 0; i < dynCols.size(); ++i) {
                DynamicObject dynObj = (DynamicObject)dynCols.get(i);
                DynamicObject materialGroup = dynObj.getDynamicObject("materialgroup");
                if (materialGroup == null) continue;
                this.getModel().setValue("materialgroup", null, i);
            }
        }
    }

    private void viewMaterialField(Long orgId) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"auxpty", "configuredcode", "tracknumber", "project", "lot"});
    }

    private boolean verifySpecifyMaterial() {
        String status;
        if (this.getModel().getValue("org") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"DiffCalcWizards_0", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("costaccount") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"DiffCalcWizards_18", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("period") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"DiffCalcWizards_19", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        QFilter filter = new QFilter("org", "=", (Object)this.getModel().getDataEntity().getDynamicObject("org").getLong("id"));
        filter.and("costaccount", "=", (Object)this.getModel().getDataEntity().getDynamicObject("costaccount").getLong("id"));
        filter.and("period", "=", (Object)this.getModel().getDataEntity().getDynamicObject("period").getLong("id"));
        filter.and("billtype", "=", (Object)"2");
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_restore_calcreport", (String)"id,type,calcdate", (QFilter[])filter.toArray(), (String)"calcdate desc", (int)2);
        if (!result.isEmpty() && ("4".equals(status = ((DynamicObject)result.get(0)).getString("type")) || "5".equals(status))) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u671f\u672a\u8fdb\u884c\u5dee\u5f02\u5206\u644a\u6216\u6700\u540e\u4e00\u6b21\u5168\u91cf\u5dee\u5f02\u5206\u644a\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u6307\u5b9a\u7269\u6599\u8fdb\u884c\u5dee\u5f02\u5206\u644a\u3002", (String)"DiffCalcWizards_20", (String)"macc-sca-form", (Object[])new Object[0]));
        return false;
    }

    private Set<String> getSpecifyIds() {
        DynamicObject groupstandard = (DynamicObject)this.getModel().getValue("groupstandard");
        if (groupstandard == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"DiffCalcWizards_17", (String)"macc-sca-form", (Object[])new Object[0]));
            return null;
        }
        boolean isCanSpMatFlag = this.verifySpecifyMaterial();
        if (!isCanSpMatFlag) {
            return null;
        }
        HashSet specifyIds = Sets.newHashSetWithExpectedSize((int)10);
        ArrayList<Long> groupIds = new ArrayList<Long>(10);
        DynamicObjectCollection dynCols = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynObj : dynCols) {
            if (dynObj.getDynamicObject("material") != null) {
                String key = String.format("%s@0@%s@%s@%s@%s@%s", this.getDynLongId(dynObj, "material"), this.getDynLongId(dynObj, "auxpty"), this.getDynLongId(dynObj, "configuredcode"), this.getDynLongId(dynObj, "tracknumber"), this.getDynLongId(dynObj, "project"), dynObj.getString("lot"));
                specifyIds.add(key);
            }
            if (dynObj.getDynamicObject("materialgroup") == null) continue;
            groupIds.add(dynObj.getDynamicObject("materialgroup").getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty(groupIds)) {
            QFilter tmpFilter = new QFilter("group.id", "in", groupIds);
            tmpFilter.and("standard", "=", (Object)groupstandard.getLong("id"));
            DataSet tmpDataSet = QueryServiceHelper.queryDataSet((String)"materialgroup", (String)"bd_materialgroupdetail", (String)"material as id", (QFilter[])tmpFilter.toArray(), null);
            for (Row row : tmpDataSet) {
                specifyIds.add(String.format("%s@0@%s@%s@%s@%s@%s", row.getLong("id"), 0L, 0L, 0L, 0L, ""));
            }
        }
        if (CadEmptyUtils.isEmpty((Set)specifyIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u52fe\u9009\u4e86\u6307\u5b9a\u7269\u6599\u8fdb\u884c\u5dee\u5f02\u5206\u644a\uff0c\u8bf7\u5148\u9009\u62e9\u5bf9\u5e94\u7684\u7269\u6599\u3002", (String)"DiffCalcWizards_21", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        return specifyIds;
    }

    private long getDynLongId(DynamicObject dyn, String key) {
        DynamicObject cdDyn = dyn.getDynamicObject(key);
        if (cdDyn == null) {
            return 0L;
        }
        return cdDyn.getLong("id");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            switch (e.getOperateKey()) {
                case "diffcalc": {
                    this.doCalc();
                    break;
                }
                case "check": {
                    this.doCheck();
                }
            }
        }
    }

    private void doCalc() {
        if (!this.conditionVilidator(RstoreCalcEnum.RESTORE_CALC)) {
            return;
        }
        boolean isSpecifyMaterial = this.getModel().getDataEntity().getBoolean("isspecifymaterial");
        Set<String> specifyMatIds = null;
        if (isSpecifyMaterial && CadEmptyUtils.isEmpty(specifyMatIds = this.getSpecifyIds())) {
            return;
        }
        try {
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)ResManager.loadKDString((String)"\u5f00\u542f\u8ba1\u7b97", (String)"DiffCalcWizards_3", (String)"macc-sca-form", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u5f00\u542f\u8ba1\u7b97", (String)"DiffCalcWizards_4", (String)"macc-sca-form", (Object[])new Object[0]), (String)"sca_differencecalcwizards", (IDataModel)this.getModel());
        }
        catch (Exception e) {
            logger.error("+++++\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u5199\u64cd\u4f5c\u65e5\u5fd7\u9519\u8bef" + e.getMessage());
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        String orgName = org.getLocaleString("name").getLocaleValue();
        DynamicObject acct = this.getModel().getDataEntity().getDynamicObject("costaccount");
        try {
            String lockErr = CalcMutexHelper.checkAndRequireXMutex((String)"diffcalc", (Object)acct.getString("id"));
            if (StringUtils.isNotEmpty((String)lockErr)) {
                this.getView().showErrorNotification(String.format(lockErr, orgName));
                return;
            }
            String calcParam = this.buildCalcParam(specifyMatIds);
            if (CadEmptyUtils.isEmpty((String)calcParam)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u7b97\u8303\u56f4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u3002", (String)"DiffCalcWizards_6", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            JSONObject calcParamJs = JSONObject.fromObject((Object)calcParam);
            Long calcTaskConfigId = RestoreCalcCheck.CALCTASKID;
            RestoreTaskHelper.startDiffRunTask(this.getView(), this.getModel(), calcTaskConfigId, calcParamJs.toString(), isSpecifyMaterial ? "3" : "2");
        }
        catch (Exception e) {
            CalcMutexHelper.releaseXMutex((String)"diffcalc", (Object)acct.getString("id"));
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private void doCheck() {
        if (!this.conditionVilidator(RstoreCalcEnum.RESTORE_CHECK)) {
            return;
        }
        boolean flag = this.getModel().getDataEntity().getBoolean("isspecifymaterial");
        Set<String> specifyMatIds = null;
        if (flag && CadEmptyUtils.isEmpty(specifyMatIds = this.getSpecifyIds())) {
            return;
        }
        String checkParam = this.buildCalcParam(specifyMatIds);
        if (CadEmptyUtils.isEmpty((String)checkParam)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u7b97\u8303\u56f4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u5408\u6cd5\u6027\u68c0\u67e5\u3002", (String)"DiffCalcWizards_7", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("cad_checktasksetting");
        lsp.setCustomParam("checktype", (Object)"1");
        lsp.setCustomParam("calcParam", (Object)checkParam);
        lsp.setCustomParam("calType", (Object)"sca_differencecalcwizards");
        lsp.setCaption(ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u5408\u6cd5\u6027\u68c0\u67e5", (String)"DiffCalcWizards_8", (String)"macc-sca-form", (Object[])new Object[0]));
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(lsp);
    }

    private boolean conditionVilidator(RstoreCalcEnum RstoreType) {
        String operationName = "";
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        if (this.getModel().getValue("org") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DiffCalcWizards_9", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        qfList.add(new QFilter("org", "=", ((DynamicObject)this.getModel().getValue("org")).get("id")));
        if (this.getModel().getValue("costaccount") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DiffCalcWizards_10", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        Long costAccountId = ((DynamicObject)this.getModel().getValue("costaccount")).getLong("id");
        DynamicObject costaccountDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount");
        if (costaccountDyn == null || !costaccountDyn.getBoolean("enable")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DiffCalcWizards_22", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        DynamicObject period = PeriodHelper.getCurrentPeriod((Long)costAccountId);
        this.getModel().setValue("period", (Object)period);
        qfList.add(new QFilter("costaccount", "=", (Object)costAccountId));
        String appId = this.getView().getFormShowParameter().getAppId();
        qfList.add(new QFilter("tab", "=", (Object)"costaccounttabpage"));
        qfList.add(new QFilter("appnum", "=", (Object)appId));
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cad_sysparam", (String)"reductstrategy", (QFilter[])qfList.toArray(new QFilter[0]));
        if (result.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u5931\u8d25\u3002\u8bf7\u914d\u7f6e\u5dee\u5f02\u5206\u644a\u7b56\u7565(\u8def\u5f84:\u6807\u51c6\u6210\u672c\u6838\u7b97-\u6210\u672c\u53c2\u6570-\u6210\u672c\u6838\u7b97\u53c2\u6570)", (String)"DiffCalcWizards_11", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        if (((DynamicObject)result.get(0)).get("reductstrategy").equals("OVERALL_REDUCT")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u542f\u7528\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u3002\u5f53\u524d\u5dee\u5f02\u5206\u644a\u7b56\u7565\u662f\u7efc\u5408\u5206\u644a\uff0c\u9700\u8981\u8c03\u6574\u4e3a\u5206\u9879\u5206\u644a\u624d\u53ef\u4ee5\u542f\u7528\u3002", (String)"DiffCalcWizards_12", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        operationName = RstoreCalcEnum.RESTORE_CALC == RstoreType ? ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25", (String)"DiffCalcWizards_13", (String)"macc-sca-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u5931\u8d25\u3002", (String)"DiffCalcWizards_14", (String)"macc-sca-form", (Object[])new Object[0]);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"DiffCalcWizards_15", (String)"macc-sca-form", (Object[])new Object[0]), operationName));
            return false;
        }
        DynamicObject acct = this.getModel().getDataEntity().getDynamicObject("costaccount");
        if (acct == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff0c\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"DiffCalcWizards_16", (String)"macc-sca-form", (Object[])new Object[0]), operationName));
            return false;
        }
        return true;
    }

    private String buildCalcParam(Set<String> specifyMatIds) {
        JSONObject calcParamJs = new JSONObject();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return null;
        }
        calcParamJs.accumulate("org", org.getLong("masterid"));
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            return null;
        }
        calcParamJs.accumulate("costaccount", costAccount.getLong("masterid"));
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period != null) {
            calcParamJs.accumulate("period", period.getLong("id"));
            calcParamJs.accumulate("startDate", (Object)TimeUtils.formatDate((Date)period.getDate("begindate"), (String)"yyyy-MM-dd HH:mm:ss"));
            calcParamJs.accumulate("endDate", (Object)TimeUtils.formatDate((Date)period.getDate("enddate"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        calcParamJs.accumulate("currencyId", currency.getLong("masterid"));
        calcParamJs.accumulate("status", this.getModel().getValue("status"));
        Boolean validitycheck = (Boolean)this.getModel().getValue("validitycheck");
        calcParamJs.accumulate("validitycheck", (Object)validitycheck);
        Boolean domatcoll = (Boolean)this.getModel().getValue("domatcoll");
        calcParamJs.accumulate("domatcoll", (Object)domatcoll);
        Boolean parallel = (Boolean)this.getModel().getValue("parallel");
        calcParamJs.accumulate("parallel", (Object)parallel);
        if (!CadEmptyUtils.isEmpty(specifyMatIds)) {
            calcParamJs.accumulate("specifyMatIds", specifyMatIds);
        }
        return calcParamJs.toString();
    }

    private void setCloseAccount() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            return;
        }
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        if (period == null) {
            return;
        }
        boolean closeAccount = this.isCloseAccount(costAccount.getLong("id"), period.getLong("id"));
        if (closeAccount) {
            this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u662f", (String)"DiffCalcWizards_1", (String)"macc-sca-form", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("status", (Object)ResManager.loadKDString((String)"\u5426", (String)"DiffCalcWizards_2", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    private void setCurrency() {
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costaccount == null) {
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
    }

    private Long getDefaultOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return org.getLong("masterid");
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            return currentOrgId;
        }
        return 0L;
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter accountorgQF = new QFilter("org", "=", (Object)accountOrgId);
        QFilter enablestdtQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        enablestdtQF.and("appnum", "=", (Object)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
        QFilter isinitaccountQF = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF, isinitaccountQF}, (String)"entryentity.costaccount.ismainaccount desc,entryentity.costaccount.id desc");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)result)) {
            return 0L;
        }
        if (((DynamicObject)result.get(0)).getBoolean("ismainaccount") || result.size() == 1) {
            return ((DynamicObject)result.get(0)).getLong("costaccount");
        }
        return 0L;
    }

    private boolean isCloseAccount(Long costaccountId, Long periodId) {
        Date[] periodStartAndEndTime;
        Date periodLastDay;
        QFilter qfIsLeaf;
        QFilter qfBizAcctOrg;
        QFilter qfCostAccount = new QFilter("id", "=", (Object)costaccountId);
        DynamicObject costAccountDO = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)"id,name,calorg,calsystem", (QFilter[])qfCostAccount.toArray());
        String accountSysSelects = "id,bizorgentry.bizorg as ownerid,bizorgentry.bizacctorg as calorgid";
        QFilter qfBizOrg = new QFilter("bizorgentry.bizorg", "<>", (Object)0L);
        DynamicObjectCollection accountingsysDOC = QueryServiceHelper.query((String)"bd_accountingsys", (String)accountSysSelects, (QFilter[])new QFilter[]{qfBizOrg, qfBizAcctOrg = new QFilter("bizorgentry.bizacctorg", "=", (Object)costAccountDO.getLong("calorg"))}, null);
        List ownerIds = accountingsysDOC.stream().map(v -> v.getLong("ownerid")).collect(Collectors.toList());
        QFilter qfOwner = new QFilter("owner", "in", ownerIds);
        DynamicObjectCollection closeInfos = QueryServiceHelper.query((String)"cal_closeaccounttable", (String)"owner,closedate", (QFilter[])new QFilter[]{qfOwner, qfIsLeaf = new QFilter("isleaf", "=", (Object)Boolean.TRUE)}, (String)"closedate");
        if (closeInfos.size() == 0 || ownerIds.size() != closeInfos.size()) {
            return false;
        }
        Date minCloseDate = ((DynamicObject)closeInfos.get(0)).getDate("closedate");
        return minCloseDate.compareTo(periodLastDay = TimeUtils.getDayStartTime((Date)(periodStartAndEndTime = PeriodHelper.getPeriodStartAndEndTime((Long)periodId))[1])) >= 0;
    }
}

