/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.restore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.CostDriverIdConstant;
import kd.macc.cad.common.constants.DutyIdConstants;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.FillBatchHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.enums.AllocMoldEnum;
import kd.macc.sca.common.enums.ScaAllocEnum;

public class OverHeadAllotCostEditPlugin
extends AbstractBillPlugIn {
    protected static final String ISINITED = "isInited";

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("allocmold", (Object)AllocMoldEnum.BASIC_PRODUCT_ALLOC.getValue());
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String appid = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((CharSequence)appid)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5e94\u7528\u6807\u8bc6\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\uff01", (String)"OverHeadAllotCostEditPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        Map sourceData = e.getSourceData();
        sourceData.put("appnum", appid);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.setCostCenterFilter();
    }

    public void initialize() {
        super.initialize();
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isexpense"});
        }
        this.addListener();
    }

    protected void addListener() {
        List permCalOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("id", "in", (Object)permCalOrgIds));
            filterParameter.setQFilters(filters);
        });
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            List manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId());
            QFilter orgfilter = new QFilter("id", "in", (Object)manuorgList);
            formShowParameter.getListFilterParameter().getQFilters().add(orgfilter);
        });
        BasedataEdit costCenterEdit = (BasedataEdit)this.getControl("costcenter");
        costCenterEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("org");
            DynamicObject manuOrg = this.getModel().getDataEntity().getDynamicObject("manuorg");
            filters.add(new QFilter("orgduty", "=", (Object)DutyIdConstants.BASIC_PRODUCT_ID));
            if (acctOrg != null) {
                QFilter billStatusFilter;
                QFilter appnumFilter;
                QFilter manuorgFilter;
                QFilter orgFilter = new QFilter("org", "=", acctOrg.getPkValue());
                DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"sca_overheadallotcost", (String)"costcenter", (QFilter[])new QFilter[]{orgFilter, manuorgFilter = new QFilter("manuorg", "=", manuOrg == null ? Long.valueOf(0L) : manuOrg.getPkValue()), appnumFilter = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()), billStatusFilter = new QFilter("billstatus", "!=", (Object)"A")});
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costCenters)) {
                    Set costCenterIds = costCenters.stream().map(item -> item.getLong("costcenter")).collect(Collectors.toSet());
                    filters.add(new QFilter("id", "not in", costCenterIds));
                }
                Long manuorgId = this.getModel().getDataEntity().getLong("manuorg.id");
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                manuOrgList.add(manuorgId);
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactory((long)acctOrg.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                filters.add(costCenterIdFilter);
            } else {
                filters.add(new QFilter("accountorg", ">", (Object)0L));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit centerGroupEdit = (BasedataEdit)this.getControl("costcentergroup");
        centerGroupEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("org");
            DynamicObject manuOrg = this.getModel().getDataEntity().getDynamicObject("manuorg");
            if (acctOrg != null) {
                boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)acctOrg.getLong("id"));
                QFilter qFilter = new QFilter("org", "=", acctOrg.getPkValue());
                if (isEnableMultiFactory) {
                    qFilter.and(new QFilter("manuorg", "=", manuOrg == null ? Long.valueOf(0L) : manuOrg.getPkValue()));
                }
                filters.add(qFilter);
            }
            Date date = new Date();
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            dateFilter.and("expdate", ">", (Object)date);
            filters.add(dateFilter);
            filterParameter.setQFilters(filters);
        });
        this.f7FilterSelectedItems("expenseitem");
        this.f7FilterSelectedItems("subelement");
        BasedataEdit costDriver = (BasedataEdit)this.getControl("costdriver");
        costDriver.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("enable", "=", (Object)"1"));
            qList.add(new QFilter("status", "=", (Object)"C"));
            List<Long> matQuotaCostDriverIds = this.getMatQuotaDriverIds();
            if (!CadEmptyUtils.isEmpty(matQuotaCostDriverIds)) {
                qList.add(new QFilter("id", "not in", matQuotaCostDriverIds));
            }
            qList.add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
            qList.add(new QFilter("allocclass", "=", (Object)"COSTOBJECT"));
        });
        BasedataEdit subProductEdit = (BasedataEdit)this.getControl("product");
        subProductEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            ArrayList<Long> exsitProductId = new ArrayList<Long>(10);
            DynamicObjectCollection subentryentity1 = this.getModel().getEntryEntity("subentryentity1");
            for (DynamicObject subentry : subentryentity1) {
                exsitProductId.add(subentry.getLong("product.masterid"));
            }
            qFilters.add(new QFilter("masterid", "not in", exsitProductId));
        });
    }

    private List<Long> getMatQuotaDriverIds() {
        ArrayList<Long> matQuotaCostDriverIds = new ArrayList<Long>();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        QFilter complexFilter = new QFilter("iscomplexcd", "=", (Object)true);
        DynamicObjectCollection complexCostDrivers = QueryServiceHelper.query((String)"cad_costdriver", (String)"id,formula", (QFilter[])new QFilter[]{qFilter, complexFilter});
        for (DynamicObject costDriver : complexCostDrivers) {
            String formula = costDriver.getString("formula");
            List<Long> costDriverIds = OverHeadAllotCostEditPlugin.getCostDriverIds(formula);
            if (costDriverIds == null || !costDriverIds.contains(CostDriverIdConstant.MAT_QUOTA_ACA)) continue;
            matQuotaCostDriverIds.add(costDriver.getLong("id"));
        }
        return matQuotaCostDriverIds;
    }

    private static List<Long> getCostDriverIds(String formula) {
        String[] formulaArr;
        if (StringUtils.isEmpty((CharSequence)formula)) {
            return null;
        }
        String formulaString = formula.replaceAll("\\s*", "");
        ArrayList<Long> costDriverIds = new ArrayList<Long>();
        if (StringUtils.isNotEmpty((CharSequence)formulaString) && (formulaArr = formulaString.split("\\D")) != null) {
            for (String id : formulaArr) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                costDriverIds.add(Long.valueOf(id));
            }
        }
        return costDriverIds;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "batchfillentry": {
                FillBatchHelper.batchFill((IFormView)this.getView(), (String)"entryentity", (String[])new String[]{"costdriver"});
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long id = this.getModel().getDataEntity().getLong("id");
        if (CadEmptyUtils.isEmpty((Long)id) && CadEmptyUtils.isEmpty((String)this.getPageCache().get(ISINITED))) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String costCenterId = (String)fsp.getCustomParam("costcenter");
            this.getModel().setValue("costcenter", (Object)costCenterId);
            String manuorgId = (String)fsp.getCustomParam("manuorg");
            if (StringUtils.isNotEmpty((CharSequence)manuorgId)) {
                this.getModel().setValue("manuorg", (Object)Long.valueOf(manuorgId));
            }
            this.getPageCache().put(ISINITED, "true");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideFields();
        this.hideCenterGroupFields();
        this.hideEntryFields();
        this.enableManuOrg();
        this.changManuorgStatus();
        AppIdHelper.setAppIdWhenAddNew((IFormView)this.getView(), (IDataModel)this.getModel());
        this.setDefaultValueOnAdd();
    }

    private void setDefaultValueOnAdd() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            this.getModel().setValue("issender", (Object)true);
            if (AppIdHelper.isSCA((IFormView)this.getView())) {
                this.getModel().setValue("isexpense", (Object)false);
            } else {
                this.getModel().setValue("isexpense", (Object)true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.enableManuOrg();
                this.changManuorgStatus();
                break;
            }
            case "manuorg": {
                this.getModel().setValue("costcenter", null);
                this.getModel().setValue("costcentergroup", null);
                break;
            }
            case "issender": {
                this.hideCenterGroupFields();
                break;
            }
            case "isexpense": {
                this.deleteEntryEntityAndAddNewRow();
                this.hideEntryFields();
                break;
            }
        }
    }

    private void hideCenterGroupFields() {
        boolean isBeneFiciary = (Boolean)this.getModel().getValue("issender");
        if (isBeneFiciary) {
            this.getModel().setValue("costcentergroup", null);
        } else {
            this.getModel().setValue("costcenter", null);
        }
        this.getView().setVisible(Boolean.valueOf(isBeneFiciary), new String[]{"costcenter"});
        this.getView().setVisible(Boolean.valueOf(!isBeneFiciary), new String[]{"costcentergroup"});
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcenter");
        BasedataEdit costCenterGroup = (BasedataEdit)this.getControl("costcentergroup");
        costCenter.setMustInput(isBeneFiciary);
        costCenterGroup.setMustInput(!isBeneFiciary);
    }

    private void hideEntryFields() {
        boolean isExpense = (Boolean)this.getModel().getValue("isexpense");
        this.getView().setVisible(Boolean.valueOf(isExpense), new String[]{"expenseitem"});
        this.getView().setVisible(Boolean.valueOf(isExpense), new String[]{"expenseitemnumber"});
        this.getView().setVisible(Boolean.valueOf(!isExpense), new String[]{"subelement"});
        BasedataEdit expenseItem = (BasedataEdit)this.getControl("expenseitem");
        BasedataEdit subElement = (BasedataEdit)this.getControl("subelement");
        expenseItem.setMustInput(isExpense);
        subElement.setMustInput(!isExpense);
    }

    private void deleteEntryEntityAndAddNewRow() {
        this.getModel().deleteEntryData("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entryEntity.addNew();
        this.getView().updateView("entryentity");
    }

    private void f7FilterSelectedItems(String controlName) {
        BasedataEdit productGroupEdit = (BasedataEdit)this.getControl(controlName);
        productGroupEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> productGroupFilters = new ArrayList<QFilter>();
            ArrayList<Long> selectedExpenseItemIds = new ArrayList<Long>();
            DynamicObjectCollection entryInfos = this.getModel().getEntryEntity("entryentity");
            for (int index = 0; index < entryInfos.size(); ++index) {
                DynamicObject rowObject = (DynamicObject)entryInfos.get(index);
                DynamicObject productGroup = (DynamicObject)rowObject.get(controlName);
                if (productGroup == null) continue;
                selectedExpenseItemIds.add(productGroup.getLong("masterid"));
            }
            QFilter selectedExpenseItemFilter = new QFilter("masterid", "not in", (Object)selectedExpenseItemIds.toArray());
            if ("productgroup".equals(controlName)) {
                QFilter otherFilter = new QFilter("grouptype", "=", (Object)"3");
                productGroupFilters.add(otherFilter);
            }
            if ("expenseitem".equals(controlName)) {
                QFilter isleafFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
                productGroupFilters.add(isleafFilter);
            }
            productGroupFilters.add(selectedExpenseItemFilter);
            filterParameter.setQFilters(productGroupFilters);
        });
    }

    private void hideFields() {
        String allocMold = this.getModel().getDataEntity().getString("allocmold");
        if (allocMold == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"productgroup"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"benifitcostcenterplane"});
            return;
        }
        Boolean isBasicProduct = ScaAllocEnum.BASIC_PRODUCT_ALLOC.getValue().equals(allocMold);
        if (!isBasicProduct.booleanValue()) {
            this.getModel().setValue("issender", (Object)Boolean.TRUE);
        }
        this.getView().setEnable(isBasicProduct, new String[]{"issender"});
        this.getView().setVisible(isBasicProduct, new String[]{"productgroup"});
        this.getView().setVisible(Boolean.valueOf(isBasicProduct == false), new String[]{"benifitcostcenterplane"});
        this.getView().setVisible(Boolean.valueOf(!AppIdHelper.isSCA((IFormView)this.getView())), new String[]{"allocdim"});
    }

    private void setCostCenterFilter() {
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcenter");
        costCenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Object allocMold = this.getModel().getDataEntity().get("allocmold");
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            if (ScaAllocEnum.NON_PRODUCT_ALLOC.getValue().equals(allocMold)) {
                qFilters.add(new QFilter("orgduty", "not in", Arrays.asList(DutyIdConstants.BASIC_PRODUCT_ID, DutyIdConstants.ASSIST_PRODUCT_ID)));
            }
            if (ScaAllocEnum.ASSIST_PRODUCT_ALLOC.getValue().equals(allocMold)) {
                qFilters.add(new QFilter("orgduty", "=", (Object)DutyIdConstants.ASSIST_PRODUCT_ID));
            }
            if (ScaAllocEnum.BASIC_PRODUCT_ALLOC.getValue().equals(allocMold)) {
                qFilters.add(new QFilter("orgduty", "=", (Object)DutyIdConstants.BASIC_PRODUCT_ID));
            }
        });
    }

    private int getEnableMulFactory(Long orgId) {
        DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts((Long)orgId, (Boolean)true, (String)this.getView().getFormShowParameter().getAppId());
        int i = 0;
        for (DynamicObject obj : costAccounts) {
            if (!CostAccountHelper.isEnableMulFactory((Long)obj.getLong("id"))) continue;
            ++i;
        }
        if (i != 0 && i == costAccounts.size()) {
            i = Integer.MAX_VALUE;
        }
        return i;
    }

    private void enableManuOrg() {
        DynamicObject obj = this.getModel().getDataEntity().getDynamicObject("org");
        if (obj == null) {
            return;
        }
        Long orgId = obj.getLong("id");
        boolean enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        if (!enableMultiFactory) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"manuorg"});
            this.getModel().setValue("manuorg", null);
            BasedataEdit manuorgEdit = (BasedataEdit)this.getControl("manuorg");
            manuorgEdit.setMustInput(false);
        } else {
            BasedataEdit manuorgEdit = (BasedataEdit)this.getControl("manuorg");
            manuorgEdit.setMustInput(true);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"manuorg"});
        }
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

