/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.restore;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import kd.macc.sca.formplugin.base.BaseOrgAndCostCenterFilterList;

public class OverHeadAllotCostListPlugin
extends BaseOrgAndCostCenterFilterList {
    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("org.number asc,billno asc");
        e.addCustomQFilter(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("new".equals(operateKey)) {
            boolean isValid = this.checkOrg();
            if (!isValid) {
                args.setCancel(true);
            }
            return;
        }
    }

    private boolean checkOrg() {
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        if (CadEmptyUtils.isEmpty((String)orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OverHeadAllotCostListPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            if (!column.toString().equals("billno")) continue;
            column.setFixed(true);
            break;
        }
        HashSet hiddenKeys = Sets.newHashSet((Object[])new String[]{"isexpense"});
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, (Set)hiddenKeys);
        }
    }

    @Override
    protected List<ComboItem> getCostCenterComboItemList(String orgId) {
        Long orgduty = 4L;
        ArrayList<Long> orgdutys = new ArrayList<Long>();
        orgdutys.add(orgduty);
        return this.getCostCenterComboItemListBy(orgId, orgdutys);
    }

    @Override
    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)"sca_overheadallotcost", (String)"47150e89000000ac", (String)this.getView().getFormShowParameter().getAppId());
    }
}

