/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.restore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class OverheadAllotCostSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final List<String> SYS_ALLOC_DIM = Lists.newArrayList((Object[])new String[]{"projectnumber", "tracknumber", "lot"});

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("costcenter");
        fieldKeys.add("manuorg");
        fieldKeys.add("billstatus");
        fieldKeys.add("issender");
        fieldKeys.add("isexpense");
        fieldKeys.add("costcentergroup");
        fieldKeys.add("subelement");
        fieldKeys.add("expenseitem");
        fieldKeys.add("costdriver");
        fieldKeys.add("allocdim");
        fieldKeys.add("appnum");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                HashSet<String> excludeKeys = new HashSet<String>(this.dataEntities.length);
                ExtendedDataEntity[] dataEntities = this.dataEntities;
                HashMap<Long, Boolean> enableManorgMap = new HashMap<Long, Boolean>();
                MainEntityType costObjectEntityType = EntityMetadataCache.getDataEntityType((String)"cad_costobject");
                MainEntityType mfgFeeBillEntityType = EntityMetadataCache.getDataEntityType((String)"cad_mfgfeebill");
                MainEntityType nonProdEntityType = EntityMetadataCache.getDataEntityType((String)"cad_nonprodalloc");
                MainEntityType basicEntityType = EntityMetadataCache.getDataEntityType((String)"cad_basicalloc");
                MainEntityType coEntityType = EntityMetadataCache.getDataEntityType((String)"cad_mfgfeeallocco");
                MainEntityType allocStdEntityType = EntityMetadataCache.getDataEntityType((String)"sca_overheadallotcost");
                IDataEntityProperty allocDimProperty = allocStdEntityType.findProperty("allocdim");
                List comboItems = new ArrayList();
                if (allocDimProperty != null) {
                    comboItems = ((MulComboProp)allocDimProperty).getComboItems();
                }
                HashMap comboNameMap = new HashMap(4);
                for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                    boolean isExpense;
                    QFilter qFilter;
                    String[] split;
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    String allocDim = dataEntity.getString("allocdim");
                    boolean allocDimCheckPass = true;
                    if (!CadEmptyUtils.isEmpty((String)allocDim) && (split = allocDim.split(",")) != null && split.length > 1) {
                        for (String arr : split) {
                            if (CadEmptyUtils.isEmpty((String)arr) || SYS_ALLOC_DIM.contains(arr)) continue;
                            String allocDimShowName = OverheadAllotCostSaveOpPlugin.this.getComboName(comboItems, comboNameMap, arr);
                            if (costObjectEntityType.findProperty(arr) == null) {
                                allocDimCheckPass = false;
                                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"OverheadAllotCostSaveOpPlugin_26", (String)"macc-sca-form", (Object[])new Object[0]), arr, allocDimShowName, allocDimShowName));
                            }
                            if (mfgFeeBillEntityType.findProperty(arr) == null) {
                                allocDimCheckPass = false;
                                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"OverheadAllotCostSaveOpPlugin_27", (String)"macc-sca-form", (Object[])new Object[0]), arr, allocDimShowName, allocDimShowName));
                            }
                            if (nonProdEntityType.findProperty(arr) == null) {
                                allocDimCheckPass = false;
                                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"OverheadAllotCostSaveOpPlugin_28", (String)"macc-sca-form", (Object[])new Object[0]), arr, allocDimShowName, allocDimShowName));
                            }
                            if (basicEntityType.findProperty(arr) == null) {
                                allocDimCheckPass = false;
                                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"OverheadAllotCostSaveOpPlugin_29", (String)"macc-sca-form", (Object[])new Object[0]), arr, allocDimShowName, allocDimShowName));
                            }
                            if (coEntityType.findProperty(arr) != null) continue;
                            allocDimCheckPass = false;
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"OverheadAllotCostSaveOpPlugin_25", (String)"macc-sca-form", (Object[])new Object[0]), arr, allocDimShowName, allocDimShowName));
                        }
                    }
                    if (!allocDimCheckPass) {
                        return;
                    }
                    Long id = dataEntity.getLong("id");
                    String billno = dataEntity.getString("billno");
                    boolean isSender = dataEntity.getBoolean("issender");
                    HashSet<Long> costCenterIds = new HashSet<Long>(16);
                    if (isSender) {
                        if (dataEntity.get("costcenter") == null) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6309\u6210\u672c\u4e2d\u5fc3\u8bbe\u7f6e\u53d1\u9001\u65b9\uff0c\u6210\u672c\u4e2d\u5fc3\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"OverheadAllotCostSaveOpPlugin_15", (String)"macc-sca-form", (Object[])new Object[0]));
                            continue;
                        }
                        costCenterIds.add(dataEntity.getLong("costcenter.id"));
                    } else {
                        if (dataEntity.get("costcentergroup") == null) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6309\u6210\u672c\u4e2d\u5fc3\u7ec4\u8bbe\u7f6e\u53d1\u9001\u65b9\uff0c\u6210\u672c\u4e2d\u5fc3\u7ec4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"OverheadAllotCostSaveOpPlugin_16", (String)"macc-sca-form", (Object[])new Object[0]));
                            continue;
                        }
                        long centerGroupId = dataEntity.getLong("costcentergroup.id");
                        qFilter = new QFilter("id", "=", (Object)centerGroupId);
                        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"id, entryentity.costcenter as costcenter", (QFilter[])qFilter.toArray());
                        costCenters.forEach(s -> costCenterIds.add(s.getLong("costcenter")));
                    }
                    if ("save".equals(this.getOperateKey()) || "submit".equals(this.getOperateKey())) {
                        this.verifyManuorg(extendedDataEntity, dataEntity, enableManorgMap);
                    }
                    if ("submit".equals(this.getOperateKey()) || "audit".equals(this.getOperateKey())) {
                        Long orgid = dataEntity.getLong("org.id");
                        Long manuOrgid = dataEntity.getLong("manuorg.id");
                        qFilter = new QFilter("org", "=", (Object)orgid);
                        qFilter.and("manuorg", "=", (Object)manuOrgid);
                        qFilter.and("entryentity.costcenter", "in", costCenterIds);
                        qFilter.and(OverheadAllotCostSaveOpPlugin.this.getEffectDateFilter());
                        Iterator statusFilter = new QFilter("status", "=", (Object)"C");
                        statusFilter.and("enable", "=", Boolean.TRUE);
                        DynamicObjectCollection costCenterGroups = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"id", (QFilter[])new QFilter[]{qFilter, statusFilter});
                        HashSet centerGroups = new HashSet(16);
                        costCenterGroups.forEach(s -> centerGroups.add(s.getLong("id")));
                        String appNum = dataEntity.getString("appnum");
                        boolean isExistBillByGroup = OverheadAllotCostSaveOpPlugin.this.isExistBillByGroup(centerGroups, orgid, manuOrgid, id, appNum);
                        for (Long costcenterId : costCenterIds) {
                            String key = String.format("%s@%s@%s", costcenterId, orgid, manuOrgid);
                            boolean isExist = OverheadAllotCostSaveOpPlugin.this.isExistBill(costcenterId, orgid, manuOrgid, id, appNum);
                            if (isExist || excludeKeys.contains(key) || isExistBillByGroup) {
                                StringBuilder sb = new StringBuilder();
                                sb.append(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7", (String)"OverheadAllotCostSaveOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                                if (manuOrgid != null && manuOrgid > 0L) {
                                    sb.append(ResManager.loadKDString((String)"+\u751f\u4ea7\u7ec4\u7ec7", (String)"OverheadAllotCostSaveOpPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                                }
                                if (costcenterId != null && costcenterId > 0L) {
                                    QFilter costCenterFilter = new QFilter("id", "=", (Object)costcenterId);
                                    DynamicObject costCenter = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"id, number, name", (QFilter[])costCenterFilter.toArray());
                                    sb.append(String.format(ResManager.loadKDString((String)"+\u6210\u672c\u4e2d\u5fc3\u3010%1$s/%2$s\u3011", (String)"OverheadAllotCostSaveOpPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]), costCenter.getString("number"), costCenter.getString("name")));
                                }
                                if (sb.length() > 6) {
                                    sb.append(ResManager.loadKDString((String)"\u7ec4\u5408\u4e0b", (String)"OverheadAllotCostSaveOpPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                                }
                                sb.append(ResManager.loadKDString((String)"\u5df2\u7ecf\u7ef4\u62a4\u4e86\u5236\u9020\u8d39\u7528\u5206\u914d\u6807\u51c6\u3002", (String)"OverheadAllotCostSaveOpPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002%s", (String)"OverheadAllotCostSaveOpPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]), sb.toString()));
                            }
                            excludeKeys.add(key);
                        }
                    }
                    if ("0".equals(dataEntity.getString("id"))) {
                        boolean isExist = OverheadAllotCostSaveOpPlugin.this.isExistBill(billno);
                        if (isExist && "submit".equals(this.getOperateKey())) {
                            this.addErrorMessage(extendedDataEntity, String.format(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u3010%s\u3011\u5206\u914d\u6807\u51c6\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"OverheadAllotCostSaveOpPlugin_17", (String)"macc-sca-form", (Object[])new Object[0]), billno), new Object[0]));
                        }
                        if (isExist && "save".equals(this.getOperateKey())) {
                            this.addErrorMessage(extendedDataEntity, String.format(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u3010%s\u3011\u5206\u914d\u6807\u51c6\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"OverheadAllotCostSaveOpPlugin_18", (String)"macc-sca-form", (Object[])new Object[0]), billno), new Object[0]));
                        }
                    }
                    if (!(isExpense = dataEntity.getBoolean("isexpense"))) {
                        HashSet<Long> subElementIds = new HashSet<Long>(16);
                        DynamicObjectCollection entryCollect = dataEntity.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entry : entryCollect) {
                            long subelementId = entry.getLong("subelement.id");
                            if (subElementIds.contains(subelementId)) {
                                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u6210\u672c\u5b50\u8981\u7d20\u7ef4\u62a4\u91cd\u590d\u3002", (String)"OverheadAllotCostSaveOpPlugin_20", (String)"macc-sca-form", (Object[])new Object[0]));
                            }
                            subElementIds.add(subelementId);
                        }
                    }
                    int index = 1;
                    String errorTip = isExpense ? String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u7ef4\u62a4\u7b2c%s\u884c\u8d39\u7528\u9879\u76ee/\u5206\u914d\u6807\u51c6\u3002", (String)"OverheadAllotCostSaveOpPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), index) : String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u7ef4\u62a4\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20/\u5206\u914d\u6807\u51c6\u3002", (String)"OverheadAllotCostSaveOpPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]), index);
                    DynamicObjectCollection entryCollect = dataEntity.getDynamicObjectCollection("entryentity");
                    if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryCollect)) {
                        this.addErrorMessage(extendedDataEntity, errorTip);
                    }
                    for (DynamicObject entry : entryCollect) {
                        long costDriverId = entry.getLong("costdriver.id");
                        if (isExpense) {
                            long expenseitemId = entry.getLong("expenseitem.id");
                            if (CadEmptyUtils.isEmpty((Long)expenseitemId) || CadEmptyUtils.isEmpty((Long)costDriverId)) {
                                this.addErrorMessage(extendedDataEntity, errorTip);
                            }
                        } else {
                            long subelementId = entry.getLong("subelement.id");
                            if (CadEmptyUtils.isEmpty((Long)subelementId) || CadEmptyUtils.isEmpty((Long)costDriverId)) {
                                this.addErrorMessage(extendedDataEntity, errorTip);
                            }
                        }
                        ++index;
                    }
                }
                OverheadAllotCostSaveOpPlugin.this.realData(dataEntities);
            }

            private boolean verifyManuorg(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, Map<Long, Boolean> enableManorgMap) {
                Long orgId = dataEntity.getLong("org.id");
                if (!enableManorgMap.containsKey(orgId)) {
                    String appId = dataEntity.getString("appnum");
                    DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts((Long)orgId, (Boolean)true, (String)appId);
                    String appName = AppIdHelper.getAppName((String)appId);
                    if (costAccounts.isEmpty()) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u542f\u7528%s\u6216\u6210\u672c\u8d26\u8584\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"OverheadAllotCostSaveOpPlugin_14", (String)"macc-sca-form", (Object[])new Object[0]), appName));
                        return true;
                    }
                    for (DynamicObject obj : costAccounts) {
                        if (!CostAccountHelper.isEnableMulFactory((Long)obj.getLong("id"))) continue;
                        enableManorgMap.put(orgId, Boolean.TRUE);
                        break;
                    }
                    if (!enableManorgMap.containsKey(orgId)) {
                        enableManorgMap.put(orgId, Boolean.FALSE);
                    }
                }
                Long manuorgId = dataEntity.getLong("manuorg.id");
                if (enableManorgMap.get(orgId).booleanValue()) {
                    if (manuorgId == null || manuorgId == 0L) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0e\u6210\u672c\u8d26\u7c3f\u7ec4\u5408\u4e0b\u542f\u7528\u591a\u5de5\u5382\uff0c\u751f\u4ea7\u7ec4\u7ec7\u5fc5\u5f55\u3002", (String)"OverheadAllotCostSaveOpPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]));
                        return true;
                    }
                } else if (manuorgId != null && manuorgId > 0L) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0e\u6210\u672c\u8d26\u7c3f\u7ec4\u5408\u4e0b\u672a\u542f\u7528\u591a\u5de5\u5382\uff0c\u751f\u4ea7\u7ec4\u7ec7\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"OverheadAllotCostSaveOpPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]));
                    return true;
                }
                return false;
            }
        });
    }

    private String getComboName(List<ValueMapItem> comboItems, Map<String, String> comboNameMap, String arr) {
        if (comboNameMap.containsKey(arr)) {
            return comboNameMap.get(arr);
        }
        String comboName = "";
        for (ValueMapItem combo : comboItems) {
            comboNameMap.put(combo.getValue(), combo.getName().getLocaleValue());
            if (!combo.getValue().equals(arr)) continue;
            comboName = combo.getName().getLocaleValue();
        }
        return comboName;
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<Long> expenseitemIdList = new ArrayList<Long>();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                expenseitemIdList.add(entry.getLong("expenseitem.id"));
            }
        }
        Map expenseitemMap = MfgfeeBillImportHelper.expenseitemIdToMasterId(expenseitemIdList);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                Long expenseitemMasterId = (Long)expenseitemMap.get(entry.getLong("expenseitem.id"));
                if (CadEmptyUtils.isEmpty((Long)expenseitemMasterId)) continue;
                entry.set("expenseitem_id", (Object)expenseitemMasterId);
            }
        }
    }

    private QFilter getEffectDateFilter() {
        Date date = new Date();
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        return dateFilter;
    }

    private boolean isExistBill(String billno) {
        QFilter billnoFilter = new QFilter("billno", "=", (Object)billno);
        return QueryServiceHelper.exists((String)"sca_overheadallotcost", (QFilter[])new QFilter[]{billnoFilter});
    }

    private boolean isExistBill(Long costcenterId, long orgid, Long manuOrg, Long id, String appnum) {
        QFilter billnoFilter = new QFilter("costcenter.id", "=", (Object)costcenterId);
        QFilter billstatusFilter = new QFilter("billstatus", "!=", (Object)"A");
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgid);
        QFilter manuOrgFilter = new QFilter("manuorg.id", "=", (Object)manuOrg);
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appnum);
        return QueryServiceHelper.exists((String)"sca_overheadallotcost", (QFilter[])new QFilter[]{billnoFilter, billstatusFilter, orgFilter, manuOrgFilter, idFilter, appnumFilter});
    }

    private boolean isExistBillByGroup(Set<Long> centerGroupId, long orgid, Long manuOrg, Long id, String appnum) {
        QFilter billnoFilter = new QFilter("costcentergroup.id", "in", centerGroupId);
        QFilter billstatusFilter = new QFilter("billstatus", "!=", (Object)"A");
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgid);
        QFilter manuOrgFilter = new QFilter("manuorg.id", "=", (Object)manuOrg);
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appnum);
        return QueryServiceHelper.exists((String)"sca_overheadallotcost", (QFilter[])new QFilter[]{billnoFilter, billstatusFilter, orgFilter, manuOrgFilter, idFilter, appnumFilter});
    }

    private void realData(ExtendedDataEntity[] dataEntity) {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject diyBill = entity.getDataEntity();
            boolean issender = diyBill.getBoolean("issender");
            boolean isexpense = diyBill.getBoolean("isexpense");
            if (issender) {
                diyBill.set("costcentergroup", null);
            } else {
                diyBill.set("costcenter", null);
            }
            DynamicObjectCollection entrys = diyBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (isexpense) {
                    entry.set("subelement", null);
                    continue;
                }
                entry.set("expenseitem", null);
            }
        }
    }
}

