/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.formplugin.restore;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.RestoreCalcReportHelper;
import kd.macc.sca.algox.utils.RestoreCheckHelper;
import kd.macc.sca.algox.utils.TimeUtils;

public class RestoreTaskHelper {
    public static void upateTaskRecord(Long taskId, int mProgess, String status, Long executor) {
        Long lastRecordId = RestoreTaskHelper.getLastTaskRecordId(taskId, executor);
        QFilter filter = new QFilter("id", "=", (Object)lastRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty((Object[])records)) {
            Object record = records[0];
            long totalProgress = record.getLong("progress") + (long)mProgess;
            if (totalProgress >= 100L) {
                record.set("progress", (Object)100);
            } else {
                record.set("progress", (Object)totalProgress);
            }
            record.set("time", (Object)TimeUtils.getSecond((Date)record.getDate("starttime"), (Date)new Date()));
            record.set("status", (Object)status);
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static void upateTaskRecordEntry(Long taskId, Long taskDetailId, String status, Long executor) {
        Long lastRecordId = RestoreTaskHelper.getLastTaskRecordId(taskId, executor);
        QFilter filter = new QFilter("id", "=", (Object)lastRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty((Object[])records)) {
            Object record = records[0];
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskDetailId.compareTo(entry.getLong("detailconfig")) != 0) continue;
                entry.set("substatus", (Object)status);
                if ("2".equals(status) && entry.getDate("substarttime") == null) {
                    entry.set("substarttime", (Object)new Date());
                }
                if (!"4".equals(status)) continue;
                entry.set("subtime", (Object)TimeUtils.getMilliSecond((Date)entry.getDate("substarttime"), (Date)new Date()));
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static void upateTaskRecordEntryPara(Long taskConfigId, Long taskConfigDetailId, String detail, String nextPagePara, Long executor) {
        Long lastRecordId = RestoreTaskHelper.getLastTaskRecordId(taskConfigId, executor);
        QFilter filter = new QFilter("id", "=", (Object)lastRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subparam", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty((Object[])records)) {
            Object record = records[0];
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskConfigDetailId.compareTo(entry.getLong("detailconfig")) != 0) continue;
                entry.set("subparam", (Object)nextPagePara);
                entry.set("detail", (Object)detail);
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static void updateErroToTaskRecordEntry(Long taskConfigId, Exception erro, Long executor) {
        if (erro == null || erro.getStackTrace() == null || erro.getStackTrace().length < 1) {
            return;
        }
        StringBuilder erroStr = new StringBuilder();
        erroStr.append(erro.getCause()).append("\n");
        for (StackTraceElement traceElement : erro.getStackTrace()) {
            erroStr.append(traceElement).append("\n");
        }
        Long lastRecordId = RestoreTaskHelper.getLastTaskRecordId(taskConfigId, executor);
        QFilter filter = new QFilter("id", "=", (Object)lastRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subparam,entryentity.substatus substatus", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty((Object[])records)) {
            Object record = records[0];
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (!"2".equals(entry.getString("substatus"))) continue;
                entry.set("substatus", (Object)"3");
                entry.set("detail", (Object)(erroStr.length() > 255 ? erroStr.substring(0, 255) : erroStr.toString()));
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static Long getLastTaskRecordId(Long taskConfigId, Long executor) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)taskConfigId);
        filter.and(new QFilter("executor", "=", (Object)executor));
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        return CadEmptyUtils.isEmpty((Object[])records) ? 0L : records[0].getLong("id");
    }

    public static DynamicObject getLastTaskRecord(Long taskId, Long executor) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)taskId);
        filter.and(new QFilter("executor", "=", (Object)executor));
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,time,nextpagepara", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        return CadEmptyUtils.isEmpty((Object[])records) ? null : records[0];
    }

    public static void upTaskRecordNextPagePara(Long taskId, Long executor, String nextPagePara) {
        DynamicObject taskRecord = RestoreTaskHelper.getLastTaskRecord(taskId, executor);
        if (taskRecord == null) {
            return;
        }
        taskRecord.set("nextpagepara", (Object)nextPagePara);
        SaveServiceHelper.update((DynamicObject)taskRecord);
    }

    public static void startDiffRunTask(IFormView view, Long taskId, String param) {
        Long taskRecordId = RestoreTaskHelper.initCheckTaskRecord(taskId);
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("sca_difftaskrunning");
        lsp.setCustomParam("calcParam", (Object)param);
        lsp.setCustomParam("taskConfigId", (Object)taskId);
        lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(lsp);
    }

    public static void startDiffRunTask(IFormView view, IDataModel model, Long taskId, String param, String taskType) {
        Long checkReportId = RestoreCheckHelper.initDiffCheckCalcReport((String)param);
        Long calcReportId = RestoreCalcReportHelper.initDiffCalcReport((Long)taskId, (IDataModel)model, (String)taskType);
        Long taskRecordId = RestoreTaskHelper.initTaskRecord(taskId, calcReportId);
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("sca_difftaskrunning");
        lsp.setCustomParam("calcParam", (Object)param);
        lsp.setCustomParam("taskConfigId", (Object)taskId);
        lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
        lsp.setCustomParam("checkReportId", (Object)checkReportId);
        lsp.setCustomParam("calcReportId", (Object)calcReportId);
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(lsp);
    }

    public static void continueDiffRunTask(IFormView view, IDataModel model, Long taskConfigId, Long reportId, String param) {
        DynamicObject taskrecord = BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (String)"id,status,progress", (QFilter[])new QFilter[]{new QFilter("reportid", "=", (Object)reportId)});
        taskrecord.set("status", (Object)"2");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskrecord});
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("sca_difftaskrunning");
        lsp.setCustomParam("calcParam", (Object)param);
        lsp.setCustomParam("taskConfigId", (Object)taskConfigId);
        lsp.setCustomParam("taskRecordId", taskrecord.get("id"));
        lsp.setCustomParam("calcReportId", (Object)reportId);
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(lsp);
    }

    private static Long initCheckTaskRecord(Long taskId) {
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject taskrecord = BusinessDataServiceHelper.newDynamicObject((String)"sca_taskrecord");
        Long id = DBServiceHelper.genGlobalLongId();
        Date startTime = new Date();
        taskrecord.set("id", (Object)id);
        taskrecord.set("taskname", (Object)taskConfig.getString("name"));
        taskrecord.set("starttime", (Object)startTime);
        taskrecord.set("time", (Object)0);
        taskrecord.set("status", (Object)2);
        taskrecord.set("progress", (Object)0);
        taskrecord.set("executor", (Object)RequestContext.get().getUserId());
        taskrecord.set("nextpage", (Object)taskConfig.getString("nextentity"));
        taskrecord.set("taskconfig", (Object)taskConfig.getLong("id"));
        DynamicObjectCollection taskConfigEntrys = taskConfig.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection taskrecordEntrys = taskrecord.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject entry : taskConfigEntrys) {
            DynamicObject taskrecordEntry = taskrecordEntrys.addNew();
            taskrecordEntry.set("detailconfig", entry.getPkValue());
            taskrecordEntry.set("subname", (Object)entry.getString("subname"));
            taskrecordEntry.set("subnextentity", (Object)entry.getString("subnextentity"));
            taskrecordEntry.set("substatus", (Object)1);
            if (seq == 1) {
                taskrecordEntry.set("substarttime", (Object)startTime);
            }
            taskrecordEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskrecord});
        return id;
    }

    private static Long initTaskRecord(Long taskId, Long calcReportId) {
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject taskrecord = BusinessDataServiceHelper.newDynamicObject((String)"sca_taskrecord");
        Long id = DBServiceHelper.genGlobalLongId();
        Date startTime = new Date();
        taskrecord.set("id", (Object)id);
        taskrecord.set("taskname", (Object)taskConfig.getString("name"));
        taskrecord.set("starttime", (Object)startTime);
        taskrecord.set("time", (Object)0);
        taskrecord.set("status", (Object)2);
        taskrecord.set("progress", (Object)0);
        taskrecord.set("executor", (Object)RequestContext.get().getUserId());
        taskrecord.set("nextpage", (Object)taskConfig.getString("nextentity"));
        taskrecord.set("taskconfig", (Object)taskConfig.getLong("id"));
        taskrecord.set("reportid", (Object)calcReportId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskrecord});
        return id;
    }
}

