/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.allocstd;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class DiyCostDriverEffectOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("org");
        fieldKeys.add("manuorg");
        fieldKeys.add("costaccount");
        fieldKeys.add("sourceid");
        fieldKeys.add("effectdate");
        fieldKeys.add("expdate");
        fieldKeys.add("effectstatus");
        fieldKeys.add("effectperiod");
        fieldKeys.add("expperiod");
        fieldKeys.add("costdriver");
        fieldKeys.add("costcenter");
        fieldKeys.add("materialgroupstd");
        fieldKeys.add("entryentity");
        fieldKeys.add("entryentity.benefcostcenter");
        fieldKeys.add("entryentity.costobject");
        fieldKeys.add("entryentity.matnum");
        fieldKeys.add("entryentity.matauxpty");
        fieldKeys.add("entryentity.materialgroup");
        fieldKeys.add("appnum");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity entity : dataEntities = this.getDataEntities()) {
                    DynamicObject dataEntity = entity.getDataEntity();
                    Date effectDate = DateUtils.getDefaultEffectDate();
                    Date expDate = DateUtils.getDeFaultExpDate();
                    String effectStatus = "E";
                    DynamicObject accountOrg = (DynamicObject)dataEntity.get("org");
                    DynamicObject costAccount = (DynamicObject)dataEntity.get("costaccount");
                    DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
                    if (accountOrg == null || costAccount == null || costDriver == null) {
                        return;
                    }
                    long costAccountId = costAccount.getLong("id");
                    DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
                    if (currentPeriod == null) {
                        return;
                    }
                    String status = dataEntity.getString("effectstatus");
                    if (!"A".equals(status)) {
                        this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u751f\u6548\u5931\u8d25\uff0c\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u672a\u751f\u6548\u3002", (String)"DiyCostDriverEffectOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                        continue;
                    }
                    if (DiyCostDriverEffectOpPlugin.this.isEnableEffectByOrg(accountOrg.getLong("id"), dataEntity.getString("appnum"))) {
                        long sourceId = DiyCostDriverEffectOpPlugin.this.getSourceId(dataEntity);
                        if (CadEmptyUtils.isEmpty((Long)sourceId)) {
                            effectDate = currentPeriod.getDate("begindate");
                            dataEntity.set("effectperiod", (Object)currentPeriod);
                        } else {
                            DynamicObject sourceMaxEffectData = DiyCostDriverEffectOpPlugin.this.getMaxEffectBySourceId(sourceId);
                            DynamicObject sourceEffectPeriod = null;
                            if (sourceMaxEffectData != null) {
                                sourceEffectPeriod = sourceMaxEffectData.getDynamicObject("effectperiod");
                            }
                            if (sourceEffectPeriod == null || currentPeriod.getLong("id") == sourceEffectPeriod.getLong("id")) {
                                if (sourceMaxEffectData != null) {
                                    QFilter idFilter = new QFilter("id", "=", sourceMaxEffectData.getPkValue());
                                    DeleteServiceHelper.delete((String)"sca_diycostdriver", (QFilter[])idFilter.toArray());
                                }
                                effectDate = currentPeriod.getDate("begindate");
                                dataEntity.set("effectperiod", (Object)currentPeriod);
                            } else if (PeriodHelper.compare2period((DynamicObject)currentPeriod, (DynamicObject)sourceEffectPeriod) > 0) {
                                sourceMaxEffectData.set("expperiod", (Object)currentPeriod);
                                sourceMaxEffectData.set("expdate", (Object)currentPeriod.getDate("begindate"));
                                sourceMaxEffectData.set("effectstatus", (Object)"F");
                                SaveServiceHelper.update((DynamicObject)sourceMaxEffectData);
                                dataEntity.set("effectperiod", (Object)currentPeriod);
                                effectDate = currentPeriod.getDate("begindate");
                            } else if (PeriodHelper.compare2period((DynamicObject)currentPeriod, (DynamicObject)sourceEffectPeriod) < 0) {
                                long currentPeriodId = currentPeriod.getLong("id");
                                QFilter dateFilter = new QFilter("effectperiod", "<=", (Object)currentPeriodId);
                                dateFilter.and("expperiod", ">", (Object)currentPeriodId);
                                QFilter sourceIdFilter = new QFilter("sourceid", "=", (Object)sourceId);
                                QFilter idFilter = new QFilter("id", "=", (Object)sourceId);
                                sourceIdFilter.and(dateFilter);
                                idFilter.and(dateFilter);
                                QFilter qFilter = sourceIdFilter.or(idFilter);
                                DynamicObject changeSource = BusinessDataServiceHelper.loadSingle((String)"sca_diycostdriver", (String)"id,effectperiod,expperiod,effectdate,expdate", (QFilter[])qFilter.toArray());
                                if (changeSource == null) {
                                    effectDate = currentPeriod.getDate("begindate");
                                    DynamicObject sourceMinEffectData = DiyCostDriverEffectOpPlugin.this.getMinEffectBySourceId(sourceId);
                                    if (sourceMinEffectData != null) {
                                        DynamicObject sourceMinEffectPeriod = sourceMinEffectData.getDynamicObject("effectperiod");
                                        expDate = sourceMinEffectData.getDate("effectdate");
                                        dataEntity.set("effectperiod", (Object)currentPeriod);
                                        dataEntity.set("expperiod", (Object)sourceMinEffectPeriod);
                                    }
                                } else if (changeSource.getDynamicObject("effectperiod").getLong("id") == currentPeriodId) {
                                    effectDate = changeSource.getDate("effectdate");
                                    expDate = changeSource.getDate("expdate");
                                    dataEntity.set("effectperiod", (Object)currentPeriod);
                                    DynamicObject changeExpPeriod = changeSource.getDynamicObject("expperiod");
                                    dataEntity.set("expperiod", (Object)changeExpPeriod);
                                    QFilter changeFilter = new QFilter("id", "=", (Object)changeSource.getLong("id"));
                                    DeleteServiceHelper.delete((String)"sca_diycostdriver", (QFilter[])changeFilter.toArray());
                                } else {
                                    dataEntity.set("expperiod", (Object)changeSource.getDynamicObject("expperiod"));
                                    dataEntity.set("effectperiod", (Object)currentPeriod);
                                    effectDate = currentPeriod.getDate("begindate");
                                    expDate = changeSource.getDate("expdate");
                                    changeSource.set("expperiod", (Object)currentPeriod);
                                    changeSource.set("expdate", (Object)currentPeriod.getDate("begindate"));
                                    SaveServiceHelper.update((DynamicObject)changeSource);
                                }
                            }
                        }
                    } else {
                        if (DiyCostDriverEffectOpPlugin.this.existsDiyCostDriver(dataEntity)) continue;
                        DynamicObject startPeriod = PeriodHelper.getStartPeriod((Long)costAccountId);
                        dataEntity.set("effectperiod", (Object)startPeriod);
                    }
                    dataEntity.set("effectdate", (Object)effectDate);
                    dataEntity.set("expdate", (Object)expDate);
                    dataEntity.set("effectstatus", (Object)effectStatus);
                    SaveServiceHelper.update((DynamicObject)dataEntity);
                }
            }
        });
    }

    private long getSourceId(DynamicObject dataEntity) {
        long sourceId = dataEntity.getLong("sourceid");
        if (CadEmptyUtils.isEmpty((Long)sourceId)) {
            QFilter[] filters = this.getQFilter(dataEntity, true);
            if (filters == null) {
                return 0L;
            }
            DynamicObject source = QueryServiceHelper.queryOne((String)"sca_diycostdriver", (String)"id, sourceid", (QFilter[])filters);
            if (source != null) {
                sourceId = CadEmptyUtils.isEmpty((Long)source.getLong("sourceid")) ? source.getLong("id") : source.getLong("sourceid");
                dataEntity.set("sourceid", (Object)sourceId);
            }
        }
        return sourceId;
    }

    private boolean existsDiyCostDriver(DynamicObject dataEntity) {
        QFilter[] filters = this.getQFilter(dataEntity, true);
        if (filters == null) {
            return false;
        }
        return QueryServiceHelper.exists((String)"sca_diycostdriver", (QFilter[])filters);
    }

    private QFilter[] getQFilter(DynamicObject dataEntity, boolean includeEntryEntity) {
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
        if (org == null || costAccount == null || costDriver == null) {
            return null;
        }
        DynamicObject manuOrg = dataEntity.getDynamicObject("manuorg");
        DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("id", "!=", dataEntity.getPkValue()));
        qFilters.add(new QFilter("org", "=", org.getPkValue()));
        qFilters.add(new QFilter("manuorg", "=", manuOrg == null ? Long.valueOf(0L) : manuOrg.getPkValue()));
        qFilters.add(new QFilter("costaccount", "=", costAccount.getPkValue()));
        qFilters.add(new QFilter("costcenter", "=", costCenter == null ? Long.valueOf(0L) : costCenter.getPkValue()));
        qFilters.add(new QFilter("costdriver", "=", costDriver.getPkValue()));
        qFilters.add(new QFilter("effectstatus", "in", (Object)new String[]{"E"}));
        qFilters.add(new QFilter("appnum", "=", (Object)dataEntity.getString("appnum")));
        if (includeEntryEntity) {
            String allocClass;
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            switch (allocClass = costDriver.getString("allocclass")) {
                case "COSTCENTER": {
                    List benefitCostCenterIds = entryEntity.stream().map(e -> Long.parseLong(e.get("benefcostcenter.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(benefitCostCenterIds)) break;
                    qFilters.add(new QFilter("entryentity.benefcostcenter", "in", benefitCostCenterIds));
                    break;
                }
                case "MATERIAL": {
                    List materialIds = entryEntity.stream().map(e -> Long.parseLong(e.get("matnum.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(materialIds)) break;
                    qFilters.add(new QFilter("entryentity.matnum", "in", materialIds));
                    break;
                }
                case "COSTOBJECT": {
                    List costObjectIds = entryEntity.stream().map(e -> Long.parseLong(e.get("costobject.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(costObjectIds)) break;
                    qFilters.add(new QFilter("entryentity.costobject", "in", costObjectIds));
                    break;
                }
                case "MATERIALGROUP": {
                    List materialGroupIds = entryEntity.stream().map(e -> Long.parseLong(e.get("materialgroup.id").toString())).collect(Collectors.toList());
                    if (CadEmptyUtils.isEmpty(materialGroupIds)) break;
                    qFilters.add(new QFilter("entryentity.materialgroup", "in", materialGroupIds));
                    break;
                }
            }
        }
        return qFilters.toArray(new QFilter[0]);
    }

    private DynamicObject getMaxEffectBySourceId(long sourceId) {
        QFilter qFilter = new QFilter("sourceid", "=", (Object)sourceId);
        qFilter.or("id", "=", (Object)sourceId);
        DynamicObject[] sourceDatas = BusinessDataServiceHelper.load((String)"sca_diycostdriver", (String)"id,effectdate,expdate,effectperiod,expperiod,effectstatus", (QFilter[])qFilter.toArray());
        DynamicObject maxEffectData = null;
        for (DynamicObject source : sourceDatas) {
            DynamicObject effectPeriod = source.getDynamicObject("effectperiod");
            if (effectPeriod == null) continue;
            if (maxEffectData == null) {
                maxEffectData = source;
                continue;
            }
            DynamicObject maxEffectPeriod = maxEffectData.getDynamicObject("effectperiod");
            if (maxEffectPeriod == null || PeriodHelper.compare2period((DynamicObject)effectPeriod, (DynamicObject)maxEffectPeriod) <= 0) continue;
            maxEffectData = source;
        }
        return maxEffectData;
    }

    private DynamicObject getMinEffectBySourceId(long sourceId) {
        QFilter qFilter = new QFilter("sourceid", "=", (Object)sourceId);
        qFilter.or("id", "=", (Object)sourceId);
        DynamicObject[] sourceDatas = BusinessDataServiceHelper.load((String)"sca_diycostdriver", (String)"id,effectdate,expdate,effectperiod,expperiod,effectstatus", (QFilter[])qFilter.toArray());
        DynamicObject minEffectData = null;
        for (DynamicObject source : sourceDatas) {
            DynamicObject effectPeriod = source.getDynamicObject("effectperiod");
            if (effectPeriod == null) continue;
            if (minEffectData == null) {
                minEffectData = source;
                continue;
            }
            DynamicObject minEffectPeriod = minEffectData.getDynamicObject("effectperiod");
            if (minEffectPeriod == null || PeriodHelper.compare2period((DynamicObject)effectPeriod, (DynamicObject)minEffectPeriod) >= 0) continue;
            minEffectData = source;
        }
        return minEffectData;
    }

    private boolean isEnableEffectByOrg(Long orgId, String appId) {
        return SysParamHelper.getEnableEffectByOrg((Long)orgId, (String)appId, (String)"sca_diycostdriver");
    }
}

