/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.allocstd;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.constants.ElementConstant;
import kd.macc.cad.common.constants.ResourceAbsorbParam;
import kd.macc.cad.common.helper.ResourceAbsorbHelper;

public class ResourceAuditOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String HOUR_UNIT = "10";
    private static final String SECOND_UNIT = "8";
    private static final Log logger = LogFactory.getLog(ResourceAuditOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(EntityMetadataCache.getDataEntityType((String)"sca_resourceuse").getFields().keySet());
        fieldKeys.add("entryentity");
        fieldKeys.add("facthour");
        fieldKeys.add("seq");
        fieldKeys.add("entryentity.seq");
        fieldKeys.add("opra");
        fieldKeys.add("material");
        fieldKeys.add("auxpty");
        fieldKeys.add("costobject");
        fieldKeys.add("workhour");
        fieldKeys.add("facthour");
        fieldKeys.add("factuse");
        fieldKeys.add("factbatch");
        fieldKeys.add("pricedate");
        fieldKeys.add("bookdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ResourceAbsorbParam resourceSbsParam = new ResourceAbsorbParam();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                DynamicObject dynamicObject = dataEntities[0].getDataEntity();
                String appNum = dynamicObject.getString("appnum");
                long org = dynamicObject.getLong("org.id");
                long manuOrg = dynamicObject.getLong("manuorg.id");
                if (!"sca".equals(appNum)) {
                    return;
                }
                Set sourceIds = ResourceAuditOpPlugin.this.getResourceIds(dataEntities);
                Map resourceMap = new HashMap(16);
                long costType = 0L;
                DynamicObject costTypeByOrg = ResourceAbsorbHelper.getCostTypeByOrg((long)org, (long)manuOrg);
                if (costTypeByOrg != null) {
                    costType = costTypeByOrg.getLong("costType");
                    resourceMap = ResourceAbsorbHelper.getResourceMap((Set)Sets.newHashSet((Object[])new Long[]{costType}), (Set)sourceIds, null);
                    resourceSbsParam.setCostRulePlan(ResourceAbsorbHelper.getRulePlanByCostTypes((Set)Sets.newHashSet((Object[])new Long[]{costType})));
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject entityDataEntity = dataEntity.getDataEntity();
                    if (costTypeByOrg == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\u672a\u5173\u8054\u6210\u672c\u7c7b\u578b\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"ResourceAuditOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject resourceObj = ResourceAbsorbHelper.getResourceByPriceRule((Long)costType, (DynamicObject)entityDataEntity, resourceMap, (ResourceAbsorbParam)resourceSbsParam);
                    if (resourceObj != null) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5bf9\u5e94\u7684\u8d44\u6e90\u672a\u7ef4\u62a4\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868\uff0c\u5ba1\u6838\u5931\u8d25\u3002", (String)"ResourceAuditOpPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dynamicObject = dataEntities[0];
        String appNum = dynamicObject.getString("appnum");
        long org = dynamicObject.getLong("org.id");
        long manuOrg = dynamicObject.getLong("manuorg.id");
        if (!"sca".equals(appNum)) {
            return;
        }
        Set<Long> sourceIds = this.getResourceIds(dataEntities);
        DynamicObject costType = ResourceAbsorbHelper.getCostTypeByOrg((long)org, (long)manuOrg);
        ResourceAbsorbParam resourceSbsParam = new ResourceAbsorbParam();
        ResourceAbsorbHelper.buildCostAndPeriod((Long)org, (ResourceAbsorbParam)resourceSbsParam);
        Map resourceMap = ResourceAbsorbHelper.getResourceMap((Set)Sets.newHashSet((Object[])new Long[]{costType.getLong("costType")}), sourceIds, null);
        resourceSbsParam.setCostRulePlan(ResourceAbsorbHelper.getRulePlanByCostTypes((Set)Sets.newHashSet((Object[])new Long[]{costType.getLong("costType")})));
        ArrayList<DynamicObject> resourceAbsorbList = new ArrayList<DynamicObject>(16);
        for (DynamicObject targetBill : dataEntities) {
            for (Long costAccount : resourceSbsParam.getCostAccountSet()) {
                Long period = (Long)resourceSbsParam.getCostAccountPeriodMap().get(costAccount);
                Date periodStart = (Date)resourceSbsParam.getPeriodTimeMap().get(period);
                Date bookDate = targetBill.getDate("bookdate");
                if (periodStart == null || bookDate.compareTo(periodStart) < 0) {
                    logger.info("\u5355\u636e==>{}\u8bb0\u8d26\u65e5\u671f\u5728\u5f53\u524d\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u4e4b\u524d\uff0c\u4e0d\u751f\u6210\u8d39\u7528\u5438\u6536\u6210\u672c\u5355", (Object)targetBill.getString("billno"));
                    continue;
                }
                DynamicObject resourceObj = ResourceAbsorbHelper.getResourceByPriceRule((Long)costType.getLong("costType"), (DynamicObject)targetBill, (Map)resourceMap, (ResourceAbsorbParam)resourceSbsParam);
                if (resourceObj == null) {
                    logger.info("\u5355\u636e==>\u5bf9\u5e94\u7684\u8d44\u6e90\u672a\u7ef4\u62a4\u8d44\u6e90\u6807\u51c6\u8d39\u7528\u4ef7\u76ee\u8868", (Object)targetBill.getString("billno"));
                    continue;
                }
                DynamicObjectCollection dynamicObjects = targetBill.getDynamicObjectCollection("entryentity");
                for (DynamicObject resEntry : dynamicObjects) {
                    String calcBasis = resourceObj.getString("calcbasis");
                    String resourceUnit = resourceObj.getString("resourceunit.id");
                    BigDecimal qty = BigDecimal.ZERO;
                    BigDecimal unitPrice = resourceObj.getBigDecimal("qty");
                    if ("001".equals(calcBasis)) {
                        String workHour = resEntry.getString("workhour.id");
                        BigDecimal factHour = resEntry.getBigDecimal("facthour");
                        if (factHour.compareTo(BigDecimal.ZERO) != 0) {
                            switch (workHour) {
                                case "10": {
                                    qty = factHour.multiply(new BigDecimal(60));
                                    break;
                                }
                                case "8": {
                                    qty = factHour.divide(new BigDecimal(60), 10, 4);
                                    break;
                                }
                                default: {
                                    qty = factHour;
                                }
                            }
                            if (HOUR_UNIT.equals(resourceUnit)) {
                                qty = qty.divide(new BigDecimal(60), 10, RoundingMode.HALF_UP);
                            }
                            if (SECOND_UNIT.equals(resourceUnit)) {
                                qty = qty.multiply(new BigDecimal(60));
                            }
                        } else {
                            qty = factHour;
                        }
                    } else {
                        qty = "002".equals(calcBasis) ? resEntry.getBigDecimal("factuse") : resEntry.getBigDecimal("factbatch");
                    }
                    if (BigDecimal.ZERO.compareTo(qty) == 0) {
                        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355==>{}\u5bf9\u5e94\u8d44\u6e90\u7684\u5de5\u65f6\u4e3a0", (Object)targetBill.getString("billno"));
                        continue;
                    }
                    Long currey = (Long)resourceSbsParam.getCostActCurrMap().get(costAccount);
                    int seq = resEntry.getInt("seq");
                    DynamicObject resourceAbsorb = BusinessDataServiceHelper.newDynamicObject((String)"sca_resourceabsorb");
                    resourceAbsorb.set("billno", (Object)(targetBill.getString("billno") + "-" + seq));
                    resourceAbsorb.set("period", (Object)period);
                    resourceAbsorb.set("org", (Object)resourceSbsParam.getAccountOrg());
                    resourceAbsorb.set("costaccount", (Object)costAccount);
                    resourceAbsorb.set("costcenter", (Object)targetBill.getLong("costcenter.id"));
                    resourceAbsorb.set("sourcetype", (Object)"R");
                    resourceAbsorb.set("resource", (Object)targetBill.getLong("resource.id"));
                    resourceAbsorb.set("bizdate", targetBill.get("bizdate"));
                    resourceAbsorb.set("bookdate", (Object)bookDate);
                    resourceAbsorb.set("resourceusebillno", targetBill.get("billno"));
                    resourceAbsorb.set("resourceuserow", (Object)seq);
                    resourceAbsorb.set("costobject", resEntry.get("costobject.id"));
                    resourceAbsorb.set("opra", resEntry.get("opra"));
                    resourceAbsorb.set("currency", (Object)currey);
                    resourceAbsorb.set("material", resEntry.get("material"));
                    resourceAbsorb.set("auxpty", resEntry.get("auxpty"));
                    resourceAbsorb.set("billstatus", (Object)"C");
                    resourceAbsorb.set("sourcebill", (Object)targetBill.getLong("id"));
                    resourceAbsorb.set("sourcebillentry", (Object)resEntry.getLong("id"));
                    resourceAbsorb.set("calcbasis", (Object)calcBasis);
                    long currUserId = RequestContext.get().getCurrUserId();
                    Date date = new Date();
                    resourceAbsorb.set("creator", (Object)currUserId);
                    resourceAbsorb.set("modifier", (Object)currUserId);
                    resourceAbsorb.set("auditor", (Object)currUserId);
                    resourceAbsorb.set("createtime", (Object)date);
                    resourceAbsorb.set("modifytime", (Object)date);
                    resourceAbsorb.set("auditdate", (Object)date);
                    DynamicObjectCollection entryEntity = resourceAbsorb.getDynamicObjectCollection("entryentity");
                    DynamicObject dynamicObjectEntry = entryEntity.addNew();
                    dynamicObjectEntry.set("element", resourceObj.get("element"));
                    dynamicObjectEntry.set("subelement", resourceObj.get("subelement"));
                    dynamicObjectEntry.set("baseunit", resourceObj.get("resourceunit"));
                    dynamicObjectEntry.set("qty", (Object)qty.setScale(10, RoundingMode.HALF_UP));
                    dynamicObjectEntry.set("unitprice", (Object)unitPrice.setScale(((DynamicObject)resourceSbsParam.getCurreyMap().get(currey)).getInt("priceprecision"), RoundingMode.HALF_UP));
                    dynamicObjectEntry.set("amount", (Object)qty.multiply(unitPrice).setScale(((DynamicObject)resourceSbsParam.getCurreyMap().get(currey)).getInt("amtprecision"), RoundingMode.HALF_UP));
                    DynamicObjectCollection objs = resourceObj.getDynamicObjectCollection("entryentity");
                    for (DynamicObject obj : objs) {
                        DynamicObject subEntry = entryEntity.addNew();
                        subEntry.set("element", obj.get("attaelement"));
                        subEntry.set("subelement", obj.get("attasubelement"));
                        subEntry.set("baseunit", resourceObj.get("resourceunit"));
                        subEntry.set("qty", (Object)qty.setScale(10, RoundingMode.HALF_UP));
                        BigDecimal price = obj.getBigDecimal("attaqty");
                        if (resourceObj.getLong("element.id") == ElementConstant.OUTWORK_ID.longValue()) {
                            price = obj.getBigDecimal("attaamt");
                        }
                        subEntry.set("unitprice", (Object)price.setScale(((DynamicObject)resourceSbsParam.getCurreyMap().get(currey)).getInt("priceprecision"), RoundingMode.HALF_UP));
                        subEntry.set("amount", (Object)qty.multiply(price).setScale(((DynamicObject)resourceSbsParam.getCurreyMap().get(currey)).getInt("amtprecision"), RoundingMode.HALF_UP));
                    }
                    resourceAbsorbList.add(resourceAbsorb);
                }
            }
        }
        if (!resourceAbsorbList.isEmpty()) {
            List partition = Lists.partition(resourceAbsorbList, (int)300);
            for (List saveObj : partition) {
                SaveServiceHelper.save((DynamicObject[])saveObj.toArray(new DynamicObject[0]));
            }
        }
    }

    private Set<Long> getResourceIds(ExtendedDataEntity[] dataEntities) {
        HashSet<Long> sourceIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamic = dataEntity.getDataEntity();
            sourceIds.add(dynamic.getLong("resource.id"));
        }
        return sourceIds;
    }

    private Set<Long> getResourceIds(DynamicObject[] dataEntities) {
        HashSet<Long> sourceIds = new HashSet<Long>(16);
        for (DynamicObject dynamic : dataEntities) {
            sourceIds.add(dynamic.getLong("resource.id"));
        }
        return sourceIds;
    }
}

