/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.allocstd;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class ResourceUnAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("billno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashSet<Long> ids = new HashSet<Long>(dataEntities.length);
                HashMap<Long, ExtendedDataEntity> idResourceUseMap = new HashMap<Long, ExtendedDataEntity>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    String billNo = dynamicObject.getString("billno");
                    if (billNo.contains("pz")) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5bf9\u5e94\u7684\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u5df2\u751f\u6210\u51ed\u8bc1\u6216\u4e3a\u51ed\u8bc1\u51b2\u9500\u5355\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"ResourceUnAuditOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                        continue;
                    }
                    ids.add(dynamicObject.getLong("id"));
                    idResourceUseMap.put(dynamicObject.getLong("id"), dataEntity);
                }
                if (ids.isEmpty()) {
                    return;
                }
                QFilter filter = new QFilter("sourcebill", "in", ids);
                filter.and("vouchernum", "!=", (Object)" ");
                DynamicObjectCollection resourceAbsorbs = QueryServiceHelper.query((String)"sca_resourceabsorb", (String)"sourcebill", (QFilter[])new QFilter[]{filter});
                if (resourceAbsorbs == null) {
                    return;
                }
                for (DynamicObject resourceAbsorb : resourceAbsorbs) {
                    long sourceBillId = resourceAbsorb.getLong("sourcebill");
                    ExtendedDataEntity dataEntity = (ExtendedDataEntity)idResourceUseMap.get(sourceBillId);
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5bf9\u5e94\u7684\u8d39\u7528\u5438\u6536\u6210\u672c\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"ResourceUnAuditOpPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> ids = new HashSet<Long>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            ids.add(dynamicObject.getLong("id"));
        }
        if (ids.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("sourcebill", "in", ids);
        filter.and("vouchernum", "=", (Object)" ");
        DeleteServiceHelper.delete((String)"sca_resourceabsorb", (QFilter[])new QFilter[]{filter});
    }
}

