/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.calc;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CalcResultHelper;
import kd.macc.sca.algox.utils.PeriodHelper;
import kd.macc.sca.algox.utils.ScaCalcHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;
import kd.macc.sca.common.costcalc.Diff2CostAdjust;
import kd.macc.sca.common.costcalc.ShareHelper;
import kd.macc.sca.common.costcalc.groupkey.MatFinalGroupKey;
import kd.macc.sca.opplugin.calc.CostConfirmPeriodValidator;
import kd.macc.sca.opplugin.calc.CostConfirm_ChangeRecord;
import kd.macc.sca.opplugin.calc.CostConfirm_Object;
import kd.macc.sca.opplugin.calc.CostConfirm_Object2Account;
import kd.macc.sca.opplugin.calc.FinishDiffBillBuilder;

public class CostConfirmOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CostConfirmOpPlugin.class);
    private FinishDiffBillBuilder finishDiffBillBuilder;
    private CostConfirm_Object costObjectHelper;
    private CostConfirm_ChangeRecord changeRecordHelper;
    private CostConfirm_Object2Account object2AcountHelper;
    private Diff2CostAdjust diff2CostAdjust;

    private FinishDiffBillBuilder getFinishDiffBillBuilder() {
        if (this.finishDiffBillBuilder == null) {
            this.finishDiffBillBuilder = new FinishDiffBillBuilder();
        }
        return this.finishDiffBillBuilder;
    }

    public CostConfirm_Object getCostObjectHelper() {
        if (this.costObjectHelper == null) {
            this.costObjectHelper = new CostConfirm_Object();
        }
        return this.costObjectHelper;
    }

    public CostConfirm_ChangeRecord getChangeRecordHelper() {
        if (this.changeRecordHelper == null) {
            this.changeRecordHelper = new CostConfirm_ChangeRecord();
        }
        return this.changeRecordHelper;
    }

    public CostConfirm_Object2Account getObject2AcountHelper() {
        if (this.object2AcountHelper == null) {
            this.object2AcountHelper = new CostConfirm_Object2Account();
        }
        return this.object2AcountHelper;
    }

    public Diff2CostAdjust getDiff2CostAdjust() {
        if (this.diff2CostAdjust == null) {
            this.diff2CostAdjust = new Diff2CostAdjust();
        }
        return this.diff2CostAdjust;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bizstatus");
        fieldKeys.add("costobject");
        fieldKeys.add("srcbill");
        fieldKeys.add("period");
        fieldKeys.add("costaccount");
        fieldKeys.add("diff");
        fieldKeys.addAll(this.getFinishDiffBillBuilder().getCostConfirmSelectFields());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        logger.info("\u6210\u672c\u786e\u8ba4\u5355\u786e\u8ba4\u64cd\u4f5c\uff1a\u5f00\u59cb");
        e.getValidators().add(new CostConfirmPeriodValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        ArrayList<Object> calcResultIds = new ArrayList<Object>(10);
        HashSet<Long> costObjectIds = new HashSet<Long>(32);
        for (DynamicObject costConfirm : e.getDataEntities()) {
            calcResultIds.add(costConfirm.get("srcbill"));
            costObjectIds.add(costConfirm.getLong("costobject.id"));
        }
        DynamicObject costConfirm = e.getDataEntities()[0];
        long orgId = costConfirm.getLong("org.id");
        long costAccountId = costConfirm.getLong("costaccount.id");
        long periodId = costConfirm.getLong("period.id");
        CalcResultHelper.updateDiff(calcResultIds, (String)"1");
        Map mainJoinSideCalcResultInfo = ScaCalcHelper.getMainJoinSideCalcResultInfo((Long)orgId, (Long)costAccountId, (Long)periodId, (Long)PeriodHelper.getPrePeriodId((Object)periodId), costObjectIds);
        this.mainJoinShare(calcResultIds, mainJoinSideCalcResultInfo);
        List<DynamicObject> finishDiffBillObjs = this.getFinishDiffBillBuilder().build(e.getDataEntities());
        if (!finishDiffBillObjs.isEmpty()) {
            Object[] bills = this.getDiff2CostAdjust().calCostBillService(finishDiffBillObjs.toArray(new DynamicObject[0]), "Y");
            if (bills != null && bills.length > 0) {
                SaveServiceHelper.save((IDataEntityType)bills[0].getDataEntityType(), (Object[])bills);
                logger.info(String.format("\u5171\u786e\u8ba4%s\u5f20\u6210\u672c\u786e\u8ba4\u5355\uff0c\u521b\u5efa%s\u5f20\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u5e76\u4fdd\u5b58\u6210\u529f", e.getDataEntities().length, bills.length));
            } else {
                logger.info(String.format("\u5171\u786e\u8ba4%s\u5f20\u6210\u672c\u786e\u8ba4\u5355\uff0c\u672a\u521b\u5efa\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355", e.getDataEntities().length));
            }
        }
        this.getChangeRecordHelper().updateStatus(e.getDataEntities(), mainJoinSideCalcResultInfo, "B");
        this.updateBizStatus(e.getDataEntities());
        this.getCostObjectHelper().updateStatus(e.getDataEntities(), mainJoinSideCalcResultInfo, "B", null);
        this.getObject2AcountHelper().updateStatus(e.getDataEntities(), mainJoinSideCalcResultInfo, "B", null);
        CalcResultHelper.updateBizStatus(calcResultIds, (String)"B");
        logger.info(String.format("\u786e\u8ba4\u6210\u529f %s \u5f20", e.getDataEntities().length));
    }

    private void mainJoinShare(List<Object> calcResultIds, Map<Long, Map<Long, CalcResultObjectInfo>> mainJoinSideCalcResultInfo) {
        Object[] calcResults = BusinessDataServiceHelper.load((String)"sca_calcresult", (String)"id,costobject.id,org.id,costaccount.id,costcenter.id,currency.amtprecision,entryentity.caltype,entryentity.obj,entryentity.producttype,entryentity.resource,entryentity.costlevel,entryentity.calcbasis,entryentity.element,entryentity.subelement,entryentity.material,entryentity.auxpty,entryentity.matversion,entryentity.datatype,entryentity.difftype,entryentity.keycol,entryentity.keycolid,entryentity.diff,entryentity.diffqty", (QFilter[])new QFilter[]{new QFilter("id", "in", calcResultIds)});
        if (!CadEmptyUtils.isEmpty((Object[])calcResults)) {
            for (Object calcResult : calcResults) {
                long costObjectId = calcResult.getLong("costobject.id");
                Map<Long, CalcResultObjectInfo> objectInfoMap = mainJoinSideCalcResultInfo.get(costObjectId);
                if (objectInfoMap == null || !ShareHelper.existsJoinPro(objectInfoMap)) continue;
                long orgId = calcResult.getLong("org.id");
                long costAccountId = calcResult.getLong("costaccount.id");
                long costCenterId = calcResult.getLong("costcenter.id");
                int amtPrecision = calcResult.getInt("currency.amtprecision");
                DynamicObjectCollection entryEntitys = calcResult.getDynamicObjectCollection("entryentity");
                HashMap sumMap = Maps.newHashMapWithExpectedSize((int)16);
                HashMap groupMap = Maps.newHashMapWithExpectedSize((int)entryEntitys.size());
                for (DynamicObject entryEntity : entryEntitys) {
                    String calType = entryEntity.getString("caltype");
                    MatFinalGroupKey matFinalGroupKey = new MatFinalGroupKey(Long.valueOf(orgId), Long.valueOf(costAccountId), Long.valueOf(costCenterId), Long.valueOf(costObjectId), Long.valueOf(entryEntity.getLong("obj.id")), entryEntity.getString("producttype"), Long.valueOf(entryEntity.getLong("resource.id")), entryEntity.getString("costlevel"), entryEntity.getString("calcbasis"), Long.valueOf(entryEntity.getLong("element.id")), Long.valueOf(entryEntity.getLong("subelement.id")), Long.valueOf(entryEntity.getLong("material.id")), Long.valueOf(entryEntity.getLong("auxpty.id")), Long.valueOf(entryEntity.getLong("matversion.id")), entryEntity.getString("datatype"), entryEntity.getString("difftype"), entryEntity.getString("keycol"), Long.valueOf(entryEntity.getLong("keycolid.id")));
                    if ("3".equals(calType) || "4".equals(calType)) {
                        groupMap.put(matFinalGroupKey, entryEntity);
                    }
                    if (!"5".equals(calType)) continue;
                    sumMap.put(matFinalGroupKey, entryEntity);
                }
                HashMap costobjectTotalMap = Maps.newHashMapWithExpectedSize((int)10);
                ArrayList groupKeys = new ArrayList(groupMap.keySet());
                for (MatFinalGroupKey matFinalGroupKey : groupKeys) {
                    DynamicObject entryEntity = (DynamicObject)groupMap.get(matFinalGroupKey);
                    String productType = matFinalGroupKey.getProductType();
                    BigDecimal diffQty = entryEntity.getBigDecimal("diffqty");
                    BigDecimal diffAmt = entryEntity.getBigDecimal("diff");
                    if (!"C".equals(productType) || !ScaCalcHelper.isContainsProductFacted(objectInfoMap, (String)"A") || BigDecimal.ZERO.compareTo(diffQty) == 0 && BigDecimal.ZERO.compareTo(diffAmt) == 0) continue;
                    logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61:{}\u5b58\u5728\u8054\u4ea7\u54c1\u5b8c\u5de5\u9700\u8981\u6309\u6743\u91cd\u5206\u644a\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02");
                    Map<Long, CalcResultObjectInfo> objInfoMap = mainJoinSideCalcResultInfo.get(costObjectId);
                    BigDecimal totalRatio = BigDecimal.ZERO;
                    BigDecimal maxRatio = null;
                    boolean isAllFinQtyZero = true;
                    for (Map.Entry<Long, CalcResultObjectInfo> objectInfoEntry : objInfoMap.entrySet()) {
                        BigDecimal finQty;
                        CalcResultObjectInfo objectInfo = objectInfoEntry.getValue();
                        if ("B".equals(objectInfo.getProductType()) || BigDecimal.ZERO.compareTo(finQty = objectInfo.getFinishQty()) == 0) continue;
                        isAllFinQtyZero = false;
                        BigDecimal weight = objectInfo.getWeight();
                        BigDecimal finRatio = finQty.multiply(weight);
                        totalRatio = totalRatio.add(finRatio);
                        if (maxRatio != null && maxRatio.compareTo(finRatio.abs()) >= 0) continue;
                        maxRatio = finRatio.abs();
                    }
                    if (totalRatio.compareTo(BigDecimal.ZERO) == 0 && maxRatio != null) {
                        totalRatio = maxRatio;
                    }
                    if (totalRatio.compareTo(BigDecimal.ZERO) == 0 && !isAllFinQtyZero) {
                        DynamicObject costObjectDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)costObjectId, (String)"cad_costobject", (String)"costcenter,name");
                        DynamicObject subElementDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)matFinalGroupKey.getSubelementId(), (String)"cad_subelement", (String)"name");
                        String errStr = String.format(ResManager.loadKDString((String)"\u4e3b\u8054\u4ea7\u54c1\u5b8c\u5de5\u6bd4\u4f8b\u5206\u914d\u5931\u8d25\uff0c\u3010\u2211\u4e3b\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd+\u2211\u8054\u4ea7\u54c1\u5b8c\u5de5\u5165\u5e93\u6570\u91cf*\u6743\u91cd=0\u3011\uff0c\u6210\u672c\u5bf9\u8c61\u3010%2$s\u3011\uff0c\u5b50\u8981\u7d20\u3010%3$s\u3011\u3002", (String)"CostConfirmOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]), costObjectDyo != null ? costObjectDyo.getString("name") : "", subElementDyo != null ? subElementDyo.getString("name") : "");
                        logger.info(errStr);
                        throw new KDBizException(errStr);
                    }
                    BigDecimal diffFinQty = diffQty;
                    BigDecimal diffFinAmt = diffAmt;
                    DynamicObject allocMaxRow = null;
                    boolean isContainMainFact = false;
                    boolean isContainJoinFact = false;
                    for (Map.Entry<Long, CalcResultObjectInfo> entry : objInfoMap.entrySet()) {
                        CalcResultObjectInfo objectInfo = entry.getValue();
                        if ("B".equals(objectInfo.getProductType())) continue;
                        BigDecimal qty = objectInfo.getFinishQty();
                        BigDecimal weight = objectInfo.getWeight();
                        BigDecimal finRatio = qty.multiply(weight);
                        BigDecimal ratio = BigDecimal.ZERO;
                        if (totalRatio.compareTo(BigDecimal.ZERO) != 0) {
                            ratio = finRatio.divide(totalRatio, 10, RoundingMode.HALF_UP);
                        }
                        BigDecimal allocAmt = ratio.multiply(diffAmt).setScale(amtPrecision, RoundingMode.HALF_UP);
                        BigDecimal allocQty = ratio.multiply(diffQty).setScale(10, RoundingMode.HALF_UP);
                        diffFinQty = diffFinQty.subtract(allocQty);
                        diffFinAmt = diffFinAmt.subtract(allocAmt);
                        if ("C".equals(objectInfo.getProductType())) {
                            if ("2".equals(matFinalGroupKey.getDataType())) {
                                this.addTotalMoney(costobjectTotalMap, objectInfo.getCostObjectId(), allocAmt);
                            }
                            entryEntity.set("diff", (Object)allocAmt);
                            entryEntity.set("diffqty", (Object)allocQty);
                            if (qty.compareTo(BigDecimal.ZERO) != 0 && (allocMaxRow == null || allocMaxRow.getBigDecimal("diff").compareTo(allocAmt) < 0)) {
                                allocMaxRow = entryEntity;
                            }
                            isContainMainFact = true;
                            continue;
                        }
                        String belongProductType = objectInfo.getProductType();
                        long joinCostObjectId = objectInfo.getCostObjectId();
                        MatFinalGroupKey joinKey = new MatFinalGroupKey(matFinalGroupKey.getOrgId(), matFinalGroupKey.getCostAccountId(), matFinalGroupKey.getCostCenterid(), matFinalGroupKey.getCostObjectId(), Long.valueOf(joinCostObjectId), belongProductType, matFinalGroupKey.getResourceId(), matFinalGroupKey.getCostLevel(), matFinalGroupKey.getCalcBasis(), matFinalGroupKey.getElementId(), matFinalGroupKey.getSubelementId(), matFinalGroupKey.getMaterialId(), matFinalGroupKey.getAuxptyId(), matFinalGroupKey.getMatVersionId(), matFinalGroupKey.getDataType(), matFinalGroupKey.getDiffType(), matFinalGroupKey.getKeycol(), matFinalGroupKey.getKeycolId());
                        DynamicObject joinRow = (DynamicObject)groupMap.get(joinKey);
                        if (joinRow == null) {
                            logger.info("\u8054\u4ea7\u54c1key:{},\u672a\u627e\u5230\u8054\u4ea7\u54c1\u884c!", (Object)joinKey);
                            joinRow = entryEntitys.addNew();
                            groupMap.put(joinKey, joinRow);
                            joinRow.set("caltype", entryEntity.get("caltype"));
                            joinRow.set("obj_id", (Object)joinCostObjectId);
                            joinRow.set("producttype", (Object)belongProductType);
                            joinRow.set("resource", entryEntity.get("resource"));
                            joinRow.set("costlevel", entryEntity.get("costlevel"));
                            joinRow.set("calcbasis", entryEntity.get("calcbasis"));
                            joinRow.set("element", entryEntity.get("element"));
                            joinRow.set("subelement", entryEntity.get("subelement"));
                            joinRow.set("material", entryEntity.get("material"));
                            joinRow.set("auxpty", entryEntity.get("auxpty"));
                            joinRow.set("matversion", entryEntity.get("matversion"));
                            joinRow.set("datatype", entryEntity.get("datatype"));
                            joinRow.set("difftype", entryEntity.get("difftype"));
                            joinRow.set("keycol", entryEntity.get("keycol"));
                            joinRow.set("keycolid", entryEntity.get("keycolid"));
                        }
                        if ("2".equals(matFinalGroupKey.getDataType())) {
                            this.addTotalMoney(costobjectTotalMap, objectInfo.getCostObjectId(), allocAmt);
                        }
                        joinRow.set("diff", (Object)allocAmt);
                        joinRow.set("diffqty", (Object)allocQty);
                        if (qty.compareTo(BigDecimal.ZERO) != 0 && (allocMaxRow == null || allocMaxRow.getBigDecimal("diff").compareTo(allocAmt) < 0)) {
                            allocMaxRow = joinRow;
                        }
                        isContainJoinFact = true;
                    }
                    if (diffFinQty.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
                        allocMaxRow.set("diffqty", (Object)allocMaxRow.getBigDecimal("diffqty").add(diffFinQty));
                    }
                    if (diffFinAmt.compareTo(BigDecimal.ZERO) != 0 && allocMaxRow != null) {
                        if ("2".equals(matFinalGroupKey.getDataType())) {
                            this.addTotalMoney(costobjectTotalMap, entryEntity.getLong("obj.id"), diffFinAmt);
                        }
                        allocMaxRow.set("diff", (Object)allocMaxRow.getBigDecimal("diff").add(diffFinAmt));
                    }
                    if (isContainMainFact || !isContainJoinFact) continue;
                    entryEntity.set("diff", (Object)BigDecimal.ZERO);
                    entryEntity.set("diffqty", (Object)BigDecimal.ZERO);
                }
                for (Map.Entry entry : sumMap.entrySet()) {
                    MatFinalGroupKey key = (MatFinalGroupKey)entry.getKey();
                    DynamicObject value = (DynamicObject)entry.getValue();
                    String productType = key.getProductType();
                    if ("B".equals(productType)) continue;
                    BigDecimal totalAmt = (BigDecimal)costobjectTotalMap.get(key.getBelongCostObjectId());
                    if (totalAmt == null) {
                        totalAmt = BigDecimal.ZERO;
                    }
                    value.set("diff", (Object)totalAmt);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])calcResults);
    }

    private void addTotalMoney(Map<Long, BigDecimal> costobjectTotalMap, Long costobjectId, BigDecimal allocAmt) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        if (costobjectTotalMap.containsKey(costobjectId)) {
            totalAmt = costobjectTotalMap.get(costobjectId);
        }
        totalAmt = totalAmt.add(allocAmt);
        costobjectTotalMap.put(costobjectId, totalAmt);
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        logger.info("\u6210\u672c\u786e\u8ba4\u5355\u786e\u8ba4\u64cd\u4f5c\uff1a\u7ed3\u675f");
    }

    private void updateBizStatus(DynamicObject[] costConfirms) {
        for (DynamicObject costConfirm : costConfirms) {
            costConfirm.set("bizstatus", (Object)"B");
        }
        SaveServiceHelper.save((DynamicObject[])costConfirms);
        logger.info(String.format("\u5171\u66f4\u65b0 %s \u5f20\u6210\u672c\u786e\u8ba4\u5355\u7684\u786e\u8ba4\u72b6\u6001", costConfirms.length));
    }
}

