/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.calc;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.common.costcalc.CalcResultObjectInfo;

class CostConfirm_ChangeRecord {
    private static final Log logger = LogFactory.getLog(CostConfirm_ChangeRecord.class);

    CostConfirm_ChangeRecord() {
    }

    public void updateStatus(DynamicObject[] costConfirms, Map<Long, Map<Long, CalcResultObjectInfo>> mainSideCostObjectInfo, String status) {
        if (costConfirms == null || costConfirms.length == 0) {
            return;
        }
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(10);
        for (DynamicObject costConfirm : costConfirms) {
            orgIds.add(costConfirm.getLong("org.id"));
            long costObjectId = costConfirm.getLong("costobject.id");
            if (mainSideCostObjectInfo.containsKey(costObjectId)) {
                costObjectIds.addAll(mainSideCostObjectInfo.get(costObjectId).keySet());
                continue;
            }
            costObjectIds.add(costObjectId);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("org", "in", orgIds));
        filters.add(new QFilter("costobject", "in", costObjectIds));
        StringBuilder sbFilters = new StringBuilder();
        sbFilters.append(ResManager.loadKDString((String)"\u6ca1\u6709\u53d6\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6210\u672c\u53d8\u66f4\u5355\uff0c\u53d6\u6570\u6761\u4ef6\uff1a", (String)"CostConfirm_ChangeRecord_0", (String)"macc-sca-form", (Object[])new Object[0]));
        for (QFilter filter : filters) {
            sbFilters.append("\r\n ").append(filter.toString());
        }
        String selectedFields = "id, org, costobject, createtime, bizstatus , sourcebiztime";
        DynamicObject[] changeRecords = BusinessDataServiceHelper.load((String)"sca_costchangerecord", (String)selectedFields, (QFilter[])filters.toArray(new QFilter[0]));
        if (changeRecords == null || changeRecords.length == 0) {
            logger.info(sbFilters.toString());
            return;
        }
        HashMap<Long, List> groupByCostObjects = new HashMap<Long, List>(changeRecords.length);
        for (DynamicObject changeRecord : changeRecords) {
            Long costObjectId = changeRecord.getLong("costobject.id");
            List list = groupByCostObjects.computeIfAbsent(costObjectId, s -> new ArrayList(1));
            list.add(changeRecord);
        }
        ArrayList<DynamicObject> saveChangeRecords = new ArrayList<DynamicObject>(changeRecords.length);
        for (DynamicObject costConfirm : costConfirms) {
            Long costObjectId = costConfirm.getLong("costobject.id");
            List list = (List)groupByCostObjects.get(costObjectId);
            if (list == null) continue;
            Long orgId = costConfirm.getLong("org.id");
            DynamicObject period = costConfirm.getDynamicObject("period");
            if (!period.getDataEntityType().getProperties().containsKey((Object)"begindate") || !period.getDataEntityType().getProperties().containsKey((Object)"enddate")) {
                period = BusinessDataServiceHelper.loadSingleFromCache((Object)period.getPkValue(), (String)period.getDynamicObjectType().getName());
            }
            Date periodStartDate = period.getDate("begindate");
            Date periodEndDate = period.getDate("enddate");
            for (DynamicObject changeRecord : list) {
                String oldStatus;
                if (Long.compare(orgId, changeRecord.getLong("org.id")) != 0 || StringUtils.equals((CharSequence)status, (CharSequence)(oldStatus = changeRecord.getString("bizstatus")))) continue;
                Date sourceBizTime = changeRecord.getDate("sourcebiztime");
                if (periodStartDate == null || periodEndDate == null || sourceBizTime == null) {
                    logger.warn(String.format("\u671f\u95f4\u5f00\u59cb\u65f6\u95f4\u3001\u7ed3\u675f\u65f6\u95f4\uff0c\u6216\u6210\u672c\u53d8\u66f4\u5355\u6e90\u5355\u4e1a\u52a1\u65e5\u671f\u4e3anull\uff0c\u65e0\u6cd5\u6bd4\u8f83\u3002\u671f\u95f4 = %s, \u671f\u95f4\u5f00\u59cb\u65f6\u95f4 = %s\uff0c\u671f\u95f4\u7ed3\u675f\u65f6\u95f4 = %s\uff0c\u6210\u672c\u66f4\u65b0\u5355 =%s, \u6e90\u5355\u4e1a\u52a1\u65e5\u671f = %s", period.getPkValue(), periodStartDate, periodEndDate, changeRecord.getPkValue(), sourceBizTime));
                    continue;
                }
                if (sourceBizTime.getTime() < periodStartDate.getTime() || sourceBizTime.getTime() > periodEndDate.getTime()) continue;
                changeRecord.set("bizstatus", (Object)status);
                saveChangeRecords.add(changeRecord);
            }
        }
        if (!saveChangeRecords.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveChangeRecords.toArray(new DynamicObject[0]));
        }
        logger.info(String.format("\u5171\u53d6\u51fa %s \u5f20\u6210\u672c\u53d8\u66f4\u5355\uff0c\u66f4\u65b0\u4e86 %s \u5f20\u53d8\u66f4\u5355\u7684\u72b6\u6001\uff0c\u53d8\u66f4\u5355\u53d6\u6570\u6761\u4ef6\uff1a%s", changeRecords.length, saveChangeRecords.size(), sbFilters.toString()));
    }
}

