/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.calc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.BillBaseEnum;
import kd.macc.sca.opplugin.calc.FinishDiffBillGroupKey;

public class FinishDiffBillBuilder {
    private static final Log logger = LogFactory.getLog(FinishDiffBillBuilder.class);

    public List<String> getCostConfirmSelectFields() {
        ArrayList<String> fieldKeys = new ArrayList<String>();
        fieldKeys.add("period");
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("costcenter");
        fieldKeys.add("costobject");
        fieldKeys.add("material");
        fieldKeys.add("auxpty");
        fieldKeys.add("subelement");
        fieldKeys.add("difftype");
        fieldKeys.add("currency");
        fieldKeys.add("bizstatus");
        fieldKeys.add("srcbill");
        fieldKeys.add("diff");
        return fieldKeys;
    }

    public List<DynamicObject> build(DynamicObject[] costConfirmObjs) {
        if (costConfirmObjs == null || costConfirmObjs.length == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        HashSet<Long> calcResultIds = new HashSet<Long>(costConfirmObjs.length);
        for (DynamicObject costconfirm : costConfirmObjs) {
            calcResultIds.add(costconfirm.getLong("srcbill"));
        }
        Map<Long, Set<DynamicObject>> resultIdObjSet = this.getNeedGenFinDiffObj(calcResultIds);
        ArrayList<DynamicObject> finishDiffBills = new ArrayList<DynamicObject>(10);
        Map<Long, List<DynamicObject>> calcResultMap = this.queryCalcResult(calcResultIds);
        Map<Long, BigDecimal> calcTotalResult = this.queryCalcTotalResult(calcResultIds);
        Map<FinishDiffBillGroupKey, BigDecimal> existFinishiDiff = this.loadExistFinishDiff(costConfirmObjs, resultIdObjSet);
        int dataSize = costConfirmObjs.length;
        int billNoSize = 0;
        for (Map.Entry<Long, Set<DynamicObject>> resultIdObjSetEntry : resultIdObjSet.entrySet()) {
            billNoSize += resultIdObjSetEntry.getValue().size();
        }
        String[] sysbillnoArr = CodeRuleServiceHelper.getBatchNumber((String)"sca_finishdiffbill", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_finishdiffbill"), (String)"", (int)billNoSize);
        for (int i = 0; i < dataSize; ++i) {
            DynamicObject costConfirm = costConfirmObjs[i];
            Set<DynamicObject> costObjects = resultIdObjSet.get(costConfirm.getLong("srcbill"));
            if (CadEmptyUtils.isEmpty(costObjects)) continue;
            for (DynamicObject costObject : costObjects) {
                DynamicObject finishDiffBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_finishdiffbill");
                FinishDiffBillGroupKey costObjectKey = new FinishDiffBillGroupKey(this.getBDFieldValue(costConfirm, "org"), this.getBDFieldValue(costConfirm, "costaccount"), this.getBDFieldValue(costConfirm, "period"), this.getBDFieldValue(costConfirm, "costcenter"), costObject.getLong("id"), costObject.getLong("material.id"), costObject.getLong("auxpty.id"));
                this.setBillInfor(costConfirm, costObjectKey, finishDiffBill, existFinishiDiff, calcTotalResult, costObject);
                this.setBillEntryInfo(costConfirm, costObjectKey, finishDiffBill, existFinishiDiff, calcResultMap);
                if (finishDiffBill.getDynamicObjectCollection("entryentity").size() <= 0) continue;
                finishDiffBills.add(finishDiffBill);
                if (sysbillnoArr == null || sysbillnoArr.length < finishDiffBills.size()) continue;
                finishDiffBill.set("billno", (Object)sysbillnoArr[finishDiffBills.size() - 1]);
            }
        }
        return finishDiffBills;
    }

    private Map<Long, Set<DynamicObject>> getNeedGenFinDiffObj(Set<Long> calcResultIds) {
        HashMap<Long, Set> resultIdObjIdSet = new HashMap<Long, Set>(16);
        HashMap<Long, Set<DynamicObject>> resultIdCostObjectMap = new HashMap<Long, Set<DynamicObject>>(16);
        QFilter idQf = new QFilter("id", "in", calcResultIds);
        QFilter productTypeQf = new QFilter("entryentity.producttype", "in", (Object)new String[]{"A", "C"});
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FinishDiffBillBuilder.getNeedGenFinDiffObj", (String)"sca_calcresult", (String)"id,entryentity.obj costobject", (QFilter[])new QFilter[]{idQf, productTypeQf}, (String)"id desc");
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                resultIdObjIdSet.computeIfAbsent(row.getLong("id"), s -> new HashSet()).add(row.getLong("costobject"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashMap<Long, DynamicObject> costObjectMap = new HashMap<Long, DynamicObject>(64);
        if (!CadEmptyUtils.isEmpty(resultIdObjIdSet)) {
            HashSet costObjectIds = new HashSet(16);
            for (Map.Entry entry : resultIdObjIdSet.entrySet()) {
                Set objectIds = (Set)entry.getValue();
                costObjectIds.addAll(objectIds);
            }
            if (!CadEmptyUtils.isEmpty(costObjectIds)) {
                DynamicObject[] dynamicObjectArray;
                for (DynamicObject costObject : dynamicObjectArray = BusinessDataServiceHelper.load((String)"cad_costobject", (String)"id,manuorg,material,auxpty,matversion", (QFilter[])new QFilter[]{new QFilter("id", "in", costObjectIds)})) {
                    costObjectMap.put(costObject.getLong("id"), costObject);
                }
            }
        }
        if (!CadEmptyUtils.isEmpty(costObjectMap)) {
            for (Map.Entry entry : resultIdObjIdSet.entrySet()) {
                Long l = (Long)entry.getKey();
                Set objectIds = (Set)entry.getValue();
                for (Long objectId : objectIds) {
                    DynamicObject costObject = (DynamicObject)costObjectMap.get(objectId);
                    resultIdCostObjectMap.computeIfAbsent(l, s -> new HashSet()).add(costObject);
                }
            }
        }
        return resultIdCostObjectMap;
    }

    private void setBillInfor(DynamicObject costConfirm, FinishDiffBillGroupKey costObjectKey, DynamicObject finishDiffBill, Map<FinishDiffBillGroupKey, BigDecimal> existFinishDiff, Map<Long, BigDecimal> calcTotalResult, DynamicObject costObject) {
        finishDiffBill.set("id", (Object)ID.genLongId());
        finishDiffBill.set("period", (Object)costObjectKey.getPeriod());
        finishDiffBill.set("org", (Object)costObjectKey.getOrgId());
        finishDiffBill.set("costaccount", (Object)costObjectKey.getCostAccountId());
        finishDiffBill.set("costcenter", (Object)costObjectKey.getCostCenterId());
        finishDiffBill.set("costobject", (Object)costObject.getLong("id"));
        finishDiffBill.set("manuorg", (Object)costObject.getLong("manuorg.id"));
        finishDiffBill.set("material", (Object)costObject.getLong("material.masterid"));
        finishDiffBill.set("auxpty", (Object)costObject.getLong("auxpty.id"));
        int amtprecision = 10;
        DynamicObject currency = costConfirm.getDynamicObject("currency");
        if (currency != null) {
            amtprecision = currency.getInt("amtprecision");
        }
        BigDecimal diff = BigDecimal.ZERO;
        Long srcBillId = costConfirm.getLong("srcbill");
        if (srcBillId == null || Long.compare(srcBillId, 0L) == 0) {
            logger.warn(String.format("\u6210\u672c\u786e\u8ba4\u5355(%s)srcbill\u5b57\u6bb5\u6ca1\u503c\uff0c\u6ca1\u6709\u5173\u8054\u5230\u8ba1\u7b97\u7ed3\u679c\u5355", costConfirm.getPkValue()));
        } else {
            diff = calcTotalResult.get(costObjectKey.getCostObjectId());
            diff = diff == null ? BigDecimal.ZERO : diff;
        }
        BigDecimal val = existFinishDiff.get(costObjectKey);
        if (val != null && BigDecimal.ZERO.compareTo(val) != 0) {
            diff = diff.subtract(val);
        }
        if (BigDecimal.ZERO.compareTo(diff) == 0) {
            logger.warn(String.format("\u6210\u672c\u786e\u8ba4\u5355(%s)\u5df2\u5173\u8054\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355\u91d1\u989d\u4e3a %s\uff0c\u6ca1\u6709\u65b0\u7684\u5dee\u5f02\u91d1\u989d", costConfirm.getPkValue(), val));
        }
        finishDiffBill.set("diffamount", (Object)diff.setScale(amtprecision, 5));
        finishDiffBill.set("unit", (Object)costObject.getLong("material.baseunit.id"));
        finishDiffBill.set("sourcebill", (Object)costConfirm.getLong("id"));
        finishDiffBill.set("billstatus", (Object)BillBaseEnum.BILL_STATUS_AUDITED.getValue());
        finishDiffBill.set("currency", (Object)this.getBDFieldValue(costConfirm, "currency"));
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Date date = TimeServiceHelper.now();
        finishDiffBill.set("creator", (Object)userId);
        finishDiffBill.set("createtime", (Object)date);
        finishDiffBill.set("modifier", (Object)userId);
        finishDiffBill.set("modifytime", (Object)date);
        finishDiffBill.set("auditor", (Object)userId);
        finishDiffBill.set("auditdate", (Object)date);
    }

    private void setBillEntryInfo(DynamicObject costConfirm, FinishDiffBillGroupKey costObjectKey, DynamicObject finishDiffBill, Map<FinishDiffBillGroupKey, BigDecimal> existFinishDiff, Map<Long, List<DynamicObject>> calcResultMap) {
        int i;
        List<DynamicObject> calcResList = calcResultMap.get(costObjectKey.getCostObjectId());
        if (calcResList == null || calcResList.isEmpty()) {
            return;
        }
        int amtprecision = 10;
        DynamicObject currency = costConfirm.getDynamicObject("currency");
        if (currency != null) {
            amtprecision = currency.getInt("amtprecision");
        }
        HashMap<FinishDiffBillGroupKey, DynamicObject> subelementMap = new HashMap<FinishDiffBillGroupKey, DynamicObject>();
        DynamicObjectCollection entryentity = finishDiffBill.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject calcRes : calcResList) {
            FinishDiffBillGroupKey subElementKey = new FinishDiffBillGroupKey(costObjectKey.getOrgId(), costObjectKey.getCostAccountId(), costObjectKey.getPeriod(), costObjectKey.getCostCenterId(), costObjectKey.getCostObjectId(), costObjectKey.getMaterialId(), costObjectKey.getAuxptyId(), calcRes.getLong("subelement"), calcRes.getString("difftype"));
            BigDecimal val = existFinishDiff.get(subElementKey);
            if (subelementMap.get(subElementKey) != null) {
                DynamicObject entry = (DynamicObject)subelementMap.get(subElementKey);
                BigDecimal amount = entry.getBigDecimal("amount").add(calcRes.getBigDecimal("diff")).setScale(amtprecision, 5);
                entry.set("amount", (Object)amount);
                continue;
            }
            BigDecimal amount = calcRes.getBigDecimal("diff").setScale(amtprecision, 5);
            if (val != null && BigDecimal.ZERO.compareTo(val) != 0) {
                amount = amount.subtract(val);
            }
            DynamicObject entry = entryentity.addNew();
            entry.set("id", (Object)ID.genLongId());
            entry.set("seq", (Object)seq++);
            entry.set("difftype", calcRes.get("difftype"));
            entry.set("element", calcRes.get("element"));
            entry.set("subelement", calcRes.get("subelement"));
            entry.set("amount", (Object)amount);
            subelementMap.put(subElementKey, entry);
        }
        for (i = entryentity.size() - 1; i >= 0; --i) {
            DynamicObject entry = (DynamicObject)entryentity.get(i);
            BigDecimal amount = entry.getBigDecimal("amount");
            if (BigDecimal.ZERO.compareTo(amount) != 0) continue;
            entryentity.remove(i);
        }
        for (i = 0; i < entryentity.size(); ++i) {
            ((DynamicObject)entryentity.get(i)).set("seq", (Object)(i + 1));
        }
        finishDiffBill.set("material", calcResList.get(0).get("material"));
        finishDiffBill.set("auxpty", calcResList.get(0).get("auxpty"));
        finishDiffBill.set("unit", calcResList.get(0).get("baseunit"));
    }

    private Long getBDFieldValue(DynamicObject obj, String key) {
        Long id = 0L;
        Object fldValue = obj.get(key);
        if (fldValue instanceof DynamicObject) {
            id = (Long)((DynamicObject)fldValue).getPkValue();
        } else if (fldValue instanceof Long) {
            id = (Long)fldValue;
        }
        return id;
    }

    private Map<Long, List<DynamicObject>> queryCalcResult(Set<Long> calcResultIds) {
        QFilter srcidQF = new QFilter("id", "in", calcResultIds);
        QFilter caltypeQF = new QFilter("entryentity.caltype", "in", (Object)new String[]{"3", "4"});
        QFilter datatypeQF = new QFilter("entryentity.datatype", "in", (Object)new String[]{"2"});
        String fields = "id,entryentity.obj.material AS material,entryentity.obj.material.baseunit AS baseunit,entryentity.obj.auxpty AS auxpty,entryentity.obj.bomversion AS bomversion,entryentity.obj AS belongobj,entryentity.producttype AS producttype,entryentity.difftype AS difftype,entryentity.caltype AS caltype,entryentity.element AS element,entryentity.subelement AS subelement,entryentity.diff AS diff";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"sca_calcresult", (String)fields, (QFilter[])new QFilter[]{srcidQF, caltypeQF, datatypeQF});
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>();
        if (rows != null && !rows.isEmpty()) {
            for (DynamicObject calcRes : rows) {
                List list = map.computeIfAbsent(calcRes.getLong("belongobj"), v -> new ArrayList());
                list.add(calcRes);
            }
        }
        return map;
    }

    private Map<Long, BigDecimal> queryCalcTotalResult(Set<Long> calcResultIds) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(16);
        QFilter srcidQF = new QFilter("id", "in", calcResultIds);
        QFilter datatypeQF = new QFilter("entryentity.datatype", "=", (Object)"98");
        QFilter[] qFilters = new QFilter[]{srcidQF, datatypeQF};
        String fields = "id,entryentity.obj belongobj,entryentity.producttype producttype,entryentity.diff AS diff";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".queryCalcTotalResult"), (String)"sca_calcresult", (String)fields, (QFilter[])qFilters, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.put(row.getLong("belongobj"), row.getBigDecimal("diff"));
            }
        }
        return map;
    }

    private Map<FinishDiffBillGroupKey, BigDecimal> loadExistFinishDiff(DynamicObject[] costConfirmObjs, Map<Long, Set<DynamicObject>> resultIdObjSet) {
        HashSet<Long> periodIds = new HashSet<Long>(4);
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashSet<Long> costCenterIds = new HashSet<Long>(4);
        HashSet<Long> costAccountIds = new HashSet<Long>(1);
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        for (DynamicObject r : costConfirmObjs) {
            periodIds.add(this.getBDFieldValue(r, "period"));
            orgIds.add(this.getBDFieldValue(r, "org"));
            costAccountIds.add(this.getBDFieldValue(r, "costaccount"));
            costCenterIds.add(this.getBDFieldValue(r, "costcenter"));
            Set<DynamicObject> objects = resultIdObjSet.get(r.getLong("srcbill"));
            if (CadEmptyUtils.isEmpty(objects)) continue;
            for (DynamicObject object : objects) {
                costObjectIds.add(object.getLong("id"));
            }
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("period", "in", periodIds));
        filters.add(new QFilter("org", "in", orgIds));
        filters.add(new QFilter("costaccount", "in", costAccountIds));
        filters.add(new QFilter("costcenter", "in", costCenterIds));
        filters.add(new QFilter("costobject", "in", costObjectIds));
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"sca_finishdiffbill", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1);
        if (ids == null || ids.isEmpty()) {
            logger.info("\u6ca1\u6709\u5df2\u5b58\u5728\u7684\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355");
            return new HashMap<FinishDiffBillGroupKey, BigDecimal>(0);
        }
        DynamicObject[] finishDiffObjs = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sca_finishdiffbill"));
        if (finishDiffObjs == null || finishDiffObjs.length == 0) {
            logger.info("\u6ca1\u6709\u5df2\u5b58\u5728\u7684\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355");
            return new HashMap<FinishDiffBillGroupKey, BigDecimal>(0);
        }
        logger.info(String.format("\u5171\u53d6\u51fa %s \u5f20\u5df2\u5b58\u5728\u7684\u5b8c\u5de5\u7ed3\u7b97\u5dee\u5f02\u5355", finishDiffObjs.length));
        HashMap<FinishDiffBillGroupKey, BigDecimal> finishDiff = new HashMap<FinishDiffBillGroupKey, BigDecimal>(10);
        for (DynamicObject finishBill : finishDiffObjs) {
            FinishDiffBillGroupKey costObjectKey = new FinishDiffBillGroupKey(finishBill.getLong("org.id"), finishBill.getLong("costaccount.id"), finishBill.getLong("period.id"), finishBill.getLong("costcenter.id"), finishBill.getLong("costobject.id"), finishBill.getLong("material.id"), finishBill.getLong("auxpty.id"));
            BigDecimal diffValue = (BigDecimal)finishDiff.get(costObjectKey);
            diffValue = diffValue != null ? diffValue.add(finishBill.getBigDecimal("diffamount")) : finishBill.getBigDecimal("diffamount");
            finishDiff.put(costObjectKey, diffValue);
            DynamicObjectCollection entrys = finishBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                FinishDiffBillGroupKey subElementKey = new FinishDiffBillGroupKey(costObjectKey.getOrgId(), costObjectKey.getCostAccountId(), costObjectKey.getPeriod(), costObjectKey.getCostCenterId(), costObjectKey.getCostObjectId(), costObjectKey.getMaterialId(), costObjectKey.getAuxptyId(), this.getBDFieldValue(entry, "subelement"), entry.getString("difftype"));
                BigDecimal diffEntryValue = (BigDecimal)finishDiff.get(subElementKey);
                diffEntryValue = diffEntryValue != null ? diffEntryValue.add(entry.getBigDecimal("amount")) : entry.getBigDecimal("amount");
                finishDiff.put(subElementKey, diffEntryValue);
            }
        }
        return finishDiff;
    }
}

