/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.effect;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.EntityPropertyHelper;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public abstract class CommonEfOpPlugin
extends AbstractOperationServicePlugIn {
    private final Log logger = LogFactory.getLog(CommonEfOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        Sets.SetView propSet = Sets.union((Set)Sets.union((Set)Sets.union(this.getHeaderDiffList(), this.getEntryDiffList()), this.getSubEntryDiffList()), this.getEffectProps());
        e.getFieldKeys().addAll(propSet);
        Set<String> addFileKeys = this.getAddFileKeys();
        if (!CadEmptyUtils.isEmpty(addFileKeys)) {
            e.getFieldKeys().addAll(addFileKeys);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String appNum;
        super.beforeExecuteOperationTransaction(e);
        Object[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if (CadEmptyUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet appNumSet = Sets.newHashSetWithExpectedSize((int)3);
        for (Object dataEntity : dataEntities) {
            DynamicObject org = dataEntity.getDynamicObject(this.getOrgKey());
            if (org == null) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u7ec4\u7ec7\u8bbe\u503c\u3002", (String)"CommonEfOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            long orgId = org.getLong("id");
            appNum = dataEntity.getString("appnum");
            if (StringUtils.isEmpty((String)appNum)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u6807\u8bc6\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u6807\u8bc6\u8bbe\u503c\u3002", (String)"CommonEfOpPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            orgIdSet.add(orgId);
            appNumSet.add(appNum);
        }
        List<String> startEfStr = this.getStartEfStr(orgIdSet, appNumSet);
        for (Object dataEntity : dataEntities) {
            Date expDate;
            String orgId = dataEntity.getDynamicObject(this.getOrgKey()).getString("id");
            String entityId = dataEntity.getDataEntityType().getName();
            appNum = dataEntity.getString("appnum");
            if (startEfStr.contains(orgId.concat(entityId).concat(appNum))) {
                switch (operationKey) {
                    case "audit": {
                        this.efAudit((DynamicObject)dataEntity);
                        break;
                    }
                    case "unaudit": {
                        this.efUnAudit((DynamicObject)dataEntity, e);
                        break;
                    }
                    case "delete": {
                        this.efDelete((DynamicObject)dataEntity, e);
                        break;
                    }
                }
                continue;
            }
            this.logger.info("\u6838\u7b97\u7ec4\u7ec7".concat(orgId).concat("\u5355\u636e\u6807\u8bc6").concat(entityId).concat("\u4e1a\u52a1\u6807\u8bc6").concat(appNum).concat("\u5728\u6210\u672c\u53c2\u6570\u672a\u5f00\u542f\u6709\u6548\u65e5\u671f\u63a7\u5236"));
            Date effectDate = dataEntity.getDate("effectdate");
            if (effectDate == null) {
                dataEntity.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
            }
            if ((expDate = dataEntity.getDate("expdate")) != null) continue;
            dataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
        }
        this.beforeExecuteOpTransactionEf();
    }

    protected void beforeExecuteOpTransactionEf() {
    }

    private void efDelete(DynamicObject dataEntity, BeforeOperationArgs e) {
        Date effectDate = dataEntity.getDate("effectdate");
        Date expDate = dataEntity.getDate("expdate");
        if (expDate != null || effectDate != null) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u5355\u636e\u5728\u6210\u672c\u53c2\u6570\u5f00\u542f\u4e86\u6709\u6548\u65e5\u671f\u63a7\u5236\uff0c\u5355\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CommonEfOpPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
        }
    }

    private void efUnAudit(DynamicObject dataEntity, BeforeOperationArgs e) {
        String entityId = dataEntity.getDataEntityType().getName();
        long sourceId = dataEntity.getLong("sourceid");
        if (!CadEmptyUtils.isEmpty((Long)sourceId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u5355\u636e\u5728\u6210\u672c\u53c2\u6570\u5f00\u542f\u4e86\u6709\u6548\u65e5\u671f\u63a7\u5236\uff0c\u5907\u4efd\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"CommonEfOpPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
            return;
        }
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)dataEntity);
        Date now = DateUtils.getCurrentSystemTime();
        String newBillNo = ID.genStringId();
        clone.set(this.getBillNoKey(), (Object)ID.genStringId());
        clone.set("expdate", (Object)now);
        clone.set("effectstatus", (Object)0);
        clone.set("sourceid", (Object)dataEntity.getLong("id"));
        clone.set("creator", (Object)RequestContext.get().getCurrUserId());
        clone.set("createtime", (Object)now);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)entityId, (DynamicObject[])new DynamicObject[]{clone}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            this.logger.error("\u53cd\u5ba1\u6838\u521b\u5efa\u5386\u53f2\u5355\u5931\u8d25:{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)result));
            e.setCancel(true);
            e.setCancelMessage(OperationResultHelper.errorMsgHandle((OperationResult)result));
            return;
        }
        this.logger.info("\u53cd\u5ba1\u6838\u521b\u5efa\u5386\u53f2\u5355\u6210\u529f\uff0c\u5355\u53f7\uff1a{}", (Object)newBillNo);
        dataEntity.set("effectdate", (Object)now);
    }

    private void efAudit(DynamicObject dataEntity) {
        String entityId = dataEntity.getDataEntityType().getName();
        Set<String> headerDiffList = this.getHeaderDiffList();
        Set<String> entryDiffList = this.getEntryDiffList();
        Set<String> subEntryDiffList = this.getSubEntryDiffList();
        Set<String> effectProps = this.getEffectProps();
        String headerNames = String.join((CharSequence)",", headerDiffList);
        String effectNames = String.join((CharSequence)",", effectProps);
        headerNames = headerNames.concat(",").concat(effectNames).concat(",billstatus");
        for (String entryPropName : entryDiffList) {
            headerNames = headerNames.concat(",").concat(this.getEntryEntityKey().concat(".").concat(entryPropName));
        }
        for (String subEntryPropName : subEntryDiffList) {
            headerNames = headerNames.concat(",").concat(this.getSubEntryEntityKey().concat(".").concat(subEntryPropName));
        }
        long id = dataEntity.getLong("id");
        Object[] historyList = BusinessDataServiceHelper.load((String)entityId, (String)headerNames, (QFilter[])new QFilter[]{new QFilter("sourceid", "=", (Object)id)}, (String)"expdate desc");
        if (!CadEmptyUtils.isEmpty((Object[])historyList)) {
            Object previousDy = historyList[0];
            boolean isHeaderSame = this.checkHeader(dataEntity, (DynamicObject)previousDy);
            if (isHeaderSame) {
                DynamicObject modifiedDy = this.checkEntry(dataEntity, (DynamicObject)previousDy);
                if (modifiedDy != null) {
                    modifiedDy = BusinessDataServiceHelper.loadSingle((Object)modifiedDy.getPkValue(), (String)entityId);
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)entityId, (DynamicObject[])new DynamicObject[]{modifiedDy}, (OperateOption)OperateOption.create());
                    if (result.isSuccess()) {
                        this.logger.info("\u5355\u636e\u4f53\u5b58\u5728\u5dee\u5f02\uff0c\u4fdd\u5b58\u5dee\u5f02\u6570\u636e\u6210\u529f:{}", (Object)modifiedDy.getString(this.getBillNoKey()));
                    } else {
                        this.logger.error("\u5355\u636e\u4f53\u5b58\u5728\u5dee\u5f02\uff0c\u4fdd\u5b58\u5dee\u5f02\u6570\u636e\u5931\u8d25:{}", (Object)OperationResultHelper.errorMsgHandle((OperationResult)result));
                    }
                } else {
                    dataEntity.set("effectdate", (Object)previousDy.getDate("effectdate"));
                    dataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                    previousDy.set("billstatus", (Object)"A");
                    DeleteServiceHelper.delete((IDataEntityType)dataEntity.getDataEntityType(), (Object[])new Object[]{previousDy.getPkValue()});
                }
            }
        } else {
            dataEntity.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
            dataEntity.set("expdate", (Object)DateUtils.getDeFaultExpDate());
        }
    }

    private boolean checkHeader(DynamicObject dataEntity, DynamicObject previousDy) {
        Set headerDiffList = this.getHeaderDiffList();
        if (headerDiffList.isEmpty()) {
            headerDiffList = EntityPropertyHelper.getPropertys((String)dataEntity.getDataEntityType().getName());
        }
        headerDiffList.removeAll(Sets.newHashSet((Object[])new String[]{this.getBillNoKey(), "billstatus", "modifier", "effectstatus", "sourceid", "modifytime", "effectdate", "expdate", "creator", "createtime", "auditor", "auditdate"}));
        for (String headerProp : headerDiffList) {
            Object currentObj = dataEntity.get(headerProp);
            Object preObj = previousDy.get(headerProp);
            if (currentObj != null && preObj != null) {
                if (currentObj.toString().equals(preObj.toString())) continue;
                return false;
            }
            if (currentObj == null && preObj != null) {
                return false;
            }
            if (currentObj == null || preObj != null) continue;
            return false;
        }
        return true;
    }

    private DynamicObject checkEntry(DynamicObject dataEntity, DynamicObject previousDy) {
        Set<String> subEntryDiffList;
        DynamicObjectCollection productSubEntry;
        Object o;
        boolean isPreEntryNull;
        DynamicObjectCollection currentEntry = dataEntity.getDynamicObjectCollection(this.getEntryEntityKey());
        DynamicObjectCollection preEntry = previousDy.getDynamicObjectCollection(this.getEntryEntityKey());
        boolean isCurrentEntryNull = currentEntry == null;
        boolean bl = isPreEntryNull = preEntry == null;
        if (isCurrentEntryNull && isPreEntryNull) {
            return null;
        }
        if (isCurrentEntryNull || isPreEntryNull) {
            previousDy.set("effectstatus", (Object)"0");
            return previousDy;
        }
        if (currentEntry.size() != preEntry.size()) {
            previousDy.set("effectstatus", (Object)"0");
            return previousDy;
        }
        Set entryDiffList = this.getEntryDiffList();
        if (entryDiffList.isEmpty()) {
            entryDiffList = EntityPropertyHelper.getEntryPropertys((String)dataEntity.getDataEntityType().getName(), (String)this.getEntryEntityKey());
        }
        HashSet currentEntryKey = Sets.newHashSetWithExpectedSize((int)currentEntry.size());
        for (DynamicObject curEntryItem : currentEntry) {
            Object field2;
            StringBuilder currentItemKey = new StringBuilder();
            for (Object field2 : entryDiffList) {
                o = curEntryItem.get((String)field2);
                if (o == null) continue;
                if (o instanceof DynamicObject) {
                    currentItemKey.append(((DynamicObject)o).getLong("id"));
                    continue;
                }
                currentItemKey.append(o.toString());
            }
            currentEntryKey.add(currentItemKey.toString());
            productSubEntry = curEntryItem.getDynamicObjectCollection(this.getSubEntryEntityKey());
            field2 = productSubEntry.iterator();
            while (field2.hasNext()) {
                DynamicObject subEntry = (DynamicObject)field2.next();
                subEntryDiffList = this.getSubEntryDiffList();
                StringBuilder currentSubKey = new StringBuilder();
                for (String diffKey : subEntryDiffList) {
                    Object o2 = subEntry.get(diffKey);
                    if (o2 == null) continue;
                    if (o2 instanceof DynamicObject) {
                        currentItemKey.append(((DynamicObject)o2).getLong("id"));
                        continue;
                    }
                    currentItemKey.append(o2.toString());
                }
                currentEntryKey.add(currentSubKey.toString());
            }
        }
        for (DynamicObject preEntryItem : preEntry) {
            StringBuilder preEntryItemKey = new StringBuilder();
            for (Object field2 : entryDiffList) {
                o = preEntryItem.get((String)field2);
                if (o == null) continue;
                if (o instanceof DynamicObject) {
                    preEntryItemKey.append(((DynamicObject)o).getLong("id"));
                    continue;
                }
                preEntryItemKey.append(o.toString());
            }
            productSubEntry = preEntryItem.getDynamicObjectCollection(this.getSubEntryEntityKey());
            for (DynamicObject subEntry : productSubEntry) {
                subEntryDiffList = this.getSubEntryDiffList();
                for (String diffKey : subEntryDiffList) {
                    Object o3 = subEntry.get(diffKey);
                    if (o3 == null) continue;
                    if (o3 instanceof DynamicObject) {
                        preEntryItemKey.append(((DynamicObject)o3).getLong("id"));
                        continue;
                    }
                    preEntryItemKey.append(o3.toString());
                }
            }
            if (currentEntryKey.contains(preEntryItemKey.toString())) continue;
            previousDy.set("effectstatus", (Object)"0");
            return previousDy;
        }
        return null;
    }

    protected abstract Set<String> getHeaderDiffList();

    protected abstract Set<String> getEntryDiffList();

    protected abstract String getEntryEntityKey();

    protected abstract String getSubEntryEntityKey();

    protected abstract String getBillNoKey();

    protected abstract String getOrgKey();

    protected abstract Set<String> getSubEntryDiffList();

    private List<String> getStartEfStr(Set<Long> orgIdSet, Set<String> appNumSet) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)128);
        QFilter acctOrgFilter = new QFilter("actorg", "in", orgIdSet);
        acctOrgFilter.and("tab", "=", (Object)"settingtabpage");
        acctOrgFilter.and("appnum", "in", appNumSet);
        DynamicObjectCollection efEntityArray = QueryServiceHelper.query((String)"cad_sysparam", (String)"id,actorg,effectcontrol,appnum", (QFilter[])new QFilter[]{acctOrgFilter});
        for (DynamicObject dynamicObject : efEntityArray) {
            String[] entityArray;
            String orgId = dynamicObject.getString("actorg");
            String appNum = dynamicObject.getString("appnum");
            String effectControl = dynamicObject.getString("effectcontrol");
            if (!StringUtils.isNotEmpty((String)effectControl)) continue;
            for (String entityId : entityArray = effectControl.split(",")) {
                String current = orgId.concat(entityId).concat(appNum);
                resultList.add(current);
            }
        }
        return resultList;
    }

    protected abstract String getBillEntityId();

    protected abstract Set<String> getAddFileKeys();

    private Set<String> getEffectProps() {
        return Sets.newHashSet((Object[])new String[]{"effectdate", "expdate", "sourceid", "appnum", "effectstatus", "creator", "createtime"});
    }
}

