/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.feealloc;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.util.TimeUtils;
import org.apache.commons.lang3.time.DateUtils;

public class MatAllocStdSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MatAllocStdSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("billno");
        fieldKeys.add("billstatus");
        fieldKeys.add("manuorg");
        fieldKeys.add("effectdate");
        fieldKeys.add("expdate");
        fieldKeys.add("auditdate");
        fieldKeys.add("auditor");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("appnum");
        fieldKeys.add("allocentry");
        fieldKeys.add("allocentry.costcenter");
        fieldKeys.add("allocentry.bmaterial");
        fieldKeys.add("allocentry.matversion");
        fieldKeys.add("allocentry.auxpty");
        fieldKeys.add("allocentry.materialgroup");
        fieldKeys.add("allocentry.costdriver");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                try {
                    String headMsg = "";
                    if ("save".equals(this.getOperateKey())) {
                        headMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MatAllocStdSaveOp_0", (String)"macc-sca-form", (Object[])new Object[0]);
                    } else if ("submit".equals(this.getOperateKey())) {
                        headMsg = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"MatAllocStdSaveOp_1", (String)"macc-sca-form", (Object[])new Object[0]);
                    } else if ("audit".equals(this.getOperateKey())) {
                        headMsg = ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\u3002", (String)"MatAllocStdSaveOp_2", (String)"macc-sca-form", (Object[])new Object[0]);
                    }
                    ExtendedDataEntity[] dataEntities = this.dataEntities;
                    String appnum = dataEntities[0].getDataEntity().getString("appnum");
                    block2: for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                        DynamicObjectCollection allocEntry = dataEntity.getDynamicObjectCollection("allocentry");
                        Long orgId = dataEntity.getLong("org.id");
                        Long manuOrgId = dataEntity.getLong("manuorg.id");
                        if (!OrgHelper.isOrgEnableMultiFactory((Long)orgId) && !CadEmptyUtils.isEmpty((Long)manuOrgId)) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u672a\u5f00\u542f\u591a\u5de5\u5382\uff0c\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u53ef\u5f55\u3002", (String)"MatAllocStdSaveOp_3", (String)"macc-sca-form", (Object[])new Object[0]), headMsg));
                            continue;
                        }
                        Map effectMap = MatAllocStdSaveOp.this.getMatallocStdUniqMap(orgId, manuOrgId, dataEntity.getPkValue(), appnum);
                        for (DynamicObject entry : allocEntry) {
                            String resMsg;
                            DynamicObject bmaterialDyn;
                            String seq = entry.getString("seq");
                            Long costcenterId = entry.getLong("costcenter.id");
                            Long bmaterialId = entry.getLong("bmaterial.id");
                            Long matversionId = entry.getLong("matversion.id");
                            Long auxptyId = entry.getLong("auxpty.id");
                            Long materialgroupId = entry.getLong("materialgroup.id");
                            if (!CadEmptyUtils.isEmpty((Long)bmaterialId) && !CadEmptyUtils.isEmpty((Long)materialgroupId)) {
                                String resMsg2 = ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u7269\u6599\u548c\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u540c\u65f6\u5f55\u5165\u3002", (String)"MatAllocStdSaveOp_4", (String)"macc-sca-form", (Object[])new Object[0]);
                                this.addErrorMessage(extendedDataEntity, String.format(resMsg2, headMsg, seq));
                                continue block2;
                            }
                            if (!CadEmptyUtils.isEmpty((Long)bmaterialId) && BomRouterHelper.isEnableAuxprop((DynamicObject)(bmaterialDyn = entry.getDynamicObject("bmaterial"))) && CadEmptyUtils.isEmpty((Long)auxptyId)) {
                                resMsg = ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u7269\u6599\u542f\u7528\u8f85\u52a9\u5c5e\u6027\u5e76\u5f71\u54cd\u6210\u672c\u65f6\uff0c\u9700\u8f93\u5165\u7269\u6599\u8f85\u52a9\u5c5e\u6027\u3002", (String)"MatAllocStdSaveOp_6", (String)"macc-sca-form", (Object[])new Object[0]);
                                this.addErrorMessage(extendedDataEntity, String.format(resMsg, headMsg, seq));
                                continue block2;
                            }
                            String uniqKey = String.format("%s@%s@%s@%s@%s", costcenterId, bmaterialId, matversionId, auxptyId, materialgroupId);
                            if (effectMap.containsKey(uniqKey)) {
                                resMsg = ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u5df2\u7ecf\u5728%3$s\u5355\u636e\u4e2d\u8bbe\u7f6e\u5206\u914d\u6807\u51c6\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"MatAllocStdSaveOp_7", (String)"macc-sca-form", (Object[])new Object[0]);
                                this.addErrorMessage(extendedDataEntity, String.format(resMsg, headMsg, seq, effectMap.get(uniqKey)));
                                continue block2;
                            }
                            effectMap.put(uniqKey, "");
                        }
                    }
                }
                catch (Exception exp) {
                    logger.error("\u6309\u94ae\u6821\u9a8c\u64cd\u4f5c\u5f02\u5e38\uff1a" + exp.getMessage());
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            Date date = dataEntity.getDate("effectdate");
            if (date == null) {
                dataEntity.set("effectdate", (Object)TimeUtils.getDefaultEffectDate());
            }
            if ((date = dataEntity.getDate("expdate")) != null) continue;
            dataEntity.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
        }
    }

    private DataSet getMatallocStdDs(Long orgId, Long manuOrgId, Object allocStdId, Object appnum) {
        QFilter filter = new QFilter("id", "!=", allocStdId);
        filter.and("appnum", "=", appnum);
        filter.and("org", "=", (Object)orgId);
        filter.and("manuorg", "=", (Object)manuOrgId);
        QFilter expdateFilter = new QFilter("expdate", ">=", (Object)DateUtils.addDays((Date)new Date(), (int)100));
        expdateFilter.or("expdate", "is null", null);
        filter.and(expdateFilter);
        return QueryServiceHelper.queryDataSet((String)"sca_matallocstd_sava_op", (String)"sca_matallocstd", (String)"id,billno,org,manuorg,allocentry.costcenter costcenter,allocentry.bmaterial bmaterial,allocentry.matversion matversion,allocentry.auxpty auxpty,allocentry.materialgroup materialgroup", (QFilter[])filter.toArray(), null);
    }

    private Map<String, String> getMatallocStdUniqMap(Long orgId, Long manuOrgId, Object allocStdId, Object appnum) {
        HashMap<String, String> map = new HashMap<String, String>(32);
        DataSet ds = this.getMatallocStdDs(orgId, manuOrgId, allocStdId, appnum);
        if (!ds.isEmpty()) {
            while (ds.hasNext()) {
                Row row = ds.next();
                String billno = row.getString("billno");
                String uniqKey = String.format("%s@%s@%s@%s@%s", this.getRowLongVal(row, "costcenter"), this.getRowLongVal(row, "bmaterial"), this.getRowLongVal(row, "matversion"), this.getRowLongVal(row, "auxpty"), this.getRowLongVal(row, "materialgroup"));
                map.put(uniqKey, billno);
            }
        }
        return map;
    }

    private long getRowLongVal(Row row, String key) {
        Long val = row.getLong(key);
        if (val == null) {
            return 0L;
        }
        return val;
    }
}

