/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.feealloc;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.cad.common.helper.CostChangeRecHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.sca.common.enums.ScaAllocEnum;

public class MatAllocateDelOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("allocstatus");
        fieldKeys.add("costaccount");
        fieldKeys.add("period");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    this.isCurPeriod(dataEntity);
                    this.checkAllocStatus(dataEntity);
                }
            }

            private void isCurPeriod(ExtendedDataEntity dataEntity) {
                DynamicObject item = dataEntity.getDataEntity();
                DynamicObject costaccount = item.getDynamicObject("costaccount");
                DynamicObject period = item.getDynamicObject("period");
                Long curPeriodId = 0L;
                DynamicObject dyn = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"));
                if (dyn != null) {
                    curPeriodId = dyn.getLong("id");
                }
                if (period.getLong("id") != curPeriodId.longValue()) {
                    String tip = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002\u4e0d\u5141\u8bb8\u5bf9\u4ee5\u524d\u671f\u95f4\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MatAllocateDelOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)tip, (String)"MatAllocateDelOpPlugin_1", (String)"MatAllocateDelOpPlugin_1", (Object[])new Object[0]));
                }
            }

            private void checkAllocStatus(ExtendedDataEntity dataEntity) {
                String allocStatus = dataEntity.getDataEntity().getString("allocstatus");
                if (ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(allocStatus)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u3002\u5f53\u524d\u6750\u6599\u8017\u7528\u8bb0\u5f55\u5df2\u7ecf\u786e\u8ba4\u5206\u914d\u7ed3\u679c\u3002", (String)"MatAllocateDelOpPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> allocBills = new HashSet<Long>(16);
        for (DynamicObject dataEntity : dataEntities) {
            allocBills.add(dataEntity.getLong("id"));
        }
        CostChangeRecHelper.writeCostChangeRecForAllocDel(allocBills);
        super.beginOperationTransaction(e);
    }
}

