/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.feealloc;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.cad.common.helper.MultiPartCcHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.alloc.MatAllocHelper;
import kd.macc.sca.algox.alloc.output.AllocResult;
import kd.macc.sca.algox.wip.CalcMutexHelper;
import kd.macc.sca.common.enums.BillBaseEnum;
import kd.macc.sca.common.enums.ScaAllocEnum;

public class MatAllocateOpValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashSet costObjCcSet = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            ExtendedDataEntity dataEntity = datas[i];
            DynamicObject saveItem = null;
            if (!this.isCurPeriod(dataEntity, this.getOperateKey())) continue;
            switch (this.getOperateKey()) {
                case "op_confirm": {
                    if (!this.validateAll(dataEntity)) break;
                    saveItem = this.confirm(dataEntity);
                    this.checkIfMultiPartCc(dataEntity, costObjCcSet);
                    break;
                }
                case "op_unconfirm": {
                    saveItem = this.unconfirm(dataEntity);
                }
            }
            if (saveItem == null) continue;
            list.add(saveItem);
        }
        MultiPartCcHelper.resolveMultipartCc((Set)costObjCcSet);
        switch (this.getOperateKey()) {
            case "op_allocate": {
                this.allocate(datas);
                break;
            }
            case "op_confirm": 
            case "op_unconfirm": {
                this.save(list);
            }
        }
    }

    private boolean validateAll(ExtendedDataEntity dataEntity) {
        DynamicObject mainData = dataEntity.getDataEntity();
        String tips = null;
        if (!this.validateQty(mainData)) {
            tips = ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u3002\u6570\u91cf\u5408\u8ba1\u2260\u9886\u7528\u6570\u91cf\u3002", (String)"MatAllocateOpValidator_0", (String)"macc-sca-form", (Object[])new Object[0]);
        }
        if (!this.validateAmount(mainData)) {
            tips = ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u3002\u6210\u672c\u91d1\u989d\u5408\u8ba1\u2260\u9886\u6599\u6210\u672c\u3002", (String)"MatAllocateOpValidator_1", (String)"macc-sca-form", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty(tips)) {
            this.addErrorMessage(dataEntity, String.format(tips, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateQty(DynamicObject mainData) {
        DynamicObjectCollection rows = mainData.getDynamicObjectCollection("entryentity");
        BigDecimal useQty = mainData.getBigDecimal("useqty");
        BigDecimal entryQty = BigDecimal.ZERO;
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return useQty.compareTo(entryQty) == 0;
        }
        for (DynamicObject row : rows) {
            entryQty = entryQty.add(row.getBigDecimal("qty"));
        }
        return useQty.compareTo(entryQty) == 0;
    }

    private boolean validateAmount(DynamicObject mainData) {
        DynamicObjectCollection rows = mainData.getDynamicObjectCollection("entryentity");
        BigDecimal useAmount = mainData.getBigDecimal("useamount");
        BigDecimal entryAmount = BigDecimal.ZERO;
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return useAmount.compareTo(entryAmount) == 0;
        }
        for (DynamicObject row : rows) {
            entryAmount = entryAmount.add(row.getBigDecimal("amount"));
        }
        double diff = useAmount.doubleValue() - entryAmount.doubleValue();
        return Math.asin(diff) < 1.0E-5;
    }

    private void save(List<DynamicObject> list) {
        if (CadEmptyUtils.isEmpty(list)) {
            return;
        }
        DynamicObject item = list.get(0);
        Long id = item.getLong("id");
        if (CadEmptyUtils.isEmpty((Long)id)) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sca_matalloc");
            SaveServiceHelper.save((IDataEntityType)type, (Object[])list.toArray(new DynamicObject[0]));
        } else {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void allocate(ExtendedDataEntity[] datas) {
        HashMap<Long, String> commonMap = new HashMap<Long, String>();
        HashSet<Long> prdOrgSet = new HashSet<Long>(8);
        DynamicObject costaccount = datas[0].getDataEntity().getDynamicObject("costaccount");
        Long costAcctId = costaccount.getLong("id");
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costAcctId);
        boolean returnFlag = false;
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject item = dataEntity.getDataEntity();
            if (!this.checkAlloc(dataEntity) || item.get("costobject") != null || ScaAllocEnum.USETYPE_DRIECT.getValue().equals(item.getString("usetype"))) continue;
            commonMap.put(item.getLong("id"), item.getString("billno"));
            DynamicObject manuorg = item.getDynamicObject("manuorg");
            if (!enableMulFactory) continue;
            if (manuorg == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a", (String)"MatAllocateOpValidator_2", (String)"macc-sca-form", (Object[])new Object[0]));
                returnFlag = true;
                break;
            }
            prdOrgSet.add(manuorg.getLong("id"));
        }
        if (returnFlag) {
            return;
        }
        try {
            AllocResult result = MatAllocHelper.doAlloc(commonMap.keySet());
            this.showAfterAlgoxTips4Alloc(datas, result);
        }
        finally {
            CalcMutexHelper.releaseMuteFromSet((String)"matdist", (boolean)enableMulFactory, (Long)costAcctId, prdOrgSet);
        }
    }

    private DynamicObject confirm(ExtendedDataEntity dataEntity) {
        DynamicObject item = dataEntity.getDataEntity();
        DynamicObjectCollection entrys = item.getDynamicObjectCollection("entryentity");
        if (CostCloseAccountHelper.checkIsCloseAccount((DynamicObject)item)) {
            String aTips = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u786e\u8ba4\u3002", (String)"MatAllocateOpValidator_3", (String)"macc-sca-form", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            return null;
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys) && ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue().equalsIgnoreCase(item.getString("allocstatus"))) {
            item.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
            item.set("billstatus", (Object)BillBaseEnum.BILL_STATUS_STAGED.getValue());
            item.set("auditdate", (Object)TimeServiceHelper.now());
            return item;
        }
        String aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u3002\u975e\u5206\u914d\u72b6\u6001\u3002", (String)"MatAllocateOpValidator_4", (String)"macc-sca-form", (Object[])new Object[0]);
        this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
        return null;
    }

    private DynamicObject unconfirm(ExtendedDataEntity dataEntity) {
        DynamicObject item = dataEntity.getDataEntity();
        if (!ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equalsIgnoreCase(item.getString("allocstatus"))) {
            String aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u53cd\u786e\u8ba4\u3002\u975e\u5df2\u786e\u8ba4\u72b6\u6001\u3002", (String)"MatAllocateOpValidator_5", (String)"macc-sca-form", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            return null;
        }
        if (CostCloseAccountHelper.checkIsCloseAccount((DynamicObject)item)) {
            String aTips = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u786e\u8ba4\u3002", (String)"MatAllocateOpValidator_6", (String)"macc-sca-form", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            return null;
        }
        if ("sca".equals(item.getString("appnum"))) {
            DynamicObjectCollection entrys = item.getDynamicObjectCollection("entryentity");
            Set costObjectSet = entrys.stream().map(entry -> entry.getLong("costobejctentry.id")).collect(Collectors.toSet());
            ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
            qfList.add(new QFilter("costobject", "in", costObjectSet));
            qfList.add(new QFilter("costaccount", "=", (Object)item.getLong("costaccount.id")));
            qfList.add(new QFilter("bizstatus", "=", (Object)"B"));
            if (QueryServiceHelper.exists((String)"cad_costobjectaccount", (QFilter[])qfList.toArray(new QFilter[0]))) {
                String aTips = ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u7ecf\u7ed3\u7b97\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u786e\u8ba4\u3002", (String)"MatAllocateOpValidator_7", (String)"macc-sca-form", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
                return null;
            }
        }
        item.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
        item.set("billstatus", (Object)BillBaseEnum.BILL_STATUS_STAGED.getValue());
        return item;
    }

    private boolean isCurPeriod(ExtendedDataEntity dataEntity, String opreateKey) {
        String opreateKeyStr = "";
        boolean flag = true;
        switch (opreateKey) {
            case "op_allocate": {
                opreateKeyStr = ResManager.loadKDString((String)"\u5206\u914d", (String)"MatAllocateOpValidator_8", (String)"macc-sca-form", (Object[])new Object[0]);
                break;
            }
            case "op_confirm": {
                opreateKeyStr = ResManager.loadKDString((String)"\u786e\u8ba4", (String)"MatAllocateOpValidator_9", (String)"macc-sca-form", (Object[])new Object[0]);
                break;
            }
            case "op_unconfirm": {
                opreateKeyStr = ResManager.loadKDString((String)"\u53cd\u786e\u8ba4", (String)"MatAllocateOpValidator_10", (String)"macc-sca-form", (Object[])new Object[0]);
                break;
            }
            default: {
                return false;
            }
        }
        DynamicObject item = dataEntity.getDataEntity();
        DynamicObject costaccount = item.getDynamicObject("costaccount");
        DynamicObject period = item.getDynamicObject("period");
        Long curPeriodId = 0L;
        DynamicObject dyn = PeriodHelper.getCurrentPeriod((Long)costaccount.getLong("id"));
        if (dyn != null) {
            curPeriodId = dyn.getLong("id");
        }
        if (period.getLong("id") != curPeriodId.longValue()) {
            flag = false;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\u3002\u4e0d\u5141\u8bb8\u5bf9\u4ee5\u524d\u671f\u95f4\u7684\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MatAllocateOpValidator_20", (String)"macc-sca-form", (Object[])new Object[0]), opreateKeyStr));
        }
        return flag;
    }

    private boolean checkAlloc(ExtendedDataEntity dataEntity) {
        DynamicObject item = dataEntity.getDataEntity();
        if (CostCloseAccountHelper.checkIsCloseAccount((DynamicObject)item)) {
            String aTips = ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6750\u6599\u8017\u7528\u5206\u914d\u3002", (String)"MatAllocateOpValidator_13", (String)"macc-sca-form", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            return false;
        }
        if (item.getDynamicObject("costobject") != null || ScaAllocEnum.USETYPE_DRIECT.getValue().equals(item.getString("usetype"))) {
            String aTips = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002%s\u5355\u636e\u5df2\u5b8c\u6210\u5206\u914d\u3002", (String)"MatAllocateOpValidator_14", (String)"macc-sca-form", (Object[])new Object[0]), item.getString("billno"));
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            return false;
        }
        if (ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equalsIgnoreCase(item.getString("allocstatus"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002\u5f53\u524d\u8bb0\u5f55\u5df2\u7ecf\u786e\u8ba4\u5206\u914d\u7ed3\u679c\u3002", (String)"MatAllocateOpValidator_15", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        if (item.getString("costdriver") == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002\u201c\u5206\u914d\u6807\u51c6\u201d\u4e3a\u7a7a\u3002", (String)"MatAllocateOpValidator_16", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        if (ScaAllocEnum.ALLOCTYPE_MANUAL.getValue().equalsIgnoreCase(item.getString("alloctype"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002\u5f53\u524d\u8bb0\u5f55\u5df2\u7ecf\u8fdb\u884c\u8fc7\u624b\u52a8\u5206\u914d\u3002", (String)"MatAllocateOpValidator_17", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showAfterAlgoxTips4Alloc(ExtendedDataEntity[] datas, AllocResult result) {
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject item = dataEntity.getDataEntity();
            for (String number : result.getReasonMap().keySet()) {
                if (!StringUtils.equals((CharSequence)number, (CharSequence)item.getString("id")) || !StringUtils.isNotEmpty((CharSequence)((CharSequence)result.getReasonMap().get(number)))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002", (String)"MatAllocateOpValidator_18", (String)"macc-sca-form", (Object[])new Object[0]));
            }
        }
    }

    private void checkIfMultiPartCc(ExtendedDataEntity dataEntity, Set<String> costObjCcSet) {
        DynamicObject item = dataEntity.getDataEntity();
        long costCenterId = item.getLong("costcenter.id");
        DynamicObjectCollection entryentity = item.getDynamicObjectCollection("entryentity");
        if (entryentity != null) {
            for (DynamicObject dynamicObject : entryentity) {
                long ccId;
                DynamicObject costObject = dynamicObject.getDynamicObject("costobejctentry");
                if (CadEmptyUtils.isEmpty((DynamicObject)costObject) || costCenterId == (ccId = costObject.getLong("costcenter.id"))) continue;
                costObjCcSet.add(String.valueOf(costObject.getLong("id")).concat("@").concat(String.valueOf(costCenterId)));
            }
        }
    }
}

