/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.feealloc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.ScaAllocEnum;

public class MfgFeeAllocStdSaveValidator
extends AbstractValidator {
    private static final List<String> SYS_ALLOC_DIM = Lists.newArrayList((Object[])new String[]{"projectnumber", "tracknumber", "lot"});

    public void validate() {
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        HashSet<String> excludeKeys = new HashSet<String>(dataEntities.length);
        HashMap<Long, Boolean> enableManorgMap = new HashMap<Long, Boolean>();
        MainEntityType mfgFeeBillEntityType = EntityMetadataCache.getDataEntityType((String)"cad_mfgfeebill");
        MainEntityType nonProdEntityType = EntityMetadataCache.getDataEntityType((String)"cad_nonprodalloc");
        MainEntityType basicEntityType = EntityMetadataCache.getDataEntityType((String)"cad_basicalloc");
        MainEntityType allocStdEntityType = EntityMetadataCache.getDataEntityType((String)"sca_mfgfeeallocstdnew");
        IDataEntityProperty allocDimProperty = allocStdEntityType.findProperty("allocdim");
        ArrayList<ValueMapItem> comboItems = new ArrayList();
        if (allocDimProperty != null) {
            comboItems = ((MulComboProp)allocDimProperty).getComboItems();
        }
        HashMap<String, String> comboNameMap = new HashMap<String, String>(4);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            String[] split;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String allocDim = dataEntity.getString("allocdim");
            String allocMold = dataEntity.getString("allocmold");
            boolean allocDimCheckPass = true;
            if (!CadEmptyUtils.isEmpty((String)allocDim) && (split = allocDim.split(",")) != null && split.length > 1) {
                for (String arr : split) {
                    if (CadEmptyUtils.isEmpty((String)arr) || SYS_ALLOC_DIM.contains(arr)) continue;
                    String allocDimShowName = this.getComboName(comboItems, comboNameMap, arr);
                    if (mfgFeeBillEntityType.findProperty(arr) == null) {
                        allocDimCheckPass = false;
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeAllocStdSaveValidator_36", (String)"macc-sca-form", (Object[])new Object[0]), arr, allocDimShowName, allocDimShowName));
                    }
                    if (nonProdEntityType.findProperty(arr) == null) {
                        allocDimCheckPass = false;
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u975e\u751f\u4ea7\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeAllocStdSaveValidator_37", (String)"macc-sca-form", (Object[])new Object[0]), arr, allocDimShowName, allocDimShowName));
                    }
                    if (!ScaAllocEnum.BASIC_PRODUCT_ALLOC.getValue().equals(allocMold) || basicEntityType.findProperty(arr) != null) continue;
                    allocDimCheckPass = false;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7\u5206\u914d\u5355\u636e\u672a\u589e\u52a0\u6807\u8bc6\u4e3a%1$s\u7684%2$s\u7ef4\u5ea6\u5b57\u6bb5\uff0c\u5206\u914d\u6807\u51c6\u5206\u914d\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u8bbe\u7f6e%3$s\u7ef4\u5ea6\u3002", (String)"MfgFeeAllocStdSaveValidator_38", (String)"macc-sca-form", (Object[])new Object[0]), arr, allocDimShowName, allocDimShowName));
                }
            }
            if (!allocDimCheckPass) {
                return;
            }
            if (this.verifyManuorg(extendedDataEntity, dataEntity, enableManorgMap)) {
                return;
            }
            if (this.verifyBillNumber(extendedDataEntity, dataEntity)) {
                return;
            }
            if (this.verifyAllocMethod(extendedDataEntity, dataEntity)) {
                return;
            }
            if (this.verifyCostCenter(extendedDataEntity, dataEntity)) {
                return;
            }
            if (this.verifyMfgFeeAllocStd(extendedDataEntity, dataEntity, excludeKeys)) {
                return;
            }
            if (this.verifyAuxEntry(extendedDataEntity, dataEntity)) {
                return;
            }
            if (this.verifyMustInputEntry(extendedDataEntity, dataEntity)) {
                return;
            }
            if (this.verifySubElementEntry(extendedDataEntity, dataEntity)) {
                return;
            }
            if (!this.verifyRepeatEntry(extendedDataEntity, dataEntity)) continue;
            return;
        }
        this.checkCenter(dataEntities, operateKey);
    }

    private String getComboName(List<ValueMapItem> comboItems, Map<String, String> comboNameMap, String arr) {
        if (comboNameMap.containsKey(arr)) {
            return comboNameMap.get(arr);
        }
        String comboName = "";
        for (ValueMapItem combo : comboItems) {
            comboNameMap.put(combo.getValue(), combo.getName().getLocaleValue());
            if (!combo.getValue().equals(arr)) continue;
            comboName = combo.getName().getLocaleValue();
        }
        return comboName;
    }

    private boolean verifyRepeatEntry(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        boolean isBeneficiary = dataEntity.getBoolean("isbeneficiary");
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
        int rowIndex = 1;
        boolean isRepeat = false;
        for (DynamicObject entry : entrys) {
            DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
            HashMap<Long, List> entryMapIndex = new HashMap<Long, List>(16);
            int subRowIndex = 1;
            for (DynamicObject subentry : subEntrys) {
                long costCenterId;
                long l = costCenterId = isBeneficiary ? subentry.getLong("benefcostcenter.masterid") : subentry.getLong("centergroup.masterid");
                if (costCenterId != 0L) {
                    entryMapIndex.computeIfAbsent(costCenterId, s -> new ArrayList()).add(String.valueOf(subRowIndex));
                }
                ++subRowIndex;
            }
            StringBuffer sb = new StringBuffer();
            if (entryMapIndex.size() > 0) {
                for (List indexList : entryMapIndex.values()) {
                    if (indexList.size() <= 1) continue;
                    indexList.forEach(s -> sb.append((String)s).append("\uff0c"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                String expenseItem = "";
                if (entry.getDynamicObject("expenseitem") != null) {
                    expenseItem = entry.getDynamicObject("expenseitem").getString("number");
                }
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u8bbe\u7f6e\u7b2c%1$s\u884c\u8d39\u7528\u9879\u76ee\u201c%2$s\u201d\u5bf9\u5e94\u7684\u6536\u76ca\u65b9\u7b2c%3$s\u884c\u6210\u672c\u4e2d\u5fc3\u91cd\u590d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"MfgFeeAllocStdSaveValidator_29", (String)"macc-sca-form", (Object[])new Object[0]), rowIndex, expenseItem, sb.substring(0, sb.length() - 1)));
                isRepeat = true;
            }
            ++rowIndex;
        }
        return isRepeat;
    }

    private boolean verifyAllocMethod(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
        String allocMold = dataEntity.getString("allocmold");
        if (costCenter != null) {
            Long orgduty = costCenter.getLong("orgduty.id");
            boolean isNotMatch = false;
            if (ScaAllocEnum.BASIC_PRODUCT_ALLOC.getValue().equals(allocMold) && orgduty != 4L) {
                isNotMatch = true;
            } else if (ScaAllocEnum.ASSIST_PRODUCT_ALLOC.getValue().equals(allocMold) && orgduty != 5L) {
                isNotMatch = true;
            } else if (ScaAllocEnum.NON_PRODUCT_ALLOC.getValue().equals(allocMold) && (orgduty == 4L || orgduty == 5L)) {
                isNotMatch = true;
            }
            if (isNotMatch) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5206\u914d\u7c7b\u578b\u4e0e\u6210\u672c\u4e2d\u5fc3\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"MfgFeeAllocStdSaveValidator_0", (String)"macc-sca-form", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean verifyManuorg(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, Map<Long, Boolean> enableManorgMap) {
        Long orgId = dataEntity.getLong("org.id");
        if (!enableManorgMap.containsKey(orgId)) {
            String appNum = dataEntity.getString("appnum");
            DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts((Long)orgId, (Boolean)true, (String)appNum);
            String appName = AppIdHelper.getAppName((String)appNum);
            if (costAccounts.isEmpty()) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u542f\u7528%s\u6216\u6210\u672c\u8d26\u8584\u672a\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"MfgFeeAllocStdSaveValidator_27", (String)"macc-sca-form", (Object[])new Object[0]), appName));
                return true;
            }
            for (DynamicObject obj : costAccounts) {
                if (!CostAccountHelper.isEnableMulFactory((Long)obj.getLong("id"))) continue;
                enableManorgMap.put(orgId, Boolean.TRUE);
                break;
            }
            if (!enableManorgMap.containsKey(orgId)) {
                enableManorgMap.put(orgId, Boolean.FALSE);
            }
        }
        Long manuorgId = dataEntity.getLong("manuorg.id");
        if (enableManorgMap.get(orgId).booleanValue()) {
            if (manuorgId == null || manuorgId == 0L) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0e\u6210\u672c\u8d26\u7c3f\u7ec4\u5408\u4e0b\u542f\u7528\u591a\u5de5\u5382\uff0c\u751f\u4ea7\u7ec4\u7ec7\u5fc5\u5f55\u3002", (String)"MfgFeeAllocStdSaveValidator_1", (String)"macc-sca-form", (Object[])new Object[0]));
                return true;
            }
        } else if (manuorgId != null && manuorgId > 0L) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0e\u6210\u672c\u8d26\u7c3f\u7ec4\u5408\u4e0b\u672a\u542f\u7528\u591a\u5de5\u5382\uff0c\u751f\u4ea7\u7ec4\u7ec7\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"MfgFeeAllocStdSaveValidator_2", (String)"macc-sca-form", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean verifyBillNumber(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        String billno = dataEntity.getString("billno");
        QFilter billnoFilter = new QFilter("billno", "=", (Object)billno);
        billnoFilter.and("appnum", "=", (Object)dataEntity.getString("appnum"));
        Boolean isExist = QueryServiceHelper.exists((String)"sca_mfgfeeallocstdnew", (QFilter[])new QFilter[]{billnoFilter});
        if (isExist.booleanValue() && "0".equals(dataEntity.getString("id"))) {
            if ("submit".equals(this.getOperateKey())) {
                this.addErrorMessage(extendedDataEntity, String.format(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u3010%s\u3011\u5206\u914d\u6807\u51c6\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"MfgFeeAllocStdSaveValidator_30", (String)"macc-sca-form", (Object[])new Object[0]), billno), new Object[0]));
                return true;
            }
            if ("save".equals(this.getOperateKey())) {
                this.addErrorMessage(extendedDataEntity, String.format(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u3010%s\u3011\u5206\u914d\u6807\u51c6\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"MfgFeeAllocStdSaveValidator_31", (String)"macc-sca-form", (Object[])new Object[0]), billno), new Object[0]));
                return true;
            }
        }
        return false;
    }

    private boolean verifyMfgFeeAllocStd(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity, Set<String> excludeKeys) {
        long orgId = dataEntity.getLong("org.id");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        HashSet<Long> costCenterIds = new HashSet<Long>(10);
        if (dataEntity.getBoolean("issender")) {
            costCenterIds.add(dataEntity.getLong("costcenter.id"));
        } else {
            long centerGroupId = dataEntity.getLong("costcentergroup.id");
            QFilter qFilter = new QFilter("id", "=", (Object)centerGroupId);
            DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"id, entryentity.costcenter as costcenter", (QFilter[])qFilter.toArray());
            costCenters.forEach(s -> costCenterIds.add(s.getLong("costcenter")));
        }
        Long manuorgId = dataEntity.getLong("manuorg.id");
        Long id = dataEntity.getLong("id");
        QFilter manuorgFilter = new QFilter("manuorg", "=", (Object)manuorgId);
        QFilter qFilter = new QFilter("entryentity.costcenter", "in", costCenterIds);
        qFilter.and(this.getEffectDateFilter());
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        statusFilter.and("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection costCenterGroups = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"id", (QFilter[])new QFilter[]{orgFilter, manuorgFilter, qFilter, statusFilter});
        HashSet<Long> centerGroups = new HashSet<Long>(16);
        costCenterGroups.forEach(s -> centerGroups.add(s.getLong("id")));
        String appNum = dataEntity.getString("appnum");
        boolean isExistBillByGroup = this.isExistBillByGroup(centerGroups, orgId, manuorgId, id, appNum);
        boolean isExit = false;
        for (Long costcenterId : costCenterIds) {
            String key = String.format("%s@%s@%s", costcenterId, orgId, manuorgId);
            boolean isExistBill = this.isExistBill(costcenterId, orgId, manuorgId, id, appNum);
            if (isExistBill || excludeKeys.contains(key) || isExistBillByGroup) {
                isExit = true;
                StringBuilder sb = new StringBuilder();
                sb.append(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7", (String)"MfgFeeAllocStdSaveValidator_5", (String)"macc-sca-form", (Object[])new Object[0]));
                if (manuorgId != null && manuorgId > 0L) {
                    sb.append(ResManager.loadKDString((String)"+\u751f\u4ea7\u7ec4\u7ec7", (String)"MfgFeeAllocStdSaveValidator_6", (String)"macc-sca-form", (Object[])new Object[0]));
                }
                if (costcenterId != null && costcenterId > 0L) {
                    QFilter costCenterFilter = new QFilter("id", "=", (Object)costcenterId);
                    DynamicObject costCenter = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"id, number, name", (QFilter[])costCenterFilter.toArray());
                    sb.append(String.format(ResManager.loadKDString((String)"+\u6210\u672c\u4e2d\u5fc3\u3010%1$s/%2$s\u3011", (String)"MfgFeeAllocStdSaveValidator_28", (String)"macc-sca-form", (Object[])new Object[0]), costCenter.getString("number"), costCenter.getString("name")));
                }
                if (sb.length() > 6) {
                    sb.append(ResManager.loadKDString((String)"\u7ec4\u5408\u4e0b", (String)"MfgFeeAllocStdSaveValidator_8", (String)"macc-sca-form", (Object[])new Object[0]));
                }
                sb.append(ResManager.loadKDString((String)"\u5df2\u7ecf\u7ef4\u62a4\u4e86\u5236\u9020\u8d39\u7528\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeAllocStdSaveValidator_9", (String)"macc-sca-form", (Object[])new Object[0]));
                String operate = "";
                switch (this.getOperateKey()) {
                    case "save": {
                        operate = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MfgFeeAllocStdSaveValidator_10", (String)"macc-sca-form", (Object[])new Object[0]);
                        break;
                    }
                    case "submit": {
                        operate = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"MfgFeeAllocStdSaveValidator_11", (String)"macc-sca-form", (Object[])new Object[0]);
                        break;
                    }
                    case "audit": {
                        operate = ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\u3002", (String)"MfgFeeAllocStdSaveValidator_12", (String)"macc-sca-form", (Object[])new Object[0]);
                        break;
                    }
                }
                String errorTips = ResManager.loadKDString((String)(operate + sb), (String)"MatAllocStdSaveOp_2", (String)"MfgFeeAllocStdSaveValidator_13", (Object[])new Object[0]);
                this.addErrorMessage(extendedDataEntity, errorTips);
            }
            excludeKeys.add(key);
        }
        return isExit;
    }

    private boolean isExistBill(Long costCenterId, long orgId, Long manuorgId, Long id, String appNum) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter billNoFilter = new QFilter("costcenter.id", "=", (Object)costCenterId);
        billNoFilter.and("issender", "=", (Object)Boolean.TRUE);
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)"A");
        QFilter manuorgFilter = new QFilter("manuorg", "=", (Object)manuorgId);
        QFilter idFilter = new QFilter("id", "not in", (Object)id);
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)appNum);
        return QueryServiceHelper.exists((String)"sca_mfgfeeallocstdnew", (QFilter[])new QFilter[]{billNoFilter, billStatusFilter, orgFilter, manuorgFilter, idFilter, appNumFilter});
    }

    private QFilter getEffectDateFilter() {
        Date date = new Date();
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        return dateFilter;
    }

    private boolean isExistBillByGroup(Set<Long> centerGroupId, long orgid, Long manuOrg, Long id, String appNum) {
        QFilter billNoFilter = new QFilter("costcentergroup.id", "in", centerGroupId);
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)"A");
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgid);
        QFilter manuOrgFilter = new QFilter("manuorg.id", "=", (Object)manuOrg);
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        QFilter appNumFilter = new QFilter("appnum", "=", (Object)appNum);
        return QueryServiceHelper.exists((String)"sca_mfgfeeallocstdnew", (QFilter[])new QFilter[]{billNoFilter, billStatusFilter, orgFilter, manuOrgFilter, idFilter, appNumFilter});
    }

    private boolean verifyCostCenter(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        String allocMold = dataEntity.getString("allocmold");
        if (ScaAllocEnum.ASSIST_PRODUCT_ALLOC.getValue().equals(allocMold) || ScaAllocEnum.BASIC_PRODUCT_ALLOC.getValue().equals(allocMold)) {
            boolean isSender = dataEntity.getBoolean("isSender");
            DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
            DynamicObject costCenterGroup = dataEntity.getDynamicObject("costcentergroup");
            if (isSender && costCenter == null || !isSender && costCenterGroup == null) {
                String tip = isSender ? ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3", (String)"MfgFeeAllocStdSaveValidator_14", (String)"macc-sca-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7ec4", (String)"MfgFeeAllocStdSaveValidator_15", (String)"macc-sca-form", (Object[])new Object[0]);
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5f53\u524d\u5206\u914d\u7c7b\u578b\u4e3a%1$s\uff0c%2$s\u5fc5\u5f55\u3002", (String)"MfgFeeAllocStdSaveValidator_16", (String)"macc-sca-form", (Object[])new Object[0]), ScaAllocEnum.getName(allocMold), tip));
                return true;
            }
        }
        return false;
    }

    private boolean verifyAuxEntry(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        String allocMold = dataEntity.getString("allocmold");
        if (ScaAllocEnum.ASSIST_PRODUCT_ALLOC.getValue().equals(allocMold) && dataEntity.getDynamicObjectCollection("entryentity").size() != 1) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5206\u914d\u7c7b\u578b\u4e3a\u8f85\u52a9\u751f\u4ea7\u5206\u914d\u65f6\uff0c\u5206\u914d\u6807\u51c6\u9501\u5b9a\u4e3a\u4e00\u884c\u3002", (String)"MfgFeeAllocStdSaveValidator_17", (String)"macc-sca-form", (Object[])new Object[0]), ScaAllocEnum.getName(allocMold)));
            return true;
        }
        return false;
    }

    private boolean verifySubElementEntry(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        boolean isExpense = dataEntity.getBoolean("isexpense");
        if (!isExpense) {
            HashSet<Long> subElementIds = new HashSet<Long>(16);
            DynamicObjectCollection entryCollect = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCollect) {
                long subelementId = entry.getLong("subelement.id");
                if (subElementIds.contains(subelementId)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u6210\u672c\u5b50\u8981\u7d20\u7ef4\u62a4\u91cd\u590d\u3002", (String)"MfgFeeAllocStdSaveValidator_33", (String)"macc-sca-form", (Object[])new Object[0]));
                    return true;
                }
                subElementIds.add(subelementId);
            }
        }
        return false;
    }

    private boolean verifyMustInputEntry(ExtendedDataEntity extendedDataEntity, DynamicObject dataEntity) {
        boolean isExpense = dataEntity.getBoolean("isexpense");
        int index = 1;
        String errorTip = isExpense ? String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u7ef4\u62a4\u7b2c%s\u884c\u8d39\u7528\u9879\u76ee/\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeAllocStdSaveValidator_19", (String)"macc-sca-form", (Object[])new Object[0]), index) : String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u7ef4\u62a4\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20/\u5206\u914d\u6807\u51c6\u3002", (String)"MfgFeeAllocStdSaveValidator_20", (String)"macc-sca-form", (Object[])new Object[0]), index);
        DynamicObjectCollection entryCollect = dataEntity.getDynamicObjectCollection("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryCollect)) {
            this.addErrorMessage(extendedDataEntity, errorTip);
            return true;
        }
        for (DynamicObject entry : entryCollect) {
            long costDriverId = entry.getLong("costdriver.id");
            if (isExpense) {
                long expenseitemId = entry.getLong("expenseitem.id");
                if (CadEmptyUtils.isEmpty((Long)expenseitemId) || CadEmptyUtils.isEmpty((Long)costDriverId)) {
                    this.addErrorMessage(extendedDataEntity, errorTip);
                    return true;
                }
            } else {
                long subelementId = entry.getLong("subelement.id");
                if (CadEmptyUtils.isEmpty((Long)subelementId) || CadEmptyUtils.isEmpty((Long)costDriverId)) {
                    this.addErrorMessage(extendedDataEntity, errorTip);
                    return true;
                }
            }
            ++index;
        }
        return false;
    }

    private void checkCenter(ExtendedDataEntity[] dataEntity, String operateKey) {
        if ("submit".equals(operateKey) || "audit".equals(operateKey)) {
            for (ExtendedDataEntity entity : dataEntity) {
                Object dynamicObject2;
                Object entry2;
                DynamicObject diyBill = entity.getDataEntity();
                long orgId = diyBill.getLong("org.id");
                String appNum = diyBill.getString("appnum");
                boolean isbeneficiary = diyBill.getBoolean("isbeneficiary");
                if (!OrgHelper.isOrgEnableMultiFactory((Long)orgId)) continue;
                ArrayList<DynamicObject> entryEntity = new ArrayList<DynamicObject>(10);
                DynamicObjectCollection entrys = diyBill.getDynamicObjectCollection("entryentity");
                for (Object entry2 : entrys) {
                    DynamicObjectCollection dynamicObjectCollection = entry2.getDynamicObjectCollection("subentryentity");
                    for (Object dynamicObject2 : dynamicObjectCollection) {
                        entryEntity.add((DynamicObject)dynamicObject2);
                    }
                }
                if (entryEntity.size() == 0) continue;
                HashMap<Long, DynamicObject> centerMap = new HashMap<Long, DynamicObject>(16);
                entry2 = entryEntity.iterator();
                while (entry2.hasNext()) {
                    DynamicObject entry3 = (DynamicObject)entry2.next();
                    if (isbeneficiary) {
                        DynamicObject benefCostcenter = entry3.getDynamicObject("benefcostcenter");
                        if (CadEmptyUtils.isEmpty((DynamicObject)benefCostcenter) || !"4".equals(benefCostcenter.getString("orgduty.number")) && !"5".equals(benefCostcenter.getString("orgduty.number"))) continue;
                        centerMap.put(benefCostcenter.getLong("id"), benefCostcenter);
                        continue;
                    }
                    long centerGroup = entry3.getLong("centergroup.id");
                    this.centerGroupConvert(centerGroup, centerMap, orgId);
                }
                Set centerIds = centerMap.keySet();
                if (centerIds.isEmpty()) continue;
                Set centerManuOrgByIds = OrgHelper.getCenterManuOrgByIds((Long)orgId, centerIds, (String)appNum);
                StringJoiner joiner = new StringJoiner("\uff1b");
                dynamicObject2 = centerMap.entrySet().iterator();
                while (dynamicObject2.hasNext()) {
                    Map.Entry entry4 = (Map.Entry)dynamicObject2.next();
                    Long key = (Long)entry4.getKey();
                    if (centerManuOrgByIds.contains(key)) continue;
                    DynamicObject value = (DynamicObject)entry4.getValue();
                    joiner.add("\u3010" + value.getString("number") + "/" + value.getString("name") + "\u3011");
                }
                String message = joiner.toString();
                if (!StringUtils.isNotBlank((CharSequence)message)) continue;
                String tips = "submit".equals(operateKey) ? (isbeneficiary ? ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u6210\u672c\u4e2d\u5fc3%s\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u8868\u3002", (String)"MfgFeeAllocStdSaveValidator_21", (String)"macc-sca-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002\u53d7\u76ca\u6210\u672c\u4e2d\u5fc3\u7ec4\u4e0b\u6210\u672c\u4e2d\u5fc3%s\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u8868\u3002", (String)"MfgFeeAllocStdSaveValidator_22", (String)"macc-sca-form", (Object[])new Object[0])) : (isbeneficiary ? ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\u3002\u6210\u672c\u4e2d\u5fc3%s\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u8868\u3002", (String)"MfgFeeAllocStdSaveValidator_23", (String)"macc-sca-form", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\u3002\u53d7\u76ca\u6210\u672c\u4e2d\u5fc3\u7ec4\u4e0b\u6210\u672c\u4e2d\u5fc3%s\u672a\u7ef4\u62a4\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u8868\u3002", (String)"MfgFeeAllocStdSaveValidator_24", (String)"macc-sca-form", (Object[])new Object[0]));
                this.addErrorMessage(entity, ResManager.loadKDString((String)String.format(tips, message), (String)"DiyCostDriverSaveOpPlugin_3", (String)"MfgFeeAllocStdSaveValidator_25", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void centerGroupConvert(long centerGroup, Map<Long, DynamicObject> centerMap, long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and("id", "=", (Object)centerGroup);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"entryentity.costcenter as costcenterid,entryentity.costcenter.number as number,entryentity.costcenter.name as name,entryentity.costcenter.orgduty.number as orgduty", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : query) {
            if (!"4".equals(dynamicObject.getString("orgduty")) && !"5".equals(dynamicObject.getString("orgduty"))) continue;
            centerMap.put(dynamicObject.getLong("costcenterid"), dynamicObject);
        }
    }
}

