/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.feealloc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AccountViewHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MfgfeeBillImportHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.enums.ScaMfgFeeImpSchEnum;

public class MfgFeeImpSchSavePlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MfgFeeImpSchSavePlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("assgrp");
        fieldKeys.add("addtype");
        fieldKeys.add("manuorg");
        fieldKeys.add("srcbizsys");
        fieldKeys.add("entryentity.costcenter");
        fieldKeys.add("entryentity.costcentertype");
        fieldKeys.add("entryentity.expenseitem");
        fieldKeys.add("entryentity.expenseitemtype");
        fieldKeys.add("entryentity.benefcostcentertype");
        fieldKeys.add("entryentity.benefcostcenter");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                String tip = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MfgFeeImpSchSavePlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
                if ("submit".equals(operateKey)) {
                    tip = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"MfgFeeImpSchSavePlugin_1", (String)"macc-sca-form", (Object[])new Object[0]);
                }
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                ArrayList<DynamicObject> dataDys = new ArrayList<DynamicObject>(16);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    this.checkValueType(dataEntity, tip);
                    this.checkOrgAndManuorg(dataEntity, tip);
                    dataDys.add(dataEntity.getDataEntity());
                }
                Map accountBookMap = MfgFeeImpSchSavePlugin.this.getAccountBookMap(dataDys.toArray(new DynamicObject[0]));
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    this.checkAccountBook(dataEntity, tip, accountBookMap);
                }
            }

            private void checkAccountBook(ExtendedDataEntity dataEntity, String tip, Map<String, Long> accountBookMap) {
                Long costAccountId;
                DynamicObject bill = dataEntity.getDataEntity();
                String srcBiz = bill.getString("srcbizsys.number");
                if (!"gl".equals(srcBiz)) {
                    return;
                }
                long orgId = bill.getLong("org.id");
                Long accountBookId = MfgFeeImpSchSavePlugin.this.getAccountBook(orgId, costAccountId = Long.valueOf(bill.getLong("costaccount.id")), accountBookMap);
                if (CadEmptyUtils.isEmpty((Long)accountBookId)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u6839\u636e\u6210\u672c\u8d26\u7c3f\u83b7\u53d6\u5bf9\u5e94\u4f1a\u8ba1\u8d26\u7c3f\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5728\u4f1a\u8ba1\u8d26\u7c3f\u7ef4\u62a4\u8d26\u7c3f\u5173\u8054\u5173\u7cfb\u3002", (String)"MfgFeeImpSchSavePlugin_5", (String)"macc-sca-form", (Object[])new Object[0]), tip));
                }
            }

            private void checkValueType(ExtendedDataEntity dataEntity, String tip) {
                DynamicObject entity = dataEntity.getDataEntity();
                DynamicObjectCollection entry = entity.getDynamicObjectCollection("entryentity");
                DynamicObject row = (DynamicObject)entry.get(0);
                if (ScaMfgFeeImpSchEnum.VALUETYPE_FIXED.getValue().equals(row.getString("expenseitemtype")) && CadEmptyUtils.isEmpty((DynamicObject)row.getDynamicObject("expenseitem"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u8d39\u7528\u9879\u76ee\u53d6\u503c\u4e3a\u56fa\u5b9a\u503c\u65f6\uff0c\u8d39\u7528\u9879\u76ee\u4e3a\u5fc5\u5f55\u9879\u3002", (String)"MfgFeeImpSchSavePlugin_2", (String)"macc-sca-form", (Object[])new Object[0]), tip));
                }
                if (ScaMfgFeeImpSchEnum.VALUETYPE_FIXED.getValue().equals(row.getString("costcentertype")) && CadEmptyUtils.isEmpty((DynamicObject)row.getDynamicObject("costcenter"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u6210\u672c\u4e2d\u5fc3\u53d6\u503c\u4e3a\u56fa\u5b9a\u503c\u65f6\uff0c\u6210\u672c\u4e2d\u5fc3\u4e3a\u5fc5\u5f55\u9879\u3002", (String)"MfgFeeImpSchSavePlugin_3", (String)"macc-sca-form", (Object[])new Object[0]), tip));
                }
            }

            private void checkOrgAndManuorg(ExtendedDataEntity dataEntity, String tip) {
                List userHasPermManuorgs;
                long org = dataEntity.getDataEntity().getLong("org.id");
                long manuorg = dataEntity.getDataEntity().getLong("manuorg.id");
                if (!CadEmptyUtils.isEmpty((Long)manuorg) && OrgHelper.isOrgEnableMultiFactory((Long)org) && !(userHasPermManuorgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org, (String)"sca_mfgfeeimpsch")).contains(manuorg)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u8bf7\u68c0\u67e51.\u5f55\u5165\u7684\u751f\u4ea7\u7ec4\u7ec7\u662f\u5426\u6709\u751f\u4ea7\u804c\u80fd\uff1b2.\u6838\u7b97\u7ec4\u7ec7\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u662f\u5426\u6709\u59d4\u6258\u5173\u7cfb\uff1b3.\u662f\u5426\u6709\u5f55\u5165\u7684\u751f\u4ea7\u7ec4\u7ec7\u7684\u6743\u9650\u3002", (String)"MfgFeeImpSchSavePlugin_4", (String)"macc-sca-form", (Object[])new Object[0]), tip));
                }
            }
        });
        super.onAddValidators(e);
    }

    private Long getAccountBook(long orgId, Long costAccountId, Map<String, Long> accountBookMap) {
        StringBuilder keySb = new StringBuilder();
        keySb.append(orgId).append('@').append(costAccountId);
        Long accountBookId = accountBookMap.get(keySb.toString());
        if (CadEmptyUtils.isEmpty((Long)accountBookId)) {
            accountBookId = accountBookMap.get(String.valueOf(costAccountId));
        }
        return accountBookId;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map<String, Set<String>> assgrpMap;
        super.beginOperationTransaction(e);
        logger.info("\u8fdb\u5165\u5236\u9020\u8d39\u7528\u5bfc\u5165\u65b9\u6848\u5bfc\u5165\u6838\u7b97\u7ef4\u5ea6\u5904\u7406");
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        MfgFeeImpSchSavePlugin.setExpenseItem(dataEntities);
        DynamicObject tempBill = dataEntities[0];
        String addtype = tempBill.getString("addtype");
        logger.info("\u8fdb\u5165\u5236\u9020\u8d39\u7528\u5bfc\u5165\u65b9\u6848\u5bfc\u5165\u6838\u7b97\u7ef4\u5ea6\u5904\u7406,addtype =>{}", (Object)addtype);
        if (!"execl".equals(addtype)) {
            return;
        }
        Map<String, Set<String>> accountViewMap = this.getAccountViewMap(dataEntities);
        if (!accountViewMap.isEmpty()) {
            logger.info("\u4f1a\u8ba1\u79d1\u76ee\u7ef4\u5ea6:" + SerializationUtils.toJsonString(accountViewMap));
        }
        if ((assgrpMap = this.getAssgrpMap(dataEntities, accountViewMap)).isEmpty()) {
            for (DynamicObject bill : dataEntities) {
                bill.set("assgrp", (Object)"");
            }
        }
        Map<String, DynamicObject> assgrpToEntityMap = this.getAssgrpToEntityMap(assgrpMap);
        Map<String, Map<String, String>> assgrpToValueNumAndIdMap = this.getAssgrpToValueNumAndIdMap(assgrpMap, assgrpToEntityMap);
        Map<String, Long> accountBookMap = this.getAccountBookMap(dataEntities);
        for (DynamicObject bill : dataEntities) {
            String[] assgrpArr;
            this.setAccoutBook(bill, accountBookMap);
            String assgrp = bill.getString("assgrp");
            if (StringUtils.isEmpty((String)assgrp)) {
                logger.info("MfgFeeImpSchSavePlugin==>\u6838\u7b97\u7ef4\u5ea6\u4e3a\u7a7a");
                continue;
            }
            HashMap srcAssgrpMap = new HashMap(16);
            for (String assgrpStr : assgrpArr = assgrp.split(";")) {
                String[] valueNumArr;
                String[] assgrpSimple = assgrpStr.split(":");
                if (assgrpSimple.length < 2) continue;
                String assgrpNum = assgrpSimple[0].trim();
                String assgrpValues = assgrpSimple[1].trim();
                Map<String, String> valueMap = assgrpToValueNumAndIdMap.get(assgrpNum);
                if (valueMap == null || valueMap.isEmpty()) {
                    logger.info("assgrpToValueNumAndIdMap.get(assgrpNum) is null assgrpNum=>{},assgrpValues=>{}", (Object)assgrpNum, (Object)assgrpValues);
                    continue;
                }
                ArrayList<String> valueIdList = new ArrayList<String>(10);
                DynamicObject asstactType = assgrpToEntityMap.get(assgrpNum);
                String flexfield = asstactType.getString("flexfield");
                for (String valueNum : valueNumArr = assgrpValues.split(",")) {
                    String valueId = valueMap.get(valueNum);
                    if (StringUtils.isEmpty((String)valueId)) {
                        logger.info("valueMap.get(valueNum) is null valueNum=>{}", (Object)valueNum);
                        continue;
                    }
                    valueIdList.add(valueId);
                }
                srcAssgrpMap.put(flexfield, valueIdList);
            }
            String assgrpJson = SerializationUtils.toJsonString(srcAssgrpMap);
            logger.info("assgrpJson ==>{}", (Object)assgrpJson);
            bill.set("assgrp", (Object)assgrpJson);
        }
    }

    private static void setExpenseItem(DynamicObject[] dataEntities) {
        ArrayList<Long> expenseitemIdList = new ArrayList<Long>();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                expenseitemIdList.add(entry.getLong("expenseitem.id"));
            }
        }
        Map expenseitemMap = MfgfeeBillImportHelper.expenseitemIdToMasterId(expenseitemIdList);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                Long expenseitemMasterId = (Long)expenseitemMap.get(entry.getLong("expenseitem.id"));
                if (CadEmptyUtils.isEmpty((Long)expenseitemMasterId)) continue;
                entry.set("expenseitem_id", (Object)expenseitemMasterId);
            }
        }
    }

    private void setAccoutBook(DynamicObject bill, Map<String, Long> accountBookMap) {
        Long orgId = bill.getLong("org.id");
        Long costAccountId = bill.getLong("costaccount.id");
        Long accountBookId = this.getAccountBook(orgId, costAccountId, accountBookMap);
        DynamicObject accountBook = BusinessDataServiceHelper.newDynamicObject((String)"gl_accountbook");
        accountBook.set("id", (Object)accountBookId);
        bill.set("accountbook", (Object)accountBook);
    }

    private Map<String, Long> getAccountBookMap(DynamicObject[] dataEntities) {
        HashMap<Long, Set> calSystemAndCostAcocuntMap = new HashMap<Long, Set>(16);
        for (DynamicObject bill : dataEntities) {
            Long calSystemId;
            DynamicObject costAccount = bill.getDynamicObject("costaccount");
            if (costAccount == null || (calSystemId = Long.valueOf(costAccount.getLong("calsystem.id"))) == null) continue;
            long costAccountId = bill.getLong("costaccount.id");
            calSystemAndCostAcocuntMap.computeIfAbsent(calSystemId, s -> new HashSet()).add(costAccountId);
        }
        QFilter calSystemAndCostAcocuntQF = new QFilter("org", "=", (Object)-1L);
        for (Map.Entry entry : calSystemAndCostAcocuntMap.entrySet()) {
            Long calSystemId = (Long)entry.getKey();
            Set costAccountIds = (Set)entry.getValue();
            calSystemAndCostAcocuntQF.or(new QFilter("accountingsys", "=", (Object)calSystemId).and("b_entry.b_relatebook.fbasedataid", "in", (Object)costAccountIds));
        }
        QFilter enableQf = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] qf = new QFilter[]{enableQf, calSystemAndCostAcocuntQF};
        String fields = "id, org, b_entry.b_relatebook.fbasedataid AS costaccount, accounttable";
        DynamicObjectCollection accountBooks = QueryServiceHelper.query((String)"gl_accountbook", (String)fields, (QFilter[])qf);
        StringBuilder keySb = new StringBuilder();
        String split = "@";
        HashMap<String, Long> accountBookMap = new HashMap<String, Long>(16);
        accountBooks.forEach(accountBook -> {
            keySb.setLength(0);
            keySb.append(accountBook.getLong("org")).append(split).append(accountBook.getLong("costaccount"));
            accountBookMap.put(keySb.toString(), accountBook.getLong("id"));
            accountBookMap.put(String.valueOf(accountBook.getLong("costaccount")), accountBook.getLong("id"));
        });
        return accountBookMap;
    }

    private Map<String, Map<String, String>> getAssgrpToValueNumAndIdMap(Map<String, Set<String>> assgrpMap, Map<String, DynamicObject> assgrpToEntityMap) {
        HashMap<String, Map<String, String>> assgrpToValueNumAndIdMap = new HashMap<String, Map<String, String>>(16);
        for (Map.Entry<String, Set<String>> assgrpEntry : assgrpMap.entrySet()) {
            String assgrpNum = assgrpEntry.getKey();
            Set<String> valueNums = assgrpEntry.getValue();
            DynamicObject asstactType = assgrpToEntityMap.get(assgrpNum);
            String entityNum = asstactType.getString("entityNum");
            QFilter valueNumQf = new QFilter("number", "in", valueNums);
            DynamicObjectCollection values = QueryServiceHelper.query((String)entityNum, (String)"id, number", (QFilter[])new QFilter[]{valueNumQf});
            HashMap valueMap = new HashMap(16);
            values.forEach(value -> valueMap.put(value.getString("number"), value.getString("id")));
            assgrpToValueNumAndIdMap.put(assgrpNum, valueMap);
        }
        return assgrpToValueNumAndIdMap;
    }

    private Map<String, DynamicObject> getAssgrpToEntityMap(Map<String, Set<String>> assgrpMap) {
        HashMap<String, DynamicObject> assgrpToEntityMap = new HashMap<String, DynamicObject>(16);
        Set<String> assgrpNumbers = assgrpMap.keySet();
        QFilter numQf = new QFilter("number", "in", assgrpNumbers);
        DynamicObjectCollection asstactTypes = QueryServiceHelper.query((String)"bd_asstacttype", (String)"number, flexfield, valuesource.number AS entityNum", (QFilter[])new QFilter[]{numQf});
        asstactTypes.forEach(asstactType -> assgrpToEntityMap.put(asstactType.getString("number"), (DynamicObject)asstactType));
        return assgrpToEntityMap;
    }

    private Map<String, Set<String>> getAssgrpMap(DynamicObject[] dataEntities, Map<String, Set<String>> accountViewMap) {
        HashMap<String, Set<String>> assgrpMap = new HashMap<String, Set<String>>(16);
        for (DynamicObject bill : dataEntities) {
            String[] assgrpArr;
            String assgrp = bill.getString("assgrp");
            if (StringUtils.isEmpty((String)assgrp)) continue;
            HashSet<String> assgrpNumSet = new HashSet<String>();
            DynamicObjectCollection accountViews = bill.getDynamicObjectCollection("accountviews");
            HashSet<Long> accountViewIdSet = new HashSet<Long>(16);
            for (DynamicObject accountView : accountViews) {
                accountViewIdSet.add(accountView.getDynamicObject("fbasedataid").getLong("id"));
            }
            Set leafAccountViewIds = AccountViewHelper.getLeafAccountViewByIds(accountViewIdSet);
            QFilter accountQf = new QFilter("id", "in", (Object)leafAccountViewIds);
            DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"number", (QFilter[])new QFilter[]{accountQf});
            for (DynamicObject account : accounts) {
                Set<String> number = accountViewMap.get(account.getString("number"));
                if (number == null) continue;
                assgrpNumSet.addAll(number);
            }
            if (assgrpNumSet == null || assgrpNumSet.isEmpty() || (assgrpArr = assgrp.split(";")) == null || assgrpArr.length == 0) continue;
            for (String assgrpStr : assgrpArr) {
                Set assgrpValueSet;
                String[] assgrpSimple = assgrpStr.split(":");
                if (assgrpSimple.length < 2) continue;
                String assgrpNum = assgrpSimple[0].trim();
                String assgrpValues = assgrpSimple[1].trim();
                if (!assgrpNumSet.contains(assgrpNum) || (assgrpValueSet = Arrays.stream(assgrpValues.split(",")).collect(Collectors.toSet())).isEmpty()) continue;
                assgrpMap.computeIfAbsent(assgrpNum, s -> new HashSet()).addAll(assgrpValueSet);
            }
        }
        return assgrpMap;
    }

    private Map<String, Set<String>> getAccountViewMap(DynamicObject[] dataEntities) {
        HashSet<Long> accountViewIdSet = new HashSet<Long>(16);
        for (DynamicObject bill : dataEntities) {
            String assgrp = bill.getString("assgrp");
            if (StringUtils.isEmpty((String)assgrp)) continue;
            DynamicObjectCollection accountViews = bill.getDynamicObjectCollection("accountviews");
            for (DynamicObject accountView : accountViews) {
                accountViewIdSet.add(accountView.getDynamicObject("fbasedataid").getLong("id"));
            }
        }
        Set leafAccountViewIds = AccountViewHelper.getLeafAccountViewByIds(accountViewIdSet);
        QFilter accountQf = new QFilter("id", "in", (Object)leafAccountViewIds);
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"number, checkitementry.asstactitem.number AS assgrpNum", (QFilter[])new QFilter[]{accountQf});
        HashMap<String, Set<String>> accountViewMap = new HashMap<String, Set<String>>(16);
        accounts.forEach(account -> {
            if (!StringUtils.isEmpty((String)account.getString("assgrpNum"))) {
                accountViewMap.computeIfAbsent(account.getString("number"), s -> new HashSet()).add(account.getString("assgrpNum"));
            }
        });
        return accountViewMap;
    }
}

