/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.feealloc;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.sca.business.wipallocstd.WipAllocStdService;
import org.apache.commons.lang3.StringUtils;

public class ProAllocStdOpValidator
extends AbstractValidator {
    public void validate() {
        String operationName = this.getOperateKey();
        if (!"unaudit".equals(operationName)) {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                this.validateOp(dataEntity);
            }
        }
    }

    private void validateOp(ExtendedDataEntity exDataEntity) {
        Set allMatSubElements = ElementHelper.getMatSubElementIds();
        DynamicObject dataEntity = exDataEntity.getDataEntity();
        long orgId = dataEntity.getLong("org".concat(".id"));
        DynamicObjectCollection allocEntry = dataEntity.getDynamicObjectCollection("allocentry");
        Set<Long> allowAssemblyCC = WipAllocStdService.getAllowAssemblyCC(orgId);
        for (DynamicObject allocItem : allocEntry) {
            Sets.SetView diff;
            long costCenterId = allocItem.getLong("costcenter".concat(".id"));
            String costCenterName = allocItem.getString("costcenter".concat(".name"));
            DynamicObjectCollection productSubEntry = allocItem.getDynamicObjectCollection("productsubentry");
            HashSet subElementIdSet = Sets.newHashSetWithExpectedSize((int)8);
            HashSet subEleNameSet = Sets.newHashSetWithExpectedSize((int)8);
            for (DynamicObject dynamicObject : productSubEntry) {
                String costDriverDetail = dynamicObject.getString("costdriverdetail");
                if (!"3".equals(costDriverDetail)) continue;
                if (allowAssemblyCC.contains(costCenterId)) {
                    Long subElementId = dynamicObject.getLong("subelement.id");
                    String type = dynamicObject.getString("subelement.type");
                    if (type.equals("001")) {
                        subEleNameSet.add(dynamicObject.getString("subelement.name"));
                        subElementIdSet.add(subElementId);
                        continue;
                    }
                    this.addErrorMessage(exDataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u7c7b\u578b\u4e0d\u4e3a\u7269\u6599\uff0c\u4f46\u914d\u7f6e\u4e86\u201c\u6309\u7ec4\u4ef6\u6e05\u5355\u8ba1\u7b97\u201d\u3002", (String)"ProAllocStdOpValidator_0", (String)"macc-sca-form", (Object[])new Object[0]), costCenterName));
                    continue;
                }
                this.addErrorMessage(exDataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u201c%s\u201d\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5\u4e0d\u4e3a\u201c\u5de5\u5355\u6210\u672c\u201d\uff0c\u4f46\u914d\u7f6e\u4e86\u201c\u6309\u7ec4\u4ef6\u6e05\u5355\u8ba1\u7b97\u201d\u3002", (String)"ProAllocStdOpValidator_1", (String)"macc-sca-form", (Object[])new Object[0]), costCenterName));
            }
            if (subElementIdSet.isEmpty() || (diff = Sets.difference((Set)allMatSubElements, (Set)subElementIdSet)).isEmpty()) continue;
            String eleNames = StringUtils.join((Iterable)subEleNameSet, (String)",");
            this.addErrorMessage(exDataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u201c%s\u201d\u5df2\u8bbe\u7f6e\u4e86\u201c\u6309\u7ec4\u4ef6\u6e05\u5355\u8ba1\u7b97\u201d\uff0c\u5219\u5176\u5b83\u7269\u6599\u5c5e\u6027\u7684\u6210\u672c\u5b50\u8981\u7d20\u9700\u8981\u4f7f\u7528\u540c\u4e00\u89c4\u5219\u3002", (String)"ProAllocStdOpValidator_2", (String)"macc-sca-form", (Object[])new Object[0]), eleNames));
        }
    }
}

