/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.MatHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;

public class WipCostInitSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private BigDecimal getToTalValue(Map<String, DynamicObject> subelementMapItem) {
        BigDecimal totalValue = BigDecimal.ZERO;
        for (Map.Entry<String, DynamicObject> entrySet : subelementMapItem.entrySet()) {
            DynamicObject entry = entrySet.getValue();
            BigDecimal stdCost = entry.getBigDecimal("stdcost");
            if (CadEmptyUtils.isEmpty((BigDecimal)stdCost)) continue;
            totalValue = totalValue.add(stdCost);
        }
        return totalValue;
    }

    private void setEntryEntityRowReal(DynamicObject entry, DynamicObject addNew, BigDecimal initQty, BigDecimal initAmt, BigDecimal totalDiffAmt, BigDecimal totalStdCost) {
        addNew.set("resource", (Object)entry.getLong("resource"));
        addNew.set("calcbasis", (Object)entry.getLong("calcbasis"));
        addNew.set("element", (Object)entry.getLong("element"));
        addNew.set("subelement", (Object)entry.getLong("subelement"));
        BigDecimal stdCost = entry.getBigDecimal("stdcost");
        addNew.set("stdcost", (Object)entry.getBigDecimal("stdcost"));
        if (CadEmptyUtils.isEmpty((BigDecimal)stdCost)) {
            return;
        }
        BigDecimal stdAmt = BigDecimal.ZERO;
        if (!CadEmptyUtils.isEmpty((BigDecimal)initQty)) {
            stdAmt = stdCost.multiply(initQty);
            addNew.set("stdamt", (Object)stdAmt);
        }
        BigDecimal rate = stdCost.divide(totalStdCost, 4, 4);
        if (!CadEmptyUtils.isEmpty((BigDecimal)initAmt)) {
            BigDecimal realAmt = initAmt.multiply(rate);
            addNew.set("realamt", (Object)realAmt);
            addNew.set("diffamt", (Object)realAmt.subtract(stdAmt));
            return;
        }
        if (!CadEmptyUtils.isEmpty((BigDecimal)totalDiffAmt)) {
            BigDecimal diffAmt = totalDiffAmt.multiply(rate);
            addNew.set("diffamt", (Object)diffAmt);
            addNew.set("realamt", (Object)diffAmt.add(stdAmt));
        }
    }

    private void setEntryEntityValue(DynamicObjectCollection matCostInfo, DynamicObjectCollection entryentity, DynamicObject entity) {
        DynamicObject entry;
        DynamicObject addNew;
        BigDecimal totalDiffAmt = entity.getBigDecimal("totaldiffamt");
        BigDecimal initQty = entity.getBigDecimal("initqty");
        BigDecimal initAmt = entity.getBigDecimal("initamt");
        HashMap<String, DynamicObject> subelementMapItem = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> subelementMapMulti = new HashMap<String, DynamicObject>();
        for (DynamicObject info : matCostInfo) {
            DynamicObject entry2;
            String subelement = info.getString("subelement") + "@" + info.getString("resource") + "@" + info.getString("calcbasis");
            String datatype = info.getString("datatype");
            if ("2".equals(datatype) || "3".equals(datatype)) {
                if (subelementMapItem.get(subelement) != null) {
                    entry2 = (DynamicObject)subelementMapItem.get(subelement);
                    entry2.set("stdcost", (Object)entry2.getBigDecimal("stdcost").add(info.getBigDecimal("stdcost")));
                } else {
                    subelementMapItem.put(subelement, info);
                }
            }
            if (!"2".equals(datatype) && !"4".equals(datatype)) continue;
            if (subelementMapMulti.get(subelement) != null) {
                entry2 = (DynamicObject)subelementMapMulti.get(subelement);
                entry2.set("stdcost", (Object)entry2.getBigDecimal("stdcost").add(info.getBigDecimal("stdcost")));
                continue;
            }
            subelementMapMulti.put(subelement, info);
        }
        BigDecimal toTalMulti = this.getToTalValue(subelementMapMulti);
        BigDecimal toTalItem = this.getToTalValue(subelementMapItem);
        BigDecimal factInitAmt = BigDecimal.ZERO;
        BigDecimal factTotalDiffAmt = BigDecimal.ZERO;
        for (Map.Entry entrySet : subelementMapMulti.entrySet()) {
            addNew = entryentity.addNew();
            entry = (DynamicObject)entrySet.getValue();
            this.setEntryEntityRowReal(entry, addNew, initQty, initAmt, totalDiffAmt, toTalMulti);
            addNew.set("datatype", (Object)"1");
            BigDecimal realAmt = addNew.getBigDecimal("realamt");
            BigDecimal diffAmt = addNew.getBigDecimal("diffamt");
            if (!CadEmptyUtils.isEmpty((BigDecimal)realAmt)) {
                factInitAmt = factInitAmt.add(realAmt);
            }
            if (CadEmptyUtils.isEmpty((BigDecimal)diffAmt)) continue;
            factTotalDiffAmt = factTotalDiffAmt.add(diffAmt);
        }
        if (CadEmptyUtils.isEmpty((BigDecimal)initAmt)) {
            entity.set("initamt", (Object)factInitAmt);
        }
        if (CadEmptyUtils.isEmpty((BigDecimal)totalDiffAmt)) {
            entity.set("totaldiffamt", (Object)factTotalDiffAmt);
        }
        for (Map.Entry entrySet : subelementMapItem.entrySet()) {
            addNew = entryentity.addNew();
            entry = (DynamicObject)entrySet.getValue();
            this.setEntryEntityRowReal(entry, addNew, initQty, initAmt, totalDiffAmt, toTalItem);
            addNew.set("datatype", (Object)"2");
        }
    }

    private DynamicObjectCollection getMatCostInfo(String costtypeid, String materialid, String matverid, String auxptyid) {
        if (CadEmptyUtils.isEmpty((String)materialid) || CadEmptyUtils.isEmpty((String)costtypeid)) {
            return null;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)Long.valueOf(costtypeid));
        filter.and(new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3", "4")));
        filter.and(new QFilter("material", "=", (Object)Long.valueOf(materialid)));
        String fields = "id,effectdate,expdate,entryentity.resource resource,entryentity.calcbasis calcbasis,entryentity.element element,entryentity.subelement subelement,entryentity.submaterial submaterial,entryentity.submatvers submatvers,entryentity.subauxproperty subauxproperty,entryentity.datatype datatype,entryentity.qty qty,entryentity.stdprice stdcost,entryentity.price stdprice";
        DynamicObjectCollection matCostInfoIds = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"effectdate ASC");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)matCostInfoIds)) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)((DynamicObject)matCostInfoIds.get(0)).getLong("id"));
        QFilter dataTypeFilter = new QFilter("entryentity.datatype", "in", Arrays.asList("2", "3", "4"));
        DynamicObjectCollection matCostInfos = QueryServiceHelper.query((String)"cad_calceffectiveresult", (String)fields, (QFilter[])new QFilter[]{idFilter, dataTypeFilter});
        return matCostInfos;
    }

    private Map<Long, Boolean> getStartstdCostMap(List<Long> orgIds) {
        String fields = "entryentity.costaccount AS costaccount,entryentity.isinit AS isinit";
        QFilter orgQF = new QFilter("org", "in", orgIds);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)"sca");
        DynamicObjectCollection res = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])new QFilter[]{orgQF, appNumQF});
        HashMap<Long, Boolean> startStdCostMap = new HashMap<Long, Boolean>();
        res.forEach(e -> startStdCostMap.put(e.getLong("costaccount"), e.getBoolean("isinit")));
        return startStdCostMap;
    }

    private void getBatchData(ExtendedDataEntity[] dataEntities, List<Long> orgIds) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject wipCostInit = dataEntity.getDataEntity();
            orgIds.add(wipCostInit.getLong("org.id"));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                this.checkInit();
                this.checkCostObject();
                this.checkAmt();
            }

            private void checkInit() {
                ArrayList orgIds = new ArrayList(10);
                WipCostInitSaveOpPlugin.this.getBatchData(this.dataEntities, orgIds);
                Map startStdCostMap = WipCostInitSaveOpPlugin.this.getStartstdCostMap(orgIds);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObject costAccount = entity.getDynamicObject("costaccount");
                    Long costAccountId = costAccount.getLong("id");
                    if (!((Boolean)startStdCostMap.get(costAccountId)).booleanValue()) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u2018%s\u2019\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"WipCostInitSaveOpPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]), costAccount.getString("name")));
                }
            }

            private void checkCostObject() {
                Map<String, Long> costAccountAndCostObject = this.getCostObjectKey();
                HashSet<String> costObjectSet = new HashSet<String>(16);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObject costAccount = entity.getDynamicObject("costaccount");
                    DynamicObject costObject = entity.getDynamicObject("costobject");
                    String key = costAccount.getString("id") + "@" + costObject.getString("id");
                    Long costInitId = costAccountAndCostObject.get(key);
                    if (costInitId != null && costInitId.longValue() != entity.getLong("id")) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u2018%s\u2019\u4e0b\uff0c\u8be5\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ecf\u7ef4\u62a4\u4e86\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316\u6570\u636e\u3002", (String)"WipCostInitSaveOpPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]), costAccount.getString("name")));
                    }
                    if (costObjectSet.contains(key)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u4e0b\uff0c\u8be5\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5df2\u5b58\u5728\u3002", (String)"WipCostInitSaveOpPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]), costAccount.getString("name")));
                        continue;
                    }
                    costObjectSet.add(key);
                }
            }

            private Map<String, Long> getCostObjectKey() {
                HashMap<String, Long> costAccountAndCostObject = new HashMap<String, Long>(16);
                HashSet<Long> orgIdSet = new HashSet<Long>(16);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    DynamicObject org = entity.getDynamicObject("org");
                    if (org == null) continue;
                    orgIdSet.add(org.getLong("id"));
                }
                if (CadEmptyUtils.isEmpty(orgIdSet)) {
                    return costAccountAndCostObject;
                }
                QFilter costAccountQF = new QFilter("org", "in", orgIdSet);
                QFilter[] qf = new QFilter[]{costAccountQF};
                DynamicObjectCollection res = QueryServiceHelper.query((String)"sca_wipcostinit", (String)"id,costobject,costaccount", (QFilter[])qf);
                for (DynamicObject wipcost : res) {
                    String key = wipcost.getString("costaccount") + '@' + wipcost.getString("costobject");
                    costAccountAndCostObject.put(key, wipcost.getLong("id"));
                }
                return costAccountAndCostObject;
            }

            private void checkAmt() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject entity = dataEntity.getDataEntity();
                    BigDecimal totalDiffAmt = entity.getBigDecimal("totaldiffamt");
                    BigDecimal initAmt = entity.getBigDecimal("initamt");
                    if (CadEmptyUtils.isEmpty((BigDecimal)totalDiffAmt) && CadEmptyUtils.isEmpty((BigDecimal)initAmt)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1\u91d1\u989d\u3001\u603b\u5dee\u5f02\uff0c\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"WipCostInitSaveOpPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                    }
                    DynamicObject costObject = entity.getDynamicObject("costobject");
                    DynamicObject costaccount = entity.getDynamicObject("costaccount");
                    if (costObject == null || costaccount == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WipCostInitSaveOpPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject costtype = entity.getDynamicObject("costtype");
                    if (costtype == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WipCostInitSaveOpPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject material = costObject.getDynamicObject("material");
                    if (material == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e2d\u7684\u7269\u6599\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WipCostInitSaveOpPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
                    if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity)) {
                        DynamicObjectCollection matCostInfo = WipCostInitSaveOpPlugin.this.getMatCostInfo(costtype.getPkValue().toString(), material.getPkValue().toString(), costObject.getString("bomversion.id"), costObject.getString("auxpty.id"));
                        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)matCostInfo)) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4ea7\u54c1\u201c%s\u201d\u5377\u7b97\u4fe1\u606f\uff0c\u8bf7\u5148\u8fdb\u884c\u6807\u51c6\u6210\u672c\u5377\u7b97\u3002", (String)"WipCostInitSaveOpPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), material.getString("name")));
                            continue;
                        }
                        WipCostInitSaveOpPlugin.this.setEntryEntityValue(matCostInfo, entryentity, entity);
                        totalDiffAmt = entity.getBigDecimal("totaldiffamt");
                        initAmt = entity.getBigDecimal("initamt");
                    }
                    BigDecimal countDiffAmt = BigDecimal.ZERO;
                    BigDecimal countRealAmt = BigDecimal.ZERO;
                    for (DynamicObject entry : entryentity) {
                        if (!"2".equals(entry.getString("datatype"))) continue;
                        BigDecimal diffAmt = entry.getBigDecimal("diffamt");
                        BigDecimal realAmt = entry.getBigDecimal("realamt");
                        countDiffAmt = countDiffAmt.add(diffAmt);
                        countRealAmt = countRealAmt.add(realAmt);
                    }
                    if (initAmt.compareTo(countRealAmt) != 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1\u91d1\u989d\u2260\u5b9e\u9645\u91d1\u989d\u5408\u8ba1\u3002", (String)"WipCostInitSaveOpPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
                    }
                    if (totalDiffAmt.compareTo(countDiffAmt) == 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u603b\u5dee\u5f02\u2260\u5dee\u5f02\u5408\u8ba1\u3002", (String)"WipCostInitSaveOpPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]));
                }
            }
        });
        super.onAddValidators(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        ArrayList<Object> importWips = new ArrayList<Object>();
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : datas) {
            ids.add(dynamicObject.getLong("id"));
        }
        Object[] wips = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sca_wipcostinit"));
        if (CadEmptyUtils.isEmpty((Object[])wips)) {
            return;
        }
        HashSet<Long> matSet = new HashSet<Long>(16);
        HashSet<Long> currencySet = new HashSet<Long>(16);
        for (Object entity : wips) {
            DynamicObject material;
            DynamicObject costObject;
            DynamicObject costaccount;
            DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryentity) || (costaccount = entity.getDynamicObject("costaccount")) == null || (costObject = entity.getDynamicObject("costobject")) == null || (material = costObject.getDynamicObject("material")) == null) continue;
            matSet.add(material.getLong("id"));
            currencySet.add(costaccount.getLong("calpolicy.id"));
        }
        Map map = MatHelper.getMatBaseUnit(matSet);
        Map<Long, Long> currencyMap = this.getCurrencyMap(currencySet);
        for (Object wip : wips) {
            DynamicObject costaccount = wip.getDynamicObject("costaccount");
            DynamicObject costObject = wip.getDynamicObject("costobject");
            DynamicObject currency = wip.getDynamicObject("currency");
            if (!CadEmptyUtils.isEmpty((DynamicObject)currency) || CadEmptyUtils.isEmpty((DynamicObject)costaccount) || CadEmptyUtils.isEmpty((DynamicObject)costObject)) continue;
            wip.set("currency", (Object)currencyMap.get(costaccount.getLong("calpolicy.id")));
            wip.set("material", (Object)costObject.getDynamicObject("material"));
            DynamicObject material = costObject.getDynamicObject("material");
            wip.set("material", (Object)material);
            wip.set("auxpty", (Object)costObject.getDynamicObject("auxpty"));
            if (CadEmptyUtils.isEmpty((DynamicObject)material)) continue;
            wip.set("baseunit", map.get(material.getLong("id")));
            importWips.add(wip);
        }
        if (!CadEmptyUtils.isEmpty(importWips)) {
            SaveServiceHelper.update((DynamicObject[])importWips.toArray(new DynamicObject[0]));
        }
    }

    private Map<Long, Long> getCurrencyMap(Set<Long> currencySet) {
        HashMap<Long, Long> currencyBaseUnit = new HashMap<Long, Long>(16);
        String fields = "id,currency";
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", currencySet)});
        if (res == null) {
            return currencyBaseUnit;
        }
        for (DynamicObject currency : res) {
            long id = currency.getLong("id");
            long currencyId = currency.getLong("currency");
            currencyBaseUnit.put(id, currencyId);
        }
        return currencyBaseUnit;
    }
}

