/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.opplugin.matalloc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.alloc.MatAllocHelper;
import kd.macc.sca.algox.alloc.output.AllocResult;
import kd.macc.sca.common.enums.ScaAllocEnum;

public class MatAllocateOpValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (int i = 0; i < datas.length; ++i) {
            ExtendedDataEntity dataEntity = datas[i];
            DynamicObject saveItem = null;
            switch (this.getOperateKey()) {
                case "op_confirm": {
                    if (!this.validateAll(dataEntity)) break;
                    saveItem = this.confirm(dataEntity);
                    break;
                }
                case "op_unconfirm": {
                    saveItem = this.unconfirm(dataEntity);
                }
            }
            if (saveItem == null) continue;
            list.add(saveItem);
        }
        switch (this.getOperateKey()) {
            case "op_allocate": {
                this.allocate(datas);
                break;
            }
            case "op_confirm": 
            case "op_unconfirm": {
                this.save(list);
            }
        }
    }

    private boolean validateAll(ExtendedDataEntity dataEntity) {
        DynamicObject mainData = dataEntity.getDataEntity();
        String tips = null;
        if (!this.validateQty(mainData)) {
            tips = ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u3002\u6570\u91cf\u5408\u8ba1\u2260\u9886\u7528\u6570\u91cf\u3002", (String)"MatAllocateOpValidator_0", (String)"macc-sca-form", (Object[])new Object[0]);
        }
        if (!this.validateAmount(mainData)) {
            tips = ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u3002\u6210\u672c\u91d1\u989d\u5408\u8ba1\u2260\u9886\u6599\u6210\u672c\u3002", (String)"MatAllocateOpValidator_1", (String)"macc-sca-form", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty(tips)) {
            this.addErrorMessage(dataEntity, String.format(tips, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateQty(DynamicObject mainData) {
        DynamicObjectCollection rows = mainData.getDynamicObjectCollection("entryentity");
        BigDecimal useQty = mainData.getBigDecimal("useqty");
        BigDecimal entryQty = BigDecimal.ZERO;
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return useQty.compareTo(entryQty) == 0;
        }
        for (DynamicObject row : rows) {
            entryQty = entryQty.add(row.getBigDecimal("qty"));
        }
        return useQty.compareTo(entryQty) == 0;
    }

    private boolean validateAmount(DynamicObject mainData) {
        DynamicObjectCollection rows = mainData.getDynamicObjectCollection("entryentity");
        BigDecimal useAmount = mainData.getBigDecimal("useamount");
        BigDecimal entryAmount = BigDecimal.ZERO;
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return useAmount.compareTo(entryAmount) == 0;
        }
        for (DynamicObject row : rows) {
            entryAmount = entryAmount.add(row.getBigDecimal("amount"));
        }
        return useAmount.compareTo(entryAmount) == 0;
    }

    private void save(List<DynamicObject> list) {
        if (CadEmptyUtils.isEmpty(list)) {
            return;
        }
        DynamicObject item = list.get(0);
        Long id = item.getLong("id");
        if (CadEmptyUtils.isEmpty((Long)id)) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"sca_matalloc");
            SaveServiceHelper.save((IDataEntityType)type, (Object[])list.toArray(new DynamicObject[0]));
        } else {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
    }

    protected void allocate(ExtendedDataEntity[] datas) {
        HashMap<Long, String> commonMap = new HashMap<Long, String>();
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject item = dataEntity.getDataEntity();
            if (!this.checkAlloc(dataEntity) || item.get("costobject") != null || ScaAllocEnum.USETYPE_DRIECT.getValue().equals(item.getString("usetype"))) continue;
            commonMap.put(item.getLong("id"), item.getString("billno"));
        }
        AllocResult result = MatAllocHelper.doAlloc(commonMap.keySet());
        this.showAfterAlgoxTips4Alloc(datas, result);
    }

    private DynamicObject confirm(ExtendedDataEntity dataEntity) {
        DynamicObject item = dataEntity.getDataEntity();
        if (!ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue().equalsIgnoreCase(item.getString("allocstatus"))) {
            String aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u3002\u975e\u5206\u914d\u72b6\u6001\u3002", (String)"MatAllocateOpValidator_4", (String)"macc-sca-form", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            return null;
        }
        item.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        return item;
    }

    private DynamicObject unconfirm(ExtendedDataEntity dataEntity) {
        DynamicObject item = dataEntity.getDataEntity();
        if (!ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equalsIgnoreCase(item.getString("allocstatus"))) {
            String aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u53cd\u786e\u8ba4\u3002\u975e\u5df2\u786e\u8ba4\u72b6\u6001\u3002", (String)"MatAllocateOpValidator_5", (String)"macc-sca-form", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            return null;
        }
        item.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
        return item;
    }

    private boolean checkAlloc(ExtendedDataEntity dataEntity) {
        String aTips;
        boolean isOK = true;
        DynamicObject item = dataEntity.getDataEntity();
        if (item.getDynamicObject("costobject") != null || ScaAllocEnum.USETYPE_DRIECT.getValue().equals(item.getString("usetype"))) {
            aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002\u201c\u7269\u6599\u4fe1\u606f.\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201d\u5df2\u7ecf\u786e\u8ba4\u3002", (String)"MatAllocateOpValidator_19", (String)"macc-sca-form", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            isOK = false;
        }
        if (ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equalsIgnoreCase(item.getString("allocstatus"))) {
            aTips = ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002\u5f53\u524d\u8bb0\u5f55\u5df2\u7ecf\u786e\u8ba4\u5206\u914d\u7ed3\u679c\u3002", (String)"MatAllocateOpValidator_15", (String)"macc-sca-form", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            isOK = false;
        }
        return isOK;
    }

    private void showAfterAlgoxTips4Alloc(ExtendedDataEntity[] datas, AllocResult result) {
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject item = dataEntity.getDataEntity();
            for (String number : result.getReasonMap().keySet()) {
                if (!StringUtils.equals((CharSequence)number, (CharSequence)item.getString("number")) || !StringUtils.isNotEmpty((CharSequence)((CharSequence)result.getReasonMap().get(number)))) continue;
                String aTips = ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\u3002", (String)"MatAllocateOpValidator_18", (String)"macc-sca-form", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(aTips, new Object[0]));
            }
        }
    }
}

