/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.calc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.sca.common.helper.MatBaseDataFilterHelper;
import org.apache.commons.lang.StringUtils;

public class CalcAllItemQueryPlugin
extends AbstractReportListDataPlugin {
    private Long currencyId;
    private final String total = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"CalcAllItemQueryPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
    private final String sum = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CalcAllItemQueryPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]);
    private static final String[] SELECTED_FIELDS = new String[]{"costobject", "entrymanuorg", "costaccount", "period", "entrybizstatus", "entryperiod", "entrycostcenter", "entrycostcentername", "entrycostobject", "entrycostobjectname", "unit", "elementid", "element", "subelement", "materialgroup", "material", "matversion", "auxpty", "resource", "pdstartqty", "pdstartamount", "pdcurrqty", "pdcurramount", "pdcompqty", "pdcompanount", "pdendqty", "pdendamount", "totalqty", "totalamount", "stdqty", "stdamount", "diff", "diffqty", "diffamount", "totalupdatediff"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        QFilter baseFilter = this.getQFilter(reportQueryParam, params);
        QFilter manuFilter = new QFilter("1", "=", (Object)1);
        long orgId = this.getQueryParam().getFilter().getLong("org");
        if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
            List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)"sca_calcallitemrpt");
            manuFilter.and("costobject.manuorg", "in", (Object)manuOrg);
        }
        ORM orm = ORM.create();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
        DataSet dataSetBase = orm.queryDataSet(algoKey, "sca_calcresult", this.getQueryFields(), new QFilter[]{baseFilter, manuFilter});
        dataSetBase = this.updateSumAmount(dataSetBase);
        DataSet dataSet = this.getDataSetByClassified(dataSetBase, params);
        QFilter fxfilter = new QFilter("entryentity.difftype", "=", (Object)"3");
        DataSet updateData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_calcresult", (String)"period,entryentity.obj costobject,costobject.manuorg AS entrymanuorg,entryentity.element.id AS elementid,entryentity.element.number AS elementnumber,entryentity.subelement.number AS subelementnumber,entryentity.subelement.name AS subelement,entryentity.material AS material,entryentity.matversion AS matversion,entryentity.auxpty AS auxpty,entryentity.pdcurramount AS curupdatediff,entryentity.resource AS resource", (QFilter[])new QFilter[]{baseFilter, fxfilter}, null);
        updateData = this.isShowDetail() != false ? updateData.groupBy(new String[]{"period", "costobject", "entrymanuorg", "elementid", "elementnumber", "subelementnumber", "subelement", "material", "matversion", "auxpty", "resource"}).sum("curupdatediff").finish() : updateData.groupBy(new String[]{"period", "costobject", "entrymanuorg", "elementid", "elementnumber", "subelementnumber", "subelement"}).sum("curupdatediff").finish().select("period,costobject,entrymanuorg,elementid,elementnumber,subelementnumber,subelement,0L material,0L matversion,0L auxpty, 0L resource,curupdatediff");
        DataSet updateSumData = updateData.groupBy(new String[]{"period", "costobject", "entrymanuorg"}).sum("curupdatediff").finish().select("period,costobject,entrymanuorg,null as elementid,null as elementnumber,null as subelementnumber,null subelement,0L material,0L matversion,0L auxpty,0L resource,curupdatediff");
        updateData = updateData.union(updateSumData);
        dataSet = this.getGroupData(dataSet);
        Boolean showGroup = (Boolean)params.get("showGroup");
        dataSet = this.getSumDataSet(dataSet, showGroup);
        JoinDataSet join = dataSet.join(updateData, JoinType.LEFT);
        join.on("period", "period").on("costobject", "costobject").on("elementid", "elementid").on("subelement", "subelement");
        if (this.isShowDetail().booleanValue()) {
            join.on("material", "material").on("matversion", "matversion").on("auxpty", "auxpty").on("resource", "resource");
        }
        dataSet = join.select(dataSet.getRowMeta().getFieldNames(), new String[]{"curupdatediff"}).finish();
        dataSet = dataSet.executeSql(this.getSelectFeilds());
        return this.getAllDataSet(dataSet);
    }

    private DataSet updateSumAmount(DataSet dataSetBase) {
        DataSet sumDatabase = dataSetBase.copy().filter("subelement != null");
        sumDatabase = sumDatabase.groupBy(new String[]{"costobject", "costaccount", "period"}).sum("pdstartamount", "pdstartamount1").sum("pdcurramount", "pdcurramount1").sum("pdcompanount", "pdcompanount1").sum("pdendamount", "pdendamount1").sum("totalamount", "totalamount1").sum("stdamount", "stdamount1").sum("diffamount", "diffamount1").sum("totalupdatediff", "totalupdatediff1").finish();
        sumDatabase = dataSetBase.join(sumDatabase, JoinType.LEFT).on("costobject", "costobject").on("costaccount", "costaccount").on("period", "period").select(dataSetBase.getRowMeta().getFieldNames(), new String[]{"pdstartamount1", "pdcurramount1", "pdcompanount1", "pdendamount1", "totalamount1", "stdamount1", "diffamount1", "totalupdatediff1"}).finish();
        sumDatabase.updateField("pdstartamount", "case when subelement!=null then pdstartamount else pdstartamount1 end");
        sumDatabase.updateField("pdcurramount", "case when subelement!=null then pdcurramount else pdcurramount1 end");
        sumDatabase.updateField("pdcompanount", "case when subelement!=null then pdcompanount else pdcompanount1 end");
        sumDatabase.updateField("pdendamount", "case when subelement!=null then pdendamount else pdendamount1 end");
        sumDatabase.updateField("totalamount", "case when subelement!=null then totalamount else totalamount1 end");
        sumDatabase.updateField("stdamount", "case when subelement!=null then stdamount else stdamount1 end");
        sumDatabase.updateField("diffamount", "case when subelement!=null then diffamount else diffamount1 end");
        sumDatabase.updateField("totalupdatediff", "case when subelement!=null then totalupdatediff else totalupdatediff1 end");
        dataSetBase = sumDatabase.select(dataSetBase.getRowMeta().getFieldNames());
        return dataSetBase;
    }

    private DataSet getDataSetByClassified(DataSet dataSet, Map<String, Object> params) {
        DynamicObject materialGrpStdDyn = (DynamicObject)params.get("materialGrpStd");
        DataSet allDataSet = null;
        if (materialGrpStdDyn == null || materialGrpStdDyn.getLong("id") != 730148448254487552L) {
            DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet((DynamicObjectCollection)((DynamicObjectCollection)params.get("mulMaterialGroup")), (boolean)false, (DynamicObject)((DynamicObject)params.get("materialGrpStd")));
            DataSet matDataSet = dataSet.filter("material != 0");
            DataSet notMatDataSet = dataSet.filter("material = 0");
            matDataSet = matDataSet.leftJoin(materialDataSet).on("material", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialgroup"}).finish();
            notMatDataSet = notMatDataSet.leftJoin(materialDataSet).on("product", "material").select(dataSet.getRowMeta().getFieldNames(), new String[]{"materialgroup"}).finish();
            allDataSet = DataSetUtils.union((DataSet)matDataSet, (DataSet)notMatDataSet);
        } else {
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(dataSet.getRowMeta().getFieldNames()));
            fieldNames.remove("group");
            fieldNames.remove("matgroup");
            fieldNames.add("case when material>0 then matgroup else group end materialgroup");
            allDataSet = dataSet.select(fieldNames.toArray(new String[0]));
        }
        DynamicObjectCollection mulMaterialGroup = (DynamicObjectCollection)params.get("mulMaterialGroup");
        if (mulMaterialGroup != null && mulMaterialGroup.size() > 0) {
            Set materialGroupId = (Set)params.get("materialGroupId");
            if (materialGroupId != null && materialGroupId.size() > 0) {
                DataSet dataSetCostObject = allDataSet.copy().filter("materialgroup in (" + StringUtils.join((Collection)materialGroupId, (String)",") + ")");
                HashSet<Long> costObjectIds = new HashSet<Long>();
                for (Row row : dataSetCostObject) {
                    costObjectIds.add(row.getLong("costobject"));
                }
                if (costObjectIds.size() > 0) {
                    DataSet fenDataSet = allDataSet.copy().filter("subelement != null and materialgroup in (" + StringUtils.join((Collection)materialGroupId, (String)",") + ")");
                    DataSet proDataSet = allDataSet.copy().filter("subelement = null and costobject in (" + StringUtils.join(costObjectIds, (String)",") + ")");
                    allDataSet = DataSetUtils.union((DataSet)fenDataSet, (DataSet)proDataSet);
                } else {
                    allDataSet = allDataSet.filter("1 = 2");
                }
            } else {
                allDataSet = allDataSet.filter("1 = 2");
            }
        }
        return allDataSet;
    }

    private DataSet getAllDataSet(DataSet dataSet) {
        DataSet costCenterSumData = dataSet.filter("subelement='" + this.total + "'").groupBy(new String[]{"entrycurrency", "entryperiod", "entrycostcenter", "entrycostcentername"}).sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("totalamount").sum("stdamount").sum("diff").sum("diffamount").sum("totalupdatediff").sum("curupdatediff").finish().select("entrycurrency,entryperiod,entrycostcenter,concat(entrycostcentername,'" + this.total + "') AS entrycostcentername,0 AS entrycostobject,0 AS entrymanuorg,'' as entrybizstatus,'' as entrycostobjectname,0 AS unit,0 AS elementid,'' as elementnumber,'' as subelementnumber,'' as element,'' as subelement,0 as materialgroup,0 AS material,0 as matversion,0 AS auxpty,0 as resource,0 AS pdstartqty,pdstartamount,0 AS pdcurrqty,pdcurramount,0 AS pdcompqty,pdcompanount,0 AS pdendqty,pdendamount,0 AS totalqty,totalamount,0 as stdqty,stdamount,diff,0 as diffqty,diffamount,totalupdatediff,curupdatediff,'1' as colour,0L as periodord,1L as costcenterord");
        DataSet periodSumData = dataSet.filter("subelement='" + this.total + "'").groupBy(new String[]{"entrycurrency", "entryperiod"}).sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("totalamount").sum("stdamount").sum("diff").sum("diffamount").sum("totalupdatediff").sum("curupdatediff").finish().select("entrycurrency,concat(entryperiod,'" + this.total + "') AS entryperiod,0 AS entrycostcenter,'' AS entrycostcentername,0 AS entrycostobject,0 AS entrymanuorg,'' as entrybizstatus,'' as entrycostobjectname,0 AS unit,0 AS elementid,'' as elementnumber,'' as subelementnumber,'' as element,'' as subelement,0 as materialgroup,0 AS material,0 as matversion,0 AS auxpty,0 as resource,0 AS pdstartqty,pdstartamount,0 AS pdcurrqty,pdcurramount,0 AS pdcompqty,pdcompanount,0 AS pdendqty,pdendamount,0 AS totalqty,totalamount,0 as stdqty,stdamount,diff,0 as diffqty,diffamount,totalupdatediff,curupdatediff,'1' as colour,1L as periodord,1L as costcenterord");
        DataSet allSumData = dataSet.filter("subelement='" + this.total + "'").groupBy(new String[]{"entrycurrency"}).sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("totalamount").sum("stdamount").sum("diff").sum("diffamount").sum("totalupdatediff").sum("curupdatediff").finish().select("entrycurrency,'" + this.sum + "' AS entryperiod,0 AS entrycostcenter,'' AS entrycostcentername,0 AS entrycostobject,0 AS entrymanuorg,'' as entrybizstatus,'' as entrycostobjectname,0 AS unit,0 AS elementid,'' as elementnumber,'' as subelementnumber,'' as element,'' as subelement,0 as materialgroup,0 AS material,0 as matversion,0 AS auxpty,0 as resource,0 AS pdstartqty,pdstartamount,0 AS pdcurrqty,pdcurramount,0 AS pdcompqty,pdcompanount,0 AS pdendqty,pdendamount,0 AS totalqty,totalamount,0 as stdqty,stdamount,diff,0 as diffqty,diffamount,totalupdatediff,curupdatediff,'1' as colour,1L as periodord,1L as costcenterord");
        DataSet unionData = dataSet.select(costCenterSumData.getRowMeta().getFieldNames()).union(costCenterSumData).union(periodSumData).orderBy(new String[]{"entryperiod", "periodord", "entrycostcentername", "costcenterord", "entrycostobjectname", "elementnumber", "subelementnumber"});
        return unionData.union(allSumData);
    }

    protected List<Object[]> count(DataSet dataSet, Boolean isShowDetail) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        HashSet<Long> costObjectIds = new HashSet<Long>();
        HashSet<Long> elementIds = new HashSet<Long>();
        for (Row row : dataSet.copy()) {
            elementIds.add(row.getLong("elementid"));
            if (!this.total.equals(row.getString("subelement"))) continue;
            costObjectIds.add(row.getLong("entrycostobject"));
        }
        DynamicObjectCollection costObjet = QueryServiceHelper.query((String)"cad_costobject", (String)"id,material,bomversion matversion,auxpty", (QFilter[])new QFilter[]{new QFilter("id", "in", costObjectIds)});
        QFilter elementNameFilter = new QFilter("id", "in", elementIds);
        QFilter elementTypeFilter = new QFilter("type", "in", Arrays.asList("003", "004"));
        DynamicObjectCollection element = QueryServiceHelper.query((String)"cad_element", (String)"id", (QFilter[])new QFilter[]{elementNameFilter, elementTypeFilter});
        HashSet existsElementIds = new HashSet();
        element.forEach(p -> existsElementIds.add(p.getLong("id")));
        DynamicObjectCollection resource = QueryServiceHelper.query((String)"cad_resourcerate", (String)"element", (QFilter[])new QFilter[]{new QFilter("element", "in", existsElementIds), new QFilter("calcbasis", "=", (Object)"001")});
        HashSet existsEleIds = new HashSet();
        resource.forEach(p -> existsEleIds.add(p.getLong("element")));
        Field[] fields = this.getRowMeta(isShowDetail).getFields();
        DynamicObject curCostObject = null;
        for (Row row : dataSet) {
            curCostObject = this.total.equals(row.getString("subelement")) ? this.getCurCostObject(row.getLong("entrycostobject"), costObjet) : null;
            Object[] rowData = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                Object val = row.get(name);
                switch (name) {
                    case "entryperiod": 
                    case "entrycostcentername": 
                    case "entrycostobjectname": {
                        if (curCostObject != null) break;
                        val = null;
                        break;
                    }
                    case "entrycostcenter": 
                    case "entrycostobject": 
                    case "entrymanuorg": {
                        if (curCostObject != null) break;
                        val = 0L;
                        break;
                    }
                    case "material": 
                    case "matversion": 
                    case "auxpty": {
                        if (curCostObject == null) break;
                        val = curCostObject.getLong(name);
                        break;
                    }
                    case "unit": {
                        Long elementId = row.getLong("elementid");
                        if (val == null && existsElementIds.contains(elementId) && existsEleIds.contains(elementId)) {
                            val = 9L;
                            break;
                        }
                        if (val != null || !existsElementIds.contains(elementId) || existsEleIds.contains(elementId)) break;
                        if (isShowDetail.booleanValue() && (row.get("pdcurrqty") == null || BigDecimal.ZERO.compareTo(row.getBigDecimal("pdcurrqty")) == 0) && row.get("pdcurramount") != null && BigDecimal.ZERO.compareTo(row.getBigDecimal("pdcurramount")) != 0 && row.getLong("resource") > 0L) {
                            val = 9L;
                            break;
                        }
                        val = 11L;
                        break;
                    }
                    case "entrybizstatus": {
                        if (curCostObject != null) break;
                        val = "";
                    }
                }
                rowData[i] = val;
            }
            dataList.add(rowData);
        }
        return dataList;
    }

    private DynamicObject getCurCostObject(Long costObjectId, DynamicObjectCollection costObject) {
        for (DynamicObject cost : costObject) {
            if (!costObjectId.equals(cost.getLong("id"))) continue;
            return cost;
        }
        return null;
    }

    protected RowMeta getRowMeta(Boolean isShowDetail) {
        List<Field> field = this.getRowMetaField(isShowDetail);
        return new RowMeta(field.toArray(new Field[0]));
    }

    protected List<Field> getRowMetaField(Boolean isShowDetail) {
        ArrayList<Field> field = new ArrayList<Field>(34);
        field.add(new Field("entrycurrency", (DataType)DataType.LongType));
        field.add(new Field("entryperiod", (DataType)DataType.StringType));
        field.add(new Field("entrycostcenter", (DataType)DataType.LongType));
        field.add(new Field("entrycostcentername", (DataType)DataType.StringType));
        field.add(new Field("entrycostobject", (DataType)DataType.LongType));
        field.add(new Field("entrymanuorg", (DataType)DataType.LongType));
        field.add(new Field("entrybizstatus", (DataType)DataType.StringType));
        field.add(new Field("entrycostobjectname", (DataType)DataType.StringType));
        field.add(new Field("unit", (DataType)DataType.LongType));
        field.add(new Field("elementid", (DataType)DataType.LongType));
        field.add(new Field("element", (DataType)DataType.StringType));
        field.add(new Field("subelement", (DataType)DataType.StringType));
        if (isShowDetail.booleanValue()) {
            field.add(new Field("material", (DataType)DataType.LongType));
            field.add(new Field("matversion", (DataType)DataType.LongType));
            field.add(new Field("auxpty", (DataType)DataType.LongType));
            field.add(new Field("resource", (DataType)DataType.LongType));
        }
        field.add(new Field("pdstartqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdstartamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdcurrqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdcurramount", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdcompqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdcompanount", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdendqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("pdendamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("stdqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("stdamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("diff", (DataType)DataType.BigDecimalType));
        field.add(new Field("diffqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("diffamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalupdatediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("curupdatediff", (DataType)DataType.BigDecimalType));
        return field;
    }

    private String getQueryFields() {
        String fields = "costobject,costobject.manuorg AS entrymanuorg,costaccount,period,period.name AS entryperiod,costcenter.id AS entrycostcenter,costcenter.name AS entrycostcentername,entryentity.obj AS entrycostobject,bizstatus AS entrybizstatus,entryentity.obj.name AS entrycostobjectname,entryentity.obj.material as product,entryentity.obj.material.baseunit unit,entryentity.obj.material.group group,entryentity.element.id AS elementid,entryentity.element.number AS elementnumber,entryentity.element.name AS element,entryentity.subelement.name AS subelement,entryentity.subelement.number AS subelementnumber,entryentity.material AS material,entryentity.material.baseunit matunit,entryentity.material.group matgroup,entryentity.matversion AS matversion,entryentity.auxpty AS auxpty,entryentity.pdstartqty AS pdstartqty,entryentity.pdstartamount AS pdstartamount,entryentity.pdcurrqty AS pdcurrqty,entryentity.pdcurramount AS pdcurramount,entryentity.pdcompqty AS pdcompqty,entryentity.pdcompanount AS pdcompanount,entryentity.pdendqty AS pdendqty,entryentity.pdendamount AS pdendamount,entryentity.totalqty AS totalqty,entryentity.totalamount AS totalamount,entryentity.stdqty AS stdqty,entryentity.stdamount AS stdamount,entryentity.diff AS diff,entryentity.diffqty AS diffqty,entryentity.diff AS diffamount,entryentity.costupdatediffamt AS totalupdatediff,entryentity.resource AS resource";
        return fields;
    }

    private DataSet getCostObjectUnit(DataSet data) {
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".getCostObjectUnit";
        HashSet<Long> costObjectIds = new HashSet<Long>();
        for (Row row : data) {
            costObjectIds.add(row.getLong("entrycostobject"));
        }
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_costobject", (String)"id costobject,material.baseunit.id unit", (QFilter[])new QFilter[]{new QFilter("id", "in", costObjectIds)}, null);
    }

    private DataSet getGroupData(DataSet data) {
        if (this.isShowDetail().booleanValue()) {
            return data;
        }
        String strSql = "select costobject,unit,entrymanuorg,costaccount,period,entryperiod,entrycostcenter,entrycostcentername,entrycostobject, entrybizstatus,entrycostobjectname,elementid,elementnumber,subelementnumber,element,subelement,materialgroup,0 AS material,0L matunit,0 AS matversion,0 AS auxpty, 0 AS resource,sum(pdstartqty) AS pdstartqty,sum(pdstartamount) AS pdstartamount,sum(pdcurrqty) AS pdcurrqty,sum(pdcurramount) AS pdcurramount,sum(pdcompqty) AS pdcompqty,sum(pdcompanount) AS pdcompanount,sum(pdendqty) AS pdendqty,sum(pdendamount) AS pdendamount,sum(totalqty) AS totalqty,sum(totalamount) AS totalamount,sum(stdqty) AS stdqty,sum(stdamount) AS stdamount,sum(diff) AS diff,sum(diffqty) AS diffqty,sum(diffamount) AS diffamount,sum(totalupdatediff) AS totalupdatediff group by costobject,unit,entrymanuorg,costaccount,period,entryperiod,entrycostcenter,entrycostcentername,entrycostobject,entrybizstatus,entrycostobjectname,elementid,elementnumber,subelementnumber,element,subelement,materialgroup,material,matunit,matversion,auxpty,resource";
        return data.executeSql(strSql);
    }

    private DataSet unionDataSet(DataSet data) {
        DataSet costObject = data.copy();
        costObject = this.getCostObjectUnit(costObject);
        DataSet newData = data.leftJoin(costObject).on("entrycostobject", "costobject").select(SELECTED_FIELDS).finish();
        return newData;
    }

    private String getSelectFeilds() {
        if (this.isShowDetail().booleanValue()) {
            return "select costobject,entrymanuorg,costaccount,period," + this.currencyId + " AS entrycurrency,entryperiod,entrycostcenter,entrybizstatus,entrycostcentername,entrycostobject,entrycostobjectname,case when subelement is null then unit when material > 0 then matunit else 9L end unit,elementid,elementnumber,subelementnumber,element,case when subelement is null then '" + this.total + "' else subelement end subelement,case when subelement is null then 0L else materialgroup end materialgroup,material,matversion,auxpty,resource,pdstartqty,pdstartamount,pdcurrqty,pdcurramount,pdcompqty,pdcompanount,pdendqty,pdendamount,totalqty,totalamount,stdqty,stdamount,diff,diffqty,diffamount,totalupdatediff,curupdatediff,case when element is null then '1' else '0' end as colour,0L as periodord,0L as costcenterord";
        }
        return "select costobject,entrymanuorg,costaccount,period," + this.currencyId + " AS entrycurrency,entryperiod,entrycostcenter,entrybizstatus,entrycostcentername,entrycostobject,entrycostobjectname,case when subelement is null then unit else 9L end unit,elementid,elementnumber,subelementnumber,element,case when subelement is null then '" + this.total + "' else subelement end subelement,case when subelement is null then 0L else materialgroup end materialgroup,0L material,0L matversion,0L auxpty, 0L resource,pdstartqty,pdstartamount,pdcurrqty,pdcurramount,pdcompqty,pdcompanount,pdendqty,pdendamount,totalqty,totalamount,stdqty,stdamount,diff,diffqty,diffamount,totalupdatediff,curupdatediff,case when element is null then '1' else '0' end as colour,0L as periodord,0L as costcenterord";
    }

    private DataSet getSumDataSet(DataSet dataSet, Boolean showGroup) {
        String strSql = "select costobject,entrymanuorg,costaccount,period,entryperiod,entrycostcenter,entrycostcentername,entrycostobject, entrybizstatus,entrycostobjectname,unit,elementid,elementnumber,subelementnumber,element,subelement,materialgroup,sum(pdstartqty) AS pdstartqty,sum(pdstartamount) AS pdstartamount,sum(pdcurrqty) AS pdcurrqty,sum(pdcurramount) AS pdcurramount,sum(pdcompqty) AS pdcompqty,sum(pdcompanount) AS pdcompanount,sum(pdendqty) AS pdendqty,sum(pdendamount) AS pdendamount,sum(totalqty) AS totalqty,sum(totalamount) AS totalamount,sum(stdqty) AS stdqty,sum(stdamount) AS stdamount,sum(diff) AS diff,sum(diffqty) AS diffqty,sum(diffamount) AS diffamount,sum(totalupdatediff) AS totalupdatediff ";
        strSql = showGroup != false ? strSql + "group by costobject,entrymanuorg,costaccount,period,entrybizstatus,entryperiod,entrycostcenter,entrycostcentername,entrycostobject,entrycostobjectname,unit,elementid,elementnumber,subelementnumber,element,subelement,materialgroup" : strSql + ",material,matunit,matversion,auxpty,resource group by costobject,entrymanuorg,costaccount,period,entrybizstatus,entryperiod,entrycostcenter,entrycostcentername,entrycostobject,entrycostobjectname,unit,elementid,elementnumber,subelementnumber,element,subelement,materialgroup,material,matunit,matversion,auxpty,resource";
        return dataSet.executeSql(strSql);
    }

    private Boolean isShowDetail() {
        return this.getQueryParam().getFilter().getBoolean("isshowdetail");
    }

    private QFilter getQFilter(ReportQueryParam reportQueryParam, Map<String, Object> params) {
        String bizstatus;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object value = this.getFilterItemValue(filterInfo, "org");
        Long orgId = (Long)value;
        QFilter filter = new QFilter("org", "=", value);
        value = this.getFilterItemValue(filterInfo, "manuorg");
        if (value != null) {
            filter.and(new QFilter("costobject.manuorg", "in", value));
        }
        value = this.getFilterItemValue(filterInfo, "costaccount");
        filter.and(new QFilter("costaccount", "=", value));
        this.currencyId = (Long)this.getFilterItemValue(filterInfo, "currency");
        value = this.getFilterItemValue(filterInfo, "period");
        filter.and(new QFilter("period", "in", value));
        value = this.getFilterItemValue(filterInfo, "costcenter");
        if (value != null) {
            filter.and(new QFilter("costcenter", "in", value));
        }
        List<Long> costObjectIds = new ArrayList<Long>(10);
        DynamicObjectCollection costobjcts = filterInfo.getDynamicObjectCollection("costobject");
        if (costobjcts != null) {
            costObjectIds = costobjcts.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        }
        if (!CadEmptyUtils.isEmpty(costObjectIds)) {
            Set<Long> mainCostObjectIds = CalcAllItemQueryPlugin.getMainCostobjectIds(filter, costObjectIds);
            filter.and(new QFilter("costobject", "in", mainCostObjectIds));
        }
        if ("A".equals(bizstatus = (String)this.getFilterItemValue(filterInfo, "bizstatus")) || "B".equals(bizstatus)) {
            filter.and(new QFilter("bizstatus", "=", (Object)bizstatus));
        }
        filter.and(new QFilter("entryentity.caltype", "in", (Object)new String[]{"1", "2", "3", "4", "5"}));
        filter.and(new QFilter("entryentity.datatype", "in", (Object)new String[]{"1", "98", "99"}));
        Set<Object> mulMaterialIdSet = new HashSet(16);
        Set<Object> costObjectIdSet = new HashSet(16);
        DynamicObjectCollection mulgroupmaterial = filterInfo.getDynamicObjectCollection("mulgroupmaterial");
        DynamicObject materialGrpStd = filterInfo.getDynamicObject("materialgrpstd");
        params.put("materialGrpStd", materialGrpStd);
        DynamicObjectCollection mulmaterialgroup = filterInfo.getDynamicObjectCollection("mulmaterialgroup");
        params.put("mulMaterialGroup", mulmaterialgroup);
        if (mulgroupmaterial != null) {
            mulMaterialIdSet = mulgroupmaterial.stream().map(object -> object.getLong("id")).collect(Collectors.toSet());
            if (mulMaterialIdSet != null && mulMaterialIdSet.size() > 0) {
                costObjectIdSet = this.getCostObjectIdSet(filter, mulMaterialIdSet);
                QFilter matfilter = new QFilter("entryentity.material", "in", mulMaterialIdSet).or(new QFilter("costobject", "in", costObjectIdSet).and(new QFilter("entryentity.caltype", "=", (Object)"5")));
                filter.and(matfilter);
            }
        } else if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterialgroup)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(Collections.singletonList(orgId)));
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulmaterialgroup) || materialGrpStd.getLong("id") != 730148448254487552L) {
                QFilter classifiedMaterialIdFilter = new QFilter("id", "in", (Object)MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)mulmaterialgroup, (boolean)false, (DynamicObject)materialGrpStd));
                qFilters.add(classifiedMaterialIdFilter);
            }
            HashSet<Long> materialIds = new HashSet<Long>(256);
            List matIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_material", (QFilter[])qFilters.toArray(new QFilter[0]), null, (int)-1);
            if (!CadEmptyUtils.isEmpty((List)matIds)) {
                matIds.forEach(s -> materialIds.add(Long.parseLong(String.valueOf(s))));
            }
            if (!CadEmptyUtils.isEmpty(materialIds)) {
                costObjectIdSet = this.getCostObjectIdSet(filter, materialIds);
                QFilter matIdQFilter = InFilterHelper.getQFilterByBachSize((String)"entryentity.material", new ArrayList<Long>(materialIds), (String)"in", (int)20000);
                QFilter matfilter = matIdQFilter.or(new QFilter("costobject", "in", costObjectIdSet).and(new QFilter("entryentity.caltype", "=", (Object)"5")));
                filter.and(matfilter);
            }
        }
        if (mulmaterialgroup != null) {
            params.put("materialGroupId", this.getMaterialGroup(materialGrpStd, mulmaterialgroup, orgId));
        }
        Boolean showgroup = filterInfo.getBoolean("showgroup");
        params.put("showGroup", showgroup);
        return filter;
    }

    private static Set<Long> getMainCostobjectIds(QFilter filter, List<Long> costObjectIds) {
        DataSet dataSet;
        ArrayList<QFilter> calResultFilter = new ArrayList<QFilter>(10);
        calResultFilter.add(filter);
        HashSet<Long> ids = new HashSet<Long>(16);
        calResultFilter.add(new QFilter("entryentity.caltype", "=", (Object)"5"));
        if (costObjectIds != null && !costObjectIds.isEmpty()) {
            calResultFilter.add(new QFilter("entryentity.obj", "in", costObjectIds));
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"costobject", (String)"sca_calcresult", (String)"costobject", (QFilter[])calResultFilter.toArray(new QFilter[0]), (String)"")) != null && dataSet.hasNext()) {
            for (Row row : dataSet) {
                ids.add(row.getLong("costobject"));
            }
        }
        return ids;
    }

    private Set<Long> getMaterialGroup(DynamicObject materialGrpStd, DynamicObjectCollection mulmaterialgroup, Long orgId) {
        Set<Long> materialGroupSet = new HashSet<Long>(16);
        ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
        createOrgIds.add(orgId);
        QFilter groupFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialGrpStd.getLong("id"), true});
        String longNumberDLM = "!";
        QFilter filter = new QFilter("1", "=", (Object)1);
        for (DynamicObject materialGroup : mulmaterialgroup) {
            if (materialGroup == null) continue;
            String groupLongNum = materialGroup.getString("longnumber");
            QFilter temFilter = new QFilter("longnumber", "like", (Object)(groupLongNum + longNumberDLM + "%"));
            temFilter.or(new QFilter("longnumber", "=", (Object)groupLongNum));
            filter.or(temFilter);
        }
        groupFilter.and(filter);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,number,name,standard,longnumber,isleaf", (QFilter[])groupFilter.toArray(), (String)"number asc");
        if (dynamicObjects != null) {
            materialGroupSet = dynamicObjects.stream().map(object -> object.getLong("id")).collect(Collectors.toSet());
        }
        return materialGroupSet;
    }

    private Set<Long> getCostObjectIdSet(QFilter baseFilter, Set<Long> mulMaterialIdSet) {
        QFilter filter = new QFilter("entryentity.material", "in", mulMaterialIdSet);
        filter.and(baseFilter);
        Set<Long> costObjectIdSet = new HashSet<Long>(16);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"sca_calcresult", (String)"costobject", (QFilter[])filter.toArray());
        if (dys != null) {
            costObjectIdSet = dys.stream().map(costObject -> costObject.getLong("costobject")).collect(Collectors.toSet());
        }
        return costObjectIdSet;
    }

    private Object getFilterItemValue(FilterInfo filterInfo, String propName) {
        FilterItemInfo filterItem = filterInfo.getFilterItem(propName);
        if (filterItem != null && filterItem.getValue() != null) {
            Object value = filterItem.getValue();
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                return values.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            return value;
        }
        return null;
    }
}

