/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.calc;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.common.helper.MatBaseDataFilterHelper;

public class CalcDetailItemFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    protected static final Log logger = LogFactory.getLog(CalcDetailItemFormPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costobject = (BasedataEdit)this.getControl("costobject");
        costobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcDetailItemFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CalcDetailItemFormPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcDetailItemFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(orgObj.getLong("id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CalcDetailItemFormPlugin_8", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcDetailItemFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(orgObj.getLong("id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), true});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit products = (BasedataEdit)this.getControl("mulgroupmaterial");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcDetailItemFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            HashSet<Long> orgSet = new HashSet<Long>(1);
            orgSet.add(orgObj.getLong("id"));
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgSet)));
            DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            if (!CollectionUtils.isEmpty((Collection)mulmaterialGroup) || materialGroupStandard.getLong("id") != 730148448254487552L) {
                QFilter classifiedMaterialIdFilter = new QFilter("id", "in", (Object)MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)mulmaterialGroup, (boolean)false, (DynamicObject)materialGroupStandard));
                qFilters.add(classifiedMaterialIdFilter);
            }
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initOrg();
        this.hideMaterialCondition();
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = reportShowParameter.getCustomParams();
        if (customParams != null && customParams.get("fromCalcResultRpt") != null) {
            Object materialgrpstd;
            Object fbizstatus;
            Object fcostObject;
            Object fcostcenter;
            Object fperiod;
            Object currency;
            Object costAccount;
            Object manuOrg;
            this.getModel().beginInit();
            Object org = customParams.get("org");
            if (org != null) {
                this.getModel().setValue("org", org);
                this.getView().updateView("org");
            }
            if ((manuOrg = customParams.get("manuorg")) != null) {
                JSONArray manuOrgIds = (JSONArray)manuOrg;
                this.getModel().setValue("manuorg", (Object)manuOrgIds.toArray());
                this.getView().updateView("manuorg");
            }
            if ((costAccount = customParams.get("costaccount")) != null) {
                this.getModel().setValue("costaccount", costAccount);
                this.getView().updateView("costaccount");
            }
            if ((currency = customParams.get("currency")) != null) {
                this.getModel().setValue("currency", currency);
                this.getView().updateView("currency");
            }
            if ((fperiod = customParams.get("fperiod")) != null) {
                JSONArray period = (JSONArray)fperiod;
                this.getModel().setValue("period", (Object)period.toArray());
                this.getView().updateView("period");
            }
            if ((fcostcenter = customParams.get("fcostcenter")) != null && fperiod != null) {
                JSONArray costcenter = (JSONArray)fperiod;
                this.getModel().setValue("costcenter", (Object)costcenter.toArray());
                this.getView().updateView("costcenter");
            }
            if ((fcostObject = customParams.get("fcostobject")) != null) {
                JSONArray costobject = (JSONArray)fcostObject;
                this.getModel().setValue("costobject", (Object)costobject.toArray());
                this.getView().updateView("costobject");
            }
            if ((fbizstatus = customParams.get("fbizstatus")) != null) {
                this.getModel().setValue("bizstatus", fbizstatus);
                this.getView().updateView("bizstatus");
            }
            if ((materialgrpstd = customParams.get("materialgrpstd")) == null) {
                materialgrpstd = BusinessDataServiceHelper.loadSingleFromCache((Object)730148448254487552L, (String)"bd_materialgroupstandard");
                this.getModel().setValue("materialgrpstd", materialgrpstd);
                this.getView().updateView("materialgrpstd");
            }
            this.getModel().endInit();
            ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
            reportFilter.search();
        }
        this.initFormCostConfirm();
    }

    private void hideMaterialCondition() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"materialgrpstd"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulmaterialgroup"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulgroupmaterial"});
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        try {
            String id = this.getView().getEntityId();
            String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CalcDetailItemFormPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]), (String)"CalcDetailItemFormPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]);
            String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"CalcDetailItemFormPlugin_9", (String)"macc-sca-form", (Object[])new Object[0]), (String)"CalcDetailItemFormPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]);
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)id, (IDataModel)this.getModel());
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2\u5931\u8d25", (Throwable)ex);
        }
    }

    private void initFormCostConfirm() {
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = reportShowParameter.getCustomParams();
        if (customParams != null && customParams.get("fromCostConfirm") != null) {
            Object materialgrpstd;
            Object bizstatus;
            Object costObject;
            Object costcenter;
            Object period;
            Object currency;
            Object costAccount;
            IReportView view = this.getView();
            IDataModel model = this.getModel();
            model.beginInit();
            Object org = customParams.get("org");
            if (org != null) {
                model.setValue("org", org);
                view.updateView("org");
            }
            if ((costAccount = customParams.get("costaccount")) != null) {
                model.setValue("costaccount", costAccount);
                view.updateView("costaccount");
            }
            if ((currency = customParams.get("currency")) != null) {
                model.setValue("currency", currency);
                view.updateView("currency");
            }
            if ((period = customParams.get("period")) != null) {
                model.setValue("period", (Object)new Object[]{period});
                view.updateView("period");
            }
            if ((costcenter = customParams.get("costcenter")) != null) {
                model.setValue("costcenter", (Object)new Object[]{costcenter});
                view.updateView("costcenter");
            }
            if ((costObject = customParams.get("costobject")) != null) {
                model.setValue("costobject", (Object)new Object[]{costObject});
                view.updateView("costobject");
            }
            if ((bizstatus = customParams.get("bizstatus")) != null) {
                model.setValue("bizstatus", bizstatus);
                view.updateView("bizstatus");
            }
            if ((materialgrpstd = customParams.get("materialgrpstd")) == null) {
                materialgrpstd = BusinessDataServiceHelper.loadSingleFromCache((Object)730148448254487552L, (String)"bd_materialgroupstandard");
                this.getModel().setValue("materialgrpstd", materialgrpstd);
                this.getView().updateView("materialgrpstd");
            }
            model.endInit();
            ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
            reportFilter.search();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.setCostAccount(newValue);
                this.configManuOrg();
                break;
            }
            case "costaccount": {
                this.setCurrencyAndPeriod(newValue);
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                this.getModel().setValue("mulgroupmaterial", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("mulgroupmaterial", null);
                break;
            }
            case "showgroup": {
                Boolean showgroup = (Boolean)this.getModel().getValue("showgroup");
                if (showgroup.booleanValue()) {
                    this.getModel().setValue("isshowdetail", (Object)false);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"materialgrpstd"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulmaterialgroup"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"materialgrpstd"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulmaterialgroup"});
                this.getModel().setValue("mulmaterialgroup", null);
                break;
            }
            case "isshowdetail": {
                Boolean isshowdetail = (Boolean)this.getModel().getValue("isshowdetail");
                if (isshowdetail.booleanValue()) {
                    this.getModel().setValue("showgroup", (Object)false);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"materialgrpstd"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulmaterialgroup"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulgroupmaterial"});
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"materialgrpstd"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulmaterialgroup"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulgroupmaterial"});
                this.getModel().setValue("mulmaterialgroup", null);
                this.getModel().setValue("mulgroupmaterial", null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject materialgrpstd;
        FormShowParameter fsp;
        String source;
        Object period;
        Object currency;
        Object costAccount;
        boolean isPass = true;
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfo = null;
        itemInfo = filterInfo.getFilterItem("org");
        Object org = itemInfo.getValue();
        if (org == null) {
            isPass = false;
        }
        if ((costAccount = (itemInfo = filterInfo.getFilterItem("costaccount")).getValue()) == null) {
            isPass = false;
        }
        if ((currency = (itemInfo = filterInfo.getFilterItem("currency")).getValue()) == null) {
            isPass = false;
        }
        if ((period = (itemInfo = filterInfo.getFilterItem("period")).getValue()) == null) {
            isPass = false;
        }
        if (!"HyperLink".equals(source = (String)(fsp = this.getView().getFormShowParameter()).getCustomParam("source")) && (materialgrpstd = this.getModel().getDataEntity().getDynamicObject("materialgrpstd")) == null) {
            isPass = false;
        }
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"CalcDetailItemFormPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        switch (name) {
            case "org": {
                List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)permAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "manuorg": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcDetailItemFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)org.getPkValue()), (String)this.getBillEntityId());
                QFilter filter = new QFilter("id", "in", (Object)manuOrg);
                listShowParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "costaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcDetailItemFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(StartCostHelper.getEndInitCostAccountIdsFilter((Long)Long.valueOf(org.getPkValue().toString()), (String)"sca"));
                break;
            }
            case "costcenter": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"CalcDetailItemFormPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("manuorg");
                List manuOrgList = dynamicObjects.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
                QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)org.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
                QFilter qfOrgDuty = new QFilter("orgduty.number", "=", (Object)"4");
                listShowParameter.getListFilterParameter().getQFilters().add(costCenterIdFilter);
                listShowParameter.getListFilterParameter().getQFilters().add(qfOrgDuty);
                break;
            }
            case "costobject": {
                List qFilters = listShowParameter.getListFilterParameter().getQFilters();
                DynamicObject datamodel = this.getModel().getDataEntity();
                DynamicObjectCollection costcenters = datamodel.getDynamicObjectCollection("costcenter");
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("manuorg");
                List manuOrgList = dynamicObjects.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
                if (CollectionUtils.isEmpty((Collection)costcenters)) {
                    if (org != null) {
                        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
                        qFilters.add(orgFilter);
                        if (manuOrgList.isEmpty()) break;
                        QFilter manuOrgFilter = new QFilter("manuorg", "in", manuOrgList);
                        qFilters.add(manuOrgFilter);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"CalcDetailItemFormPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                List ids = costcenters.stream().map(e -> e.get(2)).collect(Collectors.toList());
                QFilter costcenterFilter = new QFilter("costcenter", "in", ids);
                qFilters.add(costcenterFilter);
                if (manuOrgList.isEmpty()) break;
                QFilter manuOrgFilter = new QFilter("manuorg", "in", manuOrgList);
                qFilters.add(manuOrgFilter);
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        List<String> groupHideFields = Collections.singletonList("stdqty");
        List<String> hideDetailFields = Arrays.asList("material", "materialname", "modelnum", "unit", "matversion", "auxpty", "resource", "resourcename", "costlevel");
        boolean isShowDetail = this.getModel().getDataEntity().getBoolean("isshowdetail");
        boolean isShowGroup = this.getModel().getDataEntity().getBoolean("showgroup");
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)obj;
                String fieldKey = reportColumn.getFieldKey();
                if (isShowDetail && "diff".equals(fieldKey)) {
                    it.remove();
                }
                if (!isShowDetail && hideDetailFields.contains(fieldKey)) {
                    it.remove();
                }
                if (isShowGroup || isShowDetail || !"materialgroup".equals(fieldKey) && !"materialgroupname".equals(fieldKey)) continue;
                it.remove();
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)obj;
            if (!isShowDetail && "multdiff".equals(reportColumnGroup.getFieldKey())) {
                it.remove();
            }
            List reportColumns = reportColumnGroup.getChildren();
            for (int index = 0; index < reportColumns.size(); ++index) {
                Object column = reportColumns.get(index);
                if (!(column instanceof ReportColumn)) continue;
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (!isShowDetail && groupHideFields.contains(key)) {
                    col.setHide(true);
                }
                if (!isShowDetail || !"totalqty".equals(col.getFieldKey())) continue;
                col.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u9645\u7528\u91cf", (String)"CalcDetailItemFormPlugin_7", (String)"macc-sca-form", (Object[])new Object[0])));
            }
        }
        this.getView().updateView("reportlistap");
    }

    private void initOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.getView().updateView("org");
        }
        org = (DynamicObject)this.getModel().getValue("org");
        this.configManuOrg();
        this.setCostAccount(org);
    }

    private void configManuOrg() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        } else {
            boolean enableMul = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
            if (!enableMul) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
                this.getModel().setValue("manuorg", null);
            }
        }
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        Long mainBookId = OrgHelper.getCostAccountByOrg((Long)((DynamicObject)org).getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != null && mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
            this.getView().updateView("period");
        }
        this.getView().updateView("costaccount");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount != null) {
            this.setCurrencyAndPeriod(costAccount);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject calpolicy = ((DynamicObject)costAccount).getDynamicObject("calpolicy");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", calpolicy.getPkValue())});
        if (dynamicObject != null) {
            this.getModel().setValue("currency", dynamicObject.get("currency"));
            this.getView().updateView("currency");
        }
        this.setPeriod();
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("period", (Object)new Object[]{currentperiod});
            this.getView().updateView("period");
        }
    }
}

