/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.calc;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class CostCalcResultFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    protected static final Log logger = LogFactory.getLog(CostCalcResultFormPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("fcostcenter");
        costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costobject = (BasedataEdit)this.getControl("fcostobject");
        costobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getControl("fmaterial");
        if (material != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit period = (BasedataEdit)this.getControl("fperiod");
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCalcResultFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostCalcResultFormPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = reportShowParameter.getCustomParams();
        if (customParams != null && customParams.get("fromCalcResultRpt") != null) {
            this.assignQueryValAndSearch(customParams);
            return;
        }
        ReportQueryParam reportQueryParam = reportShowParameter.getReportQueryParam();
        if (reportQueryParam != null) {
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            return;
        }
        this.initQueryInfo();
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        try {
            String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostCalcResultFormPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]), (String)"CostCalcResultFormPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]);
            String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"CostCalcResultFormPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]), (String)"CostCalcResultFormPlugin_11", (String)"macc-sca-form", (Object[])new Object[0]);
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_calcresultrpt", (IDataModel)this.getModel());
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2\u5931\u8d25", (Throwable)ex);
        }
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("skiptopart".equals(itemKey) || "skiptoall".equals(itemKey) || "skiptoitem".equals(itemKey)) {
            boolean hasPerm = this.checkPermission(itemKey);
            if (!hasPerm) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\u3002", (String)"CostCalcResultFormPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            int[] selectedRows = reportList.getEntryState().getSelectedRows();
            if (CadEmptyUtils.isEmpty((int[])selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostCalcResultFormPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            IReportListModel reportListModel = reportList.getReportModel();
            ReportQueryParam reportQueryParam = reportListModel.getReportQueryParam();
            Map<String, Object> commonFilterMap = this.getCommonFilterMap(reportQueryParam);
            Map<String, Set<Object>> dataFilterMap = this.getDataFilterMap(reportList, selectedRows);
            if (dataFilterMap.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostCalcResultFormPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                return;
            }
            Map<String, Object> filterMap = this.getMinFilterMap(commonFilterMap, dataFilterMap);
            filterMap = this.dealValueType(filterMap);
            this.skipToReportPage(filterMap, itemKey);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ArrayList props = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", "fperiod"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)props);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"CostCalcResultFormPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        switch (name) {
            case "org": {
                List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "manuorg": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCalcResultFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)org.getPkValue()), (String)this.getBillEntityId());
                QFilter filter = new QFilter("id", "in", (Object)manuOrg);
                listShowParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "costaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCalcResultFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter costAccountFilter = StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)"sca");
                listShowParameter.getListFilterParameter().getQFilters().add(costAccountFilter);
                break;
            }
            case "fcostcenter": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"CostCalcResultFormPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                long orgId = org.getLong("id");
                List permProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId());
                if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
                    DynamicObjectCollection manuDyCol = this.getModel().getDataEntity().getDynamicObjectCollection("manuorg");
                    if (manuDyCol == null || manuDyCol.size() == 0) {
                        if (permProOrgsByAccOrg == null || permProOrgsByAccOrg.size() == 0) {
                            QFilter qf = new QFilter("accountorg", "=", (Object)-1L);
                            listShowParameter.getListFilterParameter().getQFilters().add(qf);
                            break;
                        }
                        QFilter costCenterQf = CostCenterHelper.getCostCenterByMultFactory((long)orgId, (List)permProOrgsByAccOrg, (String)this.getView().getFormShowParameter().getAppId());
                        listShowParameter.getListFilterParameter().getQFilters().add(costCenterQf);
                        break;
                    }
                    List manuOrgIds = manuDyCol.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    QFilter costCenterQf = CostCenterHelper.getCostCenterByMultFactory((long)orgId, manuOrgIds, (String)this.getView().getFormShowParameter().getAppId());
                    listShowParameter.getListFilterParameter().getQFilters().add(costCenterQf);
                    break;
                }
                QFilter orgQf = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                orgQf.and(new QFilter("orgduty", "=", (Object)4L));
                listShowParameter.getListFilterParameter().getQFilters().add(orgQf);
                break;
            }
            case "fcostobject": {
                this.setCostObjectBeforeF7Select(beforeF7SelectEvent);
                break;
            }
            case "fmaterial": {
                this.setMaterialBeforeF7Select(beforeF7SelectEvent);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.configManuOrg();
                this.setCostAccount(newValue);
                this.getModel().setValue("manuorg", null);
                break;
            }
            case "costaccount": {
                this.setCurrencyAndPeriod(newValue);
                break;
            }
            case "manuorg": {
                this.getModel().setValue("fcostcenter", null);
            }
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (formId.equals("sca_calcresultrpt_fact")) {
            DynamicObject costobject;
            HashMap<Long, BigDecimal[]> diffSumMap = new HashMap<Long, BigDecimal[]>();
            for (DynamicObject dObj : rowData) {
                costobject = dObj.getDynamicObject("costobject");
                if (costobject == null) continue;
                if ("A".equals(costobject.getString("bizstatus"))) {
                    dObj.set("currper_costupdatediff", (Object)BigDecimal.ZERO);
                    dObj.set("totalfinish_costupdatedif", (Object)BigDecimal.ZERO);
                }
                BigDecimal pdcompqty = dObj.getBigDecimal("pdcompqty");
                BigDecimal pdendqty = dObj.getBigDecimal("pdendqty");
                if (pdendqty.compareTo(BigDecimal.ZERO) < 0) {
                    pdendqty = BigDecimal.ZERO;
                }
                BigDecimal totalqty = dObj.getBigDecimal("totalqty");
                int precision = dObj.getDynamicObject("unit").getInt("precision");
                BigDecimal cursum = pdcompqty.add(pdendqty);
                BigDecimal totalsum = totalqty.add(pdendqty);
                if (cursum.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal curr_rate = pdcompqty.divide(cursum, precision, RoundingMode.HALF_UP);
                    dObj.set("currper_orderdiff", (Object)dObj.getBigDecimal("currper_orderdiff").multiply(curr_rate));
                    dObj.set("currper_invoicediff", (Object)dObj.getBigDecimal("currper_invoicediff").multiply(curr_rate));
                    dObj.set("currper_feediff", (Object)dObj.getBigDecimal("currper_feediff").multiply(curr_rate));
                }
                if (totalsum.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal total_rate = totalqty.divide(totalsum, precision, RoundingMode.HALF_UP);
                    dObj.set("totalfinish_orderdiff", (Object)dObj.getBigDecimal("totalfinish_orderdiff").multiply(total_rate));
                    dObj.set("totalfinish_invoicediff", (Object)dObj.getBigDecimal("totalfinish_invoicediff").multiply(total_rate));
                    dObj.set("totalfinish_feediff", (Object)dObj.getBigDecimal("totalfinish_feediff").multiply(total_rate));
                }
                dObj.set("currper_factcost", (Object)this.getFactCost(dObj, true));
                dObj.set("totalfinish_factcost", (Object)this.getFactCost(dObj, false));
                this.sumDiff2Map(dObj, diffSumMap);
            }
            for (DynamicObject dObj : rowData) {
                BigDecimal[] differs;
                costobject = dObj.getDynamicObject("costobject");
                if (costobject != null) continue;
                DynamicObject costcenter = dObj.getDynamicObject("costcenter");
                DynamicObject period = dObj.getDynamicObject("period");
                if (costcenter == null) {
                    differs = (BigDecimal[])diffSumMap.get(period.getLong("id"));
                    this.setSumRowDiffData(dObj, differs);
                    continue;
                }
                differs = (BigDecimal[])diffSumMap.get(costcenter.getLong("id"));
                this.setSumRowDiffData(dObj, differs);
            }
        }
    }

    private boolean checkPermission(String itemKey) {
        String userId = RequestContext.get().getUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityNum = "";
        if ("skiptopart".equals(itemKey)) {
            entityNum = "sca_calcdetailitemprt";
        } else if ("skiptoall".equals(itemKey)) {
            entityNum = "sca_calcallitemrpt";
        } else if ("skiptoitem".equals(itemKey)) {
            entityNum = "sca_calcresultrpt_detail";
        }
        return PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(userId), (String)appId, (String)entityNum, (String)"47150e89000000ac");
    }

    private Map<String, Object> dealValueType(Map<String, Object> filterMap) {
        for (Map.Entry<String, Object> entry : filterMap.entrySet()) {
            Object[] value = entry.getValue();
            if (!(value instanceof Set)) continue;
            value = ((Set)value).toArray(new Object[0]);
            filterMap.put(entry.getKey(), value);
        }
        return filterMap;
    }

    private Map<String, Object> getMinFilterMap(Map<String, Object> commonFilterMap, Map<String, Set<Object>> dataFilterMap) {
        for (Map.Entry<String, Object> entry : commonFilterMap.entrySet()) {
            if ("fperiod".equals(entry.getKey())) {
                commonFilterMap.put(entry.getKey(), dataFilterMap.get(entry.getKey()));
            }
            if ("fcostobject".equals(entry.getKey())) {
                commonFilterMap.put(entry.getKey(), dataFilterMap.get(entry.getKey()));
            }
            if (!"fbizstatus".equals(entry.getKey())) continue;
            Set<Object> value = dataFilterMap.get(entry.getKey());
            if (!StringUtils.isEmpty((Object)entry.getValue()) || value.size() != 1) continue;
            commonFilterMap.put(entry.getKey(), value.iterator().next());
        }
        return commonFilterMap;
    }

    private void skipToReportPage(Map<String, Object> filterMap, String itemKey) {
        String formId = "";
        String caption = "";
        if ("skiptopart".equals(itemKey)) {
            formId = "sca_calcdetailitemprt";
            caption = ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u660e\u7ec6\u5206\u9879\u8868", (String)"CostCalcResultFormPlugin_12", (String)"macc-sca-form", (Object[])new Object[0]);
        } else if ("skiptoall".equals(itemKey)) {
            formId = "sca_calcallitemrpt_new";
            caption = ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u660e\u7ec6\u7efc\u5408\u8868", (String)"CostCalcResultFormPlugin_13", (String)"macc-sca-form", (Object[])new Object[0]);
        } else if ("skiptoitem".equals(itemKey)) {
            formId = "sca_calcresultrpt_detail";
            caption = ResManager.loadKDString((String)"\u6210\u672c\u5206\u9879\u67e5\u8be2\uff08\u6210\u672c\u8fd8\u539f\uff09", (String)"CostCalcResultFormPlugin_10", (String)"macc-sca-form", (Object[])new Object[0]);
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId(formId);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        filterMap.put("fromCalcResultRpt", Boolean.TRUE);
        reportShowParameter.setCustomParams(filterMap);
        reportShowParameter.setCaption(caption);
        reportShowParameter.setCustomParam("source", (Object)"HyperLink");
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }

    private Map<String, Set<Object>> getDataFilterMap(ReportList reportList, int[] selectedRows) {
        IReportListModel reportListModel = reportList.getReportModel();
        HashMap<String, Set<Object>> resultMap = new HashMap<String, Set<Object>>();
        for (int i = 0; i < selectedRows.length; ++i) {
            DynamicObject rowData = reportListModel.getRowData(selectedRows[i]);
            DynamicObject period = rowData.getDynamicObject("period");
            DynamicObject costobject = rowData.getDynamicObject("costobject");
            if (costobject == null) continue;
            String bizstatus = costobject.getString("bizstatus");
            this.putIntoMap(resultMap, "fperiod", period);
            this.putIntoMap(resultMap, "fcostobject", costobject);
            this.putIntoMap(resultMap, "fbizstatus", bizstatus);
        }
        return resultMap;
    }

    private void putIntoMap(Map<String, Set<Object>> resultMap, String key, Object value) {
        if (value instanceof DynamicObject) {
            value = ((DynamicObject)value).getPkValue();
        }
        if (resultMap.get(key) != null) {
            resultMap.get(key).add(value);
        } else {
            HashSet<Object> valueSet = new HashSet<Object>();
            valueSet.add(value);
            resultMap.put(key, valueSet);
        }
    }

    private Map<String, Object> getCommonFilterMap(ReportQueryParam reportQueryParam) {
        HashMap<String, Object> keyValMap = new HashMap<String, Object>();
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object orgVal = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"org");
        Object manuOrgVal = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"manuorg");
        Object costAccountVal = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"costaccount");
        Object currencyVal = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"currency");
        Object periodVal = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fperiod");
        Object costCenterVal = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fcostcenter");
        Object costObjectVal = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fcostobject");
        Object materialVal = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fmaterial");
        Object bizStatusVal = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fbizstatus");
        keyValMap.put("org", orgVal);
        keyValMap.put("manuorg", manuOrgVal);
        keyValMap.put("costaccount", costAccountVal);
        keyValMap.put("currency", currencyVal);
        keyValMap.put("fperiod", periodVal);
        keyValMap.put("fcostcenter", costCenterVal);
        keyValMap.put("fcostobject", costObjectVal);
        keyValMap.put("fmaterial", materialVal);
        keyValMap.put("fbizstatus", bizStatusVal);
        return keyValMap;
    }

    private void setCostObjectBeforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject datamodel = this.getModel().getDataEntity();
        DynamicObject org = datamodel.getDynamicObject("org");
        DynamicObjectCollection costcenters = datamodel.getDynamicObjectCollection("fcostcenter");
        DynamicObjectCollection materials = datamodel.getDynamicObjectCollection("fmaterial");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"CostCalcResultFormPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        listShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
        if (!CollectionUtils.isEmpty((Collection)costcenters)) {
            List ids = costcenters.stream().map(e -> e.get(2)).collect(Collectors.toList());
            QFilter costcenterFilter = new QFilter("costcenter", "in", ids);
            listShowParameter.getListFilterParameter().getQFilters().add(costcenterFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)materials)) {
            List materialIds = costcenters.stream().map(e -> e.get(2)).collect(Collectors.toList());
            QFilter materialFilter = new QFilter("material", "in", materialIds);
            listShowParameter.getListFilterParameter().getQFilters().add(materialFilter);
        }
    }

    private void setMaterialBeforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
        DynamicObject datamodel = this.getModel().getDataEntity();
        DynamicObjectCollection costObjects = datamodel.getDynamicObjectCollection("fcostobject");
        if (!CollectionUtils.isEmpty((Collection)costObjects)) {
            List ids = costObjects.stream().map(e -> e.get(2)).collect(Collectors.toList());
            QFilter idFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection objects = QueryServiceHelper.query((String)"cad_costobject", (String)"material", (QFilter[])new QFilter[]{idFilter});
            List materials = objects.stream().map(e -> e.get("material")).collect(Collectors.toList());
            QFilter materialFitler = new QFilter("id", "in", materials);
            listShowParameter.getListFilterParameter().getQFilters().add(materialFitler);
        }
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long mainBookId = OrgHelper.getCostAccountByOrg((Long)orgDO.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != null && mainBookId != 0L) {
            boolean isnit = StartCostHelper.isInit((Long)mainBookId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (isnit) {
                this.getModel().setValue("costaccount", (Object)mainBookId);
            }
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("fperiod", null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.setPeriod();
    }

    private void setPeriod() {
        Long costaccountId;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long currperiod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)(costaccountId = Long.valueOf(costaccount.getLong("id"))));
        if (currperiod != null && currperiod != 0L) {
            this.getModel().setValue("fperiod", (Object)new Object[]{currperiod});
        }
    }

    private void initQueryInfo() {
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.configManuOrg();
            this.setCostAccount(this.getModel().getDataEntity().getDynamicObject("org"));
            this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
            this.getView().updateView();
        }
    }

    private void configManuOrg() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        } else {
            boolean enableMul = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
            if (!enableMul) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
            }
        }
    }

    private void assignQueryValAndSearch(Map<String, Object> customParams) {
        Object fbizstatus;
        Object fcostObject;
        Object fcostcenter;
        Object fperiod;
        Object currency;
        Object costAccount;
        this.getModel().beginInit();
        Object org = customParams.get("org");
        if (org != null) {
            this.getModel().setValue("org", org);
            this.getView().updateView("org");
        }
        if ((costAccount = customParams.get("costaccount")) != null) {
            this.getModel().setValue("costaccount", costAccount);
            this.getView().updateView("costaccount");
        }
        if ((currency = customParams.get("currency")) != null) {
            this.getModel().setValue("currency", currency);
            this.getView().updateView("currency");
        }
        if ((fperiod = customParams.get("fperiod")) != null) {
            JSONArray period = (JSONArray)fperiod;
            this.getModel().setValue("fperiod", (Object)period.toArray());
            this.getView().updateView("fperiod");
        }
        if ((fcostcenter = customParams.get("fcostcenter")) != null && fperiod != null) {
            JSONArray costcenter = (JSONArray)fperiod;
            this.getModel().setValue("fcostcenter", (Object)costcenter.toArray());
            this.getView().updateView("fcostcenter");
        }
        if ((fcostObject = customParams.get("fcostobject")) != null) {
            JSONArray costobject = (JSONArray)fcostObject;
            this.getModel().setValue("fcostobject", (Object)costobject.toArray());
            this.getView().updateView("fcostobject");
        }
        if ((fbizstatus = customParams.get("fbizstatus")) != null) {
            this.getModel().setValue("fbizstatus", fbizstatus);
            this.getView().updateView("fbizstatus");
        }
        this.getModel().endInit();
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.search();
    }

    private void sumDiff2Map(DynamicObject rowData, Map<Long, BigDecimal[]> sumMap) {
        BigDecimal[] differs;
        Long costcenterId = rowData.getDynamicObject("costcenter").getLong("id");
        long periodId = rowData.getDynamicObject("period").getLong("id");
        if (sumMap.containsKey(costcenterId)) {
            differs = sumMap.get(costcenterId);
            this.setDifferVal(differs, rowData, 1);
        } else {
            differs = new BigDecimal[10];
            this.setDifferVal(differs, rowData, 2);
            sumMap.put(costcenterId, differs);
        }
        if (sumMap.containsKey(periodId)) {
            differs = sumMap.get(periodId);
            this.setDifferVal(differs, rowData, 1);
        } else {
            differs = new BigDecimal[10];
            this.setDifferVal(differs, rowData, 2);
            sumMap.put(periodId, differs);
        }
    }

    private void setDifferVal(BigDecimal[] differs, DynamicObject rowData, int flag) {
        if (flag == 1) {
            differs[0] = differs[0].add(rowData.getBigDecimal("currper_orderdiff"));
            differs[1] = differs[1].add(rowData.getBigDecimal("currper_invoicediff"));
            differs[2] = differs[2].add(rowData.getBigDecimal("currper_feediff"));
            differs[3] = differs[3].add(rowData.getBigDecimal("currper_costupdatediff"));
            differs[4] = differs[4].add(rowData.getBigDecimal("totalfinish_orderdiff"));
            differs[5] = differs[5].add(rowData.getBigDecimal("totalfinish_invoicediff"));
            differs[6] = differs[6].add(rowData.getBigDecimal("totalfinish_feediff"));
            differs[7] = differs[7].add(rowData.getBigDecimal("totalfinish_costupdatedif"));
            differs[8] = differs[8].add(rowData.getBigDecimal("currper_factcost"));
            differs[9] = differs[9].add(rowData.getBigDecimal("totalfinish_factcost"));
        } else if (flag == 2) {
            differs[0] = rowData.getBigDecimal("currper_orderdiff");
            differs[1] = rowData.getBigDecimal("currper_invoicediff");
            differs[2] = rowData.getBigDecimal("currper_feediff");
            differs[3] = rowData.getBigDecimal("currper_costupdatediff");
            differs[4] = rowData.getBigDecimal("totalfinish_orderdiff");
            differs[5] = rowData.getBigDecimal("totalfinish_invoicediff");
            differs[6] = rowData.getBigDecimal("totalfinish_feediff");
            differs[7] = rowData.getBigDecimal("totalfinish_costupdatedif");
            differs[8] = rowData.getBigDecimal("currper_factcost");
            differs[9] = rowData.getBigDecimal("totalfinish_factcost");
        }
    }

    private void setSumRowDiffData(DynamicObject dObj, BigDecimal[] differs) {
        dObj.set("currper_orderdiff", (Object)differs[0]);
        dObj.set("currper_invoicediff", (Object)differs[1]);
        dObj.set("currper_feediff", (Object)differs[2]);
        dObj.set("currper_costupdatediff", (Object)differs[3]);
        dObj.set("totalfinish_orderdiff", (Object)differs[4]);
        dObj.set("totalfinish_invoicediff", (Object)differs[5]);
        dObj.set("totalfinish_feediff", (Object)differs[6]);
        dObj.set("totalfinish_costupdatedif", (Object)differs[7]);
        dObj.set("currper_factcost", (Object)differs[8]);
        dObj.set("totalfinish_factcost", (Object)differs[9]);
    }

    private BigDecimal getFactCost(DynamicObject rowData, boolean isCurr) {
        if (isCurr) {
            return rowData.getBigDecimal("pdcompanount").add(rowData.getBigDecimal("currper_matdiff")).add(rowData.getBigDecimal("currper_mancdiff")).add(rowData.getBigDecimal("currper_orderdiff")).add(rowData.getBigDecimal("currper_invoicediff")).add(rowData.getBigDecimal("currper_feediff")).add(rowData.getBigDecimal("currper_unabsorbdiff")).add(rowData.getBigDecimal("currper_costupdatediff"));
        }
        return rowData.getBigDecimal("stdamount").add(rowData.getBigDecimal("totalfinish_matdiff")).add(rowData.getBigDecimal("totalfinish_mancdiff")).add(rowData.getBigDecimal("totalfinish_orderdiff")).add(rowData.getBigDecimal("totalfinish_invoicediff")).add(rowData.getBigDecimal("totalfinish_feediff")).add(rowData.getBigDecimal("totalfinish_unabsorbdiff")).add(rowData.getBigDecimal("totalfinish_costupdatedif"));
    }
}

