/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.calc;

import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CalcRptHelper;

public class FactCostCalcResultQueryPlugin
extends AbstractReportListDataPlugin {
    public static final String queryColumnStr = "period, periodname, costcenter, costcenternumber, costcentername, costobject,material,auxpty,unit, matdiff,mancdiff,orderdiff,invoicediff,feediff,unabsorbdiff,costupdatediff,factcost";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        QFilter filter = CalcRptHelper.getQFilter((ReportQueryParam)reportQueryParam, (boolean)false);
        DataSet curPeriodDataSet = this.getDiffTypeDataSet(filter.copy(), "1");
        DataSet totalDataSet = this.getDiffTypeDataSet(filter.copy(), "2");
        DataSet curPeriodGroupDataSet = this.groupByCostObject(curPeriodDataSet);
        DataSet totalGroupDataSet = this.groupByCostObject(totalDataSet);
        DataSet finalDataSet = this.getFinalDataSet(reportQueryParam);
        DataSet joinDataSet = curPeriodGroupDataSet.join(totalGroupDataSet, JoinType.INNER).on("period", "period").on("periodname", "periodname").on("costcenter", "costcenter").on("costcenternumber", "costcenternumber").on("costcentername", "costcentername").on("costobject", "costobject").on("unit", "unit").select(this.getReportColumn(1), this.getReportColumn(2)).finish();
        joinDataSet = finalDataSet.join(joinDataSet, JoinType.INNER).on("period", "period").on("periodname", "periodname").on("costcenter", "costcenter").on("costcenternumber", "costcenternumber").on("costcentername", "costcentername").on("costobject", "costobject").on("unit", "unit").select(this.getReportColumn(3), this.getReportColumn(4)).finish();
        DataSet resultSet = this.getAllDataSet(joinDataSet);
        return resultSet;
    }

    private DataSet groupByCostObject(DataSet dataSet) {
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"period", "periodname", "costcenter", "costcenternumber", "costcentername", "costobject", "material", "auxpty", "unit"});
        GroupbyDataSet sumDataSet = groupbyDataSet.sum("matdiff").sum("mancdiff").sum("orderdiff").sum("invoicediff").sum("feediff").sum("unabsorbdiff").sum("costupdatediff").sum("factcost");
        return sumDataSet.finish().select(queryColumnStr);
    }

    private DataSet getAllDataSet(DataSet dataSet) {
        String total = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"FactCostCalcResultQueryPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
        GroupbyDataSet groupbyCostCenterDataSet = dataSet.groupBy(new String[]{"period", "costcenter"});
        groupbyCostCenterDataSet = groupbyCostCenterDataSet.sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("totalamount").sum("stdamount").sum("currper_matdiff").sum("currper_mancdiff").sum("currper_orderdiff").sum("currper_invoicediff").sum("currper_feediff").sum("currper_unabsorbdiff").sum("currper_costupdatediff").sum("currper_factcost").sum("totalfinish_matdiff").sum("totalfinish_mancdiff").sum("totalfinish_orderdiff").sum("totalfinish_invoicediff").sum("totalfinish_feediff").sum("totalfinish_unabsorbdiff").sum("totalfinish_costupdatedif").sum("totalfinish_factcost");
        DataSet costCenterSumDataSet = this.getgroupbyCostCenterDataSet(groupbyCostCenterDataSet, total);
        GroupbyDataSet groupbyPeriodDataSet = dataSet.groupBy(new String[]{"period"});
        groupbyPeriodDataSet = groupbyPeriodDataSet.sum("pdstartamount").sum("pdcurramount").sum("pdcompanount").sum("pdendamount").sum("totalamount").sum("stdamount").sum("currper_matdiff").sum("currper_mancdiff").sum("currper_orderdiff").sum("currper_invoicediff").sum("currper_feediff").sum("currper_unabsorbdiff").sum("currper_costupdatediff").sum("currper_factcost").sum("totalfinish_matdiff").sum("totalfinish_mancdiff").sum("totalfinish_orderdiff").sum("totalfinish_invoicediff").sum("totalfinish_feediff").sum("totalfinish_unabsorbdiff").sum("totalfinish_costupdatedif").sum("totalfinish_factcost");
        DataSet periodSumDataSet = this.getgroupbyPeriodDataSet(groupbyPeriodDataSet, total);
        DataSet unionDataSet = dataSet.union(costCenterSumDataSet).union(periodSumDataSet);
        return unionDataSet.orderBy(new String[]{"period", "costcenter desc", "costobject desc", "seqcol"});
    }

    private DataSet getgroupbyCostCenterDataSet(GroupbyDataSet groupbyCostCenterDataSet, String total) {
        return groupbyCostCenterDataSet.finish().select("period,'' AS periodname,costcenter,'" + total + "' AS costcenternumber,'' AS costcentername,0 AS costobject,0 AS material,0 AS auxpty,0 AS unit,0 AS pdstartqty, pdstartamount, 0 AS pdcurrqty, pdcurramount, 0 AS pdcompqty, pdcompanount, 0 AS pdendqty,pdendamount,0 AS totalqty,totalamount,stdamount,currper_matdiff,currper_mancdiff,currper_orderdiff,currper_invoicediff,currper_feediff,currper_unabsorbdiff,currper_costupdatediff,currper_factcost,totalfinish_matdiff,totalfinish_mancdiff,totalfinish_orderdiff,totalfinish_invoicediff,totalfinish_feediff,totalfinish_unabsorbdiff,totalfinish_costupdatedif,totalfinish_factcost,1 AS seqcol");
    }

    private DataSet getgroupbyPeriodDataSet(GroupbyDataSet groupbyPeriodDataSet, String total) {
        return groupbyPeriodDataSet.finish().select("period,'" + total + "' AS periodname,0 AS costcenter,'' AS costcenternumber,'' AS costcentername,0 AS costobject,0 AS material,0 AS auxpty,0 AS unit,0 AS pdstartqty, pdstartamount, 0 AS pdcurrqty, pdcurramount, 0 AS pdcompqty, pdcompanount, 0 AS pdendqty, pdendamount,0 AS totalqty,totalamount,stdamount,currper_matdiff,currper_mancdiff,currper_orderdiff,currper_invoicediff,currper_feediff,currper_unabsorbdiff,currper_costupdatediff,currper_factcost,totalfinish_matdiff,totalfinish_mancdiff,totalfinish_orderdiff,totalfinish_invoicediff,totalfinish_feediff,totalfinish_unabsorbdiff,totalfinish_costupdatedif,totalfinish_factcost,2 AS seqcol");
    }

    private String getQueryFields() {
        String selectFields = "period AS period, period.name AS periodname,costcenter AS costcenter,costcenter.number AS costcenternumber,costcenter.name AS costcentername,costobject AS costobject,costobject.material AS material,costobject.auxpty AS auxpty,costobject.material.baseunit AS unit, priceentry.matdiff AS matdiff,priceentry.mfgfeediff AS mancdiff,priceentry.orderdiff AS orderdiff,priceentry.receiptdiff AS invoicediff,priceentry.feediff AS feediff,priceentry.unabsorbfeediff AS unabsorbdiff,priceentry.costupdatediff AS costupdatediff,priceentry.factcost AS factcost";
        return selectFields;
    }

    private DataSet getDiffTypeDataSet(QFilter filter, String differType) {
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".getDiffTypeDataSet";
        String selectFields = this.getQueryFields();
        if ("1".equals(differType)) {
            filter.and(new QFilter("priceentry.periodtype", "=", (Object)Character.valueOf('1')));
        } else {
            filter.and(new QFilter("priceentry.periodtype", "=", (Object)Character.valueOf('2')));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_calcresult", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        return dataSet;
    }

    private String[] getReportColumn(int fieldGroup) {
        String[] columns = null;
        if (fieldGroup == 1) {
            columns = "period, periodname, costcenter, costcenternumber, costcentername, costobject,material,auxpty,unit,matdiff currper_matdiff ,mancdiff currper_mancdiff,orderdiff currper_orderdiff,invoicediff currper_invoicediff,feediff currper_feediff,unabsorbdiff currper_unabsorbdiff,costupdatediff currper_costupdatediff,factcost currper_factcost".split(",");
        } else if (fieldGroup == 2) {
            columns = "matdiff totalfinish_matdiff ,mancdiff totalfinish_mancdiff,orderdiff totalfinish_orderdiff,invoicediff totalfinish_invoicediff,feediff totalfinish_feediff,unabsorbdiff totalfinish_unabsorbdiff,costupdatediff totalfinish_costupdatedif,factcost totalfinish_factcost".split(",");
        } else if (fieldGroup == 3) {
            columns = "period, periodname, costcenter, costcenternumber, costcentername, costobject,material,auxpty,unit,pdstartqty,pdstartamount,pdcurrqty,pdcurramount,pdcompqty,pdcompanount,pdendqty,pdendamount,totalqty,totalamount,stdamount".split(",");
        } else if (fieldGroup == 4) {
            columns = "currper_matdiff,currper_mancdiff,currper_orderdiff,currper_invoicediff,currper_feediff,currper_unabsorbdiff,currper_costupdatediff,currper_factcost,totalfinish_matdiff,totalfinish_mancdiff,totalfinish_orderdiff,totalfinish_invoicediff,totalfinish_feediff,totalfinish_unabsorbdiff,totalfinish_costupdatedif,totalfinish_factcost,0 AS seqcol".split(",");
        }
        return columns;
    }

    private DataSet getFinalDataSet(ReportQueryParam reportQueryParam) {
        QFilter filter = CalcRptHelper.getQFilter((ReportQueryParam)reportQueryParam, (boolean)true);
        ORM orm = ORM.create();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".getFinalDataSet";
        String selectFields = this.getStdCostFinalResultFields();
        DataSet dataSet = orm.queryDataSet(algoKey, "sca_calcresult", selectFields, new QFilter[]{filter});
        DataSet resultSet = this.getFinalResultGroupByCostObject(dataSet);
        return resultSet;
    }

    private String getStdCostFinalResultFields() {
        String fields = "period AS period, period.name AS periodname,costcenter AS costcenter,costcenter.number AS costcenternumber,costcenter.name AS costcentername,costobject AS costobject,costobject.material AS material,costobject.auxpty AS auxpty,costobject.material.baseunit AS unit, entryentity.pdstartqty AS pdstartqty,entryentity.pdstartamount AS pdstartamount,entryentity.pdcurrqty AS pdcurrqty,entryentity.pdcurramount AS pdcurramount,entryentity.pdcompqty AS pdcompqty,entryentity.pdcompanount AS pdcompanount,entryentity.pdendqty AS pdendqty,entryentity.pdendamount AS pdendamount,entryentity.stdqty AS totalqty,entryentity.totalamount AS totalamount,entryentity.stdamount AS stdamount";
        return fields;
    }

    private DataSet getFinalResultGroupByCostObject(DataSet dataSet) {
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{"period", "periodname", "costcenter", "costcenternumber", "costcentername", "costobject", "material", "auxpty", "unit"});
        GroupbyDataSet sumDataSet = groupbyDataSet.sum("pdstartqty").sum("pdstartamount").sum("pdcurrqty").sum("pdcurramount").sum("pdcompqty").sum("pdcompanount").sum("pdendqty").sum("pdendamount").sum("totalqty").sum("totalamount").sum("stdamount");
        return sumDataSet.finish().select("period, periodname, costcenter, costcenternumber, costcentername, costobject,material,auxpty,unit,pdstartqty, pdstartamount, pdcurrqty, pdcurramount, pdcompqty, pdcompanount, pdendqty, pdendamount, totalqty,totalamount,stdamount");
    }
}

