/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.difftransfer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.constants.UnAbsorbRptParam;

public class UnAbsorbDiffRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(UnAbsorbDiffRptQueryPlugin.class);

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        UnAbsorbRptParam rptParam = this.getRptParam(reportQueryParam);
        String entityId = reportQueryParam.getFilter().getString("entityId");
        DataSet unAbsorbData = this.queryUnAbsorbAmountData(rptParam, entityId);
        List<Object[]> dataList = this.count(unAbsorbData.iterator(), rptParam);
        DataSet createDataSet = Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), this.getRowMeta());
        String selectSql = "periodname AS periodnum,costcenternumber AS costcenternum,costcentername,entrycostobject,manuorgname,entrymaterial,entrymaterialnum,elementnum,subelementnum,totalproduce,absorbupdate,unabsorbamount,absorbamount,unabsorbupdate";
        selectSql = selectSql + "," + rptParam.getCurrency().getString("id") + " hcurrency";
        return createDataSet.select(selectSql);
    }

    private Map<Long, Map<Long, List<Row>>> getUnMerPeriodData(Iterator<Row> rows, UnAbsorbRptParam rptParam) {
        LinkedHashMap<Long, Map<Long, List<Row>>> map = new LinkedHashMap<Long, Map<Long, List<Row>>>();
        if (!rows.hasNext()) {
            return map;
        }
        while (rows.hasNext()) {
            Row row = rows.next();
            Map costCenterMap = map.computeIfAbsent(row.getLong("periodnum"), k -> new LinkedHashMap());
            if ("C".equals(rptParam.getShowType())) {
                costCenterMap.computeIfAbsent(row.getLong("entrymaterial"), k -> new ArrayList()).add(row);
                continue;
            }
            costCenterMap.computeIfAbsent(row.getLong("costcenternum"), k -> new ArrayList()).add(row);
        }
        return map;
    }

    private Map<Long, List<Row>> getMerPeriodData(Iterator<Row> rows, UnAbsorbRptParam rptParam) {
        LinkedHashMap<Long, List<Row>> map = new LinkedHashMap<Long, List<Row>>();
        if (!rows.hasNext()) {
            return map;
        }
        while (rows.hasNext()) {
            Row row = rows.next();
            if ("C".equals(rptParam.getShowType())) {
                map.computeIfAbsent(row.getLong("entrymaterial"), k -> new ArrayList()).add(row);
                continue;
            }
            map.computeIfAbsent(row.getLong("costcenternum"), k -> new ArrayList()).add(row);
        }
        return map;
    }

    protected List<Object[]> count(Iterator<Row> rows, UnAbsorbRptParam rptParam) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        if (rptParam.getPeriodMerge().booleanValue()) {
            Map<Long, List<Row>> merPeriodData = this.getMerPeriodData(rows, rptParam);
            Object[] countRowData = new Object[this.getRowMeta().getFields().length];
            if ("C".equals(rptParam.getShowType())) {
                countRowData[this.getListFieldIndex((String)"entrymaterialnum")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"UnAbsorbDiffRptQueryPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
            } else {
                countRowData[this.getListFieldIndex((String)"costcenternumber")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"UnAbsorbDiffRptQueryPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
            }
            BigDecimal sumTotalProduce = BigDecimal.ZERO;
            BigDecimal sumAbsorbAmount = BigDecimal.ZERO;
            BigDecimal sumAbsorbUpdate = BigDecimal.ZERO;
            BigDecimal sumUnabsorbAmount = BigDecimal.ZERO;
            BigDecimal sumUnabsorbUpdate = BigDecimal.ZERO;
            for (Map.Entry<Long, List<Row>> entry : merPeriodData.entrySet()) {
                List<Row> value = entry.getValue();
                long lastRowCostObject = -1L;
                for (int i = 0; i < value.size(); ++i) {
                    Row row = value.get(i);
                    sumTotalProduce = sumTotalProduce.add(row.getBigDecimal("totalproduce") == null ? BigDecimal.ZERO : row.getBigDecimal("totalproduce"));
                    sumAbsorbAmount = sumAbsorbAmount.add(row.getBigDecimal("absorbamount") == null ? BigDecimal.ZERO : row.getBigDecimal("absorbamount"));
                    sumAbsorbUpdate = sumAbsorbUpdate.add(row.getBigDecimal("absorbupdate") == null ? BigDecimal.ZERO : row.getBigDecimal("absorbupdate"));
                    sumUnabsorbAmount = sumUnabsorbAmount.add(row.getBigDecimal("unabsorbamount") == null ? BigDecimal.ZERO : row.getBigDecimal("unabsorbamount"));
                    sumUnabsorbUpdate = sumUnabsorbUpdate.add(row.getBigDecimal("unabsorbupdate") == null ? BigDecimal.ZERO : row.getBigDecimal("unabsorbupdate"));
                    dataList.add(this.getObjectRow(row, 1, i, lastRowCostObject, rptParam));
                    lastRowCostObject = "A".equals(rptParam.getShowType()) ? (row.get("entrycostobject") == null ? 0L : Long.parseLong(row.get("entrycostobject").toString())) : (row.get("entrymaterial") == null ? 0L : Long.parseLong(row.get("entrymaterial").toString()));
                }
            }
            countRowData[this.getListFieldIndex((String)"totalproduce")] = sumTotalProduce;
            countRowData[this.getListFieldIndex((String)"absorbamount")] = sumAbsorbAmount;
            countRowData[this.getListFieldIndex((String)"absorbupdate")] = sumAbsorbUpdate;
            countRowData[this.getListFieldIndex((String)"unabsorbamount")] = sumUnabsorbAmount;
            countRowData[this.getListFieldIndex((String)"unabsorbupdate")] = sumUnabsorbUpdate;
            dataList.add(countRowData);
        } else {
            Map<Long, Map<Long, List<Row>>> map = this.getUnMerPeriodData(rows, rptParam);
            for (Map.Entry<Long, Map<Long, List<Row>>> entrySet : map.entrySet()) {
                int index = 0;
                Map<Long, List<Row>> costCenterMap = entrySet.getValue();
                Object[] firtCountRowData = new Object[this.getRowMeta().getFields().length];
                firtCountRowData[this.getListFieldIndex((String)"periodname")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"UnAbsorbDiffRptQueryPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
                BigDecimal sumFirtTotalProduce = BigDecimal.ZERO;
                BigDecimal sumFirtAbsorbAmount = BigDecimal.ZERO;
                BigDecimal sumFirtAbsorbUpdate = BigDecimal.ZERO;
                BigDecimal sumFirtUnabsorbAmount = BigDecimal.ZERO;
                BigDecimal sumFirtUnabsorbUpdate = BigDecimal.ZERO;
                for (Map.Entry<Long, List<Row>> entry : costCenterMap.entrySet()) {
                    List<Row> items = entry.getValue();
                    Object[] secdCountRowData = new Object[this.getRowMeta().getFields().length];
                    if ("C".equals(rptParam.getShowType())) {
                        secdCountRowData[this.getListFieldIndex((String)"entrymaterialnum")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"UnAbsorbDiffRptQueryPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
                    } else {
                        secdCountRowData[this.getListFieldIndex((String)"costcenternumber")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"UnAbsorbDiffRptQueryPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
                    }
                    BigDecimal sumSecdTotalProduce = BigDecimal.ZERO;
                    BigDecimal sumSecdAbsorbAmount = BigDecimal.ZERO;
                    BigDecimal sumSecdAbsorbUpdate = BigDecimal.ZERO;
                    BigDecimal sumSecdUnabsorbAmount = BigDecimal.ZERO;
                    BigDecimal sumSecdUnabsorbUpdate = BigDecimal.ZERO;
                    for (int i = 0; i < items.size(); ++i) {
                        Row row = items.get(i);
                        sumSecdTotalProduce = sumSecdTotalProduce.add(row.getBigDecimal("totalproduce") == null ? BigDecimal.ZERO : row.getBigDecimal("totalproduce"));
                        sumSecdAbsorbAmount = sumSecdAbsorbAmount.add(row.getBigDecimal("absorbamount") == null ? BigDecimal.ZERO : row.getBigDecimal("absorbamount"));
                        sumSecdAbsorbUpdate = sumSecdAbsorbUpdate.add(row.getBigDecimal("absorbupdate") == null ? BigDecimal.ZERO : row.getBigDecimal("absorbupdate"));
                        sumSecdUnabsorbAmount = sumSecdUnabsorbAmount.add(row.getBigDecimal("unabsorbamount") == null ? BigDecimal.ZERO : row.getBigDecimal("unabsorbamount"));
                        sumSecdUnabsorbUpdate = sumSecdUnabsorbUpdate.add(row.getBigDecimal("unabsorbupdate") == null ? BigDecimal.ZERO : row.getBigDecimal("unabsorbupdate"));
                    }
                    secdCountRowData[this.getListFieldIndex((String)"totalproduce")] = sumSecdTotalProduce;
                    secdCountRowData[this.getListFieldIndex((String)"absorbamount")] = sumSecdAbsorbAmount;
                    secdCountRowData[this.getListFieldIndex((String)"absorbupdate")] = sumSecdAbsorbUpdate;
                    secdCountRowData[this.getListFieldIndex((String)"unabsorbamount")] = sumSecdUnabsorbAmount;
                    secdCountRowData[this.getListFieldIndex((String)"unabsorbupdate")] = sumSecdUnabsorbUpdate;
                    sumFirtTotalProduce = sumFirtTotalProduce.add(sumSecdTotalProduce);
                    sumFirtAbsorbAmount = sumFirtAbsorbAmount.add(sumSecdAbsorbAmount);
                    sumFirtAbsorbUpdate = sumFirtAbsorbUpdate.add(sumSecdAbsorbUpdate);
                    sumFirtUnabsorbAmount = sumFirtUnabsorbAmount.add(sumSecdUnabsorbAmount);
                    sumFirtUnabsorbUpdate = sumFirtUnabsorbUpdate.add(sumSecdUnabsorbUpdate);
                    long lastRowCostObject = -1L;
                    for (int i = 0; i < items.size(); ++i) {
                        dataList.add(this.getObjectRow(items.get(i), index, i, lastRowCostObject, rptParam));
                        lastRowCostObject = "A".equals(rptParam.getShowType()) ? (items.get(i).get("entrycostobject") == null ? 0L : Long.parseLong(items.get(i).get("entrycostobject").toString())) : (items.get(i).get("entrymaterial") == null ? 0L : Long.parseLong(items.get(i).get("entrymaterial").toString()));
                        ++index;
                    }
                    dataList.add(secdCountRowData);
                }
                firtCountRowData[this.getListFieldIndex((String)"totalproduce")] = sumFirtTotalProduce;
                firtCountRowData[this.getListFieldIndex((String)"absorbamount")] = sumFirtAbsorbAmount;
                firtCountRowData[this.getListFieldIndex((String)"absorbupdate")] = sumFirtAbsorbUpdate;
                firtCountRowData[this.getListFieldIndex((String)"unabsorbamount")] = sumFirtUnabsorbAmount;
                firtCountRowData[this.getListFieldIndex((String)"unabsorbupdate")] = sumFirtUnabsorbUpdate;
                dataList.add(firtCountRowData);
            }
        }
        return dataList;
    }

    protected Object[] getObjectRow(Row row, int index, int second, Long lastRowCostObject, UnAbsorbRptParam rptParam) {
        Field[] fields = this.getRowMeta().getFields();
        Object[] rowData = new Object[fields.length];
        if (!rptParam.getPeriodMerge().booleanValue()) {
            rowData[this.getListFieldIndex((String)"periodname")] = row.get("periodname");
        }
        if (!"C".equals(rptParam.getShowType())) {
            rowData[this.getListFieldIndex((String)"costcenternumber")] = row.get("costcenternumber");
            rowData[this.getListFieldIndex((String)"costcentername")] = row.get("costcentername");
        }
        if ("A".equals(rptParam.getShowType())) {
            if (!rptParam.getPeriodMerge().booleanValue()) {
                rowData[this.getListFieldIndex((String)"periodname")] = row.get("periodname");
            }
            rowData[this.getListFieldIndex((String)"costcenternumber")] = row.get("costcenternumber");
            rowData[this.getListFieldIndex((String)"costcentername")] = row.get("costcentername");
            rowData[this.getListFieldIndex((String)"entrycostobject")] = row.get("entrycostobject");
            rowData[this.getListFieldIndex((String)"entrymaterialnum")] = row.get("entrymaterialnum");
            rowData[this.getListFieldIndex((String)"entrymaterial")] = row.get("entrymaterial");
            rowData[this.getListFieldIndex((String)"manuorgname")] = row.get("manuorgname");
        } else {
            rowData[this.getListFieldIndex((String)"entrymaterialnum")] = row.get("entrymaterialnum");
            rowData[this.getListFieldIndex((String)"entrymaterial")] = row.get("entrymaterial");
            rowData[this.getListFieldIndex((String)"manuorgname")] = row.get("manuorgname");
        }
        rowData[this.getListFieldIndex((String)"elementnum")] = row.get("elementnum");
        rowData[this.getListFieldIndex((String)"subelementnum")] = row.get("subelementnum");
        rowData[this.getListFieldIndex((String)"totalproduce")] = row.get("totalproduce");
        rowData[this.getListFieldIndex((String)"absorbamount")] = row.get("absorbamount");
        rowData[this.getListFieldIndex((String)"absorbupdate")] = row.get("absorbupdate");
        rowData[this.getListFieldIndex((String)"unabsorbamount")] = row.get("unabsorbamount");
        rowData[this.getListFieldIndex((String)"unabsorbupdate")] = row.get("unabsorbupdate");
        return rowData;
    }

    protected int getListFieldIndex(String field) {
        Field[] fields = this.getRowMeta().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!field.equals(fields[i].getName())) continue;
            return i;
        }
        return -1;
    }

    protected RowMeta getRowMeta() {
        List<Field> field = this.getRowMetaField();
        return new RowMeta(field.toArray(new Field[0]));
    }

    protected List<Field> getRowMetaField() {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("id", (DataType)DataType.LongType));
        field.add(new Field("periodnum", (DataType)DataType.LongType));
        field.add(new Field("periodname", (DataType)DataType.StringType));
        field.add(new Field("costcenternum", (DataType)DataType.LongType));
        field.add(new Field("costcenternumber", (DataType)DataType.StringType));
        field.add(new Field("costcentername", (DataType)DataType.StringType));
        field.add(new Field("entrycostobject", (DataType)DataType.LongType));
        field.add(new Field("manuorgname", (DataType)DataType.LongType));
        field.add(new Field("entrymaterialnum", (DataType)DataType.StringType));
        field.add(new Field("entrymaterial", (DataType)DataType.LongType));
        field.add(new Field("elementnum", (DataType)DataType.LongType));
        field.add(new Field("subelementnum", (DataType)DataType.LongType));
        field.add(new Field("totalproduce", (DataType)DataType.BigDecimalType));
        field.add(new Field("absorbamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("absorbupdate", (DataType)DataType.BigDecimalType));
        field.add(new Field("unabsorbamount", (DataType)DataType.BigDecimalType));
        field.add(new Field("unabsorbupdate", (DataType)DataType.BigDecimalType));
        return field;
    }

    private DataSet queryUnAbsorbAmountData(UnAbsorbRptParam queryParam, String entityId) {
        String unAbsorbfields = "period AS periodnum, period.name AS periodnumname, costcenter AS costcenternum, costcenter.number AS costcenternumber, costcenter.name AS costcentername, costobject AS entrycostobject, manuorg AS manuorgname, costobject.material.number AS entrymaterialnum, costobject.material.masterid AS entrymaterial, entryentity.element AS elementnum, entryentity.subelement AS subelementnum, 0 AS totalproduce, 0 AS absorbupdate, 0 AS absorbamount,0 AS unabsorbupdate,entryentity.amount AS unabsorbamount";
        List<QFilter> unAbsorbFilters = this.getFilters(queryParam, "unabsorbamount", entityId);
        logger.info("\u672a\u5438\u6536\u8d39\u7528-\u67e5\u8be2\u6761\u4ef6\uff1a{}-{}", (Object)"unabsorbamount", (Object)unAbsorbFilters.toString());
        ORMImpl orm = new ORMImpl();
        DataSet unAbsorbDataSet = orm.queryDataSet(this.getAlgoKey("queryUnAbsorbData"), "sca_unabsorbdiff", unAbsorbfields, unAbsorbFilters.toArray(new QFilter[0]));
        String updateFields = "period AS periodnum, period.name AS periodnumname, costcenter AS costcenternum, costcenter.number AS costcenternumber, costcenter.name AS costcentername, costobject AS entrycostobject, manuorg AS manuorgname, costobject.material.number AS entrymaterialnum, costobject.material.masterid AS entrymaterial, entryentity.element AS elementnum, entryentity.subelement AS subelementnum, 0 AS totalproduce, entryentity.amount AS absorbupdate, 0 AS absorbamount,0 AS unabsorbupdate,0 AS unabsorbamount";
        List<QFilter> updateFilters = this.getFilters(queryParam, "absorbupdate", entityId);
        logger.info("\u672a\u5438\u6536\u8d39\u7528-\u67e5\u8be2\u6761\u4ef6\uff1a{}-{}", (Object)"absorbupdate", (Object)unAbsorbFilters.toString());
        DataSet updateDataSet = orm.queryDataSet(this.getAlgoKey("queryUpdateData"), "sca_unabsorbdiff", updateFields, updateFilters.toArray(new QFilter[0]));
        String totalFields = "period AS periodnum, period.name AS periodnumname, costcenter AS costcenternum, costcenter.number AS costcenternumber, costcenter.name AS costcentername, costobject AS entrycostobject, costobject.manuorg AS manuorgname, costobject.material.number AS entrymaterialnum, costobject.material.masterid AS entrymaterial, entryentity.element AS elementnum, entryentity.subelement AS subelementnum, entryentity.totalproduce AS totalproduce, 0 AS absorbupdate, 0 AS absorbamount,0 AS unabsorbupdate,0 AS unabsorbamount";
        List<QFilter> totalFilters = this.getFilters(queryParam, "totalproduce", entityId);
        logger.info("\u672a\u5438\u6536\u8d39\u7528-\u67e5\u8be2\u6761\u4ef6\uff1a{}-{}", (Object)"totalproduce", (Object)unAbsorbFilters.toString());
        DataSet totalDataSet = orm.queryDataSet(this.getAlgoKey("queryTotalData"), "sca_totalmfgfee", totalFields, totalFilters.toArray(new QFilter[0]));
        unAbsorbDataSet = unAbsorbDataSet.union(updateDataSet).union(totalDataSet);
        GroupbyDataSet groupbyDataSet = unAbsorbDataSet.groupBy(this.getGroupString(queryParam));
        groupbyDataSet.sum("unabsorbamount");
        groupbyDataSet.sum("absorbupdate");
        groupbyDataSet.sum("totalproduce");
        groupbyDataSet.sum("absorbamount");
        groupbyDataSet.sum("unabsorbupdate");
        unAbsorbDataSet = groupbyDataSet.finish();
        unAbsorbDataSet = unAbsorbDataSet.select(this.getSelectGroupString(queryParam, "A"));
        unAbsorbDataSet = unAbsorbDataSet.select(this.getSelectGroupString(queryParam, "B"));
        unAbsorbDataSet = unAbsorbDataSet.orderBy(this.getOrderString(queryParam));
        if (!"A".equals(queryParam.getShowType())) {
            unAbsorbDataSet = unAbsorbDataSet.addField("0", "manuorgname");
        }
        return unAbsorbDataSet;
    }

    private String[] getOrderString(UnAbsorbRptParam queryParam) {
        ArrayList<String> list = new ArrayList<String>();
        if (!queryParam.getPeriodMerge().booleanValue()) {
            list.add("periodnum ASC");
        }
        if ("A".equals(queryParam.getShowType()) || "B".equals(queryParam.getShowType())) {
            list.add("costcenternum ASC");
        }
        if ("A".equals(queryParam.getShowType())) {
            list.add("entrycostobject ASC");
        }
        list.add("entrymaterial ASC");
        list.add("elementnum DESC");
        list.add("subelementnum DESC");
        return list.toArray(new String[0]);
    }

    private String[] getGroupString(UnAbsorbRptParam queryParam) {
        ArrayList<String> list = new ArrayList<String>();
        if (!queryParam.getPeriodMerge().booleanValue()) {
            list.add("periodnum");
            list.add("periodnumname");
        }
        if ("A".equals(queryParam.getShowType()) || "B".equals(queryParam.getShowType())) {
            list.add("costcenternum");
            list.add("costcenternumber");
            list.add("costcentername");
        }
        if ("A".equals(queryParam.getShowType())) {
            list.add("entrycostobject");
            list.add("manuorgname");
        }
        list.add("entrymaterialnum");
        list.add("entrymaterial");
        list.add("elementnum");
        list.add("subelementnum");
        return list.toArray(new String[0]);
    }

    private String[] getSelectGroupString(UnAbsorbRptParam queryParam, String type) {
        ArrayList<String> list = new ArrayList<String>(10);
        if (!queryParam.getPeriodMerge().booleanValue()) {
            list.add("periodnum");
            if (type.equals("A")) {
                list.add("periodnumname");
            } else {
                list.add("periodnumname AS periodname");
            }
        }
        if ("A".equals(queryParam.getShowType()) || "B".equals(queryParam.getShowType())) {
            list.add("costcenternum");
            list.add("costcenternumber");
            list.add("costcentername");
        }
        if ("A".equals(queryParam.getShowType())) {
            list.add("entrycostobject");
            list.add("manuorgname");
        }
        list.add("entrymaterial");
        list.add("entrymaterialnum");
        list.add("elementnum");
        list.add("subelementnum");
        if (type.equals("A")) {
            list.add("totalproduce");
            list.add("absorbupdate");
            list.add("unabsorbamount");
            list.add("totalproduce-unabsorbamount as absorbamount");
            list.add("unabsorbupdate");
        } else {
            list.add("totalproduce");
            list.add("absorbupdate");
            list.add("unabsorbamount");
            list.add("absorbamount");
            list.add("totalproduce-(unabsorbamount+absorbupdate+absorbamount) as unabsorbupdate");
        }
        return list.toArray(new String[0]);
    }

    private UnAbsorbRptParam getRptParam(ReportQueryParam param) {
        FilterInfo filter = param.getFilter();
        UnAbsorbRptParam rptParam = new UnAbsorbRptParam();
        rptParam.setOrg((List<DynamicObject>)filter.getDynamicObjectCollection("org"));
        rptParam.setManuOrg((List<DynamicObject>)filter.getDynamicObjectCollection("manuorg"));
        rptParam.setCostAccount((List<DynamicObject>)filter.getDynamicObjectCollection("costaccount"));
        rptParam.setCurrency(filter.getDynamicObject("currency"));
        rptParam.setBeginPeriod(filter.getDynamicObject("beginperiod"));
        rptParam.setEndPeriod(filter.getDynamicObject("endperiod"));
        rptParam.setCostCenter((List<DynamicObject>)filter.getDynamicObjectCollection("costcenter"));
        rptParam.setCostObject(filter.getDynamicObject("costobject"));
        rptParam.setMaterial(filter.getDynamicObject("material"));
        rptParam.setBizStatus(StringUtils.isBlank((CharSequence)filter.getString("bizstatus")) ? "ALL" : filter.getString("bizstatus"));
        rptParam.setShowType(StringUtils.isBlank((CharSequence)filter.getString("showtype")) ? "A" : filter.getString("showtype"));
        rptParam.setPeriodMerge(filter.getBoolean("periodmerge"));
        return rptParam;
    }

    private List<QFilter> getFilters(UnAbsorbRptParam queryParam, String amountType, String entityId) {
        String bizStatus;
        DynamicObject material;
        DynamicObject costObject;
        List<DynamicObject> costCenter;
        DynamicObject endPeriod;
        DynamicObject beginPeriod;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("billstatus", "=", (Object)Character.valueOf('C')));
        if (!CadEmptyUtils.isEmpty(queryParam.getOrg())) {
            List<DynamicObject> orgList = queryParam.getOrg();
            HashSet orgIds = new HashSet(orgList.size());
            orgList.forEach(org -> orgIds.add(org.getLong("id")));
            filters.add(new QFilter("org", "in", orgIds));
        }
        HashSet manuOrgIds = new HashSet(10);
        if (!CadEmptyUtils.isEmpty(queryParam.getManuOrg())) {
            List<DynamicObject> manuOrgs = queryParam.getManuOrg();
            manuOrgs.forEach(org -> manuOrgIds.add(org.getLong("id")));
        } else {
            List<DynamicObject> orgList = queryParam.getOrg();
            orgList.forEach(org -> {
                long orgId = org.getLong("id");
                List productOrgs = null;
                productOrgs = OrgHelper.isOrgEnableMultiFactory((Long)orgId) ? ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)entityId, (String)"sca") : OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)true);
                if (!CollectionUtils.isEmpty((Collection)productOrgs)) {
                    manuOrgIds.addAll(productOrgs);
                }
                logger.info("\u672a\u5438\u6536\u8d39\u7528\u67e5\u8be2\uff1a{}-{}", (Object)orgId, (Object)productOrgs);
            });
        }
        if (!CadEmptyUtils.isEmpty(queryParam.getCostAccount())) {
            List<DynamicObject> costAccounts = queryParam.getCostAccount();
            HashSet accountIds = new HashSet(costAccounts.size());
            costAccounts.forEach(account -> accountIds.add(account.getLong("id")));
            filters.add(new QFilter("costaccount", "in", accountIds));
        }
        if ((beginPeriod = queryParam.getBeginPeriod()) != null) {
            Date beginDate = beginPeriod.getDate("begindate");
            filters.add(new QFilter("period.begindate", ">=", (Object)beginDate));
        }
        if ((endPeriod = queryParam.getEndPeriod()) != null) {
            Date endDate = endPeriod.getDate("enddate");
            filters.add(new QFilter("period.enddate", "<=", (Object)endDate));
        }
        if (!CadEmptyUtils.isEmpty(costCenter = queryParam.getCostCenter())) {
            HashSet<Long> setIds = new HashSet<Long>(costCenter.size());
            for (DynamicObject dynamicObject : costCenter) {
                setIds.add(dynamicObject.getLong("id"));
            }
            filters.add(new QFilter("costcenter", "in", setIds));
        }
        if ((costObject = queryParam.getCostObject()) != null) {
            filters.add(new QFilter("costobject", "=", costObject.getPkValue()));
        }
        if ((material = queryParam.getMaterial()) != null) {
            filters.add(new QFilter("costobject.material.masterid", "=", (Object)material.getLong("masterid")));
        }
        if (!"ALL".equals(bizStatus = queryParam.getBizStatus())) {
            filters.add(new QFilter("costobject.bizstatus", "=", (Object)bizStatus));
        }
        switch (amountType) {
            case "totalproduce": {
                if (manuOrgIds.isEmpty()) break;
                filters.add(new QFilter("costobject.manuorg", "in", manuOrgIds));
                break;
            }
            case "unabsorbamount": {
                filters.add(new QFilter("difftype", "=", (Object)"4"));
                if (manuOrgIds.isEmpty()) break;
                filters.add(new QFilter("manuorg", "in", manuOrgIds));
                break;
            }
            case "absorbupdate": {
                filters.add(new QFilter("difftype", "=", (Object)"3"));
                if (manuOrgIds.isEmpty()) break;
                filters.add(new QFilter("manuorg", "in", manuOrgIds));
            }
        }
        return filters;
    }
}

