/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.feealloc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.common.constants.MfgFeeAllocRptParam;
import kd.macc.sca.common.helper.MfgFeeAllocRptHelp;
import kd.macc.sca.report.feealloc.BaseAllocRptPlugin;

public class MatAllocRptPlugin
extends BaseAllocRptPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String MAT_COL_BILLNO = "matcollectbillnos";
    private static final String PRO_BILLNO = "probillnos";
    private static final String ALLOC_BILL = "allocbillno";
    private static final String COL_BILLNO = "matcollectbillno";

    @Override
    protected String getBillEntityId() {
        return this.getView().getEntityId();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MAT_COL_BILLNO});
        this.addClickListeners(new String[]{PRO_BILLNO});
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"MatAllocRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)accountorg.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())));
        });
        BasedataEdit costcenterInput = (BasedataEdit)this.getControl("mulcostcenter");
        costcenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"MatAllocRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("manuorg");
            List manuOrgList = dynamicObjects.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
            QFilter qfId = CostCenterHelper.getCostCenterByMultFactoryForList((long)org.getLong("id"), manuOrgList, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
            List qFilters = filterParameter.getQFilters();
            qFilters.add(qfId);
        });
        BasedataEdit costobejctentryInput = (BasedataEdit)this.getControl("mulcostobejctentry");
        costobejctentryInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"MatAllocRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter qfId = new QFilter("org", "=", (Object)org.getLong("id"));
            qFilters.add(qfId);
            DynamicObjectCollection costcenter = (DynamicObjectCollection)this.getModel().getValue("mulcostcenter");
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costcenter)) {
                HashSet costcenterIds = new HashSet(16);
                costcenter.forEach(p -> costcenterIds.add(p.getLong("fbasedataid.id")));
                QFilter costCenterQF = new QFilter("costcenter", "in", costcenterIds);
                qFilters.add(costCenterQF);
            }
        });
        BasedataEdit submatInput = (BasedataEdit)this.getControl("mulsubmat");
        submatInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"MatAllocRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            DynamicObjectCollection costobjects = this.getCostobject(org.getLong("id"));
            ArrayList<Long> matIds = new ArrayList<Long>();
            for (DynamicObject coDO : costobjects) {
                matIds.add(coDO.getLong("material"));
            }
            QFilter coQF = new QFilter("id", "in", matIds);
            List qFilters = filterParameter.getQFilters();
            qFilters.add(coQF);
        });
        BasedataEdit materialInput = (BasedataEdit)this.getControl("mulmaterial");
        materialInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"MatAllocRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter fParameter = (ListShowParameter)evt.getFormShowParameter();
            fParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                ReportList rptList = (ReportList)e.getSource();
                DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
                String fieldName = e.getFieldName();
                String formId = "";
                String billno = row.getString(fieldName);
                DynamicObject org = row.getDynamicObject("orgnum");
                String appId = MatAllocRptPlugin.this.getView().getFormShowParameter().getAppId();
                if (MatAllocRptPlugin.ALLOC_BILL.equals(fieldName)) {
                    formId = "aca_matalloc";
                    if ("sca".equals(appId)) {
                        formId = "sca_matalloc";
                    }
                } else if (MatAllocRptPlugin.COL_BILLNO.equals(fieldName)) {
                    formId = "aca_matusecollect";
                    if ("sca".equals(appId)) {
                        formId = "sca_matusecollect";
                    }
                } else {
                    return;
                }
                if (CadEmptyUtils.isEmpty((String)billno)) {
                    return;
                }
                QFilter orgQF = new QFilter("org", "=", (Object)org.getLong("id"));
                QFilter allocbillnoQF = new QFilter("billno", "=", (Object)billno);
                DynamicObject allocbill = QueryServiceHelper.queryOne((String)formId, (String)"id", (QFilter[])new QFilter[]{allocbillnoQF, orgQF});
                if (CadEmptyUtils.isEmpty((DynamicObject)allocbill)) {
                    return;
                }
                Long billId = allocbill.getLong("id");
                BaseShowParameter bsp = new BaseShowParameter();
                bsp.setFormId(formId);
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bsp.setPkId((Object)billId);
                bsp.setBillStatusValue(Integer.valueOf(BillOperationStatus.VIEW.getValue()));
                bsp.setStatus(OperationStatus.VIEW);
                bsp.setCustomParam("viewOnly", (Object)"view");
                rptList.getView().showForm((FormShowParameter)bsp);
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)source;
            String key = textEdit.getKey();
            this.showStoragebillnos(key);
        }
    }

    private void showStoragebillnos(String actionId) {
        IReportView view = this.getView();
        Object value = this.getModel().getValue(actionId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setTargetKey(actionId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", value);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sca_billnos");
        if (actionId.equals(MAT_COL_BILLNO)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6\u5355\u636e\u7f16\u53f7", (String)"MatAllocRptPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
        } else if (actionId.equals(PRO_BILLNO)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u7f16\u53f7", (String)"MatAllocRptPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        MfgFeeAllocRptParam rptParam = MfgFeeAllocRptHelp.getRptParam(queryParam);
        DynamicObject costaccount = rptParam.getCostaccount();
        if (costaccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6210\u672c\u8d26\u7c3f\u540e\u518d\u67e5\u8be2\u3002", (String)"MatAllocRptPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("entityId", (Object)this.getBillEntityId());
        return super.verifyQuery(queryParam);
    }

    @Override
    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        ArrayList<String> hideFields = new ArrayList<String>();
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            hideFields.add("productgroup");
        }
        List<String> freezeFields = Arrays.asList(new String[0]);
        for (AbstractReportColumn a : cols) {
            ReportColumn reportColumn = (ReportColumn)a;
            String key = reportColumn.getFieldKey();
            if (freezeFields.contains(key)) {
                reportColumn.setFreeze(true);
            }
            if (!hideFields.contains(key)) continue;
            reportColumn.setHide(true);
        }
        super.afterCreateColumn(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        FormOperate operate = (FormOperate)evt.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "reset": {
                evt.setCancel(true);
                this.selfClean();
                break;
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2", (String)"MatAllocRptPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]), (String)"MatAllocRptPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"MatAllocRptPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]), (String)"MatAllocRptPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_matallocrpt", (String)this.getView().getFormShowParameter().getAppId());
    }

    private void selfClean() {
        this.getModel().setValue("beginperiod", null);
        this.getModel().setValue("endperiod", null);
        this.getModel().setValue("mulcostcenter", null);
        this.getModel().setValue("mulcostobejctentry", null);
        this.getModel().setValue("mulsubmat", null);
        this.getModel().setValue("mulmaterial", null);
        this.getModel().setValue(MAT_COL_BILLNO, null);
        this.getModel().setValue(PRO_BILLNO, null);
    }

    private DynamicObjectCollection getCostobject(Long orgId) {
        QFilter orgIdQF = new QFilter("org", "=", (Object)orgId);
        DynamicObjectCollection coDOC = QueryServiceHelper.query((String)"cad_costobject", (String)"id, material", (QFilter[])new QFilter[]{orgIdQF});
        return coDOC;
    }

    private String getFilterCacheKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getAccountId()).append("_");
        sb.append(RequestContext.get().getCurrUserId()).append("_");
        sb.append("sca_matallocrpt");
        return sb.toString();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        SessionManager.getCurrent().remove(this.getFilterCacheKey());
        super.beforeClosed(e);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"appnum"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
    }
}

