/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.feealloc;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.sca.common.constants.MatAllocRptParam;
import kd.macc.sca.common.helper.MatAllocRptHelp;

public class MatAllocRptQueryPlugin
extends AbstractReportListDataPlugin {
    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        MatAllocRptParam rptParam = MatAllocRptHelp.getRptParam(queryParam);
        String appnum = (String)CalcRptHelper.getFilterItemValue((FilterInfo)queryParam.getFilter(), (String)"appnum");
        String entityId = queryParam.getFilter().getString("entityId");
        DataSet allocData = this.queryAllocData(rptParam, appnum, entityId);
        return allocData;
    }

    private DataSet queryAllocData(MatAllocRptParam rptParam, String appnum, String entityId) {
        boolean acaFlag = "aca".equals(appnum);
        String fields = "id AS allocbillid, billno AS allocbillno, org AS orgnum, manuorg AS manuorgnum, costaccount AS costaccountnum, currency AS currencys, period AS periodnum, period.begindate AS begindate, bizdate AS bizdate, costcenter AS costcenternum, costcenter.number AS costcenter_num, biztype AS biztype, costdriver AS costdriver, costobject AS costobject, material AS materialnum, material.number AS material_num, matversion AS matversion, auxpty AS auxpty, lotcoderule, configuredcode, tracknumber, project, subproductnum, calckeycol, unit AS unit, entryentity.costobejctentry AS costobejctentrynum, entryentity.costobejctentry.material AS promat, entryentity.costobejctentry.auxpty AS proauxpty, entryentity.qty AS qty, entryentity.price AS price, entryentity.amount AS amount, entryentity.allocvalue AS allocvalue, matcollect AS matcollect ";
        String fieldsTwo = "id AS collectId, billno AS matcollectbillno,org AS orgnum, costcenter AS costcenternum, costcenter.number AS costcenter_num, biztype AS biztype, entryentity.id AS matcollect";
        if (acaFlag) {
            fields = fields.concat(",productgroup AS productgroup");
            fieldsTwo = fieldsTwo.concat(",entryentity.productgroup AS productgroup");
        }
        ORMImpl orm = new ORMImpl();
        List<QFilter> filters = MatAllocRptHelp.getFilters(rptParam, entityId);
        filters.add(new QFilter("appnum", "=", (Object)appnum));
        String entityName = "";
        String entityNameTwo = "";
        if ("sca".equals(appnum)) {
            entityName = "sca_matalloc";
            entityNameTwo = "sca_matusecollect";
        } else if ("aca".equals(appnum)) {
            entityName = "aca_matalloc";
            entityNameTwo = "aca_matusecollect";
        } else {
            entityName = "sca_matalloc";
            entityNameTwo = "sca_matusecollect";
        }
        DataSet dataSet = orm.queryDataSet(this.getAlgoKey("queryAllocData"), entityName, fields, filters.toArray(new QFilter[0])).orderBy(new String[]{"begindate ASC", "costcenter_num ASC", "allocbillno ASC", "material_num ASC"});
        List<QFilter> filtersTwo = MatAllocRptHelp.getFiltersTwo(rptParam);
        filtersTwo.add(new QFilter("appnum", "=", (Object)appnum));
        DataSet dataSetTwo = orm.queryDataSet(this.getAlgoKey("queryCollectData"), entityNameTwo, fieldsTwo, filtersTwo.toArray(new QFilter[0])).orderBy(new String[]{"costcenter_num ASC", "matcollectbillno ASC"});
        String columns = "allocbillid,allocbillno,orgnum,manuorgnum,costaccountnum,currencys,periodnum,begindate,bizdate,costcenternum,costcenter_num,biztype,costdriver,costobject,materialnum,material_num, matversion,auxpty,lotcoderule,configuredcode,tracknumber,project,subproductnum,calckeycol,unit,costobejctentrynum,promat,proauxpty,qty,price,amount,allocvalue";
        if (acaFlag) {
            columns = columns.concat(",productgroup");
        }
        DataSet dataSetNew = dataSet.join(dataSetTwo, JoinType.INNER).on("matcollect", "matcollect").select(columns.split(","), new String[]{"matcollectbillno"}).finish();
        return dataSetNew;
    }
}

