/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.feealloc;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.report.feealloc.BaseAllocRptPlugin;

public class MfgFeeAllocRptPlugin
extends BaseAllocRptPlugin {
    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit benefcostcenterInput = (BasedataEdit)this.getControl("benefcostcenter");
        benefcostcenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeAllocRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                QFilter qfId = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                List qFilters = filterParameter.getQFilters();
                qFilters.add(qfId);
            }
        });
        BasedataEdit beginPeriod = (BasedataEdit)this.getControl("beginperiod");
        beginPeriod.addBeforeF7SelectListener(evt -> {
            DynamicObject costAccount;
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeAllocRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (CadEmptyUtils.isEmpty((DynamicObject)(costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"MfgFeeAllocRptPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(evt -> {
            DynamicObject costAccount;
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgFeeAllocRptPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (CadEmptyUtils.isEmpty((DynamicObject)(costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"MfgFeeAllocRptPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                ReportList rptList = (ReportList)e.getSource();
                DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
                String allocbillno = row.getString("allocbillno");
                if ("".equals(allocbillno)) {
                    return;
                }
                DynamicObject org = row.getDynamicObject("orgnum");
                QFilter orgQF = new QFilter("org", "=", (Object)org.getLong("id"));
                QFilter allocbillnoQF = new QFilter("billno", "=", (Object)allocbillno);
                DynamicObjectCollection allocbill = QueryServiceHelper.query((String)"sca_mfgfeealloc", (String)"id", (QFilter[])new QFilter[]{orgQF, allocbillnoQF});
                if (allocbill.isEmpty()) {
                    return;
                }
                Long allocbillId = ((DynamicObject)allocbill.get(0)).getLong("id");
                BaseShowParameter bsp = new BaseShowParameter();
                bsp.setFormId("sca_mfgfeealloc");
                bsp.getOpenStyle().setShowType(ShowType.Modal);
                bsp.setPkId((Object)allocbillId);
                bsp.setBillStatusValue(Integer.valueOf(BillOperationStatus.VIEW.getValue()));
                rptList.getView().showForm((FormShowParameter)bsp);
            }
        });
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
    }

    @Override
    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        List<String> freezeFields = Collections.singletonList("orgnum");
        for (AbstractReportColumn a : cols) {
            ReportColumn reportColumn = (ReportColumn)a;
            String key = reportColumn.getFieldKey();
            if (!freezeFields.contains(key)) continue;
            reportColumn.setFreeze(true);
        }
        super.afterCreateColumn(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        super.afterDoOperation(evt);
        switch (key = evt.getOperateKey()) {
            case "reset": {
                this.getModel().setValue("beginperiod", null);
                this.getModel().setValue("endperiod", null);
                break;
            }
        }
    }
}

