/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class OutlayCostsDetailFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final List<String> hdieAttrFields = new ArrayList<String>(){
        {
            this.add("element");
            this.add("subelement");
        }
    };
    private static final List<String> modeloneHideFields = new ArrayList<String>(){
        {
            this.add("entryproduct");
            this.add("entryproductname");
        }
    };
    private List<String> modeltwoHideFields = new ArrayList<String>(){
        {
            this.add("costobject");
            this.add("bizstatus");
        }
    };
    private List<String> modelthreeHideFields = new ArrayList<String>(){
        {
            this.add("costcenter");
            this.add("costobject");
            this.add("bizstatus");
        }
    };
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void afterCreateColumn(CreateColumnEvent event) {
        List cols = event.getColumns();
        Iterator it = cols.iterator();
        boolean issubelement = this.getModel().getDataEntity().getBoolean("issubelement");
        int displaymodel = this.getModel().getDataEntity().getInt("displaymodel");
        AbstractReportColumn next = null;
        ReportColumn reportColumn = null;
        String key = null;
        while (it.hasNext()) {
            next = (AbstractReportColumn)it.next();
            if (!(next instanceof ReportColumn)) continue;
            reportColumn = (ReportColumn)next;
            key = reportColumn.getFieldKey();
            if (!issubelement && hdieAttrFields.contains(key)) {
                reportColumn.setHide(true);
            }
            if (displaymodel == 1 && modeloneHideFields.contains(key)) {
                reportColumn.setHide(true);
                continue;
            }
            if (displaymodel == 2 && this.modeltwoHideFields.contains(key)) {
                reportColumn.setHide(true);
                continue;
            }
            if (displaymodel != 3 || !this.modelthreeHideFields.contains(key)) continue;
            reportColumn.setHide(true);
        }
        super.afterCreateColumn(event);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("fcostcenter");
        costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costobject = (BasedataEdit)this.getControl("fcostobject");
        costobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("fperiod");
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject costAccount;
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OutlayCostsDetailFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (CadEmptyUtils.isEmpty((DynamicObject)(costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"OutlayCostsDetailFormPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)Long.valueOf(String.valueOf(accountOrg.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
            }
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        ReportQueryParam reportQueryParam = reportShowParameter.getReportQueryParam();
        if (reportQueryParam != null) {
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            return;
        }
        this.initQueryInfo();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ArrayList props = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", "fperiod"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)props);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"OutlayCostsDetailFormPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        switch (name) {
            case "org": {
                List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "costaccount": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OutlayCostsDetailFormPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter costAccountFilter = StartCostHelper.getEndInitCostAccountIdsFilter((Long)((Long)org.getPkValue()), (String)"sca");
                listShowParameter.getListFilterParameter().getQFilters().add(costAccountFilter);
                break;
            }
            case "fcostcenter": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"OutlayCostsDetailFormPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                QFilter orgFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
                orgFilter.and(new QFilter("orgduty", "=", (Object)4L));
                listShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
                break;
            }
            case "fcostobject": {
                this.setCostObjectBeforeF7Select(beforeF7SelectEvent);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.setCostAccount(newValue);
                break;
            }
            case "costaccount": {
                this.setCurrencyAndPeriod(newValue);
                break;
            }
            case "iscy": {
                if (!((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("isdetail", newValue);
                this.getModel().setValue("issubelement", newValue);
                break;
            }
            case "isdetail": {
                if (((Boolean)newValue).booleanValue()) {
                    this.getModel().setValue("issubelement", newValue);
                    break;
                }
                this.getModel().setValue("iscy", newValue);
                break;
            }
            case "issubelement": {
                if (((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("iscy", newValue);
                this.getModel().setValue("isdetail", newValue);
            }
        }
    }

    private void setCostObjectBeforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject datamodel = this.getModel().getDataEntity();
        DynamicObject org = datamodel.getDynamicObject("org");
        DynamicObjectCollection costcenters = datamodel.getDynamicObjectCollection("fcostcenter");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"OutlayCostsDetailFormPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        listShowParameter.getListFilterParameter().getQFilters().add(orgFilter);
        if (!CollectionUtils.isEmpty((Collection)costcenters)) {
            List ids = costcenters.stream().map(e -> e.get(2)).collect(Collectors.toList());
            QFilter costcenterFilter = new QFilter("costcenter", "in", ids);
            listShowParameter.getListFilterParameter().getQFilters().add(costcenterFilter);
        }
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long mainBookId = OrgHelper.getCostAccountByAccoutOrg((Long)orgDO.getLong("id"));
        if (mainBookId != null && mainBookId != 0L) {
            boolean isnit = StartCostHelper.isInit((Long)mainBookId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (isnit) {
                this.getModel().setValue("costaccount", (Object)mainBookId);
            }
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("fperiod", null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.setPeriod();
    }

    private void setPeriod() {
        Long costaccountId;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long currperiod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)(costaccountId = Long.valueOf(costaccount.getLong("id"))));
        if (currperiod != null && currperiod != 0L) {
            this.getModel().setValue("fperiod", (Object)new Object[]{currperiod});
        }
    }

    private void initQueryInfo() {
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.setCostAccount(this.getModel().getDataEntity().getDynamicObject("org"));
            this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
            this.getView().updateView();
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
    }

    protected ReportQueryParam getQueryParam() {
        return super.getQueryParam();
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        String opName = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u67e5\u8be2\uff08\u5206\u9879\u67e5\u8be2\uff09", (String)"OutlayCostsDetailFormPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]), (String)"OutlayCostsDetailFormPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]);
        String opDescription = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u67e5\u8be2\uff08\u5206\u9879\u67e5\u8be2\uff09\u6210\u529f\u3002", (String)"OutlayCostsDetailFormPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]), (String)"OutlayCostsDetailFormPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.addLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opName, (String)opDescription, (String)"sca_outlaycostsreport");
        super.afterQuery(queryParam);
    }
}

