/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.sca.common.helper.MatBaseDataFilterHelper;

public class OutlayCostsFormNewPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String[] CLEAR_STR_FIELD = new String[]{"period", "costcenter", "costobject", "bizstatus", "entryproduct"};
    private static final List<String> hdieAttrFields = new ArrayList<String>(){
        {
            this.add("elementname");
            this.add("subelement");
        }
    };
    private static final List<String> matGroupAttrFields = new ArrayList<String>(){
        {
            this.add("materialgroup");
            this.add("materialgroupname");
        }
    };
    private static final List<String> matGroupHideAttrFields = new ArrayList<String>(){
        {
            this.add("materialnumber");
            this.add("materialname");
            this.add("matversion");
            this.add("auxpty");
            this.add("baseunit");
            this.add("bookcurrency");
        }
    };
    private static final List<String> modeloneHideFields = new ArrayList<String>(){
        {
            this.add("entryproduct");
            this.add("entryproductname");
        }
    };
    private List<String> modeltwoHideFields = new ArrayList<String>(){
        {
            this.add("costobject");
            this.add("costobjectnumber");
            this.add("bizstatus");
            this.add("producttype");
        }
    };
    private List<String> modelthreeHideFields = new ArrayList<String>(){
        {
            this.add("costcenter");
            this.add("centernumber");
            this.add("costobject");
            this.add("costobjectnumber");
            this.add("bizstatus");
            this.add("producttype");
        }
    };
    private List<String> sumByPeriodHideFields = new ArrayList<String>(){
        {
            this.add("period");
        }
    };
    private List<String> diffTypes_P_Hide = new ArrayList<String>(){
        {
            this.add("startdiffqty");
            this.add("currdiffqty");
            this.add("compdiffqty");
            this.add("totaldiffqty");
            this.add("enddiffqty");
        }
    };
    private List<String> diffTypes_Q_Hide = new ArrayList<String>(){
        {
            this.add("startmadediff");
            this.add("currmadediff");
            this.add("compmadediff");
            this.add("totalmadediff");
            this.add("endmadediff");
        }
    };
    private List<String> diffTypes_S_Hide = new ArrayList<String>(){
        {
            this.add("startmadeupamt");
            this.add("currmadeupamt");
            this.add("compmadeupamt");
            this.add("totalmadeupamt");
            this.add("endmadeupamt");
        }
    };
    private List<String> diffTypes_R_Hide = new ArrayList<String>(){
        {
            this.add("startunjoindiffamt");
            this.add("currunjoindiffamt");
            this.add("compunjoindiffamt");
            this.add("totalunjoindiffamt");
            this.add("endunjoindiffamt");
        }
    };
    private List<String> diffTypes_M_Hide = new ArrayList<String>(){
        {
            this.add("startstdcostupamt");
            this.add("currstdcostupamt");
            this.add("compstdcostupamt");
            this.add("totalstdcostupamt");
            this.add("endstdcostupamt");
        }
    };
    private List<String> diffTypes_G_Hide = new ArrayList<String>(){
        {
            this.add("startorddiff");
            this.add("currorddiff");
            this.add("comporddiff");
            this.add("totalorddiff");
            this.add("endorddiff");
        }
    };
    private List<String> diffTypes_H_Hide = new ArrayList<String>(){
        {
            this.add("startinvoicediff");
            this.add("currinvoicediff");
            this.add("compinvoicediff");
            this.add("totalinvoicediff");
            this.add("endinvoicediff");
        }
    };
    private List<String> diffTypes_K_Hide = new ArrayList<String>(){
        {
            this.add("startfeediff");
            this.add("currfeediff");
            this.add("compfeediff");
            this.add("totalfeediff");
            this.add("endfeediff");
        }
    };
    private List<String> diffTypes_C_Hide = new ArrayList<String>(){
        {
            this.add("startfalldiff");
            this.add("currfalldiff");
            this.add("compfalldiff");
            this.add("totalfalldiff");
            this.add("endfalldiff");
        }
    };
    private List<String> diffTypes_T_Hide = new ArrayList<String>(){
        {
            this.add("startotherdiff");
            this.add("currotherdiff");
            this.add("compotherdiff");
            this.add("totalotherdiff");
            this.add("endotherdiff");
        }
    };

    public void afterCreateColumn(CreateColumnEvent event) {
        List cols = event.getColumns();
        Iterator it = cols.iterator();
        boolean issubelement = this.getModel().getDataEntity().getBoolean("issubelement");
        int displaymodel = this.getModel().getDataEntity().getInt("displaymodel");
        boolean isSumByPeriod = this.getModel().getDataEntity().getBoolean("issumbyperiod");
        boolean isMaterialGroup = this.getModel().getDataEntity().getBoolean("ismaterialgroup");
        boolean isDetail = this.getModel().getDataEntity().getBoolean("isdetail");
        String difftypes = this.getModel().getDataEntity().getString("difftypes");
        ArrayList diffTypeList = null;
        diffTypeList = StringUtils.isNotEmpty((String)difftypes) ? Lists.newArrayList((Object[])difftypes.split(",")) : Lists.newArrayList();
        AbstractReportColumn next = null;
        ReportColumn reportColumn = null;
        String key = null;
        while (it.hasNext()) {
            List list;
            next = (AbstractReportColumn)it.next();
            if (next instanceof ReportColumn) {
                reportColumn = (ReportColumn)next;
                key = reportColumn.getFieldKey();
                if (!issubelement && hdieAttrFields.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!isMaterialGroup && !isDetail && matGroupAttrFields.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (isMaterialGroup && matGroupHideAttrFields.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (isSumByPeriod && this.sumByPeriodHideFields.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (displaymodel == 1 && modeloneHideFields.contains(key)) {
                    reportColumn.setHide(true);
                } else if (displaymodel == 2 && this.modeltwoHideFields.contains(key)) {
                    reportColumn.setHide(true);
                } else if (displaymodel == 3 && this.modelthreeHideFields.contains(key)) {
                    reportColumn.setHide(true);
                }
            }
            if (!(next instanceof ReportColumnGroup)) continue;
            ReportColumnGroup rcg = (ReportColumnGroup)next;
            if (isSumByPeriod && ("entryfieldgroupap2".equals(rcg.getFieldKey()) || "entryfieldgroupap4".equals(rcg.getFieldKey()) || "entryfieldgroupap".equals(rcg.getFieldKey()))) {
                list = rcg.getChildren();
                for (AbstractReportColumn abstractReportColumn : list) {
                    if (!(abstractReportColumn instanceof ReportColumn)) continue;
                    reportColumn = (ReportColumn)abstractReportColumn;
                    reportColumn.setHide(true);
                }
                continue;
            }
            list = rcg.getChildren();
            for (AbstractReportColumn abstractReportColumn : list) {
                if (!(abstractReportColumn instanceof ReportColumn)) continue;
                reportColumn = (ReportColumn)abstractReportColumn;
                key = reportColumn.getFieldKey();
                if (!diffTypeList.contains("P") && this.diffTypes_P_Hide.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!diffTypeList.contains("Q") && this.diffTypes_Q_Hide.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!diffTypeList.contains("S") && this.diffTypes_S_Hide.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!diffTypeList.contains("R") && this.diffTypes_R_Hide.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!diffTypeList.contains("M") && this.diffTypes_M_Hide.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!diffTypeList.contains("G") && this.diffTypes_G_Hide.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!diffTypeList.contains("H") && this.diffTypes_H_Hide.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!diffTypeList.contains("K") && this.diffTypes_K_Hide.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!diffTypeList.contains("C") && this.diffTypes_C_Hide.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (diffTypeList.contains("T") || !this.diffTypes_T_Hide.contains(key)) continue;
                reportColumn.setHide(true);
            }
        }
        super.afterCreateColumn(event);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgs = (BasedataEdit)this.getControl("org");
        orgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("fcostcenter");
        costcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costobject = (BasedataEdit)this.getControl("fcostobject");
        costobject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit beginPeriod = (BasedataEdit)this.getControl("startperiod");
        beginPeriod.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OutlayCostsFormNewPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection costAccount = (DynamicObjectCollection)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"OutlayCostsFormNewPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            HashSet<Long> orgIdSet = new HashSet<Long>();
            org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
            HashSet<Long> accountIdSet = new HashSet<Long>();
            costAccount.forEach(c -> accountIdSet.add(c.getDynamicObject("fbasedataid").getLong("id")));
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter filter = OutlayCostsFormNewPlugin.getPeriodTypeFilter(this.getView().getFormShowParameter().getAppId(), orgIdSet, accountIdSet);
            if (filter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"OutlayCostsFormNewPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(filter);
            this.getStartPeriodFilter(qFilters, accountIdSet);
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OutlayCostsFormNewPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection costAccount = (DynamicObjectCollection)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"OutlayCostsFormNewPlugin_1", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            HashSet<Long> orgIdSet = new HashSet<Long>();
            org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
            HashSet<Long> accountIdSet = new HashSet<Long>();
            costAccount.forEach(c -> accountIdSet.add(c.getDynamicObject("fbasedataid").getLong("id")));
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter filter = OutlayCostsFormNewPlugin.getPeriodTypeFilter(this.getView().getFormShowParameter().getAppId(), orgIdSet, accountIdSet);
            if (filter == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"OutlayCostsFormNewPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(filter);
            this.getStartPeriodFilter(qFilters, accountIdSet);
        });
        BasedataEdit products = (BasedataEdit)this.getControl("materials");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("org");
            HashSet orgIds = new HashSet();
            org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OutlayCostsFormNewPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject materialGrpStdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialGrpStdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"OutlayCostsFormNewPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgIds)));
            DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            if (!CollectionUtils.isEmpty((Collection)mulmaterialGroup) || materialGroupStandard.getLong("id") != 730148448254487552L) {
                QFilter classifiedMaterialIdFilter = new QFilter("id", "in", (Object)MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)mulmaterialGroup, (boolean)false, (DynamicObject)materialGroupStandard));
                qFilters.add(classifiedMaterialIdFilter);
            }
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("org");
            ArrayList orgIds = new ArrayList();
            org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OutlayCostsFormNewPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", orgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("org");
            ArrayList orgIds = new ArrayList();
            org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"OutlayCostsFormNewPlugin_3", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OutlayCostsFormNewPlugin_4", (String)"macc-sca-form", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", orgIds, materialgrpstdObj.getPkValue(), true});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap params = new HashMap(2);
            params.put("useOrgs", orgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit costCenterInput = (BasedataEdit)this.getControl("fcostcenter");
        costCenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
            if (org.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"OutlayCostsFormNewPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                HashSet orgIdSet = new HashSet();
                org.forEach(o -> orgIdSet.add(o.getDynamicObject("fbasedataid").getLong("id")));
                QFilter qfId = null;
                for (Long orgId : orgIdSet) {
                    QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList((long)orgId, null, (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId());
                    if (qfId != null) {
                        qfId = qfId.or(costCenterIdFilter);
                        continue;
                    }
                    qfId = costCenterIdFilter;
                }
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                QFilter qfNumber = new QFilter("orgduty.number", "=", (Object)"4");
                List qFilters = filterParameter.getQFilters();
                if (qfId != null) {
                    qFilters.add(qfId);
                }
                qFilters.add(qfNumber);
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        ReportQueryParam reportQueryParam = reportShowParameter.getReportQueryParam();
        if (reportQueryParam != null) {
            this.getModel().setValue("materialgrpstd", (Object)730148448254487552L);
            boolean isDetail = this.getModel().getDataEntity().getBoolean("isdetail");
            this.getView().setEnable(Boolean.valueOf(isDetail), new String[]{"materialgrpstd"});
            this.getView().setEnable(Boolean.valueOf(isDetail), new String[]{"mulmaterialgroup"});
            this.getView().setEnable(Boolean.valueOf(isDetail), new String[]{"materials"});
            return;
        }
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("org");
        if (!org.isEmpty()) {
            return;
        }
        this.initQueryInfo();
        boolean isDetail = this.getModel().getDataEntity().getBoolean("isdetail");
        this.getView().setEnable(Boolean.valueOf(isDetail), new String[]{"materialgrpstd"});
        this.getView().setEnable(Boolean.valueOf(isDetail), new String[]{"mulmaterialgroup"});
        this.getView().setEnable(Boolean.valueOf(isDetail), new String[]{"materials"});
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean isPass;
        ArrayList props = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", "startperiod", "endperiod"});
        boolean isDetail = this.getModel().getDataEntity().getBoolean("isdetail");
        if (isDetail) {
            props.add("materialgrpstd");
        }
        if (!(isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)props))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"OutlayCostsFormNewPlugin_6", (String)"macc-sca-form", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("org");
        HashSet<Long> orgIds = new HashSet<Long>();
        org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
        switch (name) {
            case "org": {
                List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIdsByPermItem((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"47150e89000000ac");
                Set<Long> orgs = this.getStandCostOrgs(hasPermAccountOrgIds);
                QFilter idFilter = new QFilter("id", "in", orgs);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                if (orgs.size() > 50) break;
                listShowParameter.setCustomParam("isIncludeAllSub", (Object)true);
                break;
            }
            case "costaccount": {
                if (org.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"OutlayCostsFormNewPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", this.getCostAccountIds(orgIds)));
                break;
            }
            case "fcostobject": {
                this.setCostObjectBeforeF7Select(beforeF7SelectEvent);
            }
        }
    }

    private Set<Long> getStandCostOrgs(List<Long> hasPermAccountOrgIds) {
        QFilter filter = new QFilter("org", "in", hasPermAccountOrgIds);
        filter.and("appnum", "=", (Object)"sca");
        HashSet<Long> orgSet = new HashSet<Long>(16);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org", (QFilter[])new QFilter[]{filter});
        if (dynamicObjects.isEmpty()) {
            orgSet.add(-1L);
            return orgSet;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            orgSet.add(dynamicObject.getLong("org"));
        }
        return orgSet;
    }

    private Set<Long> getCostAccountIds(Set<Long> orgIds) {
        HashSet<Long> costIds = new HashSet<Long>();
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("reductstrategy", "=", (Object)"ITEMIZED_REDUCT");
        filter.and("tab", "=", (Object)"costaccounttabpage");
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)"costaccount.id as costAccountId", (QFilter[])new QFilter[]{filter});
        if (sysParams.isEmpty()) {
            costIds.add(-1L);
        }
        sysParams.forEach(s -> costIds.add(s.getLong("costAccountId")));
        return costIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.getModel().setValue("costaccount", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("startperiod", null);
                this.getModel().setValue("endperiod", null);
                this.getModel().setValue("fcostcenter", null);
                this.getModel().setValue("fcostobject", null);
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setCurrencyAndPeriod();
                break;
            }
            case "isdetail": {
                if (((Boolean)newValue).booleanValue()) {
                    this.getModel().setValue("issubelement", newValue);
                }
                if (!((Boolean)newValue).booleanValue()) {
                    this.getModel().setValue("ismaterialgroup", newValue);
                    this.getModel().setValue("materialgrpstd", (Object)730148448254487552L);
                    this.getModel().setValue("mulmaterialgroup", null);
                    this.getModel().setValue("materials", null);
                }
                this.getView().setEnable((Boolean)newValue, new String[]{"materialgrpstd"});
                this.getView().setEnable((Boolean)newValue, new String[]{"mulmaterialgroup"});
                this.getView().setEnable((Boolean)newValue, new String[]{"materials"});
                break;
            }
            case "issubelement": {
                if (((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("isdetail", newValue);
                this.getModel().setValue("ismaterialgroup", newValue);
                break;
            }
            case "ismaterialgroup": {
                if (!((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("issubelement", newValue);
                this.getModel().setValue("isdetail", newValue);
                break;
            }
            case "startperiod": {
                this.setPeriodRange("begin");
                break;
            }
            case "endperiod": {
                this.setPeriodRange("end");
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                this.getModel().setValue("materials", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("materials", null);
                break;
            }
            case "bizstatus": {
                this.getModel().setValue("fcostobject", null);
            }
        }
    }

    public void setPeriodRange(String flag) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject beginperiod = dataEntity.getDynamicObject("startperiod");
        DynamicObject endperiod = dataEntity.getDynamicObject("endperiod");
        if (beginperiod == null || endperiod == null) {
            return;
        }
        if (beginperiod.getDate("begindate").compareTo(endperiod.getDate("begindate")) <= 0) {
            return;
        }
        if ("begin".equals(flag)) {
            this.getModel().setValue("endperiod", (Object)beginperiod);
        } else if ("end".equals(flag)) {
            this.getModel().setValue("startperiod", (Object)endperiod);
        }
    }

    private void setCostObjectBeforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject dataModel = this.getModel().getDataEntity();
        DynamicObjectCollection org = dataModel.getDynamicObjectCollection("org");
        DynamicObjectCollection costCenter = dataModel.getDynamicObjectCollection("fcostcenter");
        String bizstatus = dataModel.getString("fbizstatus");
        if (org.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u8ba4\u6838\u7b97\u7ec4\u7ec7\u540e\u518d\u9009\u62e9\u3002", (String)"OutlayCostsFormNewPlugin_5", (String)"macc-sca-form", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        HashSet orgIds = new HashSet();
        org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
        QFilter filter = new QFilter("org", "in", orgIds);
        if (!CollectionUtils.isEmpty((Collection)costCenter)) {
            HashSet centerId = new HashSet();
            costCenter.forEach(o -> centerId.add(o.getDynamicObject("fbasedataid").getLong("id")));
            filter.and(new QFilter("costcenter", "in", centerId));
        }
        if ("A".equals(bizstatus) || "B".equals(bizstatus)) {
            filter.and(new QFilter("bizstatus", "=", (Object)bizstatus));
        }
        listShowParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void setCurrencyAndPeriod() {
        this.setCurrency();
        this.setPeriod();
    }

    public void setCurrency() {
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        if (dynamicObjects.isEmpty()) {
            this.getModel().setValue("currency", null);
            return;
        }
        HashSet<Long> calpolicys = new HashSet<Long>();
        for (DynamicObject row : dynamicObjects) {
            DynamicObject dynamicObject = row.getDynamicObject("fbasedataid").getDynamicObject("calpolicy");
            if (dynamicObject == null) continue;
            calpolicys.add(dynamicObject.getLong("id"));
        }
        if (calpolicys.isEmpty()) {
            this.getModel().setValue("currency", null);
            return;
        }
        HashSet<Long> currencyIds = new HashSet<Long>();
        DynamicObjectCollection objectCollection = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicys)});
        for (DynamicObject dynamicObject : objectCollection) {
            currencyIds.add(dynamicObject.getLong("currency"));
        }
        if (currencyIds.size() == 0) {
            this.getModel().setValue("currency", null);
            return;
        }
        if (currencyIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5e01\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u5e01\u522b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"OutlayCostsFormNewPlugin_7", (String)"macc-sca-form", (Object[])new Object[0]));
            this.getModel().setValue("costaccount", null);
            this.getView().updateView("costaccount");
            return;
        }
        this.getModel().setValue("currency", currencyIds.toArray()[0]);
        this.getView().updateView("currency");
    }

    public void setPeriod() {
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("org");
        DynamicObjectCollection account = (DynamicObjectCollection)this.getModel().getValue("costaccount");
        HashSet orgIds = new HashSet();
        HashSet costAccountIds = new HashSet();
        org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
        account.forEach(c -> costAccountIds.add(c.getDynamicObject("fbasedataid").getLong("id")));
        if (orgIds.isEmpty() || costAccountIds.isEmpty()) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            return;
        }
        QFilter orgQF = new QFilter("org", "in", orgIds);
        QFilter costAccountQF = new QFilter("entry.costaccount", "in", costAccountIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id,entry.calpolicy.periodtype as periodtype, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costAccountQF});
        if (dynamicObjects.isEmpty()) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
        } else {
            HashSet<Long> periods = new HashSet<Long>();
            HashSet periodTypes = Sets.newHashSetWithExpectedSize((int)4);
            for (DynamicObject dynamicObject : dynamicObjects) {
                periods.add(dynamicObject.getLong("currentperiod"));
                periodTypes.add(dynamicObject.getLong("periodtype"));
            }
            if (periodTypes.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u671f\u95f4\u7c7b\u578b\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"OutlayCostsFormNewPlugin_2", (String)"macc-sca-form", (Object[])new Object[0]));
                this.getModel().setValue("startperiod", null);
                this.getModel().setValue("endperiod", null);
            } else if (periods.size() == 1) {
                this.getModel().setValue("startperiod", periods.toArray()[0]);
                this.getModel().setValue("endperiod", periods.toArray()[0]);
            } else {
                this.getModel().setValue("startperiod", null);
                this.getModel().setValue("endperiod", null);
            }
        }
        this.getView().updateView("startperiod");
        this.getView().updateView("endperiod");
    }

    private void initQueryInfo() {
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isAccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isAccount && PermItemCheckHelper.isPerm((String)this.getBillEntityId(), (String)"47150e89000000ac", (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()), (Long)currentOrgId)) {
            this.getModel().setValue("org", (Object)new Object[]{currentOrgId});
            this.setCostAccount();
            this.getView().updateView();
        }
    }

    public void setCostAccount() {
        IDataModel model = this.getModel();
        DynamicObjectCollection org = (DynamicObjectCollection)model.getValue("org");
        if (CollectionUtils.isEmpty((Collection)org)) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>();
        org.forEach(o -> orgIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
        DynamicObjectCollection costAccounts = this.getCostAccount(orgIds);
        HashMap<Long, DynamicObjectCollection> orgAndCostMap = new HashMap<Long, DynamicObjectCollection>();
        for (Object costAccount : costAccounts) {
            orgAndCostMap.computeIfAbsent(costAccount.getLong("orgid"), r -> new DynamicObjectCollection()).add(costAccount);
        }
        ArrayList<Long> accountIds = new ArrayList<Long>();
        block1: for (Map.Entry entry : orgAndCostMap.entrySet()) {
            DynamicObjectCollection values = (DynamicObjectCollection)entry.getValue();
            if (values.size() == 1) {
                accountIds.add(((DynamicObject)values.get(0)).getLong("accountid"));
                continue;
            }
            for (DynamicObject value : values) {
                if (!value.getBoolean("ismainaccount")) continue;
                accountIds.add(value.getLong("accountid"));
                continue block1;
            }
        }
        QFilter orgQF = new QFilter("org", "in", orgIds);
        QFilter qFilter = new QFilter("entry.costaccount", "in", accountIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, qFilter});
        HashSet periods = new HashSet();
        if (!dynamicObjects.isEmpty()) {
            dynamicObjects.forEach(dynamicObject -> periods.add(dynamicObject.getLong("currentperiod")));
        }
        if (accountIds.isEmpty() || periods.size() > 1) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        Set<Long> costAccountIds = this.getCostAccountIds(orgIds);
        Set collectIds = accountIds.stream().filter(costAccountIds::contains).collect(Collectors.toSet());
        if (collectIds.isEmpty()) {
            this.getModel().setValue("costaccount", null);
            return;
        }
        model.setValue("costaccount", (Object)collectIds.toArray());
        this.getView().updateView("costaccount");
        this.setCurrencyAndPeriod();
    }

    public DynamicObjectCollection getCostAccount(Set<Long> orgIds) {
        QFilter accountorgQF = new QFilter("org", "in", orgIds);
        QFilter enablestdtQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org.id as orgid,entryentity.costaccount.id as accountid,entryentity.costaccount.ismainaccount as ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF});
        return result;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Boolean mergesame = (Boolean)this.getModel().getValue("mergesame");
        if (mergesame.booleanValue()) {
            Object[] clearStrArr = CLEAR_STR_FIELD;
            ArrayList clearList = Lists.newArrayList((Object[])clearStrArr);
            boolean issubelement = this.getModel().getDataEntity().getBoolean("issubelement");
            int displaymodel = this.getModel().getDataEntity().getInt("displaymodel");
            boolean isSumByPeriod = this.getModel().getDataEntity().getBoolean("issumbyperiod");
            if (!issubelement) {
                clearList.removeAll(hdieAttrFields);
            }
            if (isSumByPeriod) {
                clearList.removeAll(this.sumByPeriodHideFields);
            }
            if (displaymodel == 1) {
                clearList.removeAll(modeloneHideFields);
            } else if (displaymodel == 2) {
                clearList.removeAll(this.modeltwoHideFields);
            } else if (displaymodel == 3) {
                clearList.removeAll(this.modelthreeHideFields);
            }
            ReportUtils.clearFileNameValue((String[])clearList.toArray(new String[0]), (DynamicObjectCollection)rowData, (String[])clearList.toArray(new String[0]));
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
    }

    protected ReportQueryParam getQueryParam() {
        return super.getQueryParam();
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
    }

    public static QFilter getPeriodTypeFilter(String appNum, Set<Long> orgId, Set<Long> costAccountId) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfOrg = new QFilter("org", "in", orgId);
        QFilter qfCostAccount = new QFilter("entryentity.costaccount", "in", costAccountId);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype", (QFilter[])new QFilter[]{qfAppNum, qfOrg, qfCostAccount});
        if (result.isEmpty()) {
            return new QFilter("periodtype", ">", (Object)0L);
        }
        HashSet<Long> periodTypeIds = new HashSet<Long>();
        for (DynamicObject row : result) {
            periodTypeIds.add(row.getLong("periodtype"));
        }
        if (periodTypeIds.size() > 1) {
            return null;
        }
        return new QFilter("periodtype", "in", periodTypeIds);
    }

    private void getStartPeriodFilter(List<QFilter> qFilters, Set<Long> costAccountId) {
        QFilter filter = new QFilter("entry.costaccount", "in", costAccountId);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])filter.toArray());
        if (result.isEmpty()) {
            qFilters.add(new QFilter("id", "=", (Object)-1L));
            return;
        }
        long startPeriod = ((DynamicObject)result.get(0)).getLong("startperiod");
        for (DynamicObject dynamicObject : result) {
            long period = dynamicObject.getLong("startperiod");
            if (period >= startPeriod) continue;
            startPeriod = period;
        }
        long lastPeriod = ((DynamicObject)result.get(0)).getLong("currentperiod");
        for (DynamicObject dynamicObject : result) {
            long period = dynamicObject.getLong("currentperiod");
            if (period <= lastPeriod) continue;
            lastPeriod = period;
        }
        qFilters.add(new QFilter("id", ">=", (Object)startPeriod));
    }
}

