/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report.restore;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.report.restore.MapKeyComparator;

public class OutlayCostsQueryPlugin
extends AbstractReportListDataPlugin {
    protected static final Log logger = LogFactory.getLog(OutlayCostsQueryPlugin.class);
    private static Integer amtprecision = 10;
    private static final String[] qtyFields = new String[]{"startqtys", "currqtys", "compqtys", "endqtys", "totalqtys"};
    private static final String[] startFields = new String[]{"startqty", "startamt", "startdiffqty", "startmadediff", "startmadeupamt", "startunjoindiffamt", "startstdcostupamt", "startorddiff", "startinvoicediff", "startfeediff", "startfalldiff", "startotherdiff", "startactcostupamt"};
    private static final String[] currFields = new String[]{"currqty", "curramt", "currdiffqty", "currmadediff", "currmadeupamt", "currunjoindiffamt", "currstdcostupamt", "currorddiff", "currinvoicediff", "currfeediff", "currfalldiff", "currotherdiff", "curractcostupamt"};
    private static final String[] compFields = new String[]{"compqty", "compamt", "compdiffqty", "compmadediff", "compmadeupamt", "compunjoindiffamt", "compstdcostupamt", "comporddiff", "compinvoicediff", "compfeediff", "compfalldiff", "compotherdiff", "compactcostupamt"};
    private static final String[] endFields = new String[]{"endqty", "endamt", "enddiffqty", "endmadediff", "endmadeupamt", "endunjoindiffamt", "endstdcostupamt", "endorddiff", "endinvoicediff", "endfeediff", "endfalldiff", "endotherdiff", "endactcostupamt"};
    private static final String[] totalFields = new String[]{"totalqty", "totalamt", "totaldiffqty", "totalmadediff", "totalmadeupamt", "totalunjoindiffamt", "totalstdcostupamt", "totalorddiff", "totalinvoicediff", "totalfeediff", "totalfalldiff", "totalotherdiff", "totalactcostupamt"};

    private void addfields(Object obj, String[] fields) {
        if (obj instanceof StringBuilder) {
            for (int i = 0; i < fields.length; ++i) {
                ((StringBuilder)obj).append(",").append(fields[i]);
            }
        }
    }

    private void sumfields(GroupbyDataSet obj, String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            obj.sum(fields[i]);
        }
    }

    private void sumRowFields(String[] fields, Object[] row, Object[] sumRow) {
        String field = null;
        for (int j = 0; j < fields.length; ++j) {
            field = fields[j];
            sumRow[this.getListFieldIndex((String)field)] = this.getAmt(sumRow, field).add(this.getAmt(row, field));
        }
    }

    private void maxfields(GroupbyDataSet obj, String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            obj.max(fields[i]);
        }
    }

    public static Object getFilterItemValue(FilterInfo filterInfo, String propName) {
        FilterItemInfo filterItem = filterInfo.getFilterItem(propName);
        if (filterItem != null && filterItem.getValue() != null) {
            Object value = filterItem.getValue();
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                return values.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            return value;
        }
        return null;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        QFilter filter = OutlayCostsQueryPlugin.getQFilter(reportQueryParam);
        ORM orm = ORM.create();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
        String selectFields = this.getQueryFields();
        DataSet leftDataSet = orm.queryDataSet(algoKey, "sca_diffcalcresult", selectFields, filter.toArray());
        if (!(this.isSubelement() || this.isDetail() || this.iscy())) {
            List<Object[]> dataList = this.getListData(leftDataSet);
            return Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), this.getRowMeta());
        }
        if (this.isSubelement()) {
            return this.isSubelement(leftDataSet, reportQueryParam);
        }
        return leftDataSet;
    }

    private DataSet getExpenseItemSubelemenDataSet(int displaymodel, ReportQueryParam reportQueryParam) {
        ORM orm = ORM.create();
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("period,entryentity.element element,entryentity.subelement subelement,entryentity.allocamt allocamt,expenseitem,expenseitem.name expenseitemname");
        if (displaymodel == 1) {
            selectFields.append(",benefcostcenter,entryentity.costobject costobject,entryentity.costobject.bizstatus");
        } else if (displaymodel == 2) {
            selectFields.append(",benefcostcenter,entryentity.costobject.material AS entryproduct,entryentity.costobject costobject");
        } else if (displaymodel == 3) {
            selectFields.append(",entryentity.costobject.material AS entryproduct,entryentity.costobject costobject");
        }
        QFilter qFilters = OutlayCostsQueryPlugin.getQFilters(reportQueryParam);
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
        DataSet subSelect = orm.queryDataSet(algoKey, "sca_mfgfeeallocco", selectFields.toString(), qFilters.toArray());
        StringBuilder groupFields = new StringBuilder();
        groupFields.append("period,element,subelement,expenseitem,expenseitemname");
        if (displaymodel == 1) {
            groupFields.append(",benefcostcenter,costobject");
        } else if (displaymodel == 2) {
            groupFields.append(",benefcostcenter,entryproduct,costobject");
        } else if (displaymodel == 3) {
            groupFields.append(",entryproduct,costobject");
        }
        String[] groupFieldArr = groupFields.toString().split(",");
        GroupbyDataSet groupBy = subSelect.groupBy(groupFieldArr).sum("allocamt");
        selectFields.setLength(0);
        selectFields.append("period,element,subelement,expenseitem,expenseitemname,allocamt");
        if (displaymodel == 1) {
            selectFields.append(",benefcostcenter,costobject");
        } else if (displaymodel == 2) {
            selectFields.append(",benefcostcenter,entryproduct");
        } else if (displaymodel == 3) {
            selectFields.append(",entryproduct");
        }
        DataSet select = null;
        if (displaymodel == 2 || displaymodel == 3) {
            DataSet ds = groupBy.finish();
            List<String> grouplist = Arrays.stream(groupFieldArr).collect(Collectors.toList());
            grouplist.remove("costobject");
            GroupbyDataSet allgs = ds.groupBy(grouplist.toArray(new String[0]));
            allgs.sum("allocamt");
            select = allgs.finish().select(selectFields.toString());
        } else {
            select = groupBy.finish().select(selectFields.toString());
        }
        return select;
    }

    private DataSet isSubelement(DataSet leftDataSet, ReportQueryParam reportQueryParam) {
        boolean isDetail = this.isDetail();
        boolean iscy = this.iscy();
        int displaymodel = this.displaymodel();
        StringBuilder cos = new StringBuilder();
        cos.append("period,periodnumber");
        if (displaymodel == 1) {
            cos.append(",costcenter,costcenternumber,costobject,costobjectbillno,bizstatus");
        } else if (displaymodel == 2) {
            cos.append(",costcenter,costcenternumber,entryproduct,productnumber");
        } else if (displaymodel == 3) {
            cos.append(",entryproduct,productnumber");
        }
        cos.append(",element,elementnumber,elementname,subelement,subelementnumber,subelementname,bookcurrency");
        this.addfields(cos, startFields);
        this.addfields(cos, currFields);
        this.addfields(cos, compFields);
        this.addfields(cos, endFields);
        this.addfields(cos, totalFields);
        ArrayList<String> grouplist = new ArrayList<String>(10);
        grouplist.add("period");
        grouplist.add("periodnumber");
        if (displaymodel == 1) {
            grouplist.add("costcenter");
            grouplist.add("costcenternumber");
            grouplist.add("costobject");
            grouplist.add("costobjectbillno");
            grouplist.add("bizstatus");
        } else if (displaymodel == 2) {
            grouplist.add("costcenter");
            grouplist.add("costcenternumber");
            grouplist.add("entryproduct");
            grouplist.add("productnumber");
        } else if (displaymodel == 3) {
            grouplist.add("entryproduct");
            grouplist.add("productnumber");
        }
        grouplist.add("element");
        grouplist.add("elementnumber");
        grouplist.add("elementname");
        grouplist.add("subelement");
        grouplist.add("subelementnumber");
        grouplist.add("subelementname");
        grouplist.add("bookcurrency");
        ArrayList<String> order = new ArrayList<String>();
        order.add("elementnumber");
        order.add("subelementnumber");
        if (isDetail) {
            cos = cos.append(",material,materialnumber,materialname,matversion,auxpty,baseunit");
            grouplist.add("material");
            grouplist.add("materialnumber");
            grouplist.add("materialname");
            grouplist.add("matversion");
            grouplist.add("auxpty");
            grouplist.add("baseunit");
            order.add("materialnumber");
        }
        GroupbyDataSet groupBy = leftDataSet.groupBy(grouplist.toArray(new String[0]));
        this.sumfields(groupBy, startFields);
        this.sumfields(groupBy, currFields);
        this.sumfields(groupBy, compFields);
        this.sumfields(groupBy, endFields);
        this.sumfields(groupBy, totalFields);
        DataSet select = groupBy.finish().select(cos.toString()).orderBy(order.toArray(new String[0]));
        if (iscy) {
            order.add("expenseitem");
            DataSet select2 = this.getExpenseItemSubelemenDataSet(displaymodel, reportQueryParam);
            if (displaymodel == 1) {
                select = select.copy().filter("material=0 or material is null").leftJoin(select2).on("period", "period").on("costcenter", "benefcostcenter").on("element", "element").on("subelement", "subelement").on("costobject", "costobject").select(cos.toString().split(","), new String[]{"allocamt", "expenseitem", "expenseitemname"}).finish().union(select.filter("material<>0 and material is not null").select(cos.append(",null AS allocamt,null AS expenseitem,null as expenseitemname").toString())).orderBy(order.toArray(new String[0]));
            } else if (displaymodel == 2) {
                select = select.copy().filter("material=0 or material is null").leftJoin(select2).on("period", "period").on("costcenter", "benefcostcenter").on("element", "element").on("subelement", "subelement").on("entryproduct", "entryproduct").select(cos.toString().split(","), new String[]{"allocamt", "expenseitem", "expenseitemname"}).finish().union(select.filter("material<>0 and material is not null").select(cos.append(",null AS allocamt,null AS expenseitem,null as expenseitemname").toString())).orderBy(order.toArray(new String[0]));
            } else if (displaymodel == 3) {
                select = select.copy().filter("material=0 or material is null").leftJoin(select2).on("period", "period").on("element", "element").on("subelement", "subelement").on("entryproduct", "entryproduct").select(cos.toString().split(","), new String[]{"allocamt", "expenseitem", "expenseitemname"}).finish().union(select.filter("material<>0 and material is not null").select(cos.append(",null AS allocamt,null AS expenseitem,null as expenseitemname").toString())).orderBy(order.toArray(new String[0]));
            }
        }
        Map<String, List<Object[]>> map = this.addMap(select);
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        ArrayList<Map.Entry<String, List<Object[]>>> entryList = new ArrayList<Map.Entry<String, List<Object[]>>>(map.entrySet());
        Collections.sort(entryList, new MapKeyComparator());
        Iterator iter = entryList.iterator();
        Map.Entry tmpEntry = null;
        List items = null;
        String periodId = null;
        String costcenterId = null;
        String costobjectId = null;
        String bizstatus = null;
        String productId = null;
        String bookcurrency = null;
        Object[] countRowData = null;
        Object[] row = null;
        HashMap<String, BigDecimal> allocamtMap = null;
        HashMap<String, BigDecimal> absAllocamtMap = null;
        String subkey = null;
        BigDecimal allocam = BigDecimal.ZERO;
        Map<Object, Map<Object, BigDecimal[]>> proqtys = OutlayCostsQueryPlugin.getProductQtys(reportQueryParam);
        Map costobjectMap = new HashMap(8);
        HashMap costObInfoMap = new HashMap(16);
        HashMap costObMatInfoMap = new HashMap(16);
        QFilter costobQF = new QFilter("material.masterid", "in", proqtys.keySet());
        DynamicObjectCollection costObQuery = QueryServiceHelper.query((String)"cad_costobjectf7", (String)"id,material.masterid,material.name,material.baseunit.id,bomversion,auxpty", (QFilter[])new QFilter[]{costobQF});
        for (DynamicObject query : costObQuery) {
            HashMap<String, String> result = new HashMap<String, String>(8);
            result.put("costobject", query.getString("id"));
            result.put("material", query.getString("material.name"));
            result.put("matversion", query.getString("bomversion"));
            result.put("auxpty", query.getString("auxpty"));
            result.put("baseunit", query.getString("material.baseunit.id"));
            costObInfoMap.put(query.getString("id"), result);
            costObMatInfoMap.put(query.getString("material.masterid"), result);
        }
        while (iter.hasNext()) {
            ArrayList<BigDecimal[]> cqtys;
            Map<Object, BigDecimal[]> pmap;
            BigDecimal[] qtys;
            tmpEntry = (Map.Entry)iter.next();
            items = (List)tmpEntry.getValue();
            String[] keys = ((String)tmpEntry.getKey()).split("@");
            periodId = keys[0];
            costcenterId = keys[1];
            countRowData = new Object[this.getRowMeta().getFields().length];
            countRowData[this.getListFieldIndex((String)"period")] = periodId;
            countRowData[this.getListFieldIndex((String)"element")] = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"OutlayCostsQueryPlugin_0", (String)"macc-sca-form", (Object[])new Object[0]);
            if (displaymodel == 1) {
                costobjectId = keys[2];
                bizstatus = keys[3];
                bookcurrency = keys[4];
                costobjectMap = (Map)costObInfoMap.get(costobjectId);
                countRowData[this.getListFieldIndex((String)"costobject")] = costobjectMap.get("costobject");
                countRowData[this.getListFieldIndex((String)"bizstatus")] = bizstatus;
                countRowData[this.getListFieldIndex((String)"bookcurrency")] = bookcurrency;
                countRowData[this.getListFieldIndex((String)"material")] = costobjectMap.get("material");
                countRowData[this.getListFieldIndex((String)"matversion")] = costobjectMap.get("matversion");
                countRowData[this.getListFieldIndex((String)"auxpty")] = costobjectMap.get("auxpty");
                countRowData[this.getListFieldIndex((String)"baseunit")] = costobjectMap.get("baseunit");
                countRowData[this.getListFieldIndex((String)"costcenter")] = costcenterId;
            } else if (displaymodel == 2) {
                productId = keys[2];
                bookcurrency = keys[3];
                costobjectMap = (Map)costObMatInfoMap.get(productId);
                if (costobjectMap != null) {
                    countRowData[this.getListFieldIndex((String)"entryproduct")] = productId;
                    countRowData[this.getListFieldIndex((String)"bookcurrency")] = bookcurrency;
                    countRowData[this.getListFieldIndex((String)"material")] = costobjectMap.get("material");
                    countRowData[this.getListFieldIndex((String)"matversion")] = costobjectMap.get("matversion");
                    countRowData[this.getListFieldIndex((String)"auxpty")] = costobjectMap.get("auxpty");
                    countRowData[this.getListFieldIndex((String)"baseunit")] = costobjectMap.get("baseunit");
                }
                countRowData[this.getListFieldIndex((String)"costcenter")] = costcenterId;
            } else if (displaymodel == 3) {
                productId = keys[1];
                bookcurrency = keys[2];
                costobjectMap = (Map)costObMatInfoMap.get(productId);
                if (costobjectMap != null) {
                    countRowData[this.getListFieldIndex((String)"entryproduct")] = productId;
                    countRowData[this.getListFieldIndex((String)"bookcurrency")] = bookcurrency;
                    countRowData[this.getListFieldIndex((String)"material")] = costobjectMap.get("material");
                    countRowData[this.getListFieldIndex((String)"matversion")] = costobjectMap.get("matversion");
                    countRowData[this.getListFieldIndex((String)"auxpty")] = costobjectMap.get("auxpty");
                    countRowData[this.getListFieldIndex((String)"baseunit")] = costobjectMap.get("baseunit");
                }
            }
            dataList.add(countRowData);
            allocamtMap = new HashMap<String, BigDecimal>();
            absAllocamtMap = new HashMap<String, BigDecimal>();
            if (iscy) {
                logger.info("OutlayCostsQueryPlugin.log\u8ba1\u7b97\u4e4b\u524d\u7ef4\u5ea6\uff1aperiod=" + periodId + "costcenter=" + costcenterId + "entryproduct=" + productId + "costobject=" + costobjectId);
                for (int i = 0; i < items.size(); ++i) {
                    row = (Object[])items.get(i);
                    subkey = row[this.getListFieldIndex("element")] + "@" + row[this.getListFieldIndex("subelement")];
                    allocam = allocamtMap.computeIfAbsent(subkey, k -> BigDecimal.ZERO);
                    allocam = allocam.add(this.getAmt(row, "allocamt"));
                    allocamtMap.put(subkey, allocam);
                }
                for (Map.Entry entry : allocamtMap.entrySet()) {
                    logger.info("OutlayCostsQueryPlugin.log\u6210\u672c\u5b50\u8981\u7d20\u8d39\u7528\u9879\u76ee\u603b\u989d\uff1aelement@subelement=" + (String)entry.getKey() + "allocam=" + entry.getValue());
                }
                if (allocam.compareTo(BigDecimal.ZERO) == 0) {
                    for (int i = 0; i < items.size(); ++i) {
                        row = (Object[])items.get(i);
                        subkey = row[this.getListFieldIndex("element")] + "@" + row[this.getListFieldIndex("subelement")];
                        allocam = absAllocamtMap.computeIfAbsent(subkey, k -> BigDecimal.ZERO);
                        allocam = allocam.add(this.getAmt(row, "allocamt").abs());
                        absAllocamtMap.put(subkey, allocam);
                    }
                }
            }
            for (int i = 0; i < items.size(); ++i) {
                row = (Object[])items.get(i);
                if (iscy) {
                    subkey = row[this.getListFieldIndex("element")] + "@" + row[this.getListFieldIndex("subelement")];
                    if (absAllocamtMap != null && absAllocamtMap.containsKey(subkey)) {
                        allocam = (BigDecimal)absAllocamtMap.get(subkey);
                        allocam = allocam.setScale((int)amtprecision, RoundingMode.HALF_UP);
                        this.calculationAbsItems(row, startFields, allocam);
                        this.calculationAbsItems(row, currFields, allocam);
                        this.calculationAbsItems(row, compFields, allocam);
                        this.calculationAbsItems(row, endFields, allocam);
                        this.calculationAbsItems(row, totalFields, allocam);
                    } else if (allocamtMap != null && allocamtMap.containsKey(subkey)) {
                        allocam = (BigDecimal)allocamtMap.get(subkey);
                        allocam = allocam.setScale((int)amtprecision, RoundingMode.HALF_UP);
                        this.calculationItems(row, startFields, allocam);
                        this.calculationItems(row, currFields, allocam);
                        this.calculationItems(row, compFields, allocam);
                        this.calculationItems(row, endFields, allocam);
                        this.calculationItems(row, totalFields, allocam);
                    }
                }
                dataList.add(row);
                this.sumRowFields(startFields, row, countRowData);
                this.sumRowFields(currFields, row, countRowData);
                this.sumRowFields(compFields, row, countRowData);
                this.sumRowFields(endFields, row, countRowData);
                this.sumRowFields(totalFields, row, countRowData);
            }
            BigDecimal[] productTotalQtys = new BigDecimal[5];
            if (displaymodel == 1) {
                for (Map.Entry<Object, Map<Object, BigDecimal[]>> emnt : proqtys.entrySet()) {
                    Map<Object, BigDecimal[]> values = emnt.getValue();
                    BigDecimal[] qtys2 = values.get(periodId + "&" + costobjectId + "&" + costcenterId);
                    if (qtys2 == null) continue;
                    ArrayList<BigDecimal[]> cqtys2 = new ArrayList<BigDecimal[]>();
                    cqtys2.add(qtys2);
                    productTotalQtys = this.addProductQtys(productTotalQtys, cqtys2);
                }
            } else if (displaymodel == 2) {
                if (productId != null && (qtys = (pmap = proqtys.get(Long.valueOf(productId))).get(periodId + "@" + productId + "@" + costcenterId)) != null) {
                    cqtys = new ArrayList<BigDecimal[]>();
                    cqtys.add(qtys);
                    productTotalQtys = this.addProductQtys(productTotalQtys, cqtys);
                }
            } else if (displaymodel == 3 && productId != null && (qtys = (pmap = proqtys.get(Long.valueOf(productId))).get(periodId + "*" + productId + "*")) != null) {
                cqtys = new ArrayList();
                cqtys.add(qtys);
                productTotalQtys = this.addProductQtys(productTotalQtys, cqtys);
            }
            countRowData[this.getListFieldIndex((String)"startqty")] = productTotalQtys[0];
            countRowData[this.getListFieldIndex((String)"currqty")] = productTotalQtys[1];
            countRowData[this.getListFieldIndex((String)"compqty")] = productTotalQtys[2];
            countRowData[this.getListFieldIndex((String)"endqty")] = productTotalQtys[3];
            countRowData[this.getListFieldIndex((String)"totalqty")] = productTotalQtys[4];
            this.setPrice(countRowData);
        }
        return Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), this.getRowMeta());
    }

    private BigDecimal[] addProductQtys(BigDecimal[] productTotalQtys, Collection<BigDecimal[]> values) {
        values.forEach(row -> {
            for (int i = 0; i < 5; ++i) {
                BigDecimal qty = row[i] == null ? BigDecimal.ZERO : row[i];
                productTotalQtys[i] = productTotalQtys[i] == null ? BigDecimal.ZERO : productTotalQtys[i];
                productTotalQtys[i] = productTotalQtys[i].add(qty);
            }
        });
        return productTotalQtys;
    }

    private static Map<Object, Map<Object, BigDecimal[]>> getProductQtys(ReportQueryParam reportQueryParam) {
        String algoKey = "OutlayCostsQueryPlugin.query";
        String selectFields = "period,entryproduct.id productid,costcenter.id costcenterid,costobject.id costobjectid,startqtys,currqtys,compqtys,endqtys,totalqtys";
        QFilter filter = OutlayCostsQueryPlugin.getQFilter(reportQueryParam);
        DataSet pDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_diffcalcresult", (String)selectFields, (QFilter[])filter.toArray(), null);
        HashMap<Object, Map<Object, BigDecimal[]>> rtmap = new HashMap<Object, Map<Object, BigDecimal[]>>();
        while (pDataSet.hasNext()) {
            Row row = pDataSet.next();
            Object period = row.get("period");
            Object productid = row.get("productid");
            Object costobjectid = row.get("costobjectid");
            Object costcenterid = row.get("costcenterid");
            BigDecimal[] initpbqtys = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
            BigDecimal[] inittotalpbqty = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
            BigDecimal[] pbqtys = new BigDecimal[]{row.getBigDecimal("startqtys"), row.getBigDecimal("currqtys"), row.getBigDecimal("compqtys"), row.getBigDecimal("endqtys"), row.getBigDecimal("totalqtys")};
            Map tmap = rtmap.computeIfAbsent(productid, s -> new HashMap());
            tmap.put(period + "&" + costobjectid + "&" + costcenterid, pbqtys);
            BigDecimal[] precpqtys = tmap.computeIfAbsent(period + "@" + productid + "@" + costcenterid, s -> initpbqtys);
            BigDecimal[] totalpbqty = tmap.computeIfAbsent(period + "*" + productid + "*", s -> inittotalpbqty);
            for (int i = 0; i < 5; ++i) {
                precpqtys[i] = precpqtys[i].add(pbqtys[i]);
                totalpbqty[i] = totalpbqty[i].add(pbqtys[i]);
            }
        }
        return rtmap;
    }

    private void calculationItems(Object[] objectRow, String[] cells, BigDecimal allocamtRow) {
        BigDecimal cellamt = (BigDecimal)objectRow[this.getListFieldIndex("allocamt")];
        BigDecimal sumamt = null;
        if (cellamt != null) {
            if (allocamtRow == null || allocamtRow.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            for (int i = 0; i < cells.length; ++i) {
                sumamt = (BigDecimal)objectRow[this.getListFieldIndex(cells[i])] == null ? BigDecimal.ZERO : (BigDecimal)objectRow[this.getListFieldIndex(cells[i])];
                objectRow[this.getListFieldIndex((String)cells[i])] = cellamt.divide(allocamtRow, 10, RoundingMode.HALF_UP).multiply(sumamt);
            }
        }
    }

    private void calculationAbsItems(Object[] objectRow, String[] cells, BigDecimal allocamtRow) {
        BigDecimal cellamt = (BigDecimal)objectRow[this.getListFieldIndex("allocamt")];
        BigDecimal sumamt = null;
        if (cellamt != null) {
            if (allocamtRow == null || allocamtRow.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            for (int i = 0; i < cells.length; ++i) {
                sumamt = (BigDecimal)objectRow[this.getListFieldIndex(cells[i])] == null ? BigDecimal.ZERO : (BigDecimal)objectRow[this.getListFieldIndex(cells[i])];
                objectRow[this.getListFieldIndex((String)cells[i])] = cellamt.abs().divide(allocamtRow, 10, RoundingMode.HALF_UP).multiply(sumamt);
            }
        }
    }

    private Map<String, List<Object[]>> addMap(DataSet rows) {
        int displaymodel = this.displaymodel();
        LinkedHashMap<String, List<Object[]>> map = new LinkedHashMap<String, List<Object[]>>();
        String key = null;
        Object[] objectRow = null;
        List rowList = null;
        for (Row row : rows) {
            if (displaymodel == 1) {
                key = row.getString("period") + "@" + row.getString("costcenter") + "@" + row.getString("costobject") + "@" + row.getString("bizstatus") + "@" + row.getString("bookcurrency");
            } else if (displaymodel == 2) {
                key = row.getString("period") + "@" + row.getString("costcenter") + "@" + row.getString("entryproduct") + "@" + row.getString("bookcurrency");
            } else if (displaymodel == 3) {
                key = row.getString("period") + "@" + row.getString("entryproduct") + "@" + row.getString("bookcurrency");
            }
            objectRow = this.getObjectRow(row);
            rowList = map.computeIfAbsent(key, s -> new ArrayList());
            rowList.add(objectRow);
        }
        return map;
    }

    protected RowMeta getRowMeta() {
        List<Field> field = this.getRowMetaField();
        return new RowMeta(field.toArray(new Field[0]));
    }

    protected int getListFieldIndex(String field) {
        Field[] fields = this.getRowMeta().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!field.equals(fields[i].getName())) continue;
            return i;
        }
        return -1;
    }

    protected Object[] getObjectRow(Row row) {
        boolean isSubelement = this.isSubelement();
        boolean isDetail = this.isDetail();
        boolean iscy = this.iscy();
        int displaymodel = this.displaymodel();
        ArrayList<String> notShowFieldisSubelement = new ArrayList<String>(Collections.singletonList("period"));
        if (displaymodel == 1) {
            notShowFieldisSubelement.add("costcenter");
            notShowFieldisSubelement.add("costobject");
            notShowFieldisSubelement.add("bizstatus");
        } else if (displaymodel == 2) {
            notShowFieldisSubelement.add("costcenter");
            notShowFieldisSubelement.add("entryproduct");
        } else if (displaymodel == 3) {
            notShowFieldisSubelement.add("entryproduct");
        }
        ArrayList<String> notShowFields = new ArrayList<String>(Arrays.asList("period", "baseunit", "startqty", "currqty", "compqty", "totalqty", "endqty"));
        if (displaymodel == 1) {
            notShowFields.add("costcenter");
            notShowFields.add("costobject");
            notShowFields.add("bizstatus");
        } else if (displaymodel == 2) {
            notShowFields.add("costcenter");
            notShowFields.add("entryproduct");
        } else if (displaymodel == 3) {
            notShowFields.add("entryproduct");
        }
        Field[] fields = this.getRowMeta().getFields();
        Object[] rowData = new Object[fields.length];
        String field = null;
        Object value = null;
        for (int i = 0; i < fields.length; ++i) {
            field = fields[i].getName();
            if (isSubelement && isDetail ? notShowFieldisSubelement.contains(field) : isSubelement && !isDetail && notShowFields.contains(field)) continue;
            try {
                value = row.get(field);
                switch (field) {
                    case "element": {
                        value = row.getString("elementname");
                        break;
                    }
                    case "material": {
                        if (iscy) {
                            if (!value.equals(0L)) {
                                value = row.getString("materialname");
                                break;
                            }
                            value = row.getString("expenseitemname");
                            break;
                        }
                        if (value.equals(0)) break;
                        value = row.getString("materialname");
                    }
                }
                if (value instanceof BigDecimal) {
                    BigDecimal decimalValue = (BigDecimal)value;
                    decimalValue = decimalValue.setScale((int)amtprecision, RoundingMode.HALF_UP);
                    rowData[i] = decimalValue;
                    continue;
                }
                rowData[i] = value;
                continue;
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            }
        }
        return rowData;
    }

    protected Object[] getObjectRows(Row row) {
        Field[] fields = this.getRowMeta().getFields();
        Object[] rowData = new Object[fields.length];
        String field = null;
        for (int i = 0; i < fields.length; ++i) {
            try {
                field = fields[i].getName();
                if (row.get(field) instanceof BigDecimal && !field.endsWith("qty") && !field.endsWith("qtys")) {
                    BigDecimal amtValue = (BigDecimal)row.get(field);
                    amtValue = amtValue.setScale((int)amtprecision, RoundingMode.HALF_UP);
                    rowData[i] = amtValue;
                    continue;
                }
                rowData[i] = row.get(field);
                continue;
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            }
        }
        return rowData;
    }

    private boolean iscy() {
        try {
            ReportQueryParam queryParam = this.getQueryParam();
            boolean isdetail = queryParam.getFilter().getBoolean("iscy");
            return isdetail;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private boolean isDetail() {
        try {
            ReportQueryParam queryParam = this.getQueryParam();
            boolean isdetail = queryParam.getFilter().getBoolean("isdetail");
            return isdetail;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private int displaymodel() {
        try {
            ReportQueryParam queryParam = this.getQueryParam();
            int isdetail = queryParam.getFilter().getInt("displaymodel");
            return isdetail;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return 1;
        }
    }

    private boolean isSubelement() {
        try {
            ReportQueryParam queryParam = this.getQueryParam();
            boolean issubelement = queryParam.getFilter().getBoolean("issubelement");
            return issubelement;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static QFilter getQFilter(ReportQueryParam reportQueryParam) {
        FilterItemInfo currencyfilterItem;
        Object currency;
        String bizstatus;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object value = null;
        value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "org");
        QFilter filter = new QFilter("org", "=", value);
        value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "costaccount");
        filter.and(new QFilter("costaccount", "=", value));
        value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "fperiod");
        filter.and(new QFilter("period", "in", value));
        value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "fcostcenter");
        if (value != null) {
            filter.and(new QFilter("costcenter", "in", value));
        }
        if ((bizstatus = (String)OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "fbizstatus")) != null && ("A".equals(bizstatus) || "B".equals(bizstatus))) {
            filter.and(new QFilter("bizstatus", "=", value));
        }
        if ((value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "fcostobject")) != null) {
            filter.and(new QFilter("costobject", "in", value));
        }
        if ((value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "product")) != null) {
            filter.and(new QFilter("entryproduct", "in", value));
        }
        if ((currency = (currencyfilterItem = filterInfo.getFilterItem("currency")).getValue()) instanceof DynamicObject) {
            DynamicObject currencydyo = (DynamicObject)currency;
            amtprecision = currencydyo.getInt("amtprecision");
        }
        return filter;
    }

    public static QFilter getQFilters(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object value = null;
        value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "org");
        QFilter filter = new QFilter("org", "=", value);
        value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "costaccount");
        filter.and(new QFilter("costaccount", "=", value));
        value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "fperiod");
        filter.and(new QFilter("period", "in", value));
        value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "fcostcenter");
        if (value != null) {
            filter.and(new QFilter("benefcostcenter", "in", value));
        }
        if ((value = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "fcostobject")) != null && CollectionUtils.isEmpty((Collection)((List)value))) {
            filter.and(new QFilter("costobject", "in", value));
        }
        filter.and(new QFilter("allocstatus", "=", (Object)"2"));
        filter.and(new QFilter("entryentity.allocamt", "!=", (Object)0));
        filter.and(new QFilter("entryentity.allocamt", "is not null", (Object)0));
        FilterItemInfo currencyfilterItem = filterInfo.getFilterItem("currency");
        Object currency = currencyfilterItem.getValue();
        if (currency instanceof DynamicObject) {
            DynamicObject currencydyo = (DynamicObject)currency;
            amtprecision = currencydyo.getInt("amtprecision");
        }
        return filter;
    }

    private BigDecimal getAmt(Object[] row, String cell) {
        if (row[this.getListFieldIndex(cell)] != null) {
            return (BigDecimal)row[this.getListFieldIndex(cell)];
        }
        return BigDecimal.ZERO;
    }

    private void setPrice(Object[] row) {
        BigDecimal compamt = (BigDecimal)row[this.getListFieldIndex("compamt")];
        BigDecimal compqty = (BigDecimal)row[this.getListFieldIndex("compqty")];
        BigDecimal compactcostupamt = (BigDecimal)row[this.getListFieldIndex("compactcostupamt")];
        if (compqty != null && compqty.compareTo(BigDecimal.ZERO) > 0) {
            if (compamt != null) {
                row[this.getListFieldIndex((String)"compprice")] = compamt.divide(compqty, 6, RoundingMode.HALF_UP);
            }
            if (compactcostupamt != null) {
                row[this.getListFieldIndex((String)"compactcostupprice")] = compactcostupamt.divide(compqty, 6, RoundingMode.HALF_UP);
            }
        }
        BigDecimal totalamt = (BigDecimal)row[this.getListFieldIndex("totalamt")];
        BigDecimal totalqty = (BigDecimal)row[this.getListFieldIndex("totalqty")];
        BigDecimal totalactcostupamt = (BigDecimal)row[this.getListFieldIndex("totalactcostupamt")];
        if (totalqty != null && totalqty.compareTo(BigDecimal.ZERO) > 0) {
            if (totalamt != null) {
                row[this.getListFieldIndex((String)"totalprice")] = totalamt.divide(totalqty, 6, RoundingMode.HALF_UP);
            }
            if (totalactcostupamt != null) {
                row[this.getListFieldIndex((String)"totalactcostupprice")] = totalactcostupamt.divide(totalqty, 6, RoundingMode.HALF_UP);
            }
        }
    }

    public ReportQueryParam getQueryParam() {
        return super.getQueryParam();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        return super.getColumns(columns);
    }

    public Object getSelectedObj() {
        return super.getSelectedObj();
    }

    public void setProgress(int percent) {
        super.setProgress(percent);
    }

    private DataSet getBaseDataSet(DataSet leftDataSet) {
        int displaymodel = this.displaymodel();
        StringBuilder groupFields = new StringBuilder();
        groupFields.append("period,periodnumber");
        if (displaymodel == 1) {
            groupFields.append(",costcenter,costcenternumber,costobject,costobjectbillno,bizstatus,bookcurrency");
        } else if (displaymodel == 2) {
            groupFields.append(",costcenter,costcenternumber,entryproduct,productnumber,costobject,bookcurrency");
        } else if (displaymodel == 3) {
            groupFields.append(",entryproduct,productnumber,costobject,bookcurrency");
        }
        String[] groupFieldArr = groupFields.toString().split(",");
        GroupbyDataSet groupBy = leftDataSet.groupBy(groupFieldArr);
        this.maxfields(groupBy, qtyFields);
        this.sumfields(groupBy, startFields);
        this.sumfields(groupBy, currFields);
        this.sumfields(groupBy, compFields);
        this.sumfields(groupBy, endFields);
        this.sumfields(groupBy, totalFields);
        StringBuilder sb = new StringBuilder();
        sb.append("period,periodnumber");
        if (displaymodel == 1) {
            sb.append(",costcenter,costcenternumber,costobject,costobject AS material,costobjectbillno,bizstatus,bookcurrency");
        } else if (displaymodel == 2) {
            sb.append(",costcenter,costcenternumber,entryproduct,productnumber,bookcurrency");
        } else if (displaymodel == 3) {
            sb.append(",entryproduct,productnumber,bookcurrency");
        }
        this.addfields(sb, qtyFields);
        this.addfields(sb, startFields);
        this.addfields(sb, currFields);
        this.addfields(sb, compFields);
        this.addfields(sb, endFields);
        this.addfields(sb, totalFields);
        DataSet select = null;
        if (displaymodel == 2 || displaymodel == 3) {
            DataSet ds = groupBy.finish();
            List<String> groupstrs = Arrays.stream(groupFieldArr).collect(Collectors.toList());
            groupstrs.remove("costobject");
            GroupbyDataSet allgs = ds.groupBy(groupstrs.toArray(new String[0]));
            this.sumfields(allgs, qtyFields);
            this.sumfields(allgs, startFields);
            this.sumfields(allgs, currFields);
            this.sumfields(allgs, compFields);
            this.sumfields(allgs, endFields);
            this.sumfields(allgs, totalFields);
            select = allgs.finish().select(sb.toString());
        } else {
            select = groupBy.finish().select(sb.toString());
        }
        if (displaymodel == 1) {
            select = select.orderBy(new String[]{"periodnumber", "costcenternumber", "costobjectbillno"});
        } else if (displaymodel == 2) {
            select = select.orderBy(new String[]{"periodnumber", "costcenternumber", "productnumber"});
        } else if (displaymodel == 3) {
            select = select.orderBy(new String[]{"periodnumber", "productnumber"});
        }
        return select;
    }

    private List<Object[]> getListData(DataSet leftDataSet) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        Object org = null;
        org = OutlayCostsQueryPlugin.getFilterItemValue(filterInfo, "org");
        int displaymodel = this.displaymodel();
        DynamicObjectCollection costobjectColl = null;
        DynamicObject costobject = null;
        QFilter filter = null;
        Object[] objectRows = null;
        DataSet select = this.getBaseDataSet(leftDataSet);
        for (Row row : select) {
            objectRows = this.getObjectRows(row);
            objectRows[this.getListFieldIndex((String)"startqty")] = row.getBigDecimal("startqtys");
            objectRows[this.getListFieldIndex((String)"currqty")] = row.getBigDecimal("currqtys");
            objectRows[this.getListFieldIndex((String)"compqty")] = row.getBigDecimal("compqtys");
            objectRows[this.getListFieldIndex((String)"endqty")] = row.getBigDecimal("endqtys");
            objectRows[this.getListFieldIndex((String)"totalqty")] = row.getBigDecimal("totalqtys");
            if (displaymodel == 1) {
                costobject = BusinessDataServiceHelper.loadSingle((String)"cad_costobjectf7", (String)"material.name,material.baseunit.id,bomversion,auxpty", (QFilter[])new QFilter("id", "=", row.get("costobject")).toArray());
                if (costobject != null) {
                    objectRows[this.getListFieldIndex((String)"material")] = costobject.getString("material.name");
                    objectRows[this.getListFieldIndex((String)"baseunit")] = costobject.getLong("material.baseunit.id");
                    objectRows[this.getListFieldIndex((String)"matversion")] = costobject.getLong("bomversion.masterid");
                    objectRows[this.getListFieldIndex((String)"auxpty")] = costobject.getLong("auxpty.id");
                }
            } else if (displaymodel == 2) {
                filter = new QFilter("org", "=", org);
                filter.and(new QFilter("costcenter", "=", row.get("costcenter")));
                filter.and(new QFilter("material", "=", row.get("entryproduct")));
                costobjectColl = QueryServiceHelper.query((String)"cad_costobjectf7", (String)"material.name,material.baseunit.id,bomversion,auxpty", (QFilter[])filter.toArray());
                costobject = (DynamicObject)costobjectColl.get(0);
                if (costobjectColl.size() > 0 && costobject != null) {
                    objectRows[this.getListFieldIndex((String)"material")] = costobject.getString("material.name");
                    objectRows[this.getListFieldIndex((String)"baseunit")] = costobject.getLong("material.baseunit.id");
                    objectRows[this.getListFieldIndex((String)"matversion")] = costobject.getLong("bomversion");
                    objectRows[this.getListFieldIndex((String)"auxpty")] = costobject.getLong("auxpty");
                }
            } else if (displaymodel == 3) {
                filter = new QFilter("org", "=", org);
                filter.and(new QFilter("material", "=", row.get("entryproduct")));
                costobjectColl = QueryServiceHelper.query((String)"cad_costobjectf7", (String)"material.name,material.baseunit.id,bomversion,auxpty", (QFilter[])filter.toArray());
                costobject = (DynamicObject)costobjectColl.get(0);
                if (costobjectColl.size() > 0 && costobject != null) {
                    objectRows[this.getListFieldIndex((String)"material")] = costobject.getString("material.name");
                    objectRows[this.getListFieldIndex((String)"baseunit")] = costobject.getLong("material.baseunit.id");
                    objectRows[this.getListFieldIndex((String)"matversion")] = costobject.getLong("bomversion");
                    objectRows[this.getListFieldIndex((String)"auxpty")] = costobject.getLong("auxpty");
                }
            }
            this.setPrice(objectRows);
            dataList.add(objectRows);
        }
        return dataList;
    }

    private String getQueryFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("org AS org");
        sb.append(",costaccount AS costaccount");
        sb.append(",costobject AS costobject");
        sb.append(",costobject.billno AS costobjectbillno");
        sb.append(",entryproduct AS entryproduct");
        sb.append(",entryproduct.number AS productnumber");
        sb.append(",bizstatus AS bizstatus");
        sb.append(",currency AS bookcurrency");
        sb.append(",costcenter AS costcenter");
        sb.append(",costcenter.number AS costcenternumber");
        sb.append(",period AS period");
        sb.append(",period.number AS periodnumber");
        sb.append(",startqtys");
        sb.append(",currqtys");
        sb.append(",compqtys");
        sb.append(",endqtys");
        sb.append(",totalqtys");
        sb.append(",entryentity.element AS element");
        sb.append(",entryentity.element.number AS elementnumber");
        sb.append(",entryentity.element.name AS elementname");
        sb.append(",entryentity.subelement AS subelement");
        sb.append(",entryentity.subelement.number AS subelementnumber");
        sb.append(",entryentity.subelement.name AS subelementname");
        sb.append(",entryentity.material AS material");
        sb.append(",entryentity.material.number AS materialnumber");
        sb.append(",entryentity.material.name AS materialname");
        sb.append(",entryentity.auxpty AS auxpty");
        sb.append(",entryentity.matversion AS matversion");
        sb.append(",entryentity.baseunit AS baseunit");
        sb.append(",entryentity.startqty AS startqty");
        sb.append(",entryentity.startamt AS startamt");
        sb.append(",entryentity.startdiffqty AS startdiffqty");
        sb.append(",entryentity.startmadediff AS startmadediff");
        sb.append(",entryentity.startmadeupamt AS startmadeupamt");
        sb.append(",entryentity.startunjoindiffamt AS startunjoindiffamt");
        sb.append(",entryentity.startstdcostupamt AS startstdcostupamt");
        sb.append(",entryentity.startorddiff AS startorddiff");
        sb.append(",entryentity.startinvoicediff AS startinvoicediff");
        sb.append(",entryentity.startfeediff AS startfeediff");
        sb.append(",entryentity.startfalldiff AS startfalldiff");
        sb.append(",entryentity.startotherdiff AS startotherdiff");
        sb.append(",entryentity.startactcostupamt AS startactcostupamt");
        sb.append(",entryentity.currqty AS currqty");
        sb.append(",entryentity.curramt AS curramt");
        sb.append(",entryentity.currdiffqty AS currdiffqty");
        sb.append(",entryentity.currmadediff AS currmadediff");
        sb.append(",entryentity.currmadeupamt AS currmadeupamt");
        sb.append(",entryentity.currunjoindiffamt AS currunjoindiffamt");
        sb.append(",entryentity.currstdcostupamt AS currstdcostupamt");
        sb.append(",entryentity.currorddiff AS currorddiff");
        sb.append(",entryentity.currinvoicediff AS currinvoicediff");
        sb.append(",entryentity.currfeediff AS currfeediff");
        sb.append(",entryentity.currfalldiff AS currfalldiff");
        sb.append(",entryentity.currotherdiff AS currotherdiff");
        sb.append(",entryentity.curractcostupamt AS curractcostupamt");
        sb.append(",entryentity.compqty AS compqty");
        sb.append(",entryentity.compamt AS compamt");
        sb.append(",entryentity.compdiffqty AS compdiffqty");
        sb.append(",entryentity.compmadediff AS compmadediff");
        sb.append(",entryentity.compmadeupamt AS compmadeupamt");
        sb.append(",entryentity.compunjoindiffamt AS compunjoindiffamt");
        sb.append(",entryentity.compstdcostupamt AS compstdcostupamt");
        sb.append(",entryentity.comporddiff AS comporddiff");
        sb.append(",entryentity.compinvoicediff AS compinvoicediff");
        sb.append(",entryentity.compfeediff AS compfeediff");
        sb.append(",entryentity.compfalldiff AS compfalldiff");
        sb.append(",entryentity.compotherdiff AS compotherdiff");
        sb.append(",entryentity.compactcostupamt AS compactcostupamt");
        sb.append(",entryentity.endqty AS endqty");
        sb.append(",entryentity.endamt AS endamt");
        sb.append(",entryentity.enddiffqty AS enddiffqty");
        sb.append(",entryentity.endmadediff AS endmadediff");
        sb.append(",entryentity.endmadeupamt AS endmadeupamt");
        sb.append(",entryentity.endunjoindiffamt AS endunjoindiffamt");
        sb.append(",entryentity.endstdcostupamt AS endstdcostupamt");
        sb.append(",entryentity.endorddiff AS endorddiff");
        sb.append(",entryentity.endinvoicediff AS endinvoicediff");
        sb.append(",entryentity.endfeediff AS endfeediff");
        sb.append(",entryentity.endfalldiff AS endfalldiff");
        sb.append(",entryentity.endotherdiff AS endotherdiff");
        sb.append(",entryentity.endactcostupamt AS endactcostupamt");
        sb.append(",entryentity.totalqty AS totalqty");
        sb.append(",entryentity.totalamt AS totalamt");
        sb.append(",entryentity.totaldiffqty AS totaldiffqty");
        sb.append(",entryentity.totalmadediff AS totalmadediff");
        sb.append(",entryentity.totalmadeupamt AS totalmadeupamt");
        sb.append(",entryentity.totalunjoindiffamt AS totalunjoindiffamt");
        sb.append(",entryentity.totalstdcostupamt AS totalstdcostupamt");
        sb.append(",entryentity.totalorddiff AS totalorddiff");
        sb.append(",entryentity.totalinvoicediff AS totalinvoicediff");
        sb.append(",entryentity.totalfeediff AS totalfeediff");
        sb.append(",entryentity.totalfalldiff AS totalfalldiff");
        sb.append(",entryentity.totalotherdiff AS totalotherdiff");
        sb.append(",entryentity.totalactcostupamt AS totalactcostupamt");
        return sb.toString();
    }

    protected List<Field> getRowMetaField() {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("period", (DataType)DataType.LongType));
        field.add(new Field("costcenter", (DataType)DataType.LongType));
        field.add(new Field("costobject", (DataType)DataType.LongType));
        field.add(new Field("bizstatus", (DataType)DataType.StringType));
        field.add(new Field("entryproduct", (DataType)DataType.LongType));
        field.add(new Field("element", (DataType)DataType.StringType));
        field.add(new Field("subelement", (DataType)DataType.LongType));
        field.add(new Field("material", (DataType)DataType.StringType));
        field.add(new Field("auxpty", (DataType)DataType.LongType));
        field.add(new Field("matversion", (DataType)DataType.LongType));
        field.add(new Field("baseunit", (DataType)DataType.LongType));
        field.add(new Field("bookcurrency", (DataType)DataType.LongType));
        field.add(new Field("startqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("startamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("startorddiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("startdiffqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("startunjoindiffamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("startstdcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("startactcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("currqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("curramt", (DataType)DataType.BigDecimalType));
        field.add(new Field("currorddiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currdiffqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("currunjoindiffamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("currstdcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("curractcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("compqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("compamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("comporddiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compdiffqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("compunjoindiffamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("compstdcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("compactcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalorddiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("totaldiffqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalunjoindiffamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalstdcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalactcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("endqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("endamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("endorddiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("enddiffqty", (DataType)DataType.BigDecimalType));
        field.add(new Field("endunjoindiffamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("endstdcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("endactcostupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("allocamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("startinvoicediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("startfeediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("startfalldiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("startotherdiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("startmadediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("startmadeupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("currinvoicediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currfeediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currfalldiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currotherdiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currmadediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("currmadeupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("compinvoicediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compfeediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compfalldiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compotherdiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compmadediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("compmadeupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("endinvoicediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("endfeediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("endfalldiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("endotherdiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("endmadediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("endmadeupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalinvoicediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalfeediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalfalldiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalotherdiff", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalmadediff", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalmadeupamt", (DataType)DataType.BigDecimalType));
        field.add(new Field("startqtys", (DataType)DataType.BigDecimalType));
        field.add(new Field("currqtys", (DataType)DataType.BigDecimalType));
        field.add(new Field("compqtys", (DataType)DataType.BigDecimalType));
        field.add(new Field("endqtys", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalqtys", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalactcostupprice", (DataType)DataType.BigDecimalType));
        field.add(new Field("totalprice", (DataType)DataType.BigDecimalType));
        field.add(new Field("compprice", (DataType)DataType.BigDecimalType));
        field.add(new Field("compactcostupprice", (DataType)DataType.BigDecimalType));
        return field;
    }
}

