/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.account;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.common.closeaccount.CostCloseAccountParam;

public class CostCloseAccountFacade {
    public Map<String, String> doCloseAccount(CostCloseAccountParam[] params) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < params.length; ++i) {
            CostCloseAccountParam param = params[i];
            DynamicObjectCollection col = this.checkCloseIsDone(param);
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)col) && param.getCloseperiod().longValue() == ((DynamicObject)col.get(0)).getLong("closeperiod")) {
                String key = this.buildMapKeyString(param);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u201c%1$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u7ec4\u5408\u4e0b\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\u3002", (String)"CostCloseAccountFacade_3", (String)"macc-sca-business", (Object[])new Object[0]), param.getManuorgName(), param.getCostaccountName());
                map.put(key, errorMsg);
                continue;
            }
            DynamicObjectCollection col2 = this.checkCalResultBillIsExist(param);
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)col2)) {
                String key = this.buildMapKeyString(param);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u201c%2$s\u201d\u7ec4\u5408\u4e0b\u672a\u8fdb\u884c\u6210\u672c\u8ba1\u7b97\u3002", (String)"CostCloseAccountFacade_4", (String)"macc-sca-business", (Object[])new Object[0]), param.getCalorgName(), param.getManuorgName());
                map.put(key, errorMsg);
                continue;
            }
            this.closeAccount(param, col);
        }
        return map;
    }

    public Map<String, String> undoCloseAccount(CostCloseAccountParam[] params) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < params.length; ++i) {
            CostCloseAccountParam param = params[i];
            List<Object> pkIdList = this.checkDataIsExist(param);
            if (CadEmptyUtils.isEmpty(pkIdList)) {
                String key = this.buildMapKeyString(param);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u201c%1$s\u201d\u4e0e\u6210\u672c\u8d26\u7c3f\u201c%2$s\u201d\u7ec4\u5408\u4e0b\u5f53\u524d\u671f\u95f4\u672a\u5173\u8d26\u3002", (String)"CostCloseAccountFacade_5", (String)"macc-sca-business", (Object[])new Object[0]), param.getManuorgName(), param.getCostaccountName());
                map.put(key, errorMsg);
                continue;
            }
            this.unCloseAccount(pkIdList);
        }
        return map;
    }

    private void closeAccount(CostCloseAccountParam param, DynamicObjectCollection col) {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)col)) {
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"sca_closeaccounttable");
            dyn.set("calorg", (Object)param.getCalorg());
            dyn.set("manuorg", (Object)param.getManuorg());
            dyn.set("costaccount", (Object)param.getCostaccount());
            dyn.set("closeperiod", (Object)param.getCloseperiod());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        } else {
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)col.get(0)).getLong("id"), (String)"sca_closeaccounttable");
            dyn.set("closeperiod", (Object)param.getCloseperiod());
            SaveServiceHelper.update((DynamicObject)dyn);
        }
    }

    private void unCloseAccount(List<Object> list) {
        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"sca_closeaccounttable"), (Object[])list.toArray());
    }

    private DynamicObjectCollection checkCalResultBillIsExist(CostCloseAccountParam param) {
        QFilter qFilter = new QFilter("org", "=", (Object)param.getCalorg());
        qFilter.and(new QFilter("costobject.manuorg", "=", (Object)param.getManuorg()));
        qFilter.and(new QFilter("costaccount", "=", (Object)param.getCostaccount()));
        qFilter.and(new QFilter("period", "=", (Object)param.getCloseperiod()));
        return QueryServiceHelper.query((String)"sca_calcresult", (String)"org.name orgname,costobject.manuorg.name manuorgname", (QFilter[])qFilter.toArray());
    }

    private DynamicObjectCollection checkCloseIsDone(CostCloseAccountParam param) {
        QFilter qFilter = this.buildQueryDataQFilter(param);
        return QueryServiceHelper.query((String)"sca_closeaccounttable", (String)"id,manuorg.name manuorgname,costaccount.name costaccountname,closeperiod", (QFilter[])qFilter.toArray());
    }

    private QFilter buildQueryDataQFilter(CostCloseAccountParam param) {
        QFilter qFilter = new QFilter("calorg", "=", (Object)param.getCalorg());
        qFilter.and(new QFilter("manuorg", "=", (Object)param.getManuorg()));
        qFilter.and(new QFilter("costaccount", "=", (Object)param.getCostaccount()));
        return qFilter;
    }

    private String buildMapKeyString(CostCloseAccountParam param) {
        String calOrg = String.valueOf(param.getCalorg());
        String manuOrg = String.valueOf(param.getManuorg());
        String costAccount = String.valueOf(param.getCostaccount());
        return calOrg + "&" + manuOrg + "&" + costAccount;
    }

    private List<Object> checkDataIsExist(CostCloseAccountParam param) {
        QFilter qFilter = new QFilter("calorg", "=", (Object)param.getCalorg());
        qFilter.and(new QFilter("manuorg", "=", (Object)param.getManuorg()));
        qFilter.and(new QFilter("costaccount", "=", (Object)param.getCostaccount()));
        return QueryServiceHelper.queryPrimaryKeys((String)"sca_closeaccounttable", (QFilter[])qFilter.toArray(), null, (int)-1);
    }
}

