/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.business.checkdata.CheckDataParam;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.item.DataEntityDataCheck;
import kd.macc.sca.business.checkdata.item.IDataCheck;

public class FactnedBillAndMfg
extends DataEntityDataCheck
implements IDataCheck {
    private static final String splitSign = "@";

    @Override
    public List<ExceptionObj> collectExceptionObj(CheckDataParam param) {
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>(16);
        Date date = FactnedBillAndMfg.getFirstDayDateOfMonth(param.getExecuteDate());
        QFilter qfBizDate = new QFilter("bookdate", ">=", (Object)date);
        QFilter qfSourceBill = new QFilter("sourcebill", ">", (Object)0L);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)param.getAppNum());
        String selectFields = "billno,material.masterid material,completetype,sourcebill,completeqty qty,entryentity.costobject.srcbillnumber srcbillnumber,entryentity.costobject.srcbillrow srcbillrow";
        DynamicObjectCollection factnedBill = QueryServiceHelper.query((String)"cad_factnedoutputbill", (String)selectFields, (QFilter[])new QFilter[]{qfBizDate, qfSourceBill, qfAppNum});
        HashSet<String> allFactnedBill = new HashSet<String>();
        HashSet<Long> wipIds = new HashSet<Long>();
        HashSet<Long> proIds = new HashSet<Long>();
        for (DynamicObject factned : factnedBill) {
            String billType = null;
            if ("WIPCOMPELETE".equals(factned.getString("completetype")) || "WIPCOMPELETEBACK".equals(factned.getString("completetype"))) {
                billType = "WIP";
                wipIds.add(factned.getLong("sourcebill"));
            } else if ("PRODUCTCOMPELETE".equals(factned.getString("completetype")) || "PRODUCTCOMPELETEBACK".equals(factned.getString("completetype"))) {
                billType = "PRO";
                proIds.add(factned.getLong("sourcebill"));
            }
            allFactnedBill.add(billType + splitSign + factned.getString("material") + splitSign + factned.getString("sourcebill") + splitSign + factned.getString("qty") + splitSign + factned.getString("srcbillnumber") + splitSign + factned.getString("srcbillrow"));
        }
        HashSet<String> allBill = new HashSet<String>(16);
        QFilter qfBizTime = new QFilter("biztime", ">=", (Object)date);
        selectFields = "billno,billentry.material.masterid material,id,billentry.qty qty,billentry.manubill manubill,billentry.seq seq";
        if (wipIds.size() > 0) {
            QFilter qfWipId = new QFilter("id", "in", wipIds);
            DynamicObjectCollection mftBill = QueryServiceHelper.query((String)"im_mdc_mftmanuinbill", (String)selectFields, (QFilter[])new QFilter[]{qfWipId, qfBizTime});
            for (DynamicObject mft : mftBill) {
                allBill.add("WIP@" + mft.getString("material") + splitSign + mft.getString("id") + splitSign + mft.getString("qty") + splitSign + mft.getString("manubill") + splitSign + mft.getString("seq"));
            }
        }
        if (proIds.size() > 0) {
            QFilter qfProId = new QFilter("id", "in", proIds);
            DynamicObjectCollection proBill = QueryServiceHelper.query((String)"im_productinbill", (String)selectFields, (QFilter[])new QFilter[]{qfProId, qfBizTime});
            for (DynamicObject pro : proBill) {
                allBill.add("PRO@" + pro.getString("material") + splitSign + pro.getString("id") + splitSign + pro.getString("qty") + splitSign + pro.getString("manubill") + splitSign + pro.getString("seq"));
            }
        }
        String tip = ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u5f52\u96c6\u7684\u6570\u636e\u4e0e\u4e0a\u6e38\u5355\u636e\u7684\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"FactnedBillAndMfg_0", (String)"macc-sca-business", (Object[])new Object[0]);
        ExceptionObj exceObj = null;
        String wipTitle = ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u5355", (String)"FactnedBillAndMfg_1", (String)"macc-sca-business", (Object[])new Object[0]);
        String proTitle = ResManager.loadKDString((String)"\u751f\u4ea7\u5165\u5e93\u5355", (String)"FactnedBillAndMfg_2", (String)"macc-sca-business", (Object[])new Object[0]);
        String billNo = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a", (String)"FactnedBillAndMfg_3", (String)"macc-sca-business", (Object[])new Object[0]);
        String rowNo = ResManager.loadKDString((String)"\u884c\u53f7\uff1a", (String)"FactnedBillAndMfg_4", (String)"macc-sca-business", (Object[])new Object[0]);
        for (String fact : allFactnedBill) {
            if (allBill.contains(fact)) continue;
            exceObj = new ExceptionObj(0L, "cad_factnedoutputbill");
            exceObj.setDescription(tip);
            exceObj.setExtralInfo(this.updateInfo(fact, wipTitle, proTitle, billNo, rowNo));
            list.add(exceObj);
        }
        return list;
    }

    private String updateInfo(String info, String wipTitle, String proTitle, String billNo, String rowNo) {
        StringBuilder sg = new StringBuilder();
        String[] infos = info.split(splitSign);
        if (infos.length != 6) {
            return null;
        }
        if ("WIP".equals(infos[0])) {
            sg.append(wipTitle);
        } else if ("PRO".equals(infos[0])) {
            sg.append(proTitle);
        }
        sg.append(" ");
        sg.append(billNo);
        sg.append(infos[4]);
        sg.append(" ");
        sg.append(rowNo);
        sg.append(infos[5]);
        return sg.toString();
    }
}

