/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.business.checkdata.CheckDataParam;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.item.DataEntityDataCheck;
import kd.macc.sca.business.checkdata.item.IDataCheck;

public class MatUseCollection
extends DataEntityDataCheck
implements IDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(CheckDataParam param) {
        DynamicObjectCollection matBill;
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>(16);
        Date date = MatUseCollection.getFirstDayDateOfMonth(param.getExecuteDate());
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)param.getAppNum());
        QFilter qfBizDate = new QFilter("bookdate", ">=", (Object)date);
        QFilter qfSourceBill = QFilter.isNotNull((String)"entryentity.costobject.srcbillnumber");
        QFilter qfSource = new QFilter("source", "in", (Object)new String[]{"SYSIMPORT_PROGET", "SYSIMPORT_PROBACK", "SYSIMPORT_PROADD", "SYSIMPORT_OUT"});
        String selectFields = "source,entryentity.material.masterid material,entryentity.qty qty,bizdate,entryentity.costobject.srcbillnumber srcbillnumber,entryentity.costobject.srcbillrow srcbillrow";
        DynamicObjectCollection matUseCollection = QueryServiceHelper.query((String)("aca".equals(param.getAppNum()) ? "aca_matusecollect" : "sca_matusecollect"), (String)selectFields, (QFilter[])new QFilter[]{qfSource, qfBizDate, qfSourceBill, qfAppNum});
        HashSet<String> matUse = new HashSet<String>();
        String splitSign = "@";
        HashSet<String> matGetBillNos = new HashSet<String>();
        HashSet<String> matBackBillNos = new HashSet<String>();
        HashSet<String> matOutBillNos = new HashSet<String>();
        HashSet<String> matAddBillNos = new HashSet<String>();
        for (DynamicObject mat : matUseCollection) {
            String source = mat.getString("source");
            if ("SYSIMPORT_PROGET".equals(source)) {
                matGetBillNos.add(mat.getString("srcbillnumber"));
            }
            if ("SYSIMPORT_PROBACK".equals(source)) {
                matBackBillNos.add(mat.getString("srcbillnumber"));
            }
            if ("SYSIMPORT_PROADD".equals(source)) {
                matAddBillNos.add(mat.getString("srcbillnumber"));
            }
            if ("SYSIMPORT_OUT".equals(source)) {
                matOutBillNos.add(mat.getString("srcbillnumber"));
            }
            matUse.add(mat.getString("material") + splitSign + mat.getString("qty") + splitSign + mat.getString("bizdate") + splitSign + mat.getString("srcbillnumber") + splitSign + mat.getString("srcbillrow"));
        }
        HashSet sourceBill = new HashSet(16);
        if (matGetBillNos.size() > 0) {
            selectFields = "billentry.material.masterid material,billentry.qty qty,biztime,billno,billentry.Seq Seq";
            matBill = QueryServiceHelper.query((String)"im_mdc_mftproorder", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("billno", "in", matGetBillNos)});
            matBill.forEach(p -> sourceBill.add(p.getString("material") + splitSign + p.getString("qty") + splitSign + p.getString("biztime") + splitSign + p.getString("billno") + splitSign + p.getString("Seq")));
        }
        if (matBackBillNos.size() > 0) {
            selectFields = "billentry.material.masterid material,billentry.qty qty,biztime,billno,billentry.Seq Seq";
            matBill = QueryServiceHelper.query((String)"im_mdc_mftreturnorder", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("billno", "in", matBackBillNos)});
            matBill.forEach(p -> sourceBill.add(p.getString("material") + splitSign + p.getString("qty") + splitSign + p.getString("biztime") + splitSign + p.getString("billno") + splitSign + p.getString("Seq")));
        }
        if (matAddBillNos.size() > 0) {
            selectFields = "billentry.material.masterid material,billentry.qty qty,biztime,billno,billentry.Seq Seq";
            matBill = QueryServiceHelper.query((String)"im_mdc_mftfeedorder", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("billno", "in", matAddBillNos)});
            matBill.forEach(p -> sourceBill.add(p.getString("material") + splitSign + p.getString("qty") + splitSign + p.getString("biztime") + splitSign + p.getString("billno") + splitSign + p.getString("Seq")));
        }
        if (matOutBillNos.size() > 0) {
            selectFields = "billentry.material.masterid material,billentry.qty qty,biztime,billno,billentry.Seq Seq";
            matBill = QueryServiceHelper.query((String)"im_materialreqoutbill", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("billno", "in", matOutBillNos)});
            matBill.forEach(p -> sourceBill.add(p.getString("material") + splitSign + p.getString("qty") + splitSign + p.getString("biztime") + splitSign + p.getString("billno") + splitSign + p.getString("Seq")));
        }
        String tip1 = ResManager.loadKDString((String)"\u6b64\u9879\u4e0e\u4e0a\u6e38\u5355\u636e\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"MatUseCollection_0", (String)"macc-sca-business", (Object[])new Object[0]);
        String tip2 = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u884c\u53f7\uff1a%2$s", (String)"MatUseCollection_1", (String)"macc-sca-business", (Object[])new Object[0]);
        ExceptionObj exceObj = null;
        for (String mat : matUse) {
            if (sourceBill.contains(mat)) continue;
            exceObj = new ExceptionObj(0L, "sca_matusecollect");
            exceObj.setDescription(tip1);
            String[] infos = mat.split(splitSign);
            if (infos == null || infos.length != 5) continue;
            exceObj.setExtralInfo(String.format(tip2, infos[3], infos[4]));
            list.add(exceObj);
        }
        return list;
    }
}

