/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.business.checkdata.CheckDataParam;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.item.DataEntityDataCheck;
import kd.macc.sca.business.checkdata.item.IDataCheck;

public class MfgFeeBill
extends DataEntityDataCheck
implements IDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(CheckDataParam param) {
        DynamicObjectCollection mfgFeeBill;
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>();
        Date date = MfgFeeBill.getFirstDayDateOfMonth(param.getExecuteDate());
        QFilter qfBizDate = new QFilter("bizdate", ">=", (Object)date);
        String selectFields = "srcbillnum,expenseitem,bizdate,totalamount AS amount,mfgfeebillentry.voucherentry AS voucherentry";
        String entityName = "sca_mfgfeebill";
        if ("aca".equals(param.getAppNum())) {
            selectFields = "srcbillnum,expenseitem,bizdate,0 AS amount,mfgfeebillentry.voucherentry AS voucherentry";
            entityName = "aca_mfgfeebill";
        }
        if ((mfgFeeBill = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qfBizDate})).size() == 0) {
            return list;
        }
        HashSet<String> billNum = new HashSet<String>();
        String splitSign = "@";
        HashSet<String> mfgFeeInfo = new HashSet<String>();
        for (DynamicObject mfgFee : mfgFeeBill) {
            if (StringUtils.isEmpty((Object)mfgFee.getString("srcbillnum"))) continue;
            billNum.add(mfgFee.getString("srcbillnum"));
            mfgFeeInfo.add(mfgFee.getString("srcbillnum") + splitSign + mfgFee.getString("bizdate") + splitSign + mfgFee.getString("amount") + splitSign + mfgFee.getString("voucherentry"));
        }
        if (billNum.size() == 0) {
            return list;
        }
        QFilter qfBillNo = new QFilter("billno", "in", billNum);
        selectFields = "billno,bizdate,entries.entrydc AS entrydc,entries.debitlocal AS debitlocal,entries.id AS EntryID";
        DynamicObjectCollection voucher = QueryServiceHelper.query((String)"gl_voucher", (String)selectFields, (QFilter[])new QFilter[]{qfBizDate, qfBillNo});
        HashSet<String> voucherInfo = new HashSet<String>();
        for (DynamicObject vch : voucher) {
            voucherInfo.add(vch.getString("billno") + splitSign + vch.getString("bizdate") + splitSign + vch.getBigDecimal("entrydc").multiply(vch.getBigDecimal("debitlocal")) + splitSign + vch.getString("EntryID"));
        }
        ExceptionObj exceObj = null;
        String tip1 = ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528\u5f52\u96c6\u4e0e\u51ed\u8bc1\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"MfgFeeBill_0", (String)"macc-sca-business", (Object[])new Object[0]);
        String tip2 = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a%s\u3002", (String)"MfgFeeBill_1", (String)"macc-sca-business", (Object[])new Object[0]);
        for (String mfgFee : mfgFeeInfo) {
            if (voucherInfo.contains(mfgFee)) continue;
            exceObj = new ExceptionObj(0L, "sca_mfgfeebill");
            exceObj.setDescription(tip1);
            String[] infos = mfgFee.split(splitSign);
            if (infos == null || infos.length != 4) continue;
            exceObj.setExtralInfo(String.format(tip2, infos[0]));
            list.add(exceObj);
        }
        return list;
    }
}

