/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.business.checkdata.CheckDataParam;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.item.DataEntityDataCheck;
import kd.macc.sca.business.checkdata.item.IDataCheck;

public class PlannedBillClose
extends DataEntityDataCheck
implements IDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(CheckDataParam param) {
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>(16);
        Date date = PlannedBillClose.getFirstDayDateOfMonth(param.getExecuteDate());
        QFilter qfCostCenter = new QFilter("costcenter.orgduty.id", "=", (Object)4);
        QFilter qfBizDate = new QFilter("bizdate", ">=", (Object)date);
        QFilter qfWipQty = new QFilter("wipqty", "=", (Object)BigDecimal.ZERO);
        QFilter qfCloseStatu = new QFilter("closestatu", "=", (Object)Boolean.FALSE);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)param.getAppNum());
        DynamicObjectCollection plannedBill = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"billno,costobject.name costobjectname", (QFilter[])new QFilter[]{qfCostCenter, qfBizDate, qfWipQty, qfCloseStatu, qfAppNum});
        String tip = ResManager.loadKDString((String)"\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u672a\u5173\u95ed\u3002", (String)"PlannedBillClose_0", (String)"macc-sca-business", (Object[])new Object[0]);
        String tip1 = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a%2$s \u201c\u5728\u4ea7\u54c1\u6570\u91cf\u201d=0\u4e14\u201c\u5173\u95ed\u72b6\u6001\u201d=\u672a\u5173\u95ed", (String)"PlannedBillClose_4", (String)"macc-sca-business", (Object[])new Object[0]);
        ExceptionObj exceObj = null;
        for (DynamicObject planned : plannedBill) {
            exceObj = new ExceptionObj(0L, "cad_plannedoutputbill");
            exceObj.setDescription(tip);
            exceObj.setExtralInfo(String.format(tip1, planned.getString("billno"), planned.getString("costobjectname")));
            list.add(exceObj);
        }
        return list;
    }
}

