/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.business.checkdata.CheckDataParam;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.item.DataEntityDataCheck;
import kd.macc.sca.business.checkdata.item.IDataCheck;

public class ResourceUse
extends DataEntityDataCheck
implements IDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(CheckDataParam param) {
        QFilter qfAppNum;
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>(16);
        String selectFields = "resource.id resource,entryentity.costobject.srcbillnumber srcbillnumber,entryentity.costobject.srcbillrow srcbillrow,entryentity.facthour facthour,entryentity.factuse factuse,entryentity.factbatch factbatch";
        QFilter qfSource = new QFilter("source", "=", (Object)"SYS");
        Date date = ResourceUse.getFirstDayDateOfMonth(param.getExecuteDate());
        QFilter qfBizDate = new QFilter("bookdate", ">=", (Object)date);
        DynamicObjectCollection resourceUse = QueryServiceHelper.query((String)"sca_resourceuse", (String)selectFields, (QFilter[])new QFilter[]{qfSource, qfBizDate, qfAppNum = new QFilter("appnum", "=", (Object)param.getAppNum())});
        if (resourceUse.size() == 0) {
            return list;
        }
        String splitSign = "@";
        HashSet<String> billNos = new HashSet<String>(resourceUse.size());
        HashSet<String> allResource = new HashSet<String>(resourceUse.size());
        for (DynamicObject use : resourceUse) {
            billNos.add(use.getString("srcbillnumber"));
            allResource.add(use.getString("resource") + splitSign + use.getString("srcbillnumber") + splitSign + use.getString("srcbillrow") + splitSign + use.getString("facthour") + splitSign + use.getString("factuse") + splitSign + use.getString("factbatch"));
        }
        selectFields = "id,sumentry.seq AS seq,sumentry.resource AS resource,sumentry.manufacturenun AS srcbillnumber,sumentry.manufacturerow AS srcbillrow,sumentry.sumsubentry.entryunit.number AS subentryUnitNum,sumentry.sumsubentry.entryunit AS subentryunit,sumentry.sumsubentry.entrysumqty AS subentrysumqty,sumentry.completqty AS entrycompletqty";
        DynamicObjectCollection reportBills = QueryServiceHelper.query((String)"pom_processreportbill", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos)});
        Map<String, List<DynamicObject>> reportBillMap = this.rebuildReportBill(reportBills);
        HashSet<String> allReport = new HashSet<String>(16);
        for (Map.Entry<String, List<DynamicObject>> reportBillEntry : reportBillMap.entrySet()) {
            List<DynamicObject> reportBillSubEntrys = reportBillEntry.getValue();
            String resource = "";
            String srcbillnumber = "";
            String srcbillrow = "";
            String factuse = "";
            BigDecimal sumQty = BigDecimal.ZERO;
            for (DynamicObject reportBillSubEntry : reportBillSubEntrys) {
                resource = reportBillSubEntry.getString("resource");
                srcbillnumber = reportBillSubEntry.getString("srcbillnumber");
                srcbillrow = reportBillSubEntry.getString("srcbillrow");
                factuse = reportBillSubEntry.getString("entrycompletqty");
                String subentryUnitNum = reportBillSubEntry.getString("subentryUnitNum");
                BigDecimal subentrySumQty = reportBillSubEntry.getBigDecimal("subentrysumqty");
                switch (subentryUnitNum) {
                    case "hour": {
                        sumQty = sumQty.add(subentrySumQty.multiply(new BigDecimal(60)));
                        break;
                    }
                    case "minute": {
                        sumQty = sumQty.add(subentrySumQty);
                        break;
                    }
                    case "second": {
                        sumQty = sumQty.add(subentrySumQty.divide(new BigDecimal(60)));
                        break;
                    }
                }
            }
            allReport.add(resource + splitSign + srcbillnumber + splitSign + srcbillrow + splitSign + String.valueOf(sumQty) + splitSign + factuse + splitSign + "");
        }
        String tip1 = ResManager.loadKDString((String)"\u8f66\u95f4-\u5de5\u5e8f\u6c47\u62a5\u6570\u636e\u4e0e\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u6570\u636e\u4e0d\u4e00\u81f4\u3002", (String)"ResourceUse_0", (String)"macc-sca-business", (Object[])new Object[0]);
        String tip2 = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u53f7\uff1a%\uff0c\u884c\u53f7\uff1a%", (String)"ResourceUse_1", (String)"macc-sca-business", (Object[])new Object[0]);
        ExceptionObj exceObj = null;
        for (String allRes : allResource) {
            if (allReport.contains(allRes)) continue;
            exceObj = new ExceptionObj(0L, "pom_processreportbill");
            exceObj.setDescription(tip1);
            String[] infos = allRes.split(splitSign);
            if (infos == null || infos.length != 6) continue;
            exceObj.setExtralInfo(String.format(tip2, infos[1], infos[2]));
            list.add(exceObj);
        }
        return list;
    }

    private Map<String, List<DynamicObject>> rebuildReportBill(DynamicObjectCollection reportBills) {
        HashMap<String, List<DynamicObject>> reportBillMap = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject reportBill : reportBills) {
            String entryKey = reportBill.getString("id") + "@" + reportBill.getString("seq");
            reportBillMap.computeIfAbsent(entryKey, s -> new ArrayList()).add(reportBill);
        }
        return reportBillMap;
    }
}

