/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.business.checkdata.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.business.checkdata.CheckDataParam;
import kd.macc.sca.business.checkdata.ExceptionObj;
import kd.macc.sca.business.checkdata.item.DataEntityDataCheck;
import kd.macc.sca.business.checkdata.item.IDataCheck;

public class ResourceUseHasPrice
extends DataEntityDataCheck
implements IDataCheck {
    @Override
    public List<ExceptionObj> collectExceptionObj(CheckDataParam param) {
        ArrayList<ExceptionObj> list = new ArrayList<ExceptionObj>();
        Date date = ResourceUseHasPrice.getFirstDayDateOfMonth(param.getExecuteDate());
        QFilter qfBizDate = new QFilter("bookdate", ">=", (Object)date);
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)param.getAppNum());
        String selectFields = "billno,resource.id AS resourceid,resource.name AS resourcename";
        DynamicObjectCollection resourceUse = QueryServiceHelper.query((String)"sca_resourceuse", (String)selectFields, (QFilter[])new QFilter[]{qfBizDate, qfBillStatus, qfAppNum});
        if (resourceUse.size() == 0) {
            return list;
        }
        HashSet resourceIds = new HashSet(16);
        resourceUse.forEach(p -> resourceIds.add(p.getLong("resourceid")));
        QFilter qfResource = new QFilter("resource", "in", resourceIds);
        selectFields = "resource.id AS resourceid";
        DynamicObjectCollection resourcePrice = QueryServiceHelper.query((String)"cad_resourcerate", (String)selectFields, (QFilter[])new QFilter[]{qfResource, qfBillStatus});
        HashSet resourcePriceIds = new HashSet(16);
        resourcePrice.forEach(p -> resourcePriceIds.add(p.getLong("resourceid")));
        ExceptionObj exceObj = null;
        String tip = ResManager.loadKDString((String)"\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355\uff1a%1$s \u8d44\u6e90\uff1a%2$s \u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4ef7\u76ee\u8868\u3002", (String)"ResourceUseHasPrice_0", (String)"macc-sca-business", (Object[])new Object[0]);
        for (DynamicObject resource : resourceUse) {
            if (resourcePriceIds.contains(resource.getLong("resourceid"))) continue;
            exceObj = new ExceptionObj(0L, "sca_resourceuse");
            exceObj.setDescription(String.format(tip, resource.getString("billno"), resource.getString("resourcename")));
            exceObj.setExtralInfo(resource.getString("resourceid"));
            list.add(exceObj);
        }
        return list;
    }
}

