/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.alloc;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.sca.algox.calc.input.CalcDataArgs;
import kd.macc.sca.algox.utils.CadEmptyUtils;

@Deprecated
public class MatAllocDataHelper {
    public static String getAccountType(Long costAccountId, Long orgId, Long matId) {
        ArrayList<QFilter> calRangeQfList = new ArrayList<QFilter>();
        calRangeQfList.add(new QFilter("costaccount", "=", (Object)costAccountId));
        calRangeQfList.add(new QFilter("headcalorg", "=", (Object)orgId));
        DynamicObjectCollection calRanges = QueryServiceHelper.query((String)"cal_bd_calrange", (String)"id, costaccount, accounttype", (QFilter[])calRangeQfList.toArray(new QFilter[0]));
        if (calRanges.isEmpty()) {
            return "";
        }
        DynamicObject calRange = (DynamicObject)calRanges.get(0);
        ArrayList<QFilter> accountTypeQfList = new ArrayList<QFilter>();
        accountTypeQfList.add(new QFilter("calrange", "=", (Object)calRange.getLong("id")));
        accountTypeQfList.add(new QFilter("entry.material", "=", (Object)matId));
        DynamicObjectCollection accountTypes = QueryServiceHelper.query((String)"cal_bd_accounttype", (String)"calrange.costaccount AS costaccount, entry.material AS material, entry.accounttype AS accounttype", (QFilter[])accountTypeQfList.toArray(new QFilter[0]));
        if (accountTypes.isEmpty()) {
            return calRange.getString("accounttype");
        }
        return ((DynamicObject)accountTypes.get(0)).getString("accounttype");
    }

    public static Map<Long, Map<Long, List<DynamicObject>>> getCalCostRecord(Long costAccountId, List<Long> sourceBillEntryIds) {
        DynamicObjectCollection costRecords = MatAllocDataHelper.getCalCostRecordData(costAccountId, sourceBillEntryIds);
        HashMap<Long, Map<Long, List<DynamicObject>>> resultMap = new HashMap<Long, Map<Long, List<DynamicObject>>>();
        costRecords.forEach(e -> {
            Long bizbillid = e.getLong("bizbillid");
            long bizbillentryid = e.getLong("bizbillentryid");
            HashMap<Long, List> calCostRecEntryMap = (HashMap<Long, List>)resultMap.get(bizbillid);
            if (calCostRecEntryMap == null) {
                calCostRecEntryMap = new HashMap<Long, List>();
                resultMap.put(bizbillid, calCostRecEntryMap);
            }
            calCostRecEntryMap.computeIfAbsent(bizbillentryid, s -> new ArrayList()).add(e);
        });
        return resultMap;
    }

    private static DynamicObjectCollection getCalCostRecordData(Long costAccountId, List<Long> sourceBillEntryIds) {
        String fields = "bizbillid,entry.bizbillentryid AS bizbillentryid,entry.actualcost AS actualcost,entry.material AS material,entry.mversion.id AS matversion,entry.assist.id AS auxpty,entry.subentrycostelement.sub_actualcost AS subactualcost,entry.subentrycostelement.sub_unitactualcost AS subunitactualcost,entry.subentrycostelement.costelement AS element,entry.subentrycostelement.costsubelement AS subelement";
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)fields, (QFilter[])new QFilter[]{new QFilter("entry.bizbillentryid", "in", sourceBillEntryIds), new QFilter("costaccount", "=", (Object)costAccountId)});
        return costRecords;
    }

    public static void getHomemadeRange(Map<String, Object> commonParam, List<Map<String, Object>> bizParamList, Long accountorgID, Long bdPeriodID) {
        if (CadEmptyUtils.isEmpty(commonParam) || CadEmptyUtils.isEmpty(bizParamList) || CadEmptyUtils.isEmpty(accountorgID) || CadEmptyUtils.isEmpty(bdPeriodID)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u68c0\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"MatAllocDataHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]));
        }
        String algoKey = "kd.macc.sca.algox.utils.FinishCalcHelper.getFinishedCostObject";
        QFilter plannedoutputFilter = new QFilter("billstatus", "=", (Object)"C");
        plannedoutputFilter.and(new QFilter("accountorg", "=", (Object)accountorgID));
        DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)bdPeriodID, (String)"bd_period");
        if (CadEmptyUtils.isEmpty(period)) {
            return;
        }
        plannedoutputFilter.and(new QFilter("bizdate", "<=", (Object)period.getDate("enddate")));
        plannedoutputFilter.and(new QFilter("bizdate", ">=", (Object)period.getDate("begindate")));
        DataSet costObject = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_plannedoutputbill", (String)"costobject", (QFilter[])new QFilter[]{plannedoutputFilter}, null);
        ArrayList<String> mftorderBillnos = new ArrayList<String>();
        Map<Object, DynamicObject> costObjectMap = MatAllocDataHelper.getCostObjectIds(costObject);
        if (costObject != null && costObjectMap.size() > 0) {
            for (Map.Entry<Object, DynamicObject> object : costObjectMap.entrySet()) {
                mftorderBillnos.add(object.getValue().getString("srcbillnumber"));
            }
        }
        QFilter filterBillno = new QFilter("billno", "in", mftorderBillnos);
        QFilter filterTaskstatus = new QFilter("taskstatus", "=", (Object)"C");
        DynamicObjectCollection mftorderMaterialCollection = QueryServiceHelper.query((String)"pom_mftorder", (String)"treeentryentity.material.number number", (QFilter[])new QFilter[]{filterBillno, filterTaskstatus});
        ArrayList<String> materialNumbers = new ArrayList<String>();
        for (Object dynamicObject : mftorderMaterialCollection) {
            materialNumbers.add(dynamicObject.getString("number"));
        }
        HashSet<Long> materialIds = new HashSet<Long>();
        for (String materialBillno : materialNumbers) {
            DynamicObject material = BusinessDataServiceHelper.loadSingle((String)"bd_materialmftinfo", (String)"material,materialattr", (QFilter[])new QFilter("material.number", "=", (Object)materialBillno).toArray());
            if ("10030".equals(material.getString("materialattr")) || materialIds.contains(material.getLong("material.id"))) continue;
            materialIds.add(material.getLong("material.id"));
        }
        HashMap<String, HashSet<Long>> bizParam = new HashMap<String, HashSet<Long>>();
        bizParam.put("materials", materialIds);
        bizParamList.add(bizParam);
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"calx", (String)"DiffAllocService", (String)"diffAlloc", (Object[])new Object[]{commonParam, bizParamList});
    }

    private static Map<Object, DynamicObject> getCostObjectIds(DataSet costObject) {
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        Iterator it = costObject.iterator();
        while (it.hasNext()) {
            costObjectIds.add(((Row)it.next()).getLong("costobject"));
        }
        if (costObjectIds.size() == 0) {
            return new HashMap<Object, DynamicObject>(16);
        }
        return BusinessDataServiceHelper.loadFromCache((Object[])costObjectIds.toArray(), (String)"cad_costobject");
    }

    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(MatAllocDataHelper.getNowYear(), MatAllocDataHelper.getNowMonth() - 1, 1);
        return MatAllocDataHelper.getDayStartTime(calendar.getTime());
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public boolean difftDelete(CalcDataArgs args) {
        boolean delStatus = false;
        QFilter filter = new QFilter("org.id", "=", (Object)args.getOrgId());
        filter.and(new QFilter("period.id", "=", (Object)args.getPeriod()));
        filter.and(new QFilter("costaccount.id", "=", (Object)args.getCostAccount()));
        if (QueryServiceHelper.exists((String)"sca_purchdiffalloc", (QFilter[])filter.toArray())) {
            DeleteServiceHelper.delete((String)"sca_purchdiffalloc", (QFilter[])filter.toArray());
            delStatus = true;
        }
        return delStatus;
    }
}

