/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.alloc;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.alloc.MatAllocDataHelper;
import kd.macc.sca.algox.alloc.MatAllocProcessor;
import kd.macc.sca.algox.alloc.input.AllocDataParameter;
import kd.macc.sca.algox.alloc.output.AllocResult;
import kd.macc.sca.algox.enums.ScaAllocEnum;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CostTypeHelper;
import kd.macc.sca.algox.utils.ElementHelper;
import kd.macc.sca.algox.utils.FormulaUtil;
import kd.macc.sca.algox.utils.MatCostHelper;

@Deprecated
public class MatAllocHelper {
    private static final Log logger = LogFactory.getLog(MatAllocHelper.class);
    private static final String[] allocFields = new String[]{"id", "org", "costcenter", "resource", "costobject", "material", "facthour"};
    private static final String[] resFields = new String[]{"resType"};
    private static final String COSTCENTER = "COSTCENTER";
    private static final String COSTOBJECT = "COSTOBJECT";
    private static final String OPERATOR = "+-*/()";
    public static final String fields = "id, billno, bizdate,bookdate, org, costcenter, biztype, appnum, sourcebillid, srcauditdate, auditdate,entryentity.id As entryid, entryentity.seq As seq, entryentity.material As material, entryentity.material.isenablematerialversion AS isusematver, entryentity.material.isuseauxpty AS isuseauxpty, entryentity.material.name As materialname, entryentity.material.group AS materialgroup,entryentity.matversion AS matversion,entryentity.auxpty AS auxpty,entryentity.lotcoderule AS lotcoderule,entryentity.qty AS qty, entryentity.warehouse AS warehouse, entryentity.location AS location,entryentity.outinvtype AS outinvtype,entryentity.costobject AS costobject, entryentity.unit AS unit,entryentity.sourcebillentryid AS sourcebillentryid";

    private static void validateAllocResultStatus(Set<Long> allocIds, AllocResult allocResult) {
        QFilter filter = new QFilter("id", "in", allocIds);
        filter.and(new QFilter("entryentity.id", ">", (Object)1L));
        DynamicObjectCollection entrys = QueryServiceHelper.query((String)"sca_matalloc", (String)"id", (QFilter[])new QFilter[]{filter});
        Map<String, String> map = allocResult.getReasonMap();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        for (Long id : allocIds) {
            boolean result = false;
            if (!CadEmptyUtils.isEmpty(entrys)) {
                for (DynamicObject entry : entrys) {
                    if (!id.equals(entry.getLong("id"))) continue;
                    result = true;
                    break;
                }
            }
            if (result) continue;
            map.computeIfAbsent(id.toString(), s -> "error");
        }
        allocResult.setReasonMap(map);
    }

    public static AllocResult doAlloc(Set<Long> allocIds) {
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d-\u6279\u91cf\u5206\u914d\uff1a{}", (Object)allocIds.toString());
        AllocDataParameter param = MatAllocHelper.wrapParam(allocIds);
        MatAllocProcessor allocProcessor = new MatAllocProcessor();
        AllocResult allocResult = allocProcessor.allocate(param);
        MatAllocHelper.validateAllocResultStatus(allocIds, allocResult);
        return allocResult;
    }

    public static AllocResult doAlloc(Set<Long> allocIds, String allocStatus) {
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d-\u6279\u91cf\u5206\u914d\uff0c\u53ef\u81ea\u5b9a\u4e49\u5206\u914d\u72b6\u6001\uff1a{}", (Object)allocIds.toString());
        AllocDataParameter param = MatAllocHelper.wrapParam(allocIds);
        param.setAllocStatus(allocStatus);
        MatAllocProcessor allocProcessor = new MatAllocProcessor();
        AllocResult allocResult = allocProcessor.allocate(param);
        MatAllocHelper.validateAllocResultStatus(allocIds, allocResult);
        return allocResult;
    }

    public static AllocResult doAlloc(DynamicObject alloc) {
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d-\u5355\u4e2a\u5b9e\u65f6\u5206\u914d\uff1a{}", (Object)alloc.getString("id"));
        AllocDataParameter param = MatAllocHelper.wrapParam(alloc);
        MatAllocProcessor allocProcessor = new MatAllocProcessor();
        return allocProcessor.allocate(param);
    }

    private static AllocDataParameter wrapParam(Set<Long> allocIds) {
        HashMap<Long, Map<String, Object>> allocMap = new HashMap<Long, Map<String, Object>>();
        Map<Long, Map<Long, Set<String>>> collDataMap = MatAllocHelper.getCollData(allocIds, allocMap);
        return MatAllocHelper.wrapParam(allocMap, collDataMap);
    }

    private static AllocDataParameter wrapParam(DynamicObject alloc) {
        HashMap<Long, Map<String, Object>> allocMap = new HashMap<Long, Map<String, Object>>();
        Map itemMap = allocMap.computeIfAbsent(alloc.getLong("id"), s -> new HashMap());
        DynamicObject org = alloc.getDynamicObject("org");
        Long ccId = alloc.getDynamicObject("costcenter").getLong("id");
        DynamicObject costdriver = alloc.getDynamicObject("costdriver");
        itemMap.put("id", alloc.getLong("id"));
        itemMap.put("org", org.getLong("id"));
        itemMap.put("costcenter", ccId);
        DynamicObject period = alloc.getDynamicObject("period");
        if (period != null) {
            itemMap.put("begindate", alloc.getDynamicObject("period").getDate("begindate"));
            Date endDate = MatAllocHelper.getMinDate(alloc.getDynamicObject("period").getDate("enddate"), new Date());
            itemMap.put("enddate", endDate);
            itemMap.put("periodId", period.getLong("id"));
        }
        itemMap.put("stdnumber", costdriver.getString("number"));
        itemMap.put("costdriver", costdriver.getLong("id"));
        itemMap.put("material", alloc.getDynamicObject("material").getPkValue());
        itemMap.put("costaccount", alloc.getDynamicObject("costaccount").getPkValue());
        HashMap<Long, Map<Long, Set<String>>> collDataMap = new HashMap<Long, Map<Long, Set<String>>>();
        Map driverMap = collDataMap.computeIfAbsent(alloc.getLong("id"), s -> new HashMap());
        Set matSet = driverMap.computeIfAbsent(costdriver.getLong("id"), s -> new HashSet(16));
        return MatAllocHelper.wrapParam(allocMap, collDataMap);
    }

    private static AllocDataParameter wrapParam(Map<Long, Map<String, Object>> allocMap, Map<Long, Map<Long, Set<String>>> collDataMap) {
        AllocDataParameter param = new AllocDataParameter();
        param.setCollDataMap(collDataMap);
        HashMap<String, Map<String, BigDecimal>> allocstdValueDataSets = new HashMap<String, Map<String, BigDecimal>>(16);
        for (Map.Entry<Long, Map<String, Object>> entry : allocMap.entrySet()) {
            Map<String, BigDecimal> costCenterValues;
            Map<String, Object> itemMap = entry.getValue();
            Long costDriverId = (Long)itemMap.get("costdriver");
            Long costcenterId = (Long)itemMap.get("costcenter");
            String costDriverkey = String.format("%s@%s", costcenterId, costDriverId);
            String stdNumber = String.valueOf(itemMap.get("stdnumber"));
            if (StringUtils.isEmpty((CharSequence)stdNumber) || CadEmptyUtils.isEmpty(costDriverId) || allocstdValueDataSets.containsKey(costDriverkey) || CadEmptyUtils.isEmpty(costCenterValues = MatAllocHelper.getCostCenterValues(stdNumber, itemMap))) continue;
            allocstdValueDataSets.put(costDriverkey, costCenterValues);
        }
        param.setAllocStdValueColls(allocstdValueDataSets);
        param.setProcessingAllocEntity("sca_matalloc");
        String userId = RequestContext.get().getUserId();
        param.setAllocor(userId == null ? 1L : Long.parseLong(String.valueOf(userId)));
        return param;
    }

    private static Map<String, BigDecimal> getCostCenterValues(String stdNumber, Map<String, Object> itemMap) {
        Map<String, BigDecimal> costCenterValues = null;
        switch (stdNumber) {
            case "CD_SCA000001_sys": {
                costCenterValues = MatAllocHelper.getCompeteBillDataBy(itemMap, false);
                break;
            }
            case "CD_SCA000007_sys": {
                costCenterValues = MatAllocHelper.getCompeteBillDataBy(itemMap, true);
                break;
            }
            case "CD_SCA000002_sys": {
                costCenterValues = MatAllocHelper.getPlanBillDataBy(itemMap, "qty");
                break;
            }
            case "CD_SCA000003_sys": {
                costCenterValues = MatAllocHelper.getPlanBillDataBy(itemMap, "wipqty");
                break;
            }
            case "CD_SCA000005_sys": {
                HashSet<String> resTypeSet = new HashSet<String>(16);
                resTypeSet.add("mpdm_equipment");
                resTypeSet.add("mpdm_toolsresource");
                resTypeSet.add("mpdm_toolequip");
                resTypeSet.add("mpdm_mould");
                Set<Long> resourceIds = MatAllocHelper.getResourceFromType(resTypeSet);
                if (resourceIds.isEmpty()) break;
                costCenterValues = MatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, "facthour", "");
                break;
            }
            case "CD_SCA000006_sys": {
                HashSet<String> resTypeSet = new HashSet<String>(16);
                resTypeSet.add("mpdm_manuperson");
                Set<Long> resourceIds = MatAllocHelper.getResourceFromType(resTypeSet);
                if (resourceIds.isEmpty()) break;
                costCenterValues = MatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, "facthour", "0");
                break;
            }
            case "CD_SCA000008_sys": {
                HashSet<String> resTypeSet = new HashSet<String>(16);
                resTypeSet.add("mpdm_manuperson");
                Set<Long> resourceIds = MatAllocHelper.getResourceFromType(resTypeSet);
                if (resourceIds.isEmpty()) break;
                costCenterValues = MatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, "facthour", "1");
                break;
            }
            case "CD_SCA000010_sys": {
                HashSet<String> resTypeSet = new HashSet<String>(16);
                resTypeSet.add("mpdm_manuperson");
                resTypeSet.add("mpdm_equipment");
                resTypeSet.add("mpdm_toolsresource");
                resTypeSet.add("mpdm_toolequip");
                resTypeSet.add("mpdm_mould");
                Set<Long> resourceIds = MatAllocHelper.getResourceFromType(resTypeSet);
                if (resourceIds.isEmpty()) break;
                costCenterValues = MatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, "facthour", "0");
                break;
            }
            case "CD_SCA000011_sys": {
                HashSet<String> resTypeSet = new HashSet<String>(16);
                resTypeSet.add("mpdm_manuperson");
                resTypeSet.add("mpdm_equipment");
                resTypeSet.add("mpdm_toolsresource");
                resTypeSet.add("mpdm_toolequip");
                resTypeSet.add("mpdm_mould");
                Set<Long> resourceIds = MatAllocHelper.getResourceFromType(resTypeSet);
                if (resourceIds.isEmpty()) break;
                costCenterValues = MatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, "facthour", "1");
                break;
            }
            case "CD_SCA000012_sys": {
                costCenterValues = MatAllocHelper.getReworkCompeteBillDataBy(itemMap);
                break;
            }
            default: {
                costCenterValues = MatAllocHelper.getAllocDataByDiyCostDrive(itemMap);
            }
        }
        return costCenterValues;
    }

    public static DataSet getCostDriverValue(Map<String, Object> itemMap) {
        String stdNumber = String.valueOf(itemMap.get("stdnumber"));
        Map<String, BigDecimal> costCenterValues = MatAllocHelper.getCostCenterValues(stdNumber, itemMap);
        return MatAllocHelper.buildDsResult(costCenterValues);
    }

    private static DataSet buildDsResult(Map<String, BigDecimal> costCenterValues) {
        if (CadEmptyUtils.isEmpty(costCenterValues)) {
            return null;
        }
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        for (Map.Entry<String, BigDecimal> entry : costCenterValues.entrySet()) {
            String[] split;
            Object[] arr = new Object[5];
            String key = entry.getKey();
            if (StringUtils.isNotBlank((CharSequence)key) && (split = key.split("@")) != null) {
                System.arraycopy(split, 0, arr, 0, split.length);
                arr[4] = entry.getValue();
            }
            dataList.add(arr);
        }
        DataSet ds = Algo.create((String)"kd.macc.sca.algox.alloc.MatAllocHelper").createDataSet(dataList.iterator(), MatAllocHelper.getRowMeta());
        return ds;
    }

    private static RowMeta getRowMeta() {
        List<Field> field = MatAllocHelper.getRowMetaField();
        return new RowMeta(field.toArray(new Field[0]));
    }

    private static List<Field> getRowMetaField() {
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("org", (DataType)DataType.LongType));
        field.add(new Field("costcenter", (DataType)DataType.LongType));
        field.add(new Field("costobject", (DataType)DataType.LongType));
        field.add(new Field("material", (DataType)DataType.LongType));
        field.add(new Field("value", (DataType)DataType.BigDecimalType));
        return field;
    }

    private static Map<Long, Map<Long, Set<String>>> getCollData(Set<Long> allocIds, Map<Long, Map<String, Object>> allocMap) {
        if (CadEmptyUtils.isEmpty(allocIds)) {
            return null;
        }
        String algoKey = "kd.macc.sca.algox.alloc.MatAllocHelper.getCollData";
        QFilter allocFilter = new QFilter("id", "in", allocIds);
        DataSet allocDataSet = QueryServiceHelper.queryDataSet((String)(algoKey + "1"), (String)"sca_matalloc", (String)"id, org,manuorg, costaccount, material,matversion,auxpty,material.group materialgroup,period.id periodId,period.begindate begindate,period.enddate enddate,costcenter,costobject,costdriver,costdriver.number stdnumber,appnum", (QFilter[])new QFilter[]{allocFilter}, null);
        DataSet allocCopyDataSet = allocDataSet.copy();
        Iterator it = allocCopyDataSet.iterator();
        String appnum = "sca";
        HashMap<Long, Map<Long, Set<String>>> dataMap = new HashMap<Long, Map<Long, Set<String>>>();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long costdriverId = row.getLong("costdriver");
            Long id = row.getLong("id");
            Map itemMap = allocMap.computeIfAbsent(row.getLong("id"), s -> new HashMap());
            itemMap.put("id", id);
            itemMap.put("org", row.getLong("org"));
            itemMap.put("manuorg", row.getLong("manuorg"));
            itemMap.put("costaccount", row.getLong("costaccount"));
            itemMap.put("costcenter", row.getLong("costcenter"));
            itemMap.put("begindate", row.getDate("begindate"));
            itemMap.put("periodId", row.getLong("periodId"));
            Date endDate = MatAllocHelper.getMinDate(row.getDate("enddate"), new Date());
            itemMap.put("enddate", endDate);
            itemMap.put("stdnumber", row.getString("stdnumber"));
            itemMap.put("costdriver", costdriverId);
            itemMap.put("material", row.getLong("material"));
            itemMap.put("matversion", row.getLong("matversion"));
            itemMap.put("auxpty", row.getLong("auxpty"));
            itemMap.put("materialgroup", row.getLong("materialgroup"));
            dataMap.computeIfAbsent(id, s -> new HashMap()).computeIfAbsent(costdriverId, s -> new HashSet());
        }
        return dataMap;
    }

    private static Map<String, BigDecimal> getPlanBillDataBy(Map<String, Object> allocMap, String qtyFields) {
        String selectFields = "id,accountorg org,costcenter,costobject,costobject.material material," + qtyFields + " value";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and accountorg = ? and costcenter = ? ", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter")});
        if ("qty".equals(qtyFields)) {
            filter.and(QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{allocMap.get("begindate"), allocMap.get("enddate")}));
        } else {
            filter.and(QFilter.of((String)"bizdate <= ?", (Object[])new Object[]{allocMap.get("enddate")}));
        }
        Object allocMatId = allocMap.get("material");
        if (allocMatId != null) {
            filter.and(new QFilter("costobject.material", "!=", allocMatId));
        }
        filter.and(new QFilter("appnum", "=", (Object)"sca"));
        return MatAllocHelper.queryStdValDataBy("cad_plannedoutputbill", selectFields, filter, allocMap);
    }

    private static Map<String, BigDecimal> getCompeteBillDataBy(Map<String, Object> allocMap, boolean isOutSource) {
        String selectFields = "id,org,costcenter,entryentity.costobject costobject,material,entryentity.qty value";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? and bookdate >= ? and bookdate <= ?", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter"), allocMap.get("begindate"), allocMap.get("enddate")});
        Object allocMatId = allocMap.get("material");
        if (allocMatId != null) {
            filter.and(new QFilter("material", "!=", allocMatId));
        }
        filter.and(new QFilter("appnum", "=", (Object)"sca"));
        filter.and("entryentity.costobject.isoutsource", "=", (Object)isOutSource);
        return MatAllocHelper.queryStdValDataBy("cad_factnedoutputbill", selectFields, filter, allocMap);
    }

    private static Map<String, BigDecimal> getReworkCompeteBillDataBy(Map<String, Object> allocMap) {
        String selectFields = "id,org,costcenter,entryentity.costobject costobject,material,entryentity.qty value";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? and bookdate >= ? and bookdate <= ?", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter"), allocMap.get("begindate"), allocMap.get("enddate")});
        Object allocMatId = allocMap.get("material");
        if (allocMatId != null) {
            filter.and(new QFilter("material", "!=", allocMatId));
        }
        filter.and(new QFilter("appnum", "=", (Object)"sca"));
        filter.and(new QFilter("entryentity.costobject.isrework", "=", (Object)Boolean.TRUE));
        return MatAllocHelper.queryStdValDataBy("cad_factnedoutputbill", selectFields, filter, allocMap);
    }

    public static QFilter getEffectDateFilter(Long periodId) {
        Date date = MatAllocHelper.getEndDateByPeriod(periodId);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        return dateFilter;
    }

    private static Date getEndDateByPeriod(Long periodId) {
        QFilter qFilter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,enddate", (QFilter[])qFilter.toArray());
        if (period == null) {
            return new Date();
        }
        return period.getDate("enddate");
    }

    private static Map<String, BigDecimal> queryStdValDataBy(String entity, String selectFields, QFilter filter, Map<String, Object> allocMap) {
        DataSet allocstdValueDataSet = QueryServiceHelper.queryDataSet((String)"MatAllocHelper.queryStdValDataBy", (String)entity, (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> settleObject = new HashSet<Long>(32);
        allocstdValueDataSet.copy().forEach(row -> settleObject.add(row.getLong("costobject")));
        DataSet costObjectBizStatusDataSet = MatAllocHelper.getCostObjectAccountDataSet(Long.valueOf(allocMap.get("costaccount").toString()), settleObject);
        DataSet withCostObjectBizStatus = allocstdValueDataSet.leftJoin(costObjectBizStatusDataSet).on("costobject", "costobject").select(new String[]{"org", "costcenter", "costobject", "material", "value", "bizstatus"}).finish();
        GroupbyDataSet groupDataSet = withCostObjectBizStatus.select("org,costcenter,costobject,material,value,bizstatus").groupBy(new String[]{"org", "costcenter", "costobject", "material", "bizstatus"});
        groupDataSet.sum("value");
        DataSet groupbyValueDataSet = groupDataSet.finish();
        HashMap<String, BigDecimal> costCenterValues = new HashMap<String, BigDecimal>();
        for (Row row2 : groupbyValueDataSet) {
            if ("B".equals(row2.getString("bizstatus"))) continue;
            String key = row2.getString(0) + "@" + row2.getString(1) + "@" + row2.getString(2) + "@" + row2.getString(3);
            BigDecimal value = row2.getBigDecimal("value");
            if (value.doubleValue() == 0.0) continue;
            costCenterValues.put(key, value);
        }
        return costCenterValues;
    }

    private static DataSet getCostObjectAccountDataSet(Map<String, Object> allocMap) {
        ArrayList<QFilter> qf = new ArrayList<QFilter>();
        qf.add(new QFilter("costaccount", "=", allocMap.get("costaccount")));
        DataSet costObjectBizStatusDataSet = QueryServiceHelper.queryDataSet((String)"MatAllocHelper.queryStdValDataBy", (String)"cad_costobjectaccount", (String)"costobject, bizstatus", (QFilter[])qf.toArray(new QFilter[0]), null);
        return costObjectBizStatusDataSet;
    }

    private static DataSet getCostObjectAccountDataSet(Long costaccount, Set<Long> costobjects) {
        ArrayList<QFilter> qf = new ArrayList<QFilter>();
        qf.add(new QFilter("costaccount", "=", (Object)costaccount));
        qf.add(new QFilter("bizstatus", "=", (Object)"B"));
        qf.add(new QFilter("costobject", "in", costobjects));
        DataSet costObjectBizStatusDataSet = QueryServiceHelper.queryDataSet((String)"MatAllocHelper.queryStdValDataBy", (String)"cad_costobjectaccount", (String)"costobject, bizstatus", (QFilter[])qf.toArray(new QFilter[0]), null);
        return costObjectBizStatusDataSet;
    }

    private static Set<Long> getResourceFromType(Set<String> types) {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("resourcesentryentity.itemclasstype", "in", types);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.alloc.AcaMatAllocHelper.getRourceDs", (String)"mpdm_resources", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> resourceIds = new HashSet<Long>(32);
        while (ds.hasNext()) {
            resourceIds.add(ds.next().getLong("id"));
        }
        return resourceIds;
    }

    private static Map<String, BigDecimal> getResourceBillQtyBy(Map<String, Object> allocMap, Set<Long> resourceIds, String valueField, String isOutSource) {
        DataSet allocstdValueDataSet;
        String algoKey = "kd.macc.sca.algox.alloc.MatAllocHelper.getResourceBillQtyBy2";
        String selectFields = "id,org,costcenter,resource,entryentity.costobject costobject,entryentity.material material,entryentity.workhour as workhour,entryentity." + valueField + " facthour";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? and bookdate >= ? and bookdate <= ?", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter"), allocMap.get("begindate"), allocMap.get("enddate")});
        Object allocMatId = allocMap.get("material");
        if (allocMatId != null) {
            filter.and(new QFilter("entryentity.material", "!=", allocMatId));
        }
        filter.and(new QFilter("appnum", "=", (Object)"sca"));
        if (!CollectionUtils.isEmpty(resourceIds)) {
            filter.and("resource", "in", resourceIds);
        }
        if (StringUtils.isNotBlank((CharSequence)isOutSource)) {
            boolean isOut = isOutSource.equals("1");
            filter.and("entryentity.costobject.isoutsource", "=", (Object)isOut);
        }
        if ((allocstdValueDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_resourceuse", (String)selectFields, (QFilter[])new QFilter[]{filter}, null)).isEmpty()) {
            return null;
        }
        DataSet groupbyValueDataSet = allocstdValueDataSet.select("id,resource,org,costcenter,costobject,material,case when workhour=10 then facthour*60 when workhour=8 then facthour/60 else facthour end facthour").groupBy(new String[]{"org", "costcenter", "costobject", "material"}).sum("facthour").finish();
        HashSet<Long> settleObject = new HashSet<Long>(32);
        groupbyValueDataSet.copy().forEach(row -> settleObject.add(row.getLong("costobject")));
        DataSet costObjectDs = MatAllocHelper.getCostObjectAccountDataSet(Long.valueOf(allocMap.get("costaccount").toString()), settleObject);
        groupbyValueDataSet = groupbyValueDataSet.leftJoin(costObjectDs).on("costobject", "costobject").select(new String[]{"org", "costcenter", "costobject", "material", "facthour", "bizstatus"}).finish();
        HashMap<String, BigDecimal> costCenterValues = new HashMap<String, BigDecimal>();
        for (Row row2 : groupbyValueDataSet) {
            if ("B".equals(row2.getString("bizstatus"))) continue;
            String key = row2.getString("org") + "@" + row2.getString("costcenter") + "@" + row2.getString("costobject") + "@" + row2.getString("material");
            BigDecimal value = row2.getBigDecimal("facthour");
            if (value.doubleValue() == 0.0) continue;
            costCenterValues.put(key, value);
        }
        return costCenterValues;
    }

    private static Map<String, BigDecimal> getResourceBillQtyBy(Map<String, Object> allocMap) {
        String selectFields = "id,org,costcenter,resource,entryentity.costobject costobject,entryentity.material material,entryentity.workhour as workhour,entryentity.facthour facthour,entryentity.factuse factuse,entryentity.factbatch factbatch";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? and bookdate >= ? and bookdate <= ?", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter"), allocMap.get("begindate"), allocMap.get("enddate")});
        Object allocMatId = allocMap.get("material");
        if (allocMatId != null) {
            filter.and(new QFilter("entryentity.material", "!=", allocMatId));
        }
        filter.and(new QFilter("appnum", "=", (Object)"sca"));
        DataSet allocstdValueDataSet = QueryServiceHelper.queryDataSet((String)"MatAllocHelper.queryStdValDataBy", (String)"sca_resourceuse", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> settleObject = new HashSet<Long>(32);
        allocstdValueDataSet.copy().forEach(row -> settleObject.add(row.getLong("costobject")));
        DataSet costObjectBizStatusDataSet = MatAllocHelper.getCostObjectAccountDataSet(Long.valueOf(allocMap.get("costaccount").toString()), settleObject);
        DataSet withCostObjectBizStatus = allocstdValueDataSet.leftJoin(costObjectBizStatusDataSet).on("costobject", "costobject").select(new String[]{"org", "costcenter", "resource", "costobject", "material", "facthour", "factuse", "factbatch", "bizstatus"}).finish();
        GroupbyDataSet groupDataSet = withCostObjectBizStatus.select("org,costcenter,resource,costobject,material,case when workhour=10 then facthour*60 when workhour=8 then facthour/60 else facthour end facthour,case when workhour=10 then factuse*60 when workhour=8 then factuse/60 else factuse end factuse,case when workhour=10 then factbatch*60 when workhour=8 then factbatch/60 else factbatch end factbatch,bizstatus").groupBy(new String[]{"org", "costcenter", "resource", "costobject", "material", "bizstatus"});
        groupDataSet.sum("facthour");
        groupDataSet.sum("factuse");
        groupDataSet.sum("factbatch");
        DataSet groupbyValueDataSet = groupDataSet.finish();
        QFilter rateFilter = QFilter.of((String)"billstatus = 'C' and costtype.createorg =? ", (Object[])new Object[]{allocMap.get("org")});
        DynamicObjectCollection rates = QueryServiceHelper.query((String)"cad_resourcerate", (String)"resource,calcbasis", (QFilter[])new QFilter[]{rateFilter});
        HashMap<String, BigDecimal> costCenterValues = new HashMap<String, BigDecimal>();
        for (Row row2 : groupbyValueDataSet) {
            if ("B".equals(row2.getString("bizstatus"))) continue;
            String calcbasis = null;
            for (DynamicObject rate : rates) {
                Long resource = rate.getLong("resource");
                if (!row2.getLong("resource").equals(resource)) continue;
                calcbasis = rate.getString("calcbasis");
            }
            String key = row2.getString("org") + "@" + row2.getString("costcenter") + "@" + row2.getString("costobject") + "@" + row2.getString("material");
            BigDecimal value = BigDecimal.ZERO;
            if (calcbasis == null || calcbasis.length() == 0) continue;
            switch (calcbasis) {
                case "001": {
                    value = row2.getBigDecimal("facthour");
                    break;
                }
                case "002": {
                    value = row2.getBigDecimal("factuse");
                    break;
                }
                case "003": {
                    value = row2.getBigDecimal("factbatch");
                }
            }
            if (value.doubleValue() == 0.0) continue;
            costCenterValues.put(key, value);
        }
        return costCenterValues;
    }

    public static Date getMinDate(Date start, Date end) {
        if (start == null && end == null) {
            return null;
        }
        if (start != null && end == null) {
            return start;
        }
        if (start == null && end != null) {
            return end;
        }
        int diff = start.compareTo(end);
        return diff <= 0 ? start : end;
    }

    public static int importAllocData(Map<Long, List<Long>> paramMap) {
        String selectFields = "id AS costaccount,number AS costaccountnum,calorg AS org,costtype AS costtype,calpolicy.currency.id AS currency,calpolicy.currency.amtprecision AS amtprecision";
        Set<Long> costaccountIdSet = paramMap.keySet();
        QFilter idQF = new QFilter("id", "in", costaccountIdSet);
        DynamicObjectCollection costaccountColl = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)selectFields, (QFilter[])new QFilter[]{idQF});
        ArrayList<Map<String, Object>> costaccountList = new ArrayList<Map<String, Object>>();
        for (DynamicObject data : costaccountColl) {
            Long costaccountId = data.getLong("costaccount");
            Long orgId = data.getLong("org");
            HashMap<String, Object> costaccountMap = new HashMap<String, Object>();
            costaccountMap.put("org", orgId);
            costaccountMap.put("costaccountnum", data.getString("costaccountnum"));
            costaccountMap.put("costaccountId", costaccountId);
            costaccountMap.put("currencyId", data.getLong("currency"));
            costaccountMap.put("amtprecision", data.getInt("amtprecision"));
            costaccountMap.put("costtypeId", data.getLong("costtype"));
            boolean useMatVer = CostTypeHelper.isUseMatVersion(data.getLong("costtype"));
            costaccountMap.put("useMatVer", useMatVer);
            costaccountMap.put("currentperiodId", MatAllocHelper.getPeriod(orgId, costaccountId));
            costaccountMap.put("costObjectList", paramMap.get(costaccountId));
            costaccountList.add(costaccountMap);
        }
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
        AllocResult alloc = MatAllocHelper.toAlloc(costaccountList, billList);
        if (alloc == null || alloc.getReasonMap() == null) {
            return 0;
        }
        if (!billList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])billList.toArray(new DynamicObject[0]));
        }
        return billList.size();
    }

    public static int importAllocData(List<Long> costaccountIdList) {
        HashMap<Long, List<Long>> paramMap = new HashMap<Long, List<Long>>(16);
        for (Long costaccountId : costaccountIdList) {
            paramMap.put(costaccountId, null);
        }
        return MatAllocHelper.importAllocData(paramMap);
    }

    private static Long getPeriod(Long orgId, Long costaccountId) {
        if (orgId == null || costaccountId == null) {
            return null;
        }
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQF = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF});
        if (res == null || res.size() == 0) {
            return null;
        }
        return ((DynamicObject)res.get(0)).getLong("currentperiod");
    }

    private static AllocResult toAlloc(List<Map<String, Object>> costAccountList, List<DynamicObject> billList) {
        AllocResult res = new AllocResult();
        res.setReasonMap(new HashMap<String, String>());
        int totalCount = 0;
        for (Map<String, Object> costAccountMap : costAccountList) {
            if (costAccountMap.get("costtypeId") == null) {
                Map<String, String> reasonMap = res.getReasonMap();
                reasonMap.put((String)costAccountMap.get("costaccountnum") + "_", ResManager.loadKDString((String)"\u8be5\u8d26\u7c3f\u4e0b\uff0c\u6210\u672c\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"MatAllocHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]));
                res.setSuccess(false);
                continue;
            }
            DynamicObjectCollection bills = MatAllocHelper.getImportData(costAccountMap);
            if (bills == null || bills.isEmpty()) continue;
            totalCount += bills.size();
            ArrayList<DynamicObject> scaProcessList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> acaProcessList = new ArrayList<DynamicObject>();
            HashMap<String, Date> costRecDateMap = new HashMap<String, Date>(16);
            ArrayList<Long> sourceBillEntryIds = new ArrayList<Long>();
            MatAllocHelper.splitScaAndAcaBill(costAccountMap, bills, scaProcessList, acaProcessList, sourceBillEntryIds, costRecDateMap);
            MatAllocHelper.toScaBills(scaProcessList, costAccountMap, billList, costRecDateMap, res);
            MatAllocHelper.toAcaBills(acaProcessList, costAccountMap, billList, costRecDateMap, res, sourceBillEntryIds);
        }
        res.setTotalCount(totalCount);
        res.setSuccessCount(billList.size());
        res.setFailCount(totalCount - billList.size());
        String countTip = MatAllocHelper.generateCountTip(res);
        Map<String, String> reasonMap = res.getReasonMap();
        if (res.isSuccess()) {
            if (billList.isEmpty()) {
                res.setSuccess(false);
                reasonMap.put("false", ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u5f53\u524d\u671f\u95f4\u5185\u6ca1\u6709\u53ef\u5f15\u5165\u7684\u6570\u636e\u3002", (String)"MatAllocHelper_8", (String)"macc-sca-algox", (Object[])new Object[0]));
            } else {
                String useAmountIsEmptyTip = MatAllocHelper.generateUseAmountIsEmptyTip(billList);
                reasonMap.put("useAmountIsEmptyTip", useAmountIsEmptyTip);
                reasonMap.put("success", countTip);
            }
        } else {
            String failBillTip = MatAllocHelper.generateFailBillTip(reasonMap);
            reasonMap.clear();
            reasonMap.put("false", countTip + "\r\n" + failBillTip);
        }
        return res;
    }

    private static String generateFailBillTip(Map<String, String> reasonMap) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> tipSet = new HashSet<String>(16);
        int tipLength = 100;
        int currTip = 0;
        for (Map.Entry<String, String> entry : reasonMap.entrySet()) {
            String key = entry.getKey();
            String msg = ResManager.loadKDString((String)(key.substring(0, key.indexOf("_")) + "MatAllocHelper_2" + entry.getValue()), (String)"MatAllocateListPlugin_0", (String)"macc-sca-algox", (Object[])new Object[0]);
            if (tipSet.contains(msg)) continue;
            tipSet.add(msg);
            sb.append(msg);
            sb.append("\r\n");
            if (++currTip < tipLength) continue;
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    private static String generateCountTip(AllocResult res) {
        return String.format(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f\u3002\u5f15\u5165\u6570\u636e\u3010%1$s\u3011\u6761\uff0c\u6210\u529f\u3010%2$s\u3011\u6761\uff0c\u5931\u8d25\u3010%3$s\u3011\u6761\u3002", (String)"MatAllocHelper_9", (String)"macc-sca-algox", (Object[])new Object[0]), res.getTotalCount(), res.getSuccessCount(), res.getFailCount());
    }

    private static String generateUseAmountIsEmptyTip(List<DynamicObject> billList) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject bill : billList) {
            if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("useamount")) != 0 || !"calrec".equals(bill.getString("entrysrc"))) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u91d1\u989d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u76f8\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5b9e\u9645\u6210\u672c\u3002", (String)"MatAllocHelper_4", (String)"macc-sca-algox", (Object[])new Object[0]), bill.getString("billno"));
            sb.append(msg);
            sb.append("\r\n");
        }
        if (!StringUtils.isEmpty((CharSequence)sb.toString())) {
            return sb.toString();
        }
        return "";
    }

    private static void splitScaAndAcaBill(Map<String, Object> costAccountMap, DynamicObjectCollection bills, List<DynamicObject> scaProcessList, List<DynamicObject> acaProcessList, List<Long> sourceBillEntryIds, Map<String, Date> costRecDateMap) {
        ArrayList matUseSrcBillEntryIds = new ArrayList();
        bills.forEach(bill -> {
            long srcBillEntryId = bill.getLong("sourcebillentryid");
            if (srcBillEntryId != 0L) {
                matUseSrcBillEntryIds.add(srcBillEntryId);
            }
        });
        String fields = "bookdate, costaccount, entry.bizbillentryid AS bizbillentryid, entry.accounttype AS accounttype";
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("entry.bizbillentryid", "in", matUseSrcBillEntryIds));
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)fields, (QFilter[])qfList.toArray(new QFilter[0]));
        StringBuilder dateKey = new StringBuilder();
        costRecords.forEach(e -> {
            dateKey.setLength(0);
            dateKey.append(e.getLong("costaccount")).append('@').append(e.getLong("bizbillentryid"));
            costRecDateMap.putIfAbsent(dateKey.toString(), e.getDate("bookdate"));
        });
        HashSet existCostRecScaBizBillIds = new HashSet(32);
        costRecords.forEach(e -> {
            if ("D".equalsIgnoreCase(e.getString("accounttype"))) {
                existCostRecScaBizBillIds.add(e.getLong("bizbillentryid"));
            }
        });
        matUseSrcBillEntryIds.forEach(e -> {
            if (!existCostRecScaBizBillIds.contains(e)) {
                sourceBillEntryIds.add((Long)e);
            }
        });
        bills.forEach(e -> {
            if (sourceBillEntryIds.contains(e.getLong("sourcebillentryid"))) {
                acaProcessList.add((DynamicObject)e);
            } else {
                scaProcessList.add((DynamicObject)e);
            }
        });
    }

    private static void toAcaBills(List<DynamicObject> acaProcessList, Map<String, Object> costAccountMap, List<DynamicObject> billList, Map<String, Date> costRecDateMap, AllocResult res, List<Long> acaBillEntryIds) {
        if (acaProcessList.isEmpty()) {
            return;
        }
        Long costAccountId = (Long)costAccountMap.get("costaccountId");
        Long orgId = (Long)costAccountMap.get("org");
        Map<Long, Map<Long, List<DynamicObject>>> costRecords = MatAllocDataHelper.getCalCostRecord(costAccountId, acaBillEntryIds);
        HashSet<Long> matIdSet = new HashSet<Long>(16);
        ArrayList<DynamicObject> tempBillList = new ArrayList<DynamicObject>(10);
        HashMap<String, Long> matAllocStdMap = new HashMap<String, Long>(16);
        HashMap<Long, Boolean> isForwardAmountMap = new HashMap<Long, Boolean>(16);
        MatAllocHelper.dealBatchDataToAca(acaProcessList, costAccountMap, isForwardAmountMap, matAllocStdMap);
        for (DynamicObject bill : acaProcessList) {
            String rowIndex = bill.getString("seq");
            String billno = bill.getString("billno") + "_" + rowIndex + "_" + (String)costAccountMap.get("costaccountnum");
            Boolean isForwardAmount = (Boolean)isForwardAmountMap.get(bill.getLong("outinvtype"));
            if (!isForwardAmount.booleanValue()) {
                res.getReasonMap().put(billno, ResManager.loadKDString((String)"\u672a\u53c2\u4e0e\u5b58\u8d27\u6838\u7b97\u3002", (String)"MatAllocHelper_5", (String)"macc-sca-algox", (Object[])new Object[0]));
                res.setSuccess(false);
                continue;
            }
            Long sourcebillid = bill.getLong("sourcebillid");
            Long sourcebillentryid = bill.getLong("sourcebillentryid");
            Map<Long, List<DynamicObject>> entryIdActualCostMap = costRecords.get(sourcebillid);
            boolean hasRec = true;
            List<Object> calCostRecList = new ArrayList();
            if (entryIdActualCostMap != null && !entryIdActualCostMap.isEmpty()) {
                calCostRecList = entryIdActualCostMap.get(sourcebillentryid);
            }
            if (calCostRecList == null || calCostRecList.isEmpty() || calCostRecList.size() == 0) {
                hasRec = false;
            }
            if (!hasRec) {
                Map<String, String> reasonMap = res.getReasonMap();
                reasonMap.put(billno, ResManager.loadKDString((String)"\u5b58\u5728\u5206\u5f55\u672a\u627e\u5230\u5173\u8054\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"MatAllocHelper_6", (String)"macc-sca-algox", (Object[])new Object[0]));
                res.setSuccess(false);
                continue;
            }
            DynamicObject allocBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_matalloc");
            allocBill.set("entrysrc", (Object)"calrec");
            allocBill.set("billno", (Object)billno);
            allocBill.set("matcostinfo", (Object)sourcebillentryid);
            if (calCostRecList.get(0) != null) {
                allocBill.set("useamount", (Object)((DynamicObject)calCostRecList.get(0)).getBigDecimal("actualcost"));
            } else {
                allocBill.set("useamount", (Object)BigDecimal.ZERO);
            }
            MatAllocHelper.setBillData(allocBill, bill, costAccountMap, costRecDateMap, matAllocStdMap);
            Long costobject = bill.getLong("costobject");
            if (costobject != null && costobject != 0L) {
                MatAllocHelper.setAllocDetail(allocBill, bill, costAccountMap, calCostRecList);
                MatAllocHelper.setDirAllocData(allocBill);
            }
            matIdSet.add(bill.getLong("material"));
            tempBillList.add(allocBill);
        }
        Long costTypeId = (Long)costAccountMap.get("costtypeId");
        Map<Long, Long[]> matToSubEleMap = ElementHelper.getDefSubEles(orgId, matIdSet);
        for (DynamicObject bill : tempBillList) {
            Long[] matToSubEle;
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
            if (rows == null || rows.isEmpty() || (matToSubEle = matToSubEleMap.get(bill.getLong("material"))) == null) continue;
            for (DynamicObject row : rows) {
                row.set("elemententry", (Object)matToSubEle[0]);
                row.set("subelemententry", (Object)matToSubEle[1]);
                DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
                if (subentryentity == null || !subentryentity.isEmpty()) continue;
                DynamicObject subentry = subentryentity.addNew();
                subentry.set("element", row.get("elemententry"));
                subentry.set("subelement", row.get("subelemententry"));
                subentry.set("standardcost", row.get("price"));
                subentry.set("standardamt", row.get("amount"));
            }
        }
        billList.addAll(tempBillList);
    }

    private static void dealBatchDataToAca(List<DynamicObject> acaProcessList, Map<String, Object> costAccountMap, Map<Long, Boolean> isForwardAmountMap, Map<String, Long> matAllocStdMap) {
        HashSet<Long> outInvTypeIds = new HashSet<Long>(16);
        for (DynamicObject bill : acaProcessList) {
            outInvTypeIds.add(bill.getLong("outinvtype"));
        }
        DynamicObjectCollection outInvTypes = QueryServiceHelper.query((String)"bd_invtype", (String)"id, isforwardamount", (QFilter[])new QFilter[]{new QFilter("id", "in", outInvTypeIds)});
        outInvTypes.forEach(e -> isForwardAmountMap.put(e.getLong("id"), e.getBoolean("isforwardamount")));
        Long orgId = (Long)costAccountMap.get("org");
        matAllocStdMap = kd.macc.cad.common.helper.MatAllocDataHelper.getMatAllocStdMap((Long)orgId, (String)"sca");
    }

    private static void toScaBills(List<DynamicObject> scaProcessList, Map<String, Object> costAccountMap, List<DynamicObject> billList, Map<String, Date> costRecDateMap, AllocResult res) {
        Long orgId = (Long)costAccountMap.get("org");
        HashMap<String, List<DynamicObject>> billMap = new HashMap<String, List<DynamicObject>>(16);
        StringBuilder matKey = new StringBuilder();
        Long costTypeId = (Long)costAccountMap.get("costtypeId");
        HashSet<Long> matIdSet = new HashSet<Long>(16);
        Date maxDate = null;
        Date minDate = null;
        for (DynamicObject bill : scaProcessList) {
            Long matId = bill.getLong("material");
            matIdSet.add(matId);
            Date bizDate = bill.getDate("srcauditdate");
            if (maxDate == null || bizDate.compareTo(maxDate) > 0) {
                maxDate = bizDate;
            }
            if (minDate == null || bizDate.compareTo(minDate) < 0) {
                minDate = bizDate;
            }
            String matUseBillMatKey = MatAllocHelper.getMatUseBillMatKey(bill, costAccountMap, matKey);
            billMap.computeIfAbsent(matUseBillMatKey, s -> new ArrayList()).add(bill);
        }
        Map<String, Map<Long, List<DynamicObject>>> matCostInfoMap = MatCostHelper.getMatCostInfo2(costTypeId, matIdSet, minDate, maxDate);
        if (matCostInfoMap == null) {
            return;
        }
        Map<Long, List<DynamicObject>> effeResMatCostInfo = matCostInfoMap.get("effeResMatCostInfo");
        Map<Long, List<DynamicObject>> commonMatCostInfo = matCostInfoMap.get("commonMatCostInfo");
        HashSet<String> hasCostInfoMatSet = new HashSet<String>(16);
        HashSet<Long> hasCostInfoMatIdSet = new HashSet<Long>(16);
        HashSet<Long> hasSavedBillEntryIdSet = new HashSet<Long>(16);
        ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(16);
        if (effeResMatCostInfo != null && effeResMatCostInfo.size() > 0) {
            Map<String, Map<Long, List<DynamicObject>>> commonMatCostInfoMap = MatAllocHelper.groupByMatToMatCostInfo(commonMatCostInfo, matKey);
            MatAllocHelper.setBillInfoForStd(costAccountMap, billMap, costRecDateMap, effeResMatCostInfo, tempList, hasCostInfoMatSet, hasCostInfoMatIdSet, hasSavedBillEntryIdSet, true, commonMatCostInfoMap);
        }
        if (commonMatCostInfo != null && commonMatCostInfo.size() > 0) {
            MatAllocHelper.setBillInfoForStd(costAccountMap, billMap, costRecDateMap, commonMatCostInfo, tempList, hasCostInfoMatSet, hasCostInfoMatIdSet, hasSavedBillEntryIdSet, false, null);
        }
        billList.addAll(tempList);
        MatAllocHelper.fillEntrySubElement(tempList, orgId, hasCostInfoMatIdSet);
        MatAllocHelper.putNotMatMsg(billMap, costAccountMap, hasCostInfoMatSet, res, new HashMap<Long, DynamicObject>());
    }

    private static String getMatUseBillMatKey(DynamicObject bill, Map<String, Object> costAccountMap, StringBuilder matKey) {
        matKey.setLength(0);
        Long matId = bill.getLong("material");
        boolean useMatVer = (Boolean)costAccountMap.get("useMatVer");
        long matVerId = 0L;
        if (bill.getBoolean("isusematver") && useMatVer) {
            matVerId = bill.getLong("matversion");
        }
        long auxptyId = 0L;
        if (bill.getBoolean("isuseauxpty")) {
            auxptyId = bill.getLong("auxpty");
        }
        matKey.setLength(0);
        matKey.append(matId).append('@').append(matVerId).append('@').append(auxptyId);
        return matKey.toString();
    }

    private static Map<String, Map<Long, List<DynamicObject>>> groupByMatToMatCostInfo(Map<Long, List<DynamicObject>> commonMatCostInfo, StringBuilder matKey) {
        HashMap<String, Map<Long, List<DynamicObject>>> commonMatCostInfoMap = new HashMap<String, Map<Long, List<DynamicObject>>>(16);
        for (Map.Entry<Long, List<DynamicObject>> matCostInfo : commonMatCostInfo.entrySet()) {
            List<DynamicObject> matCostInfoList = matCostInfo.getValue();
            DynamicObject matCostInfoRow = matCostInfoList.get(0);
            String matCostInfoKey = MatAllocHelper.getMatCostInfoKey(matCostInfoRow, matKey);
            commonMatCostInfoMap.computeIfAbsent(matCostInfoKey, s -> new HashMap()).put(matCostInfo.getKey(), matCostInfoList);
        }
        return commonMatCostInfoMap;
    }

    private static void putNotMatMsg(Map<String, List<DynamicObject>> billMap, Map<String, Object> costAccountMap, Set<String> hasCostInfoMatSet, AllocResult res, Map<Long, DynamicObject> matMap) {
        String costAccountNum = (String)costAccountMap.get("costaccountnum");
        StringBuilder tipSb = new StringBuilder();
        String split = "_";
        for (Map.Entry<String, List<DynamicObject>> billKV : billMap.entrySet()) {
            if (hasCostInfoMatSet.contains(billKV.getKey())) continue;
            for (DynamicObject bill : billKV.getValue()) {
                tipSb.setLength(0);
                tipSb.append(bill.getString("billno")).append(split).append(bill.getString("seq")).append(split).append(costAccountNum);
                Map<String, String> reasonMap = res.getReasonMap();
                Long matId = bill.getLong("material");
                reasonMap.put(tipSb.toString(), String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"MatAllocHelper_7", (String)"macc-sca-algox", (Object[])new Object[0]), matMap.get(matId).getString("materialname")));
                res.setSuccess(false);
            }
        }
    }

    private static void fillEntrySubElement(List<DynamicObject> tempList, Long orgId, Set<Long> hasCostInfoMatIdSet) {
        Map<Long, Long[]> matToSubEleMap = ElementHelper.getDefSubEles(orgId, hasCostInfoMatIdSet);
        for (DynamicObject bill : tempList) {
            Long[] matToSubEle;
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
            if (rows == null || rows.isEmpty() || (matToSubEle = matToSubEleMap.get(bill.getLong("material"))) == null) continue;
            for (DynamicObject row : rows) {
                row.set("elemententry", (Object)matToSubEle[0]);
                row.set("subelemententry", (Object)matToSubEle[1]);
            }
        }
    }

    private static void setBillInfoForStd(Map<String, Object> costAccountMap, Map<String, List<DynamicObject>> billMap, Map<String, Date> costRecDateMap, Map<Long, List<DynamicObject>> calcMatInfo, List<DynamicObject> billList, Set<String> hasCostInfoMatSet, Set<Long> hasCostInfoMatIdSet, Set<Long> hasSavedBillEntryIdSet, boolean isEffeRes, Map<String, Map<Long, List<DynamicObject>>> commonMatCostInfoMap) {
        StringBuilder matKey = new StringBuilder();
        String costAccountNum = (String)costAccountMap.get("costaccountnum");
        Integer amtPrecision = (Integer)costAccountMap.get("amtprecision");
        for (Map.Entry<Long, List<DynamicObject>> calcMatEntry : calcMatInfo.entrySet()) {
            List<DynamicObject> effeResList = calcMatEntry.getValue();
            DynamicObject effeRes = effeResList.get(0);
            String matCostInfoKey = MatAllocHelper.getMatCostInfoKey(effeRes, matKey);
            List<DynamicObject> bills = billMap.get(matCostInfoKey);
            if (bills == null || bills.isEmpty()) continue;
            Date effectDate = effeRes.getDate("effectdate");
            Date expDate = effeRes.getDate("expdate");
            for (DynamicObject bill : bills) {
                if (!isEffeRes && hasSavedBillEntryIdSet.contains(bill.getLong("entryid"))) continue;
                Date bizDate = bill.getDate("srcauditdate");
                List<DynamicObject> matCostInfoList = null;
                if (isEffeRes) {
                    String matUseBillMatKey = MatAllocHelper.getMatUseBillMatKey(bill, costAccountMap, matKey);
                    matCostInfoList = MatAllocHelper.getMatCostInfoByMatUseBill(commonMatCostInfoMap, matUseBillMatKey, bizDate);
                }
                if (effectDate.compareTo(bizDate) > 0 || expDate.compareTo(bizDate) <= 0) continue;
                DynamicObject allocBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_matalloc");
                String rowIndex = bill.getString("seq");
                String billno = bill.getString("billno") + "_" + rowIndex + "_" + costAccountNum;
                allocBill.set("billno", (Object)billno);
                allocBill.set("entrysrc", (Object)"calcres");
                MatAllocHelper.setBillData(allocBill, bill, costAccountMap, costRecDateMap, new HashMap<String, Long>());
                if (isEffeRes) {
                    MatAllocHelper.countTotalStandardamtForStd(allocBill, bill, matCostInfoList, isEffeRes, amtPrecision);
                } else {
                    MatAllocHelper.countTotalStandardamtForStd(allocBill, bill, effeResList, isEffeRes, amtPrecision);
                }
                Long costobject = bill.getLong("costobject");
                if (costobject != null && costobject != 0L) {
                    MatAllocHelper.setEntryDataForStd(allocBill, bill, costAccountMap, effeResList, matCostInfoList, isEffeRes);
                    MatAllocHelper.setDirAllocData(allocBill);
                }
                billList.add(allocBill);
                hasCostInfoMatSet.add(matCostInfoKey);
                hasCostInfoMatIdSet.add(effeRes.getLong("material"));
                hasSavedBillEntryIdSet.add(bill.getLong("entryid"));
            }
        }
    }

    private static List<DynamicObject> getMatCostInfoByMatUseBill(Map<String, Map<Long, List<DynamicObject>>> commonMatCostInfoMap, String matUseBillMatKey, Date bizDate) {
        if (commonMatCostInfoMap == null) {
            return null;
        }
        Map<Long, List<DynamicObject>> matCostInfoMap = commonMatCostInfoMap.get(matUseBillMatKey);
        if (matCostInfoMap == null) {
            return null;
        }
        for (Map.Entry<Long, List<DynamicObject>> matCostInfo : matCostInfoMap.entrySet()) {
            List<DynamicObject> matCostInfoList = matCostInfo.getValue();
            DynamicObject matCostInfoRow = matCostInfoList.get(0);
            Date effectDate = matCostInfoRow.getDate("effectdate");
            Date expDate = matCostInfoRow.getDate("expdate");
            if (effectDate.compareTo(bizDate) > 0 || expDate.compareTo(bizDate) < 0) continue;
            return matCostInfoList;
        }
        return null;
    }

    private static String getMatCostInfoKey(DynamicObject effeRes, StringBuilder matKey) {
        matKey.setLength(0);
        long matId = effeRes.getLong("material");
        long matVerId = effeRes.getLong("matver");
        long auxptyId = effeRes.getLong("auxpty");
        matKey.append(matId).append('@').append(matVerId).append('@').append(auxptyId);
        return matKey.toString();
    }

    public static void countTotalStandardamtForStd(DynamicObject allocBill, DynamicObject bill, List<DynamicObject> effeResList, boolean isEffeRes, Integer amtPrecision) {
        if (effeResList == null) {
            allocBill.set("useamount", (Object)0);
            return;
        }
        BigDecimal totalStandardamt = BigDecimal.ZERO;
        BigDecimal qty = bill.getBigDecimal("qty");
        for (DynamicObject entryRow : effeResList) {
            BigDecimal standardcost = entryRow.getBigDecimal("standardcost");
            BigDecimal standardamt = standardcost.multiply(qty).setScale((int)amtPrecision, 4);
            totalStandardamt = totalStandardamt.add(standardamt);
        }
        allocBill.set("useamount", (Object)totalStandardamt.setScale((int)amtPrecision, 4));
        allocBill.set("matcostinfo", effeResList.get(0).get("id"));
    }

    public static void countTotalStandardamt(DynamicObject allocBill, DynamicObject bill, DynamicObjectCollection subentryinfo) {
        BigDecimal totalStandardamt = BigDecimal.ZERO;
        BigDecimal qty = bill.getBigDecimal("qty");
        for (DynamicObject info : subentryinfo) {
            BigDecimal standardcost = info.getBigDecimal("standardcost");
            BigDecimal standardamt = standardcost.multiply(qty);
            totalStandardamt = totalStandardamt.add(standardamt);
        }
        allocBill.set("useamount", (Object)totalStandardamt);
        allocBill.set("matcostinfo", ((DynamicObject)subentryinfo.get(0)).get("id"));
    }

    private static void setAllocDetail(DynamicObject allocBill, DynamicObject bill, Map<String, Object> costAccountMap, List<DynamicObject> calCostRecList) {
        DynamicObjectCollection entryentity = allocBill.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryentity.addNew();
        entry.set("costobejctentry", (Object)bill.getLong("costobject"));
        BigDecimal price = allocBill.getBigDecimal("useamount").divide(bill.getBigDecimal("qty"), 10, RoundingMode.HALF_UP);
        entry.set("qty", (Object)bill.getBigDecimal("qty"));
        entry.set("amount", allocBill.get("useamount"));
        entry.set("price", (Object)price);
        DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
        if (calCostRecList != null && !calCostRecList.isEmpty()) {
            HashMap<String, DynamicObject> onlyMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject calRec : calCostRecList) {
                StringBuilder key = new StringBuilder();
                key.append(calRec.get("element")).append("@");
                key.append(calRec.get("subelement")).append("@");
                key.append(calRec.get("material")).append("@");
                key.append(calRec.get("matversion")).append("@");
                key.append(calRec.get("auxpty"));
                onlyMap.put(key.toString(), calRec);
            }
            for (DynamicObject calCostRec : onlyMap.values()) {
                BigDecimal subactualcost = (BigDecimal)calCostRec.get("subactualcost");
                if (BigDecimal.ZERO.compareTo(subactualcost) == 0) continue;
                DynamicObject subentry = subentryentity.addNew();
                subentry.set("element", calCostRec.get("element"));
                subentry.set("subelement", calCostRec.get("subelement"));
                subentry.set("standardcost", calCostRec.get("subunitactualcost"));
                subentry.set("standardamt", (Object)subactualcost);
                subentry.set("submaterial", calCostRec.get("material"));
                subentry.set("submatverison", calCostRec.get("matversion"));
                subentry.set("subauxpty", calCostRec.get("auxpty"));
                subentry.set("subqty", allocBill.get("useqty"));
            }
        }
    }

    public static void setEntryDataForStd_2(DynamicObject allocBill, DynamicObject bill, Map<String, Object> costaccountMap, List<Map<String, Object>> matCostInfos) {
        DynamicObjectCollection entryentity = allocBill.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryentity.addNew();
        entry.set("costobejctentry", (Object)bill.getLong("costobject"));
        entry.set("qty", (Object)bill.getBigDecimal("qty"));
        DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
        BigDecimal totalStandardcost = BigDecimal.ZERO;
        BigDecimal stdQty = bill.getBigDecimal("qty");
        Integer amtPrecision = (Integer)costaccountMap.get("amtprecision");
        if (!CadEmptyUtils.isEmpty(matCostInfos)) {
            int seq = 1;
            for (Map<String, Object> info : matCostInfos) {
                DynamicObject sub = subentryentity.addNew();
                sub.set("seq", (Object)seq);
                ++seq;
                sub.set("element", info.get("element"));
                sub.set("subelement", info.get("subelement"));
                if (info.get("qty") != null) {
                    sub.set("calcbasis", info.get("calcbasis"));
                    sub.set("resource", info.get("resource"));
                    sub.set("submaterial", info.get("submaterial"));
                    sub.set("submatverison", info.get("submatvers"));
                    sub.set("subauxpty", info.get("subauxproperty"));
                    BigDecimal subqty = stdQty.multiply((BigDecimal)info.get("qty"));
                    sub.set("subqty", (Object)subqty);
                } else {
                    sub.set("submaterial", (Object)allocBill.getLong("material"));
                    sub.set("submatverison", (Object)allocBill.getLong("matversion"));
                    sub.set("subauxpty", (Object)allocBill.getLong("auxpty"));
                    sub.set("subqty", (Object)(stdQty.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(1) : stdQty));
                }
                BigDecimal standardcost = (BigDecimal)info.get("stdprice");
                sub.set("standardcost", (Object)standardcost);
                totalStandardcost = totalStandardcost.add(standardcost);
                BigDecimal standardamt = standardcost.multiply(stdQty).setScale((int)amtPrecision, 4);
                sub.set("standardamt", (Object)standardamt);
            }
        }
        entry.set("price", (Object)totalStandardcost);
        entry.set("amount", (Object)allocBill.getBigDecimal("useamount"));
        BigDecimalUtils.dealDiff(subentryentity, "seq", "standardamt", entry.getBigDecimal("amount"), amtPrecision);
    }

    public static void setEntryDataForStd(DynamicObject allocBill, DynamicObject bill, Map<String, Object> costaccountMap, List<DynamicObject> effeResList, List<DynamicObject> matCostInfoList, boolean isEffeRes) {
        DynamicObjectCollection entryentity = allocBill.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryentity.addNew();
        entry.set("costobejctentry", (Object)bill.getLong("costobject"));
        entry.set("qty", (Object)bill.getBigDecimal("qty"));
        DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
        BigDecimal totalStandardcost = BigDecimal.ZERO;
        BigDecimal stdQty = bill.getBigDecimal("qty");
        Integer amtPrecision = (Integer)costaccountMap.get("amtprecision");
        if (!CadEmptyUtils.isEmpty(effeResList)) {
            int seq = 1;
            for (DynamicObject info : effeResList) {
                DynamicObject sub = subentryentity.addNew();
                sub.set("seq", (Object)seq);
                ++seq;
                sub.set("element", info.get("element"));
                sub.set("subelement", info.get("subelement"));
                if (isEffeRes) {
                    sub.set("calcbasis", info.get("calcbasis"));
                    sub.set("resource", info.get("resource"));
                    sub.set("submaterial", info.get("submaterial"));
                    sub.set("submatverison", info.get("submatvers"));
                    sub.set("subauxpty", info.get("subauxproperty"));
                    BigDecimal subqty = stdQty.multiply(info.getBigDecimal("qty"));
                    sub.set("subqty", (Object)subqty);
                } else {
                    sub.set("submaterial", (Object)allocBill.getLong("material"));
                    sub.set("submatverison", (Object)allocBill.getLong("matversion"));
                    sub.set("subauxpty", (Object)allocBill.getLong("auxpty"));
                    sub.set("subqty", (Object)(stdQty.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(1) : stdQty));
                }
                BigDecimal standardcost = info.getBigDecimal("standardcost");
                sub.set("standardcost", (Object)standardcost);
                totalStandardcost = totalStandardcost.add(standardcost);
                BigDecimal standardamt = standardcost.multiply(stdQty).setScale((int)amtPrecision, 4);
                sub.set("standardamt", (Object)standardamt);
            }
        }
        if (isEffeRes && matCostInfoList != null) {
            BigDecimal price = BigDecimal.ZERO;
            for (DynamicObject entryRow : matCostInfoList) {
                BigDecimal standardcost = entryRow.getBigDecimal("standardcost");
                price = price.add(standardcost);
            }
            entry.set("price", (Object)price);
        } else {
            entry.set("price", (Object)totalStandardcost);
        }
        entry.set("amount", (Object)allocBill.getBigDecimal("useamount"));
        BigDecimalUtils.dealDiff(subentryentity, "seq", "standardamt", entry.getBigDecimal("amount"), amtPrecision);
    }

    private static void setDirAllocData(DynamicObject allocBill) {
        allocBill.set("billstatus", (Object)"A");
        allocBill.set("auditor", (Object)RequestContext.get().getUserId());
        allocBill.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        allocBill.set("alloctor", (Object)RequestContext.get().getUserId());
        allocBill.set("allocatedate", (Object)new Date());
        allocBill.set("usetype", (Object)ScaAllocEnum.USETYPE_DRIECT.getValue());
    }

    private static void setBillData(DynamicObject allocBill, DynamicObject bill, Map<String, Object> costaccountMap, Map<String, Date> costRecDateMap, Map<String, Long> matAllocStdMap) {
        allocBill.set("id", (Object)DB.genLongId((String)"sca_matalloc"));
        allocBill.set("org", (Object)bill.getLong("org"));
        allocBill.set("costcenter", (Object)bill.getLong("costcenter"));
        allocBill.set("biztype", (Object)bill.getString("biztype"));
        allocBill.set("bizdate", (Object)bill.getDate("bizdate"));
        String allocStdKey = bill.getLong("org") + "@" + bill.getLong("costcenter");
        allocBill.set("costdriver", (Object)matAllocStdMap.get(allocStdKey));
        allocBill.set("material", (Object)bill.getLong("material"));
        allocBill.set("matversion", (Object)bill.getLong("matversion"));
        allocBill.set("auxpty", (Object)bill.getLong("auxpty"));
        allocBill.set("useqty", (Object)bill.getBigDecimal("qty"));
        allocBill.set("warehouse", (Object)bill.getLong("warehouse"));
        allocBill.set("location", (Object)bill.getLong("location"));
        allocBill.set("costobject", (Object)bill.getLong("costobject"));
        allocBill.set("lotcoderule", bill.get("lotcoderule"));
        allocBill.set("unit", (Object)bill.getLong("unit"));
        allocBill.set("appnum", (Object)bill.getString("appnum"));
        allocBill.set("costaccount", costaccountMap.get("costaccountId"));
        allocBill.set("period", costaccountMap.get("currentperiodId"));
        allocBill.set("currency", costaccountMap.get("currencyId"));
        allocBill.set("billstatus", (Object)"A");
        allocBill.set("alloctype", (Object)ScaAllocEnum.ALLOCTYP_AUTO.getValue());
        allocBill.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue());
        allocBill.set("matcollect", (Object)bill.getLong("entryid"));
        allocBill.set("matusesrcbillentryid", (Object)bill.getLong("sourcebillentryid"));
        allocBill.set("usetype", (Object)ScaAllocEnum.USETYPE_PUBLIC.getValue());
        Date costRecDate = MatAllocHelper.getCostRecDate(costRecDateMap, costaccountMap, bill);
        allocBill.set("srcsyncdate", (Object)costRecDate);
        allocBill.set("creator", (Object)RequestContext.get().getUserId());
        allocBill.set("createtime", (Object)new Date());
        allocBill.set("modifier", (Object)RequestContext.get().getUserId());
        allocBill.set("modifytime", (Object)new Date());
    }

    private static Date getCostRecDate(Map<String, Date> costRecDateMap, Map<String, Object> costAccountMap, DynamicObject bill) {
        String dateKey = costAccountMap.get("costaccountId") + "@" + bill.getLong("sourcebillentryid");
        Date costRecDate = costRecDateMap.get(dateKey) == null ? bill.getDate("auditdate") : costRecDateMap.get(dateKey);
        return costRecDate;
    }

    private static DynamicObjectCollection getImportData(Map<String, Object> costaccountMap) {
        HashSet collecSrcBillIds = (HashSet)costaccountMap.get("collecSrcBillIds");
        if (collecSrcBillIds != null && !collecSrcBillIds.isEmpty()) {
            return QueryServiceHelper.query((String)"sca_matusecollect", (String)fields, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)collecSrcBillIds), new QFilter("appnum", "=", costaccountMap.get("appnum"))});
        }
        Long orgId = (Long)costaccountMap.get("org");
        QFilter orgIdQF = new QFilter("org", "=", (Object)orgId);
        Object currentperiodId = costaccountMap.get("currentperiodId");
        QFilter periodQF = new QFilter("id", "=", currentperiodId);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"begindate, enddate", (QFilter[])new QFilter[]{periodQF});
        if (periods.size() == 0) {
            return null;
        }
        DynamicObject period = (DynamicObject)periods.get(0);
        QFilter begindateQF = new QFilter("bookdate", ">=", (Object)period.getDate("begindate"));
        QFilter enddateQF = new QFilter("bookdate", "<=", (Object)period.getDate("enddate"));
        QFilter costaccountQF = new QFilter("costaccount", "=", costaccountMap.get("costaccountId"));
        QFilter currPeriodQF = new QFilter("period", "=", currentperiodId);
        QFilter existQF = null;
        ArrayList<Long> existAllocIds = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.alloc.MatAllocHelper", (String)"sca_matalloc", (String)"matcollect", (QFilter[])new QFilter[]{orgIdQF, costaccountQF, currPeriodQF}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long matUseEntryId = row.getLong("matcollect");
                existAllocIds.add(matUseEntryId);
            }
        }
        if (existAllocIds.size() > 0) {
            existQF = MatAllocHelper.getQFilter("entryentity.id", existAllocIds, "not in");
        }
        QFilter billstatusQF = new QFilter("billstatus", "=", (Object)"C");
        List costObjectList = (List)costaccountMap.get("costObjectList");
        QFilter costObjectQF = null;
        if (costObjectList != null && !costObjectList.isEmpty()) {
            costObjectQF = MatAllocHelper.getQFilter("entryentity.costobject", costObjectList, "in");
        }
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"sca_matusecollect", (String)fields, (QFilter[])new QFilter[]{billstatusQF, orgIdQF, existQF, begindateQF, enddateQF, costObjectQF});
        return bills;
    }

    private static QFilter getQFilter(String queryStr, List<Long> list, String qcp) {
        QFilter qf = null;
        if (list.size() > HugeInConfig.inThreshold()) {
            List lists = Lists.partition(list, (int)HugeInConfig.inThreshold());
            for (List tempList : lists) {
                if (qf == null) {
                    qf = new QFilter(queryStr, qcp, (Object)tempList);
                    continue;
                }
                if ("in".equals(qcp)) {
                    qf = qf.or(new QFilter(queryStr, qcp, (Object)tempList));
                    continue;
                }
                qf = qf.and(new QFilter(queryStr, qcp, (Object)tempList));
            }
        } else {
            qf = new QFilter(queryStr, qcp, list);
        }
        return qf;
    }

    public static Map<String, BigDecimal> getAllocDataByDiyCostDrive(Map<String, Object> itemMap) {
        QFilter filter = new QFilter("id", "=", itemMap.get("costdriver"));
        DynamicObjectCollection costDrivers = QueryServiceHelper.query((String)"cad_costdriver", (String)"id,iscomplexcd,formula,number,name,isrelatedwork,workactivity,islinkresource,matchpattern,resource.fbasedataid resource,resourcetype,matchreport", (QFilter[])new QFilter[]{filter});
        if (costDrivers.isEmpty()) {
            return null;
        }
        if (((DynamicObject)costDrivers.get(0)).getBoolean("iscomplexcd")) {
            return MatAllocHelper.getComplexCostDriverValue((DynamicObject)costDrivers.get(0), itemMap);
        }
        if (((DynamicObject)costDrivers.get(0)).getBoolean("isrelatedwork")) {
            return MatAllocHelper.getWorkActiveData(itemMap, ((DynamicObject)costDrivers.get(0)).get("workactivity"));
        }
        if (((DynamicObject)costDrivers.get(0)).getBoolean("islinkresource")) {
            String matchpattern;
            Set<Long> resourceIds = null;
            String valueField = "facthour";
            if ("much".equals(((DynamicObject)costDrivers.get(0)).getString("matchreport"))) {
                valueField = "factuse";
            }
            if ("resource".equals(matchpattern = ((DynamicObject)costDrivers.get(0)).getString("matchpattern"))) {
                resourceIds = new HashSet<Long>(32);
                for (DynamicObject costDriver : costDrivers) {
                    resourceIds.add(costDriver.getLong("resource"));
                }
            } else {
                HashSet<String> resTypeSet = new HashSet<String>(32);
                String resTypes = ((DynamicObject)costDrivers.get(0)).getString("resourcetype");
                if (!StringUtils.isEmpty((CharSequence)resTypes)) {
                    String[] resTypsArr;
                    for (String restype : resTypsArr = resTypes.split(",")) {
                        if ("A".equals(restype)) {
                            resTypeSet.add("mpdm_equipment");
                            continue;
                        }
                        if ("B".equals(restype)) {
                            resTypeSet.add("mpdm_toolsresource");
                            continue;
                        }
                        if ("C".equals(restype)) {
                            resTypeSet.add("mpdm_toolequip");
                            continue;
                        }
                        if ("D".equals(restype)) {
                            resTypeSet.add("mpdm_mould");
                            continue;
                        }
                        if (!"E".equals(restype)) continue;
                        resTypeSet.add("mpdm_manuperson");
                    }
                }
                resourceIds = MatAllocHelper.getResourceFromType(resTypeSet);
            }
            if (resourceIds.isEmpty()) {
                return null;
            }
            return MatAllocHelper.getResourceBillQtyBy(itemMap, resourceIds, valueField, "");
        }
        return MatAllocHelper.getDiyData(itemMap);
    }

    private static Map<String, BigDecimal> getComplexCostDriverValue(DynamicObject complexCostDriver, Map<String, Object> itemMap) {
        HashMap<String, BigDecimal> costCenterValues = new HashMap<String, BigDecimal>();
        String formula = complexCostDriver.getString("formula");
        String currentNumber = complexCostDriver.getString("number");
        String currentName = complexCostDriver.getString("name");
        long costDriverId = complexCostDriver.getLong("id");
        try {
            formula = FormulaUtil.getCompleteFormula(formula, currentNumber, currentName, costDriverId);
        }
        catch (Exception e) {
            logger.error("getCompleteFormula error, formula is:{}", (Object)formula);
            return costCenterValues;
        }
        List<String> suffixList = FormulaUtil.analyticFormula(formula);
        DataSet opResultDs = null;
        DataSet totalDriverDs = null;
        long periodId = (Long)itemMap.get("periodId");
        long orgId = (Long)itemMap.get("org");
        long costAccountId = (Long)itemMap.get("costaccount");
        ArrayList<String> materials = new ArrayList<String>();
        if (!CadEmptyUtils.isEmpty(suffixList)) {
            QFilter qFilter;
            for (String number : suffixList) {
                DynamicObject costDriver;
                if (OPERATOR.indexOf(number) >= 0 || !MatAllocHelper.isInteger(number) || (costDriver = QueryServiceHelper.queryOne((String)"cad_costdriver", (String)"id,number,allocclass", (QFilter[])(qFilter = new QFilter("id", "=", (Object)Long.parseLong(number))).toArray())) == null) continue;
                costDriverId = costDriver.getLong("id");
                itemMap.put("costdriver", costDriverId);
                itemMap.put("stdnumber", costDriver.getString("number"));
                String allocClass = costDriver.getString("allocclass");
                if (COSTCENTER.equals(allocClass)) {
                    DataSet diyCostDriverDs = FormulaUtil.getDiyDsOnCostCenter(costDriverId, orgId, costAccountId, periodId, "sca");
                    diyCostDriverDs = diyCostDriverDs.executeSql("select " + costDriverId + " as costdriver,org,costcenter,benefcostcenter,0 as costobject,0 as material,sum(value) value group by costdriver,org,costcenter,benefcostcenter");
                    totalDriverDs = MatAllocHelper.union(totalDriverDs, diyCostDriverDs);
                    continue;
                }
                if (COSTOBJECT.equals(allocClass)) {
                    DataSet costDriverValue = MatAllocHelper.getCostDriverValue(itemMap);
                    if (costDriverValue != null) {
                        costDriverValue = costDriverValue.executeSql("select " + costDriverId + " as costdriver,org,costcenter,costobject,material,sum(value) value group by org,costcenter,costobject,material");
                        costDriverValue = costDriverValue.executeSql("select costdriver,org,costcenter,costcenter as benefcostcenter,costobject,material,value");
                    }
                    totalDriverDs = MatAllocHelper.union(totalDriverDs, costDriverValue);
                    continue;
                }
                materials.add(String.valueOf(costDriverId));
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("exp", suffixList);
            paramMap.put("material", materials);
            paramMap.put("orgId", orgId);
            paramMap.put("costAccountId", costAccountId);
            paramMap.put("periodId", periodId);
            paramMap.put("appId", "sca");
            if (totalDriverDs != null && !totalDriverDs.isEmpty()) {
                boolean isConSiAux = false;
                if (!CadEmptyUtils.isEmpty(materials)) {
                    qFilter = new QFilter("org", "=", (Object)orgId);
                    qFilter.and(new QFilter("costaccount", "=", (Object)costAccountId));
                    qFilter.and(new QFilter("appnum", "=", (Object)"sca"));
                    HashSet costDriverIds = new HashSet(16);
                    materials.forEach(s -> costDriverIds.add(Long.parseLong(s)));
                    qFilter.and(new QFilter("costdriver", "in", costDriverIds));
                    qFilter.and(new QFilter("entryentity.matauxpty", "!=", (Object)0L));
                    isConSiAux = QueryServiceHelper.exists((String)"sca_diycostdriver", (QFilter[])qFilter.toArray());
                }
                opResultDs = FormulaUtil.startCostObjectCalculate(paramMap, totalDriverDs, isConSiAux);
            }
        }
        if (opResultDs != null) {
            for (Row row : opResultDs) {
                StringBuilder rowKey = new StringBuilder();
                rowKey.append(row.getString("org")).append("@");
                rowKey.append(row.getString("costcenter")).append("@");
                rowKey.append(row.getString("costobject")).append("@");
                rowKey.append(row.getString("material"));
                BigDecimal value = row.getBigDecimal("value");
                if (value.doubleValue() == 0.0) continue;
                costCenterValues.put(rowKey.toString(), value);
            }
        }
        return costCenterValues;
    }

    public static boolean isInteger(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    private static DataSet union(DataSet dataSet1, DataSet dataSet2) {
        if (dataSet1 == null && dataSet2 == null) {
            return null;
        }
        if (dataSet1 == null) {
            return dataSet2;
        }
        if (dataSet2 == null) {
            return dataSet1;
        }
        DataSet result = dataSet1.union(dataSet2).distinct();
        return result;
    }

    private static Map<String, BigDecimal> getWorkActiveData(Map<String, Object> allocMap, Object workactId) {
        if (workactId == null) {
            return null;
        }
        String selectFields = "org,costcenter,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.entryqty value";
        QFilter filter = QFilter.of((String)"billstatus = 'C' and org = ? and costcenter = ? ", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter")});
        filter.and(new QFilter("costdriver", "=", allocMap.get("costdriver")));
        filter.and(new QFilter("workactivity", "=", workactId));
        filter.and(QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{allocMap.get("begindate"), allocMap.get("enddate")}));
        Object allocMatId = allocMap.get("material");
        if (allocMatId != null) {
            filter.and(new QFilter("entryentity.costobject.material", "!=", allocMatId));
        }
        return MatAllocHelper.queryStdValDataBy("sca_workqtycollec", selectFields, filter, allocMap);
    }

    private static Map<String, BigDecimal> getDiyData(Map<String, Object> allocMap) {
        String selectFields = "org,costcenter,entryentity.costobject costobject,entryentity.costobject.material material,entryentity.entryqty value";
        QFilter filter = QFilter.of((String)"org = ? and costcenter = ? ", (Object[])new Object[]{allocMap.get("org"), allocMap.get("costcenter")});
        filter.and(new QFilter("costdriver", "=", allocMap.get("costdriver")));
        filter.and(new QFilter("entryentity.costobject.bizstatus", "=", (Object)"A"));
        Object allocMatId = allocMap.get("material");
        if (allocMatId != null) {
            filter.and(new QFilter("entryentity.costobject.material", "!=", allocMatId));
        }
        if (allocMap.get("costaccount") != null) {
            filter.and(new QFilter("costaccount", "=", allocMap.get("costaccount")));
        }
        long periodId = allocMap.get("periodId") == null ? 0L : (Long)allocMap.get("periodId");
        filter.and(new QFilter("effectperiod", "!=", (Object)0L));
        filter.and(MatAllocHelper.getEffectDateFilter(periodId));
        return MatAllocHelper.queryStdValDataBy("sca_diycostdriver", selectFields, filter, allocMap);
    }

    private static Long getLongVal(Long val) {
        if (val == null) {
            return 0L;
        }
        return val;
    }
}

