/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.alloc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.CostChangeRecHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MatAllocDataHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.output.AllocResult;
import kd.macc.cad.common.utils.BigDecimalUtils;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.alloc.MatAllocHelper;
import kd.macc.sca.algox.alloc.function.ScaMatAllocFunction;

public class ScaMatAllocHelper {
    private static final Log logger = LogFactory.getLog(ScaMatAllocHelper.class);

    /*
     * WARNING - void declaration
     */
    public static AllocResult toAlloc(List<Map<String, Object>> costAccountList, String progressId) {
        boolean isUseAlgox;
        logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u5f00\u59cb\uff1a{}", costAccountList);
        if (StringUtils.isNotBlank((CharSequence)progressId) && (isUseAlgox = ScaMatAllocHelper.getMatAllocUseAlgox())) {
            logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u5f00\u59cb(Algox)\uff1a{}", costAccountList);
            return ScaMatAllocHelper.toAllocAlgox(costAccountList, progressId);
        }
        if (!StringUtils.isEmpty((CharSequence)progressId)) {
            ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"ScaMatAllocHelper_2", (String)"macc-sca-algox", (Object[])new Object[0]), (int)0, (int)100, (String)"%");
        }
        AllocResult res = new AllocResult();
        res.setReasonMap(new HashMap());
        int totalCount = 0;
        int successCount = 0;
        int unitMapProcess = 99 / costAccountList.size();
        Map<String, IDataEntityProperty> allMatAllocField = ScaMatAllocHelper.getExtFieldMap();
        for (Map<String, Object> costAccountMap : costAccountList) {
            void var18_21;
            List srcbills;
            int accountPartProcess = unitMapProcess;
            int queryDataProcess = accountPartProcess / 10;
            accountPartProcess = unitMapProcess - queryDataProcess;
            if (!StringUtils.isEmpty((CharSequence)progressId)) {
                ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u67e5\u8be2\u9886\u6599\u6570\u636e", (String)"ScaMatAllocHelper_10", (String)"macc-sca-algox", (Object[])new Object[0]), (int)0, (String)"%");
            }
            if ((srcbills = MatAllocDataHelper.getImportDataToList(costAccountMap, (String)"sca")) == null || srcbills.isEmpty()) {
                if (StringUtils.isEmpty((CharSequence)progressId)) continue;
                ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"ScaMatAllocHelper_2", (String)"macc-sca-algox", (Object[])new Object[0]), (int)unitMapProcess, (String)"%");
                continue;
            }
            totalCount += srcbills.size();
            if (!StringUtils.isEmpty((CharSequence)progressId)) {
                ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5bfc\u5165", (String)"ScaMatAllocHelper_20", (String)"macc-sca-algox", (Object[])new Object[0]), (int)queryDataProcess, (String)"%");
            }
            List billsList = Lists.partition((List)srcbills, (int)20000);
            Set calcKeys = CalcKeycolHelper.getCostaccountKeyCols((Long)((Long)costAccountMap.get("org")), (Long)((Long)costAccountMap.get("costaccountId")), (String)"sca");
            List extCalcKeys = CalcKeycolHelper.getExtendKeyCol((Set)calcKeys);
            StringBuilder extSelFields = new StringBuilder();
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"sca_matusecollect");
            if (!CadEmptyUtils.isEmpty((List)extCalcKeys)) {
                for (String string : extCalcKeys) {
                    extSelFields.append(CalcKeycolHelper.getEntityUseFields((MainEntityType)entityType, (String)string));
                }
            }
            if (!CadEmptyUtils.isEmpty(allMatAllocField)) {
                for (Map.Entry entry : allMatAllocField.entrySet()) {
                    if (extCalcKeys.contains(entry.getKey())) continue;
                    extSelFields.append(CalcKeycolHelper.getEntityUseFields((MainEntityType)entityType, (String)((String)entry.getKey())));
                }
            }
            logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u6e90\u5355\u6570{},\u5171{}\u6279", (Object)totalCount, (Object)billsList.size());
            int unitPartProcess = accountPartProcess / billsList.size();
            boolean bl = false;
            while (var18_21 < billsList.size()) {
                String useAmountIsEmptyTip;
                if (!StringUtils.isEmpty((CharSequence)progressId)) {
                    ProgressHelper.setProgress((String)progressId, (String)ScaMatAllocHelper.generateBatchTip((int)(var18_21 + true), billsList.size()), (int)0, (String)"%");
                }
                List<DynamicObject> bills = ScaMatAllocHelper.getListDynObj((List)billsList.get((int)var18_21), extSelFields.toString());
                ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
                long start = System.currentTimeMillis();
                logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u5f00\u59cb,index={}", (Object)((int)var18_21));
                ArrayList<DynamicObject> scaProcessList = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> acaProcessList = new ArrayList<DynamicObject>();
                HashMap<String, Date> costRecDateMap = new HashMap<String, Date>(16);
                ArrayList<Long> sourceBillEntryIds = new ArrayList<Long>();
                long tmpStart = System.currentTimeMillis();
                ScaMatAllocHelper.splitScaAndAcaBill(costAccountMap, bills, scaProcessList, acaProcessList, sourceBillEntryIds, costRecDateMap);
                logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u8017\u65f61,{}", (Object)(System.currentTimeMillis() - tmpStart));
                Long orgId = (Long)costAccountMap.get("org");
                Map matAllocStdMap = MatAllocDataHelper.getMatAllocStdMap((Long)orgId, (String)"sca");
                tmpStart = System.currentTimeMillis();
                ScaMatAllocHelper.toScaBills(scaProcessList, costAccountMap, billList, costRecDateMap, res, matAllocStdMap, calcKeys);
                logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u8017\u65f62,{}", (Object)(System.currentTimeMillis() - tmpStart));
                tmpStart = System.currentTimeMillis();
                ScaMatAllocHelper.toAcaBills(acaProcessList, costAccountMap, billList, costRecDateMap, res, sourceBillEntryIds, matAllocStdMap, calcKeys);
                logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u8017\u65f63,{}", (Object)(System.currentTimeMillis() - tmpStart));
                tmpStart = System.currentTimeMillis();
                Lists.partition(billList, (int)10000).forEach(list -> {
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                    CostChangeRecHelper.wrapRecs((List)list);
                    ScaMatAllocHelper.coAlloc(list);
                });
                logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u8017\u65f64,{}", (Object)(System.currentTimeMillis() - tmpStart));
                Map reasonMap = res.getReasonMap();
                if ((successCount += billList.size()) < bills.size() && !StringUtils.isEmpty((CharSequence)(useAmountIsEmptyTip = ScaMatAllocHelper.generateUseAmountIsEmptyTip(billList)))) {
                    reasonMap.put("useAmountIsEmptyTip", useAmountIsEmptyTip);
                }
                if (!StringUtils.isEmpty((CharSequence)progressId)) {
                    ProgressHelper.setProgress((String)progressId, (String)ScaMatAllocHelper.generateBatchTip((int)(var18_21 + true), billsList.size()), (int)unitPartProcess, (String)"%");
                }
                logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u7ed3\u675f,index={},\u8017\u65f6={}", (Object)((int)var18_21), (Object)(System.currentTimeMillis() - start));
                ++var18_21;
            }
        }
        res.setTotalCount(totalCount);
        res.setSuccessCount(successCount);
        res.setFailCount(totalCount - successCount);
        Map reasonMap = res.getReasonMap();
        if (res.isSuccess()) {
            if (successCount == 0) {
                res.setSuccess(false);
                reasonMap.put("false", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u5f53\u524d\u671f\u95f4\u5185\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"ScaMatAllocHelper_21", (String)"macc-sca-algox", (Object[])new Object[0]));
            } else {
                reasonMap.put("success", ScaMatAllocHelper.generateCountTip(res));
            }
        } else {
            ArrayList errorList = Lists.newArrayList();
            errorList.add(new String[]{ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u6570\u636e", (String)"ScaMatAllocHelper_22", (String)"macc-sca-algox", (Object[])new Object[0]), "Error", ScaMatAllocHelper.generateCountTip(res)});
            String useAmountIsEmptyTip = (String)reasonMap.get("useAmountIsEmptyTip");
            if (useAmountIsEmptyTip != null) {
                reasonMap.remove("useAmountIsEmptyTip");
            }
            ScaMatAllocHelper.generateFailBillTip(reasonMap, errorList);
            reasonMap.clear();
            reasonMap.put("useAmountIsEmptyTip", useAmountIsEmptyTip);
            res.setErrorList((List)errorList);
        }
        res.getReasonMap().put("successQty", String.valueOf(successCount));
        return res;
    }

    private static Map<String, IDataEntityProperty> getExtFieldMap() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"sca_matusecollect");
        Map allMatCollectField = entityType.getAllFields();
        allMatCollectField.entrySet().removeIf(entry -> !CadEmptyUtils.equals((String)((IDataEntityProperty)entry.getValue()).getParent().toString(), (String)"sca_matusecollect"));
        MainEntityType matAllocEntityType = MetadataServiceHelper.getDataEntityType((String)"sca_matalloc");
        Map allMatAllocField = matAllocEntityType.getAllFields();
        allMatAllocField.entrySet().removeIf(entry -> {
            if (!(((String)entry.getKey()).contains("_") && allMatCollectField.containsKey(entry.getKey()) && CadEmptyUtils.equals((String)((IDataEntityProperty)entry.getValue()).getParent().toString(), (String)"sca_matalloc"))) {
                return true;
            }
            return allMatCollectField.containsKey(entry.getKey()) && ((IDataEntityProperty)allMatCollectField.get(entry.getKey())).getPropertyType() != ((IDataEntityProperty)entry.getValue()).getPropertyType();
        });
        return allMatAllocField;
    }

    private static List<DynamicObject> getListDynObj(List<Long> entryIds, String extSelFields) {
        QFilter entityIdFilter = new QFilter("entryentity.id", "in", entryIds);
        return QueryServiceHelper.query((String)"sca_matusecollect", (String)("id, billno,bookdate, bizdate, org, manuorg, costcenter, biztype,srcbiztype, appnum, sourcebillid, srcauditdate, auditdate,entryentity.id As entryid, entryentity.seq As seq, entryentity.material As material, entryentity.material.baseunit As baseunit, entryentity.material.group As materialgroup, entryentity.matversion AS matversion,entryentity.auxpty AS auxpty,entryentity.qty AS qty, entryentity.warehouse AS warehouse, entryentity.location AS location,entryentity.outinvtype AS outinvtype,entryentity.costobject AS costobject, entryentity.unit AS unit,entryentity.sourcebillentryid AS sourcebillentryid,entryentity.isrework AS isrework,entryentity.configuredcode AS configuredcode,entryentity.tracknumber AS tracknumber,entryentity.project AS project,entryentity.lotcoderule AS lotcoderule,entryentity.subproductnum AS subproductnum" + extSelFields), (QFilter[])entityIdFilter.toArray());
    }

    private static void generateFailBillTip(Map<String, String> reasonMap, List<String[]> errorList) {
        HashSet<String> tipSet = new HashSet<String>(16);
        for (Map.Entry<String, String> entry : reasonMap.entrySet()) {
            String key = entry.getKey();
            String msg = null;
            msg = key.indexOf(95) >= 0 ? key.substring(0, key.indexOf(95)) + " :" + entry.getValue() : key + " :" + entry.getValue();
            if (tipSet.contains(msg)) continue;
            tipSet.add(msg);
            errorList.add(new String[]{ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u6570\u636e", (String)"ScaMatAllocHelper_22", (String)"macc-sca-algox", (Object[])new Object[0]), "Error", msg});
        }
    }

    private static String generateUseAmountIsEmptyTip(List<DynamicObject> billList) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject bill : billList) {
            if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("useamount")) != 0 || !"calrec".equals(bill.getString("entrysrc"))) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u91d1\u989d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u76f8\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5b9e\u9645\u6210\u672c\u3002", (String)"ScaMatAllocHelper_5", (String)"macc-sca-algox", (Object[])new Object[0]), bill.getString("billno"));
            sb.append(msg);
            sb.append("\r\n");
        }
        if (!StringUtils.isEmpty((CharSequence)sb.toString())) {
            return sb.toString();
        }
        return "";
    }

    private static String generateCountTip(AllocResult res) {
        return String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002\u6210\u529f\u3010%1$s\u3011\u6761\uff0c\u5931\u8d25\u3010%2$s\u3011\u6761\u3002", (String)"ScaMatAllocHelper_23", (String)"macc-sca-algox", (Object[])new Object[0]), res.getSuccessCount(), res.getFailCount());
    }

    private static String generateBatchTip(int curr, int total) {
        return String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u7b2c\u3010%1$s\u3011\u6279\u5bfc\u5165\uff0c\u5171\u3010%2$s\u3011\u6279\u3002", (String)"ScaMatAllocHelper_24", (String)"macc-sca-algox", (Object[])new Object[0]), curr, total);
    }

    private static void toAcaBills(List<DynamicObject> acaProcessList, Map<String, Object> costAccountMap, List<DynamicObject> billList, Map<String, Date> costRecDateMap, AllocResult res, List<Long> acaBillEntryIds, Map<String, Long> matAllocStdMap, Set<String> calcKeys) {
        if (acaProcessList.isEmpty()) {
            return;
        }
        Long costAccountId = (Long)costAccountMap.get("costaccountId");
        Long orgId = (Long)costAccountMap.get("org");
        Map costRecords = MatAllocDataHelper.getCalCostRecord((Long)costAccountId, acaBillEntryIds);
        ArrayList<DynamicObject> tempBillList = new ArrayList<DynamicObject>(10);
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject bill : acaProcessList) {
            String rowIndex = bill.getString("seq");
            String billno = bill.getString("billno") + "_" + rowIndex + "_" + (String)costAccountMap.get("costaccountnum");
            Long sourcebillid = bill.getLong("sourcebillid");
            Long sourcebillentryid = bill.getLong("sourcebillentryid");
            Map entryIdActualCostMap = (Map)costRecords.get(sourcebillid);
            boolean hasRec = true;
            List calCostRecList = null;
            if (entryIdActualCostMap == null || entryIdActualCostMap.isEmpty()) {
                hasRec = false;
            } else {
                calCostRecList = (List)entryIdActualCostMap.get(sourcebillentryid);
                if (calCostRecList == null || calCostRecList.isEmpty()) {
                    hasRec = false;
                }
            }
            if (!hasRec) {
                if (res == null) continue;
                Map reasonMap = res.getReasonMap();
                reasonMap.put(billno, ResManager.loadKDString((String)"\u5b58\u5728\u5206\u5f55\u672a\u627e\u5230\u5173\u8054\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"ScaMatAllocHelper_7", (String)"macc-sca-algox", (Object[])new Object[0]));
                res.setSuccess(false);
                continue;
            }
            DynamicObject allocBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_matalloc");
            allocBill.set("entrysrc", (Object)"calrec");
            allocBill.set("billno", (Object)billno);
            allocBill.set("matcostinfo", (Object)sourcebillentryid);
            if (calCostRecList != null && !calCostRecList.isEmpty()) {
                allocBill.set("useamount", (Object)((DynamicObject)calCostRecList.get(0)).getBigDecimal("actualcost"));
            }
            Map<String, IDataEntityProperty> allMatAllocField = ScaMatAllocHelper.getExtFieldMap();
            ScaMatAllocHelper.setBillData(allocBill, bill, costAccountMap, costRecDateMap, matAllocStdMap, allMatAllocField);
            allocBill.set("isreturnitem", (Object)bill.getBoolean("isrework"));
            Long costobject = bill.getLong("costobject");
            if (costobject != null && costobject != 0L) {
                ScaMatAllocHelper.setAllocDetail(allocBill, bill, calCostRecList);
                ScaMatAllocHelper.setDirAllocData(allocBill);
            }
            materialIds.add(allocBill.getLong("material"));
            CalcKeycolHelper.genMatAllocCalcKey(calcKeys, null, (String)ScaMatAllocHelper.getNoupdatecalfields(costAccountMap, bill), (DynamicObject)allocBill, (DynamicObject)bill, (String)"sca");
            tempBillList.add(allocBill);
        }
        Map matToSubEleMap = ElementHelper.getDefSubEles((Long)orgId, (Set)materialIds);
        for (DynamicObject bill : tempBillList) {
            Long[] matToSubEle;
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
            if (rows == null || rows.isEmpty() || (matToSubEle = (Long[])matToSubEleMap.get(bill.getLong("material"))) == null) continue;
            for (DynamicObject row : rows) {
                row.set("elemententry", (Object)matToSubEle[0]);
                row.set("subelemententry", (Object)matToSubEle[1]);
                DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
                if (subentryentity == null || !subentryentity.isEmpty()) continue;
                DynamicObject subentry = subentryentity.addNew();
                subentry.set("element", row.get("elemententry"));
                subentry.set("subelement", row.get("subelemententry"));
                subentry.set("standardcost", row.get("price"));
                subentry.set("standardamt", row.get("amount"));
            }
        }
        billList.addAll(tempBillList);
    }

    public static AllocResult toAllocAlgox(List<Map<String, Object>> costAccountList, String progressId) {
        logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u5f00\u59cbalgox\uff1a{}", costAccountList);
        if (!StringUtils.isEmpty((CharSequence)progressId)) {
            ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"ScaMatAllocHelper_2", (String)"macc-sca-algox", (Object[])new Object[0]), (int)0, (int)100, (String)"%");
        }
        AllocResult res = new AllocResult();
        res.setReasonMap(new HashMap());
        int totalCount = 0;
        int unitMapProcess = 99 / costAccountList.size();
        for (Map<String, Object> costAccountMap : costAccountList) {
            List srcbills;
            costAccountMap.put("isAlgox", Boolean.TRUE);
            int accountPartProcess = unitMapProcess;
            int queryDataProcess = accountPartProcess / 10;
            accountPartProcess = unitMapProcess - queryDataProcess;
            if (!StringUtils.isEmpty((CharSequence)progressId)) {
                ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u67e5\u8be2\u9886\u6599\u6570\u636e", (String)"ScaMatAllocHelper_10", (String)"macc-sca-algox", (Object[])new Object[0]), (int)0, (String)"%");
            }
            if ((srcbills = MatAllocDataHelper.getImportDataToList(costAccountMap, (String)"sca")) == null || srcbills.isEmpty()) {
                if (StringUtils.isEmpty((CharSequence)progressId)) continue;
                ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"ScaMatAllocHelper_2", (String)"macc-sca-algox", (Object[])new Object[0]), (int)unitMapProcess, (String)"%");
                continue;
            }
            totalCount += srcbills.size();
            if (!StringUtils.isEmpty((CharSequence)progressId)) {
                ProgressHelper.setProgress((String)progressId, (String)String.format(ResManager.loadKDString((String)"\u603b\u5171%s\u6761\u6570\u636e\uff0c\u6b63\u5728\u8fdb\u884c\u5bfc\u5165", (String)"ScaMatAllocHelper_25", (String)"macc-sca-algox", (Object[])new Object[0]), srcbills.size()), (int)queryDataProcess, (String)"%");
            }
            int batchSize = 20000;
            RowMeta rm = new RowMeta(new String[]{"id", "groupId"}, new DataType[]{DataType.LongType, DataType.IntegerType});
            ArrayList dataList = Lists.newArrayListWithExpectedSize((int)1024);
            int count = 0;
            int groupId = 0;
            for (Long bill : srcbills) {
                Object[] obj = new Object[]{bill, groupId};
                dataList.add(obj);
                if (++count < batchSize) continue;
                count = 0;
                ++groupId;
            }
            DataSet ds = Algo.create((String)"ScaMatAllocHelper.toAllocAlgox").createDataSet((Collection)dataList, rm);
            JobSession session = AlgoX.createSession((String)"ScaMatAllocHelper-toAlloc");
            DataSetX dsx = session.fromInput((Input)new DataSetInput(ds));
            dsx = dsx.groupBy(new String[]{"groupId"}).reduceGroup((GroupReduceFunction)new ScaMatAllocFunction(costAccountMap));
            DataSetOutput resOutput = new DataSetOutput(dsx.getRowMeta());
            dsx.output((Output)resOutput);
            try {
                logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u6e90\u5355\u6570algox\u5f00\u59cb,\u603b\u6570{},batchSize{}", (Object)totalCount, (Object)batchSize);
                long algoXStart = System.currentTimeMillis();
                try (TXHandle h = TX.notSupported();){
                    session.commit(2, TimeUnit.HOURS);
                }
                logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u6e90\u5355\u6570algox\u7ed3\u675f,\u8017\u65f6{}", (Object)(System.currentTimeMillis() - algoXStart));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw e;
            }
            DataSet resDs = session.readDataSet(resOutput.getId());
            if (!resDs.isEmpty()) {
                ScaMatAllocHelper.dealAlgoxRes(resDs, res);
            }
            if (StringUtils.isEmpty((CharSequence)progressId)) continue;
            ProgressHelper.setProgress((String)progressId, (String)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5bfc\u5165", (String)"ScaMatAllocHelper_20", (String)"macc-sca-algox", (Object[])new Object[0]), (int)accountPartProcess, (String)"%");
        }
        res.setTotalCount(totalCount);
        Map reasonMap = res.getReasonMap();
        if (res.isSuccess()) {
            if (res.getSuccessCount() == 0) {
                res.setSuccess(false);
                reasonMap.put("false", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u3002\u5f53\u524d\u671f\u95f4\u5185\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u6570\u636e\u3002", (String)"ScaMatAllocHelper_21", (String)"macc-sca-algox", (Object[])new Object[0]));
            } else {
                reasonMap.put("success", ScaMatAllocHelper.generateCountTip(res));
            }
        } else {
            ArrayList errorList = Lists.newArrayList();
            errorList.add(new String[]{ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5bfc\u5165\u6570\u636e", (String)"ScaMatAllocHelper_22", (String)"macc-sca-algox", (Object[])new Object[0]), "Error", ScaMatAllocHelper.generateCountTip(res)});
            String useAmountIsEmptyTip = (String)reasonMap.get("useAmountIsEmptyTip");
            if (useAmountIsEmptyTip != null) {
                reasonMap.remove("useAmountIsEmptyTip");
            }
            ScaMatAllocHelper.generateFailBillTip(reasonMap, errorList);
            reasonMap.clear();
            reasonMap.put("useAmountIsEmptyTip", useAmountIsEmptyTip);
            res.setErrorList((List)errorList);
        }
        res.getReasonMap().put("successQty", String.valueOf(res.getSuccessCount()));
        return res;
    }

    private static void dealAlgoxRes(DataSet ds, AllocResult res) {
        String json = null;
        for (Row row : ds) {
            AllocResult subRes;
            json = row.getString("json");
            if (StringUtils.isEmpty((CharSequence)json) || (subRes = (AllocResult)JSONObject.parseObject((String)json, AllocResult.class)) == null) continue;
            if (!subRes.isSuccess()) {
                res.setSuccess(subRes.isSuccess());
            }
            res.setSuccessCount(subRes.getSuccessCount() + res.getSuccessCount());
            res.setFailCount(subRes.getFailCount() + res.getFailCount());
            Map reasonMap = subRes.getReasonMap();
            if (reasonMap == null || reasonMap.isEmpty()) continue;
            if (reasonMap.containsKey("useAmountIsEmptyTip")) {
                String msg = (String)reasonMap.remove("useAmountIsEmptyTip");
                if (res.getReasonMap().containsKey("useAmountIsEmptyTip")) {
                    res.getReasonMap().put("useAmountIsEmptyTip", (String)res.getReasonMap().get("useAmountIsEmptyTip") + "\r\n" + msg);
                } else {
                    res.getReasonMap().put("useAmountIsEmptyTip", msg);
                }
            }
            res.getReasonMap().putAll(reasonMap);
        }
    }

    public static void toAllocSubMethod(List<DynamicObject> bills, Map<String, Object> costAccountMap, int groupId, AllocResult res, Set<String> calcKeys) {
        String useAmountIsEmptyTip;
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
        logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u5f00\u59cb,index={}", (Object)groupId);
        ArrayList<DynamicObject> scaProcessList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> acaProcessList = new ArrayList<DynamicObject>();
        HashMap<String, Date> costRecDateMap = new HashMap<String, Date>(16);
        ArrayList<Long> sourceBillEntryIds = new ArrayList<Long>();
        long tmpStart = System.currentTimeMillis();
        ScaMatAllocHelper.splitScaAndAcaBill(costAccountMap, bills, scaProcessList, acaProcessList, sourceBillEntryIds, costRecDateMap);
        logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u8017\u65f61,{},index={}", (Object)(System.currentTimeMillis() - tmpStart), (Object)groupId);
        Long orgId = (Long)costAccountMap.get("org");
        Map matAllocStdMap = MatAllocDataHelper.getMatAllocStdMap((Long)orgId, (String)"sca");
        tmpStart = System.currentTimeMillis();
        ScaMatAllocHelper.toScaBills(scaProcessList, costAccountMap, billList, costRecDateMap, res, matAllocStdMap, calcKeys);
        logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u8017\u65f62,{},index={}", (Object)(System.currentTimeMillis() - tmpStart), (Object)groupId);
        tmpStart = System.currentTimeMillis();
        ScaMatAllocHelper.toAcaBills(acaProcessList, costAccountMap, billList, costRecDateMap, res, sourceBillEntryIds, matAllocStdMap, calcKeys);
        logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u8017\u65f63,{}", (Object)(System.currentTimeMillis() - tmpStart));
        tmpStart = System.currentTimeMillis();
        Lists.partition(billList, (int)10000).forEach(list -> {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            CostChangeRecHelper.wrapRecs((List)list);
            ScaMatAllocHelper.coAlloc(list);
        });
        res.setSuccessCount(billList.size());
        res.setFailCount(bills.size() - billList.size());
        if (billList.size() < bills.size() && !StringUtils.isEmpty((CharSequence)(useAmountIsEmptyTip = ScaMatAllocHelper.generateUseAmountIsEmptyTip(billList)))) {
            res.getReasonMap().put("useAmountIsEmptyTip", useAmountIsEmptyTip);
        }
        logger.info("\u6807\u51c6\u6210\u672c\u6750\u6599\u8017\u7528\u5206\u914d\u5206\u6279\u8017\u65f64,{}", (Object)(System.currentTimeMillis() - tmpStart));
    }

    private static void setAllocDetail(DynamicObject allocBill, DynamicObject bill, List<DynamicObject> calCostRecList) {
        DynamicObjectCollection entryentity = allocBill.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryentity.addNew();
        entry.set("costobejctentry", (Object)bill.getLong("costobject"));
        BigDecimal price = allocBill.getBigDecimal("useamount").divide(bill.getBigDecimal("qty"), 10, RoundingMode.HALF_UP);
        entry.set("qty", (Object)bill.getBigDecimal("qty"));
        entry.set("amount", allocBill.get("useamount"));
        entry.set("price", (Object)price);
        DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
        if (calCostRecList != null && !calCostRecList.isEmpty()) {
            HashMap<String, DynamicObject> onlyMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject calRec : calCostRecList) {
                StringBuilder key = new StringBuilder();
                key.append(calRec.get("element")).append("@");
                key.append(calRec.get("subelement")).append("@");
                key.append(calRec.get("material")).append("@");
                key.append(calRec.get("matversion")).append("@");
                key.append(calRec.get("auxpty"));
                onlyMap.put(key.toString(), calRec);
            }
            for (DynamicObject calCostRec : onlyMap.values()) {
                BigDecimal subactualcost = (BigDecimal)calCostRec.get("subactualcost");
                if (BigDecimal.ZERO.compareTo(subactualcost) == 0) continue;
                DynamicObject subentry = subentryentity.addNew();
                subentry.set("element", calCostRec.get("element"));
                subentry.set("subelement", calCostRec.get("subelement"));
                subentry.set("standardcost", calCostRec.get("subunitactualcost"));
                subentry.set("standardamt", (Object)subactualcost);
                subentry.set("submaterial", calCostRec.get("material"));
                subentry.set("submatverison", calCostRec.get("matversion"));
                subentry.set("subauxpty", calCostRec.get("auxpty"));
                subentry.set("subqty", allocBill.get("useqty"));
            }
        }
    }

    private static void setDirAllocData(DynamicObject allocBill) {
        allocBill.set("billstatus", (Object)"A");
        allocBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        allocBill.set("alloctor", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("allocatedate", (Object)new Date());
        allocBill.set("usetype", (Object)ScaAllocEnum.USETYPE_DRIECT.getValue());
        allocBill.set("costdriver", (Object)0L);
    }

    private static void setBillData(DynamicObject allocBill, DynamicObject bill, Map<String, Object> costaccountMap, Map<String, Date> costRecDateMap, Map<String, Long> matAllocStdMap, Map<String, IDataEntityProperty> matAllocExtFieldMap) {
        String keyValue;
        Map billBizInfoMap;
        Object[] infoArr;
        allocBill.set("id", (Object)DB.genLongId((String)"sca_matalloc"));
        allocBill.set("org", (Object)bill.getLong("org"));
        allocBill.set("manuorg", (Object)bill.getLong("manuorg"));
        allocBill.set("costcenter", (Object)bill.getLong("costcenter"));
        allocBill.set("biztype", (Object)bill.getString("biztype"));
        allocBill.set("srcbiztype", (Object)bill.getString("srcbiztype"));
        allocBill.set("bizdate", (Object)bill.getDate("bookdate"));
        allocBill.set("nsrcauditdate", (Object)bill.getDate("auditdate"));
        Long costobjectId = bill.getLong("costobject");
        if (costobjectId == null || costobjectId == 0L) {
            Long costdriverId = MatAllocDataHelper.getMatAllocStdCostDriver((Long)bill.getLong("org"), (Long)bill.getLong("manuorg"), (Long)bill.getLong("costcenter"), (Long)bill.getLong("material"), (Long)bill.getLong("matversion"), (Long)bill.getLong("auxpty"), (Long)bill.getLong("materialgroup"), matAllocStdMap);
            allocBill.set("costdriver", (Object)costdriverId);
        }
        allocBill.set("material", (Object)bill.getLong("material"));
        allocBill.set("matversion", (Object)bill.getLong("matversion"));
        allocBill.set("auxpty", (Object)bill.getLong("auxpty"));
        allocBill.set("useqty", (Object)bill.getBigDecimal("qty"));
        allocBill.set("warehouse", (Object)bill.getLong("warehouse"));
        allocBill.set("location", (Object)bill.getLong("location"));
        allocBill.set("costobject", (Object)bill.getLong("costobject"));
        allocBill.set("lotcoderule", bill.get("lotcoderule"));
        allocBill.set("unit", (Object)bill.getLong("unit"));
        allocBill.set("baseunit", (Object)bill.getLong("baseunit"));
        allocBill.set("appnum", (Object)bill.getString("appnum"));
        allocBill.set("costaccount", costaccountMap.get("costaccountId"));
        allocBill.set("period", costaccountMap.get("currentperiodId"));
        allocBill.set("currency", costaccountMap.get("currencyId"));
        allocBill.set("billstatus", (Object)"A");
        allocBill.set("alloctype", (Object)ScaAllocEnum.ALLOCTYP_AUTO.getValue());
        allocBill.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue());
        allocBill.set("matcollect", (Object)bill.getLong("entryid"));
        allocBill.set("matusesrcbillentryid", (Object)bill.getLong("sourcebillentryid"));
        allocBill.set("usetype", (Object)ScaAllocEnum.USETYPE_PUBLIC.getValue());
        Date costRecDate = ScaMatAllocHelper.getCostRecDate(costRecDateMap, costaccountMap, bill);
        allocBill.set("srcsyncdate", (Object)costRecDate);
        allocBill.set("configuredcode", (Object)bill.getLong("configuredcode"));
        allocBill.set("tracknumber", (Object)bill.getLong("tracknumber"));
        allocBill.set("project", (Object)bill.getLong("project"));
        allocBill.set("lotcoderule", (Object)bill.getString("lotcoderule"));
        allocBill.set("subproductnum", (Object)bill.getString("subproductnum"));
        if (costaccountMap.get("billBizInfoMap") != null && (infoArr = (Object[])(billBizInfoMap = (Map)costaccountMap.get("billBizInfoMap")).get(keyValue = String.format("%s@%s", costaccountMap.get("costaccountId"), bill.getLong("sourcebillentryid")))) != null) {
            allocBill.set("costrecordentryid", infoArr[0]);
            allocBill.set("srcauxpty", infoArr[1]);
        }
        allocBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("createtime", (Object)new Date());
        allocBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("modifytime", (Object)new Date());
        if (!CadEmptyUtils.isEmpty(matAllocExtFieldMap)) {
            for (Map.Entry<String, IDataEntityProperty> entry : matAllocExtFieldMap.entrySet()) {
                allocBill.set(entry.getKey(), bill.get(entry.getKey()));
            }
        }
    }

    private static Date getCostRecDate(Map<String, Date> costRecDateMap, Map<String, Object> costAccountMap, DynamicObject bill) {
        String dateKey = costAccountMap.get("costaccountId") + "@" + bill.getLong("sourcebillentryid");
        Date costRecDate = costRecDateMap.get(dateKey) == null ? bill.getDate("auditdate") : costRecDateMap.get(dateKey);
        return costRecDate;
    }

    private static void toScaBills(List<DynamicObject> scaProcessListTotal, Map<String, Object> costAccountMap, List<DynamicObject> billList, Map<String, Date> costRecDateMap, AllocResult res, Map<String, Long> matAllocStdMap, Set<String> calcKeys) {
        List scaProcessListSS = Lists.partition(scaProcessListTotal, (int)45000);
        for (int i = 0; i < scaProcessListSS.size(); ++i) {
            List scaProcessList = (List)scaProcessListSS.get(i);
            HashMap<String, List<DynamicObject>> billMap = new HashMap<String, List<DynamicObject>>(16);
            ArrayList<Map<String, Object>> matCostInfoObjects = new ArrayList<Map<String, Object>>(10);
            StringBuilder matKey = new StringBuilder();
            HashMap<Long, DynamicObject> matMap = new HashMap<Long, DynamicObject>(16);
            MatAllocDataHelper.dealBatchDataToSca((List)scaProcessList, costAccountMap, matMap, matAllocStdMap);
            Long costaccountId = (Long)costAccountMap.get("costaccountId");
            Map billStdCostMap = (Map)costAccountMap.get("billStdCostMap");
            for (DynamicObject bill : scaProcessList) {
                String matUseBillMatKey = ScaMatAllocHelper.getMatUseBillMatKey(bill, matMap, costAccountMap, matKey);
                billMap.computeIfAbsent(matUseBillMatKey, s -> new ArrayList()).add(bill);
                String keyValue = costaccountId + "@" + bill.getLong("sourcebillentryid");
                if (billStdCostMap != null && billStdCostMap.containsKey(keyValue)) continue;
                Map<String, Object> param = ScaMatAllocHelper.wrapMatInfoParam(bill, matMap, costAccountMap, matUseBillMatKey);
                matCostInfoObjects.add(param);
            }
            HashSet<Long> hasCostInfoMatIdSet = new HashSet<Long>(16);
            HashSet<String> hasCostInfoMatSet = new HashSet<String>(16);
            ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(16);
            Long org = (Long)costAccountMap.get("org");
            logger.info("matCostInfoObjects size:{}", (Object)matCostInfoObjects.size());
            Map matCostInfoMap = null;
            if (!matCostInfoObjects.isEmpty()) {
                logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\uff1a\u9700\u8981\u53d6\u4ef7\u7684\u53c2\u6570\u4e2a\u6570\uff1a{}", (Object)matCostInfoObjects.size());
                matCostInfoMap = ImportServiceHelper.getMatCost(matCostInfoObjects, (Long)org, (Long)costaccountId, (String)"4");
            } else {
                matCostInfoMap = Maps.newHashMapWithExpectedSize((int)1);
            }
            if (matCostInfoMap != null) {
                ScaMatAllocHelper.setBillInfoForStd(costAccountMap, billMap, costRecDateMap, matCostInfoMap, tempList, hasCostInfoMatSet, hasCostInfoMatIdSet, matAllocStdMap, calcKeys);
                billList.addAll(tempList);
                ScaMatAllocHelper.fillEntrySubElement(org, billList, hasCostInfoMatIdSet);
            }
            if (res == null) continue;
            ScaMatAllocHelper.putNotMatMsg(billMap, costAccountMap, hasCostInfoMatSet, res, matMap);
        }
    }

    private static void setBillInfoForStd(Map<String, Object> costAccountMap, Map<String, List<DynamicObject>> billMap, Map<String, Date> costRecDateMap, Map<String, List<Map<String, Object>>> matCostInfoMap, List<DynamicObject> billList, Set<String> hasCostInfoMatSet, Set<Long> hasCostInfoMatIdSet, Map<String, Long> matAllocStdMap, Set<String> calcKeys) {
        String costAccountNum = (String)costAccountMap.get("costaccountnum");
        Integer amtPrecision = (Integer)costAccountMap.get("amtprecision");
        HashSet<String> hasGenBillNo = new HashSet<String>(32);
        for (Map.Entry<String, List<DynamicObject>> billEntry : billMap.entrySet()) {
            String matCostInfoKey = billEntry.getKey();
            List<DynamicObject> bills = billEntry.getValue();
            Map<String, Object> matCostInfo = null;
            List<Map<String, Object>> matCostInfoList = matCostInfoMap.get(matCostInfoKey);
            if (!CadEmptyUtils.isEmpty(matCostInfoList)) {
                matCostInfo = matCostInfoList.get(0);
            }
            for (DynamicObject bill : bills) {
                Map<String, Object> billCostInfo = null;
                billCostInfo = matCostInfo != null ? matCostInfo : ScaMatAllocHelper.getBillCostInfoMap(costAccountMap, bill);
                if (billCostInfo == null) continue;
                String rowIndex = bill.getString("seq");
                String billno = bill.getString("billno") + "_" + rowIndex + "_" + costAccountNum;
                if (hasGenBillNo.contains(billno)) continue;
                hasGenBillNo.add(billno);
                DynamicObject allocBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_matalloc");
                allocBill.set("billno", (Object)billno);
                allocBill.set("entrysrc", (Object)"calcres");
                allocBill.set("matcostinfo", billCostInfo.get("matcostinfoid"));
                allocBill.set("keycol", billCostInfo.get("keycol"));
                allocBill.set("keycolid", billCostInfo.get("keycolid"));
                Map<String, IDataEntityProperty> allMatAllocField = ScaMatAllocHelper.getExtFieldMap();
                ScaMatAllocHelper.setBillData(allocBill, bill, costAccountMap, costRecDateMap, matAllocStdMap, allMatAllocField);
                allocBill.set("isreturnitem", (Object)bill.getBoolean("isrework"));
                BigDecimal totalStandardamt = BigDecimal.ZERO;
                BigDecimal qty = bill.getBigDecimal("qty");
                BigDecimal standardcost = BigDecimal.ZERO;
                if (!billCostInfo.containsKey("totalamt")) {
                    standardcost = billCostInfo.get("totalprice") == null ? BigDecimal.ZERO : (BigDecimal)billCostInfo.get("totalprice");
                    totalStandardamt = standardcost.multiply(qty).setScale((int)amtPrecision, 4);
                } else {
                    standardcost = (BigDecimal)billCostInfo.get("totalprice");
                    totalStandardamt = (BigDecimal)billCostInfo.get("totalamt");
                }
                allocBill.set("useamount", (Object)totalStandardamt);
                Long costobject = bill.getLong("costobject");
                if (costobject != null && costobject != 0L) {
                    DynamicObjectCollection entryentity = allocBill.getDynamicObjectCollection("entryentity");
                    DynamicObject entry = entryentity.addNew();
                    entry.set("costobejctentry", (Object)bill.getLong("costobject"));
                    entry.set("qty", (Object)bill.getBigDecimal("qty"));
                    entry.set("price", (Object)standardcost);
                    entry.set("amount", (Object)totalStandardamt);
                    ScaMatAllocHelper.setDirAllocData(allocBill);
                }
                CalcKeycolHelper.genMatAllocCalcKey(calcKeys, null, (String)ScaMatAllocHelper.getNoupdatecalfields(costAccountMap, bill), (DynamicObject)allocBill, (DynamicObject)bill, (String)"sca");
                billList.add(allocBill);
                hasCostInfoMatSet.add(matCostInfoKey);
                hasCostInfoMatIdSet.add(bill.getLong("material"));
            }
        }
    }

    private static String getNoupdatecalfields(Map<String, Object> costAccountMap, DynamicObject bill) {
        String keyValue;
        Map billBizInfoMap;
        Object[] obj;
        if (costAccountMap.get("billBizInfoMap") != null && (obj = (Object[])(billBizInfoMap = (Map)costAccountMap.get("billBizInfoMap")).get(keyValue = String.format("%s@%s", costAccountMap.get("costaccountId"), bill.getLong("sourcebillentryid")))).length >= 3 && obj[2] != null) {
            return (String)obj[2];
        }
        return null;
    }

    private static Map<String, Object> getBillCostInfoMap(Map<String, Object> costAccountMap, DynamicObject bill) {
        Long costaccountId = (Long)costAccountMap.get("costaccountId");
        Map billStdCostMap = (Map)costAccountMap.get("billStdCostMap");
        Map matCostInfoMap = (Map)costAccountMap.get("matCostInfoMap");
        String keyValue = costaccountId + "@" + bill.getLong("sourcebillentryid");
        if (billStdCostMap != null && billStdCostMap.containsKey(keyValue)) {
            Object[] costInfo = (Object[])billStdCostMap.get(keyValue);
            HashMap billCostInfoMap = Maps.newHashMapWithExpectedSize((int)10);
            billCostInfoMap.put("matcostinfoid", costInfo[0]);
            billCostInfoMap.put("totalamt", costInfo[1]);
            billCostInfoMap.put("totalprice", costInfo[2]);
            Object[] costKeyCol = (Object[])matCostInfoMap.get(costInfo[0]);
            if (costKeyCol != null) {
                billCostInfoMap.put("keycol", costKeyCol[1]);
                billCostInfoMap.put("keycolid", costKeyCol[0]);
            }
            return billCostInfoMap;
        }
        return null;
    }

    private static Map<String, Object> wrapMatInfoParam(DynamicObject bill, Map<Long, DynamicObject> matMap, Map<String, Object> costAccountMap, String matUseBillMatKey) {
        Date bizDate = bill.getDate("srcauditdate");
        DynamicObject mat = matMap.get(bill.getLong("material"));
        Long matVerId = 0L;
        if (mat.getBoolean("isusematver")) {
            matVerId = bill.getLong("matversion");
        }
        Long auxptyId = 0L;
        if (mat.getBoolean("isuseauxpty")) {
            auxptyId = bill.getLong("auxpty");
        }
        Long costaccountId = (Long)costAccountMap.get("costaccountId");
        Long org = (Long)costAccountMap.get("org");
        Long invorg = 1L;
        if (costAccountMap.get("billOrgMap") != null) {
            String keyValue;
            Map billOrgMap = (Map)costAccountMap.get("billOrgMap");
            invorg = billOrgMap.get(keyValue = costaccountId + "@" + bill.getLong("sourcebillentryid")) == null ? Long.valueOf(1L) : (Long)billOrgMap.get(keyValue);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("uniqueID", matUseBillMatKey);
        param.put("invorg", invorg);
        param.put("material", bill.getLong("material"));
        param.put("assist", auxptyId);
        param.put("configuredcode", bill.getLong("configuredcode"));
        param.put("tracknumber", bill.getLong("tracknumber"));
        param.put("lot", bill.getString("lotcoderule"));
        param.put("project", bill.getLong("project"));
        param.put("date", bizDate);
        return param;
    }

    private static String getMatUseBillMatKey(DynamicObject bill, Map<Long, DynamicObject> matMap, Map<String, Object> costAccountMap, StringBuilder matKey) {
        matKey.setLength(0);
        Long matId = bill.getLong("material");
        DynamicObject mat = matMap.get(matId);
        long matVerId = 0L;
        if (mat != null && mat.getBoolean("isusematver")) {
            matVerId = bill.getLong("matversion");
        }
        long auxptyId = 0L;
        if (mat != null && mat.getBoolean("isuseauxpty")) {
            auxptyId = bill.getLong("auxpty");
        }
        Date bizDate = bill.getDate("srcauditdate");
        Long costaccountId = (Long)costAccountMap.get("costaccountId");
        Long invorg = 1L;
        if (costAccountMap.get("billOrgMap") != null) {
            String keyValue;
            Map billOrgMap = (Map)costAccountMap.get("billOrgMap");
            invorg = billOrgMap.get(keyValue = costaccountId + "@" + bill.getLong("sourcebillentryid")) == null ? Long.valueOf(1L) : (Long)billOrgMap.get(keyValue);
        }
        matKey.setLength(0);
        matKey.append(invorg).append('@').append(matId).append('@').append(matVerId).append('@').append(auxptyId).append('@').append(bizDate);
        matKey.append('@').append(ScaMatAllocHelper.getCalcDimenStr(bill));
        return matKey.toString();
    }

    private static String getCalcDimenStr(DynamicObject dyo) {
        if (dyo == null) {
            return "";
        }
        StringBuilder calcDimenStr = new StringBuilder();
        calcDimenStr.append(dyo.getString("auxpty"));
        calcDimenStr.append('@');
        calcDimenStr.append(dyo.getString("configuredcode"));
        calcDimenStr.append('@');
        calcDimenStr.append(dyo.getString("tracknumber"));
        calcDimenStr.append('@');
        calcDimenStr.append(dyo.getString("project"));
        calcDimenStr.append('@');
        calcDimenStr.append(dyo.getString("lotcoderule"));
        return calcDimenStr.toString();
    }

    private static void splitScaAndAcaBill(Map<String, Object> costAccountMap, List<DynamicObject> bills, List<DynamicObject> scaProcessList, List<DynamicObject> acaProcessList, List<Long> sourceBillEntryIds, Map<String, Date> costRecDateMap) {
        ArrayList matUseSrcBillEntryIds = new ArrayList();
        bills.forEach(bill -> {
            long srcBillEntryId = bill.getLong("sourcebillentryid");
            if (srcBillEntryId != 0L) {
                matUseSrcBillEntryIds.add(srcBillEntryId);
            }
        });
        String fields = "entry.id entryid,storageorgunit, bookdate, costaccount, entry.bizbillentryid AS bizbillentryid, entry.accounttype AS accounttype,entry.assist auxpty,entry.material material,entry.noupdatecalfields noupdatecalfields,entry.matcostid matcostid,entry.standardcost standardcost,entry.unitstandardcost unitstandardcost";
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("entry.bizbillentryid", "in", matUseSrcBillEntryIds));
        qfList.add(new QFilter("costaccount", "=", costAccountMap.get("costaccountId")));
        qfList.add(new QFilter("billstatus", "=", (Object)"C"));
        Long currentperiodId = (Long)costAccountMap.get("currentperiodId");
        Date[] periodDate = PeriodHelper.getPeriodStartAndEndTime((Long)currentperiodId);
        if (periodDate != null) {
            qfList.add(new QFilter("bookdate", ">=", (Object)periodDate[0]));
            qfList.add(new QFilter("bookdate", "<=", (Object)periodDate[1]));
        }
        DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)"costrecrod", (String)"cal_costrecord_subentity", (String)fields, (QFilter[])qfList.toArray(new QFilter[0]), null);
        HashMap<String, Long> billOrgMap = new HashMap<String, Long>(16);
        HashMap<String, Object[]> billBizInfoMap = new HashMap<String, Object[]>(16);
        HashSet<Long> existCostRecScaBizBillIds = new HashSet<Long>();
        StringBuilder dateKey = new StringBuilder();
        HashMap nonUpdateCalFieldsMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap billStdCostMap = Maps.newHashMapWithExpectedSize((int)10);
        HashSet matcostIds = Sets.newHashSetWithExpectedSize((int)10);
        for (Row row : costRecordDs) {
            Long matcostid;
            Long bizbillentryid = row.getLong("bizbillentryid");
            Long storageorgunit = row.getLong("storageorgunit");
            dateKey.setLength(0);
            dateKey.append(row.getLong("costaccount")).append('@').append(bizbillentryid);
            costRecDateMap.putIfAbsent(dateKey.toString(), row.getDate("bookdate"));
            if ("D".equalsIgnoreCase(row.getString("accounttype"))) {
                existCostRecScaBizBillIds.add(row.getLong("bizbillentryid"));
                billOrgMap.put(dateKey.toString(), storageorgunit);
            }
            billBizInfoMap.put(dateKey.toString(), new Object[]{row.getLong("entryid"), row.getLong("auxpty"), row.getString("noupdatecalfields")});
            String noupdatecalfields = row.getString("noupdatecalfields");
            if (!StringUtils.isEmpty((CharSequence)noupdatecalfields)) {
                nonUpdateCalFieldsMap.put(bizbillentryid, noupdatecalfields);
            }
            if (CadEmptyUtils.isEmpty((Long)(matcostid = row.getLong("matcostid")))) continue;
            matcostIds.add(matcostid);
            billStdCostMap.put(dateKey.toString(), new Object[]{matcostid, row.getBigDecimal("standardcost"), row.getBigDecimal("unitstandardcost")});
        }
        ScaMatAllocHelper.setBillEnableTracknumber(bills, nonUpdateCalFieldsMap);
        costAccountMap.put("billOrgMap", billOrgMap);
        costAccountMap.put("billBizInfoMap", billBizInfoMap);
        costAccountMap.put("billStdCostMap", billStdCostMap);
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\uff1a\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5b58\u5728\u7684\u4ef7\u76ee\u4fe1\u606f\u4e2a\u6570\uff1a{}", (Object)billStdCostMap.size());
        Map<Long, Object[]> matCostInfoMap = ScaMatAllocHelper.getMatCostInfoById(matcostIds);
        costAccountMap.put("matCostInfoMap", matCostInfoMap);
        matUseSrcBillEntryIds.forEach(e -> {
            if (!existCostRecScaBizBillIds.contains(e)) {
                sourceBillEntryIds.add((Long)e);
            }
        });
        bills.forEach(e -> {
            if (sourceBillEntryIds.contains(e.getLong("sourcebillentryid"))) {
                acaProcessList.add((DynamicObject)e);
            } else {
                scaProcessList.add((DynamicObject)e);
            }
        });
    }

    private static Map<Long, Object[]> getMatCostInfoById(Set<Long> matcostIds) {
        HashMap matCostInfoMap = Maps.newHashMapWithExpectedSize((int)10);
        if (!matcostIds.isEmpty()) {
            QFilter filter = new QFilter("id", "in", matcostIds);
            DataSet ds = QueryServiceHelper.queryDataSet((String)"getMatCostInfoById", (String)"cad_matcostinfo", (String)"id,keycolid,keycol", (QFilter[])filter.toArray(), null);
            for (Row row : ds) {
                Long id = row.getLong("id");
                matCostInfoMap.put(id, new Object[]{row.getLong("keycolid"), row.getString("keycol")});
            }
        }
        return matCostInfoMap;
    }

    private static void setBillEnableTracknumber(List<DynamicObject> bills, Map<Long, String> nonUpdateCalFieldsMap) {
        if (nonUpdateCalFieldsMap.isEmpty()) {
            logger.info("\u6750\u6599\u5206\u914d\u5355\u5bfc\u5165\uff1a\u6ca1\u6709\u8bbe\u7f6e\u8ddf\u8e2a\u53f7\u914d\u7f6e\u53f7\u7684\u6570\u636e");
            return;
        }
        HashSet tracknumbers = Sets.newHashSetWithExpectedSize((int)10);
        HashSet projects = Sets.newHashSetWithExpectedSize((int)10);
        HashSet configuredcodes = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry<Long, String> entry : nonUpdateCalFieldsMap.entrySet()) {
            JSONObject jsonObj = JSON.parseObject((String)entry.getValue());
            JSONArray arr = jsonObj.getJSONArray("setnull");
            if (arr == null || arr.isEmpty()) continue;
            HashSet nullFields = Sets.newHashSetWithExpectedSize((int)10);
            for (int i = 0; i < arr.size(); ++i) {
                nullFields.add(arr.getString(i));
            }
            for (String nullField : nullFields) {
                if (nullField != null && nullField.startsWith("tracknumber")) {
                    tracknumbers.add(entry.getKey());
                }
                if (nullField != null && nullField.startsWith("configuredcode")) {
                    configuredcodes.add(entry.getKey());
                }
                if (nullField == null || !nullField.startsWith("project")) continue;
                projects.add(entry.getKey());
            }
        }
        logger.info("\u6750\u6599\u5206\u914d\u5355\u5bfc\u5165-\u6e05\u7406\u8ddf\u8e2a\u53f7\u7684\u4e1a\u52a1\u5355\u636e\u5206\u5f55id:{}", (Object)tracknumbers);
        logger.info("\u6750\u6599\u5206\u914d\u5355\u5bfc\u5165-\u6e05\u7406\u9879\u76ee\u53f7\u7684\u4e1a\u52a1\u5355\u636e\u5206\u5f55id:{}", (Object)projects);
        logger.info("\u6750\u6599\u5206\u914d\u5355\u5bfc\u5165-\u6e05\u7406\u914d\u7f6e\u53f7\u7684\u4e1a\u52a1\u5355\u636e\u5206\u5f55id:{}", (Object)configuredcodes);
        if (tracknumbers.isEmpty() && projects.isEmpty() && configuredcodes.isEmpty()) {
            return;
        }
        for (DynamicObject bill : bills) {
            long srcBillEntryId = bill.getLong("sourcebillentryid");
            if (tracknumbers.contains(srcBillEntryId)) {
                bill.set("tracknumber", (Object)0L);
            }
            if (projects.contains(srcBillEntryId)) {
                bill.set("project", (Object)0L);
            }
            if (!configuredcodes.contains(srcBillEntryId)) continue;
            bill.set("configuredcode", (Object)0L);
        }
    }

    private static void coAlloc(List<DynamicObject> dyns) {
        HashSet<Long> toAllocBills = new HashSet<Long>();
        dyns.forEach(t -> {
            if (!"2".equals(t.getString("allocstatus")) && t.getLong("costdriver") > 0L) {
                toAllocBills.add(t.getLong("id"));
            }
        });
        if (toAllocBills.size() > 0) {
            MatAllocHelper.doAlloc(toAllocBills, "2");
        }
    }

    private static void putNotMatMsg(Map<String, List<DynamicObject>> billMap, Map<String, Object> costAccountMap, Set<String> hasCostInfoMatSet, AllocResult res, Map<Long, DynamicObject> matMap) {
        String costAccountNum = (String)costAccountMap.get("costaccountnum");
        StringBuilder tipSb = new StringBuilder();
        String split = "_";
        for (Map.Entry<String, List<DynamicObject>> billKV : billMap.entrySet()) {
            if (hasCostInfoMatSet.contains(billKV.getKey())) continue;
            for (DynamicObject bill : billKV.getValue()) {
                tipSb.setLength(0);
                tipSb.append(bill.getString("billno")).append(split).append(bill.getString("seq")).append(split).append(costAccountNum);
                Map reasonMap = res.getReasonMap();
                Long matId = bill.getLong("material");
                reasonMap.put(tipSb.toString(), String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"ScaMatAllocHelper_9", (String)"macc-sca-algox", (Object[])new Object[0]), matMap.get(matId).getString("materialname")));
                res.setSuccess(false);
            }
        }
    }

    private static void fillEntrySubElement(Long orgId, List<DynamicObject> tempList, Set<Long> hasCostInfoMatIdSet) {
        Map matToSubEleMap = ElementHelper.getDefSubEles((Long)orgId, hasCostInfoMatIdSet);
        for (DynamicObject bill : tempList) {
            Long[] matToSubEle;
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
            if (rows == null || rows.isEmpty() || (matToSubEle = (Long[])matToSubEleMap.get(bill.getLong("material"))) == null) continue;
            for (DynamicObject row : rows) {
                row.set("elemententry", (Object)matToSubEle[0]);
                row.set("subelemententry", (Object)matToSubEle[1]);
            }
        }
    }

    public static void setEntryDataForStd(DynamicObject allocBill, DynamicObject bill, Map<String, Object> costaccountMap, List<Map<String, Object>> matCostInfos, Boolean isStartMatAllocSubEntry) {
        DynamicObjectCollection entryentity = allocBill.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryentity.addNew();
        entry.set("costobejctentry", (Object)bill.getLong("costobject"));
        entry.set("qty", (Object)bill.getBigDecimal("qty"));
        DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
        BigDecimal totalStandardcost = BigDecimal.ZERO;
        BigDecimal stdQty = bill.getBigDecimal("qty");
        Integer amtPrecision = (Integer)costaccountMap.get("amtprecision");
        if (!CadEmptyUtils.isEmpty(matCostInfos)) {
            int seq = 1;
            for (Map<String, Object> info : matCostInfos) {
                BigDecimal standardcost = info.get("stdprice") == null ? BigDecimal.ZERO : (BigDecimal)info.get("stdprice");
                totalStandardcost = totalStandardcost.add(standardcost);
                BigDecimal standardamt = standardcost.multiply(stdQty).setScale((int)amtPrecision, 4);
                if (!isStartMatAllocSubEntry.booleanValue()) continue;
                DynamicObject sub = subentryentity.addNew();
                sub.set("seq", (Object)seq);
                ++seq;
                sub.set("element", info.get("element"));
                sub.set("subelement", info.get("subelement"));
                if (info.get("qty") != null) {
                    sub.set("calcbasis", info.get("calcbasis"));
                    sub.set("resource", info.get("resource"));
                    sub.set("submaterial", info.get("submaterial"));
                    sub.set("submatverison", info.get("submatvers"));
                    sub.set("subauxpty", info.get("subauxproperty"));
                    BigDecimal subqty = stdQty.multiply((BigDecimal)info.get("qty"));
                    sub.set("subqty", (Object)subqty);
                } else {
                    sub.set("submaterial", (Object)allocBill.getLong("material"));
                    sub.set("submatverison", (Object)allocBill.getLong("matversion"));
                    sub.set("subauxpty", (Object)allocBill.getLong("auxpty"));
                    sub.set("subqty", (Object)(stdQty.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(1) : stdQty));
                }
                sub.set("standardcost", (Object)standardcost);
                sub.set("standardamt", (Object)standardamt);
                sub.set("subentrykeycol", info.get("subkeycol"));
                sub.set("subentrykeycolid", info.get("subkeycolid"));
            }
        }
        entry.set("price", (Object)totalStandardcost);
        entry.set("amount", (Object)allocBill.getBigDecimal("useamount"));
        if (isStartMatAllocSubEntry.booleanValue()) {
            BigDecimalUtils.dealDiff((DynamicObjectCollection)subentryentity, (String)"seq", (String)"standardamt", (BigDecimal)entry.getBigDecimal("amount"), (int)amtPrecision);
        }
    }

    public static void countTotalStandardamtForStd(DynamicObject allocBill, DynamicObject bill, List<DynamicObject> effeResList, boolean isEffeRes, Integer amtPrecision) {
        if (effeResList == null) {
            allocBill.set("useamount", (Object)0);
            return;
        }
        BigDecimal totalStandardamt = BigDecimal.ZERO;
        BigDecimal qty = bill.getBigDecimal("qty");
        for (DynamicObject entryRow : effeResList) {
            BigDecimal standardcost = entryRow.getBigDecimal("standardcost");
            BigDecimal standardamt = standardcost.multiply(qty).setScale((int)amtPrecision, 4);
            totalStandardamt = totalStandardamt.add(standardamt);
        }
        allocBill.set("useamount", (Object)totalStandardamt.setScale((int)amtPrecision, 4));
        allocBill.set("matcostinfo", effeResList.get(0).get("id"));
    }

    private static boolean getMatAllocUseAlgox() {
        String matAllocUseAlgox = CadBgParamUtils.getScmParamForString((String)"matAllocUseAlgox", (String)"0");
        return "1".equals(matAllocUseAlgox);
    }
}

