/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.alloc.function;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.alloc.input.AllocDataParameter;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.ElementHelper;

@Deprecated
public class AllocFunction
extends GroupReduceFunction {
    private static final Log logger = LogFactory.getLog(AllocFunction.class);
    private static final long serialVersionUID = -547462364191130911L;
    private static final int MAP_INITIAL_CAPACITY = 16;
    protected AllocDataParameter para;

    public void setPara(AllocDataParameter para) {
        this.para = para;
    }

    public RowMeta getResultRowMeta() {
        return this.getRowMeta();
    }

    public RowMeta getRowMeta() {
        Field[] fields = new Field[]{new Field("id", (DataType)DataType.LongType), new Field("org", (DataType)DataType.LongType), new Field("costaccount", (DataType)DataType.LongType), new Field("costcenter", (DataType)DataType.LongType), new Field("period", (DataType)DataType.LongType), new Field("expenseitem", (DataType)DataType.LongType), new Field("subelement", (DataType)DataType.LongType), new Field("amount", (DataType)DataType.BigDecimalType), new Field("amtprecision", (DataType)DataType.IntegerType)};
        return new RowMeta(fields);
    }

    public void reduce(Iterable<RowX> arg0, Collector arg1) {
        for (RowX rowX : arg0) {
            this.doAlloc(rowX);
        }
    }

    private void doAlloc(RowX rowX) {
        if ("sca_mfgfeealloc".equals(this.para.getProcessingAllocEntity())) {
            this.doMfgAlloc(rowX);
        } else if ("sca_matalloc".equals(this.para.getProcessingAllocEntity())) {
            this.doMatAlloc(rowX);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doMfgAlloc(RowX rowX) {
        BigDecimal totalAmt = rowX.getBigDecimal(7);
        int precision = rowX.getInteger(8);
        Long costdriverId = 0L;
        Set<Object> costcenterScope = new HashSet<String>();
        if (this.para.getCollDataMap() != null) {
            Map<Long, Set<String>> allocStdScopeMap = this.para.getCollDataMap().get(rowX.get(0));
            if (allocStdScopeMap == null) {
                return;
            }
            for (Map.Entry<Long, Set<String>> entry : allocStdScopeMap.entrySet()) {
                costdriverId = entry.getKey();
                Set<String> value = entry.getValue();
                if (value == null) continue;
                costcenterScope = value;
            }
        }
        if (this.para.getCollSocpeMap().get(rowX.get(0)) != null) {
            for (String costCenterId : this.para.getCollSocpeMap().get(rowX.get(0))) {
                costcenterScope.add(costCenterId);
            }
        }
        Map<String, BigDecimal> allocStdValueMap = null;
        HashMap effectAllocStdValueMap = new HashMap();
        BigDecimal totalValue = BigDecimal.ZERO;
        if (this.para.getAllocStdValueColls() != null && this.para.getAllocStdValueColls().size() > 0 && this.para.getAllocStdValueColls().containsKey(costdriverId.toString())) {
            allocStdValueMap = this.para.getAllocStdValueColls().get(costdriverId.toString());
            for (Map.Entry entry : allocStdValueMap.entrySet()) {
                String[] keyinfos = ((String)entry.getKey()).split("@");
                if (costcenterScope.size() >= 1) {
                    if (!costcenterScope.contains(keyinfos[1])) continue;
                    totalValue = totalValue.add((BigDecimal)entry.getValue());
                    effectAllocStdValueMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                totalValue = totalValue.add((BigDecimal)entry.getValue());
                effectAllocStdValueMap.put(entry.getKey(), entry.getValue());
            }
        }
        BigDecimal allocTotalAmt = BigDecimal.ZERO;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Long maxCostCenterId = 0L;
        HashMap<Long, BigDecimal> allocRsMap = new HashMap<Long, BigDecimal>(16);
        HashMap allocValuesMap = new HashMap(16);
        if (effectAllocStdValueMap.size() < 1) {
            return;
        }
        for (Map.Entry entry : effectAllocStdValueMap.entrySet()) {
            void var10_12;
            String[] orgAndcostCenter = ((String)entry.getKey()).split("@");
            if (var10_12.compareTo((BigDecimal)entry.getValue()) < 0) {
                BigDecimal bigDecimal2 = (BigDecimal)entry.getValue();
                maxCostCenterId = Long.valueOf(orgAndcostCenter[1]);
            }
            BigDecimal allocAmt = totalAmt.multiply((BigDecimal)entry.getValue()).divide(totalValue, precision, 4);
            allocTotalAmt = allocTotalAmt.add(allocAmt);
            allocRsMap.put(Long.valueOf(orgAndcostCenter[1]), allocAmt);
            allocValuesMap.put(Long.valueOf(orgAndcostCenter[1]), entry.getValue());
        }
        BigDecimal diffAmt = totalAmt.subtract(allocTotalAmt);
        if (diffAmt.abs().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal currAllocAmt = (BigDecimal)allocRsMap.get(maxCostCenterId);
            allocRsMap.put(maxCostCenterId, currAllocAmt.add(diffAmt));
        }
        DynamicObject allocData = BusinessDataServiceHelper.loadSingle((Object)rowX.getLong(0), (String)"sca_mfgfeealloc");
        allocData.set("costdriver", (Object)costdriverId);
        this.setBaseUnit(allocData, costdriverId);
        allocData.set("allocstatus", (Object)this.para.getAllocStatus());
        allocData.set("alloctype", (Object)1);
        allocData.set("usetype", (Object)1);
        allocData.set("alloctime", (Object)new Date());
        allocData.set("allocor", (Object)this.para.getAllocor());
        DynamicObjectCollection entrys = allocData.getDynamicObjectCollection("entryentity");
        entrys.clear();
        int seq = 0;
        for (Map.Entry allocRsMapEntry : allocRsMap.entrySet()) {
            DynamicObject entry = entrys.addNew();
            entry.set("seq", (Object)seq);
            entry.set("subelement", rowX.get(6));
            entry.set("element", rowX.get(9));
            entry.set("benefcostcenter", allocRsMapEntry.getKey());
            entry.set("allocamt", allocRsMapEntry.getValue());
            entry.set("allocvalue", allocValuesMap.get(allocRsMapEntry.getKey()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allocData});
    }

    private void setBaseUnit(DynamicObject allocData, Object costdriverId) {
        DynamicObject costDriver = BusinessDataServiceHelper.loadSingle((Object)costdriverId, (String)"cad_costdriver");
        allocData.set("baseunit", costDriver.getDynamicObject("unit").getPkValue());
    }

    private void doMatAlloc(RowX rowX) {
        BigDecimal totalQty = rowX.getBigDecimal(6);
        String matcostinfo = rowX.getString(this.getSourceRowMeta().getFieldIndex("matcostinfo"));
        int precision = rowX.getInteger(7);
        int qtyPrecision = rowX.getInteger(8);
        Long orgId = rowX.getLong(1);
        Long manuOrgId = rowX.getLong(this.sourceRowMeta.getFieldIndex("manuorg"));
        Date bizDate = rowX.getDate(9);
        Long costdriverId = 0L;
        Long costcenterId = rowX.getLong(this.sourceRowMeta.getFieldIndex("costcenter"));
        String billno = rowX.getString(this.sourceRowMeta.getFieldIndex("billno"));
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d-algox\uff1a{}", (Object)billno);
        Set<String> matScope = null;
        if (CadEmptyUtils.isEmpty(this.para.getCollDataMap())) {
            logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u5206\u914d\u6807\u51c6\u4e0a\u6307\u5b9a\u7684\u5206\u914d\u8303\u56f4\u4e3a\u7a7a\uff1a{}", (Object)billno);
            return;
        }
        Map<Long, Set<String>> allocStdScopeMap = this.para.getCollDataMap().get(rowX.get(0));
        if (allocStdScopeMap == null) {
            logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u5206\u914d\u6807\u51c6\u4e0a\u6307\u5b9a\u7684\u5206\u914d\u8303\u56f4\u4e3a\u7a7a-2\uff1a{}", (Object)billno);
            return;
        }
        for (Map.Entry<Long, Set<String>> entry : allocStdScopeMap.entrySet()) {
            costdriverId = entry.getKey();
            matScope = entry.getValue();
        }
        HashMap<String, BigDecimal> effectAllocStdValueMap = new HashMap<String, BigDecimal>();
        BigDecimal totalValue = BigDecimal.ZERO;
        if (CadEmptyUtils.isEmpty(this.para.getAllocStdValueColls())) {
            logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u8ba1\u7b97\u5206\u914d\u6807\u51c6\u503c\u4e3a\u7a7a\uff1a{}", (Object)billno);
            return;
        }
        String costdriverKey = String.format("%s@%s", costcenterId, costdriverId);
        if (this.para.getAllocStdValueColls().containsKey(costdriverKey)) {
            Map<String, BigDecimal> allocStdValueMap = this.para.getAllocStdValueColls().get(costdriverKey);
            for (Map.Entry<String, BigDecimal> entry : allocStdValueMap.entrySet()) {
                if (!CadEmptyUtils.isEmpty(matScope)) {
                    String matId = entry.getKey().split("@")[3];
                    if (matScope != null && !matScope.contains(matId)) continue;
                    totalValue = totalValue.add(entry.getValue());
                    effectAllocStdValueMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                totalValue = totalValue.add(entry.getValue());
                effectAllocStdValueMap.put(entry.getKey(), entry.getValue());
            }
        }
        BigDecimal allocTotalQty = BigDecimal.ZERO;
        BigDecimal maxAllocVlue = null;
        Long maxCostObjectId = 0L;
        HashMap<Long, Object> allocRsMap = new HashMap<Long, Object>(16);
        HashMap allocValuesMap = new HashMap(16);
        if (effectAllocStdValueMap.size() < 1) {
            logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u6709\u6548\u8ba1\u7b97\u5206\u914d\u6807\u51c6\u503c\u4e3a\u7a7a\uff1a{}", (Object)billno);
            return;
        }
        for (Map.Entry entry : effectAllocStdValueMap.entrySet()) {
            String[] orgAndCcAndCoAndMat = ((String)entry.getKey()).split("@");
            if (maxAllocVlue == null || maxAllocVlue.compareTo((BigDecimal)entry.getValue()) < 0) {
                maxAllocVlue = (BigDecimal)entry.getValue();
                maxCostObjectId = Long.valueOf(orgAndCcAndCoAndMat[2]);
            }
            BigDecimal allocQty = totalQty.multiply((BigDecimal)entry.getValue()).divide(totalValue, qtyPrecision, 4);
            allocTotalQty = allocTotalQty.add(allocQty);
            allocRsMap.put(Long.valueOf(orgAndCcAndCoAndMat[2]), allocQty);
            allocValuesMap.put(Long.valueOf(orgAndCcAndCoAndMat[2]), entry.getValue());
        }
        BigDecimal diffQty = totalQty.subtract(allocTotalQty);
        if (diffQty.abs().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal currAllocAmt = (BigDecimal)allocRsMap.get(maxCostObjectId);
            allocRsMap.put(maxCostObjectId, currAllocAmt.add(diffQty));
        }
        Map<String, List<BigDecimal>> matCostInfo = this.para.getMatCostDataMap() != null ? this.para.getMatCostDataMap().get(matcostinfo) : null;
        BigDecimal totalPrice = BigDecimal.ZERO;
        if (matCostInfo != null && !matCostInfo.isEmpty()) {
            for (List list : matCostInfo.values()) {
                totalPrice = totalPrice.add((BigDecimal)list.get(1));
            }
        }
        String allocMatInfo = rowX.getString(5) + "@" + rowX.getString(10) + "@" + rowX.getString(11);
        Map<String, String> map = ElementHelper.getElementInfos(allocRsMap.keySet(), allocMatInfo, bizDate, rowX.getLong(2), orgId, manuOrgId);
        DynamicObject allocData = BusinessDataServiceHelper.loadSingle((Object)rowX.getLong(0), (String)"sca_matalloc");
        allocData.set("costdriver", (Object)costdriverId);
        allocData.set("allocstatus", (Object)this.para.getAllocStatus());
        allocData.set("alloctype", (Object)1);
        allocData.set("usetype", (Object)1);
        allocData.set("allocatedate", (Object)new Date());
        allocData.set("alloctor", (Object)this.para.getAllocor());
        String entrySrc = allocData.getString("entrysrc");
        DynamicObjectCollection entrys = allocData.getDynamicObjectCollection("entryentity");
        entrys.clear();
        int seq = 1;
        int maxAllocDataSeq = 0;
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d-\u8fdb\u884c\u5206\u914d\u5904\u7406\uff1a{}", (Object)billno);
        BigDecimal alloctotalAmt = BigDecimal.ZERO;
        for (Map.Entry allocRsMapEntry : allocRsMap.entrySet()) {
            BigDecimal qty = (BigDecimal)allocRsMap.get(allocRsMapEntry.getKey());
            if (qty.compareTo(BigDecimal.ZERO) == 0) continue;
            if (((Long)allocRsMapEntry.getKey()).longValue() == maxCostObjectId.longValue()) {
                maxAllocDataSeq = seq - 1;
            }
            DynamicObject entry = entrys.addNew();
            entry.set("seq", (Object)seq++);
            entry.set("costobejctentry", allocRsMapEntry.getKey());
            entry.set("qty", (Object)qty);
            entry.set("price", (Object)totalPrice);
            entry.set("allocvalue", allocValuesMap.get(allocRsMapEntry.getKey()));
            if (map.containsKey(((Long)allocRsMapEntry.getKey()).toString())) {
                String[] elements = map.get(((Long)allocRsMapEntry.getKey()).toString()).split("@");
                if (elements != null && elements.length > 1) {
                    entry.set("elemententry", (Object)elements[0]);
                    entry.set("subelemententry", (Object)elements[1]);
                }
            } else {
                logger.error("\u6750\u6599\u8017\u7528\u5206\u914d-\u672a\u83b7\u53d6\u5b50\u8981\u7d20\u4fe1\u606f\uff1a{}", (Object)billno);
                return;
            }
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal allocRs = (BigDecimal)allocRsMap.get(allocRsMapEntry.getKey());
            if ("calrec".equals(entrySrc)) {
                BigDecimal useamount = allocData.getBigDecimal("useamount");
                amount = useamount.multiply(allocRs).divide(totalQty, precision, 4);
            } else {
                amount = totalPrice.multiply(allocRs).setScale(precision, 4);
            }
            entry.set("amount", (Object)amount);
            alloctotalAmt = alloctotalAmt.add(amount);
            DynamicObjectCollection subentrys = entry.getDynamicObjectCollection("subentryentity");
            if (matCostInfo == null || matCostInfo.isEmpty()) continue;
            Map<String, BigDecimal> calcMatDetailCost = this.doDiff(qty, amount, matCostInfo, precision);
            int subSeq = 1;
            for (Map.Entry<String, List<BigDecimal>> matCostInfoEntry : matCostInfo.entrySet()) {
                DynamicObject subentry = subentrys.addNew();
                BigDecimal unitqty = matCostInfoEntry.getValue().get(0);
                String[] subelements = matCostInfoEntry.getKey().split("@");
                subentry.set("seq", (Object)subSeq++);
                subentry.set("element", (Object)subelements[0]);
                subentry.set("subelement", (Object)subelements[1]);
                subentry.set("submaterial", (Object)subelements[2]);
                subentry.set("submatverison", (Object)subelements[3]);
                subentry.set("subauxpty", (Object)subelements[4]);
                subentry.set("resource", (Object)subelements[6]);
                subentry.set("calcbasis", (Object)subelements[7].trim());
                subentry.set("subqty", (Object)unitqty.multiply(qty));
                subentry.set("standardcost", (Object)matCostInfoEntry.getValue().get(1));
                subentry.set("standardamt", (Object)calcMatDetailCost.get(matCostInfoEntry.getKey()));
            }
        }
        BigDecimal totalAmt = BigDecimal.ZERO;
        totalAmt = "calrec".equals(entrySrc) ? allocData.getBigDecimal("useamount") : totalPrice.multiply(totalQty).setScale(precision, 4);
        this.doEntryDiff(entrys, totalAmt, alloctotalAmt, maxAllocDataSeq, precision);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allocData});
    }

    private Map<String, BigDecimal> doDiff(BigDecimal qty, BigDecimal totalAmount, Map<String, List<BigDecimal>> matcostInfo, int amtprecision) {
        String maxPriceSubelement = "0@0";
        BigDecimal calcTotoalAmt = BigDecimal.ZERO;
        HashMap<String, BigDecimal> calcMatDetailCost = new HashMap<String, BigDecimal>(16);
        BigDecimal maxSubPrice = BigDecimal.ZERO;
        for (Map.Entry<String, List<BigDecimal>> entry : matcostInfo.entrySet()) {
            BigDecimal subPrice = entry.getValue().get(1);
            BigDecimal currAmt = subPrice.multiply(qty).setScale(amtprecision, 4);
            String key = entry.getKey();
            calcMatDetailCost.put(key, currAmt);
            calcTotoalAmt = calcTotoalAmt.add(currAmt);
            if (subPrice.compareTo(maxSubPrice) < 0) continue;
            maxPriceSubelement = key;
        }
        BigDecimal diff = totalAmount.subtract(calcTotoalAmt);
        calcMatDetailCost.put(maxPriceSubelement, ((BigDecimal)calcMatDetailCost.get(maxPriceSubelement)).add(diff));
        return calcMatDetailCost;
    }

    private void doEntryDiff(DynamicObjectCollection entrys, BigDecimal totalAmt, BigDecimal alloctotalAmt, int maxAllocDataSeq, int amtprecision) {
        BigDecimal diffAmt = totalAmt.subtract(alloctotalAmt);
        DynamicObject diffEntry = (DynamicObject)entrys.get(maxAllocDataSeq);
        diffEntry.set("amount", (Object)diffAmt.add(diffEntry.getBigDecimal("amount")));
        entrys.set(maxAllocDataSeq, (Object)diffEntry);
    }
}

