/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.alloc.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.sca.algox.alloc.MatAllocHelper;
import kd.macc.sca.algox.utils.DatSetXUtils;
import org.apache.commons.lang3.StringUtils;

public class CostObjectCalculateFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private static final String OPERATOR = "+-*/()";
    private static final String COSTCENTER = "COSTCENTER";
    private static final String COSTOBJECT = "COSTOBJECT";
    private static final String MATERIAL = "MATERIAL";
    private static final String DIGITAL = "DIGITAL";
    private static final String ENTITY_DIYCOSTDRIVER = "sca_diycostdriver";
    private static final String FIRST_MUL_VALUE = "(case when (firstValue * value) != null then (firstValue * value) else 0 end) as value";
    private static final String FIRST_DIV_VALUE = "(case when value != 0 and (firstValue / value) != null then (firstValue / value) else 0 end) as value";
    private static final String DIV_VALUE = "(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value";
    public RowMeta rowMeta;
    public Map<String, Object> paramMap;

    public CostObjectCalculateFunction(RowMeta rowMeta, Map<String, Object> param) {
        this.rowMeta = rowMeta;
        this.paramMap = param;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> rows, Collector collector) {
        DataSet ds = DatSetXUtils.getDsFromAlgoxRows(rows, null, this.rowMeta);
        List postfixExp = (List)this.paramMap.get("exp");
        List materials = (List)this.paramMap.get("material");
        long orgId = (Long)this.paramMap.get("orgId");
        long costAccountId = (Long)this.paramMap.get("costAccountId");
        long periodId = (Long)this.paramMap.get("periodId");
        String appId = (String)this.paramMap.get("appId");
        Stack<DataSet> opDsStack = new Stack<DataSet>();
        Stack opTypeAndNumberStack = new Stack();
        DataSet opResult = null;
        for (String number : postfixExp) {
            DataSet diyCostDriverDs;
            if (OPERATOR.indexOf(number) >= 0) {
                String firstType = "";
                String secondType = "";
                DataSet secondDs = (DataSet)opDsStack.pop();
                Map secondTypeMap = (Map)opTypeAndNumberStack.pop();
                double secondValue = 0.0;
                for (Map.Entry entry : secondTypeMap.entrySet()) {
                    secondType = (String)entry.getKey();
                    secondValue = (Double)entry.getValue();
                }
                DataSet firstDs = (DataSet)opDsStack.pop();
                Map firstTypeMap = (Map)opTypeAndNumberStack.pop();
                double firstValue = 0.0;
                for (Map.Entry entry : firstTypeMap.entrySet()) {
                    firstType = (String)entry.getKey();
                    firstValue = (Double)entry.getValue();
                    switch (firstType) {
                        case "COSTCENTER": {
                            firstDs = firstDs.executeSql("select org,costcenter,benefcostcenter,value as firstValue");
                            break;
                        }
                        case "COSTOBJECT": {
                            firstDs = firstDs.executeSql("select org,costcenter,costobject,material,materialauxpty,value as firstValue");
                            break;
                        }
                        case "MATERIAL": {
                            firstDs = firstDs.executeSql("select org,material,materialauxpty,value as firstValue");
                            break;
                        }
                    }
                }
                Map<Object, Object> opResultTypeMap = new HashMap(16);
                block16 : switch (number) {
                    case "+": {
                        if (!this.isSameType(firstType, secondType)) break;
                        switch (firstType) {
                            case "COSTCENTER": {
                                opResult = CostObjectCalculateFunction.doAddOnCostCenter(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                break block16;
                            }
                            case "COSTOBJECT": {
                                opResult = CostObjectCalculateFunction.doAddOnCostObject(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                break block16;
                            }
                            case "MATERIAL": {
                                opResult = CostObjectCalculateFunction.doAddOnMaterial(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                break block16;
                            }
                        }
                        break;
                    }
                    case "-": {
                        if (!this.isSameType(firstType, secondType)) break;
                        switch (firstType) {
                            case "COSTCENTER": {
                                opResult = CostObjectCalculateFunction.doSubtractOnCostCenter(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                break block16;
                            }
                            case "COSTOBJECT": {
                                opResult = CostObjectCalculateFunction.doSubtractOnCostObject(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                break block16;
                            }
                            case "MATERIAL": {
                                opResult = CostObjectCalculateFunction.doSubtractOnMaterial(firstDs, secondDs);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                break block16;
                            }
                        }
                        break;
                    }
                    case "*": {
                        if (this.isSameType(firstType, secondType)) {
                            switch (firstType) {
                                case "COSTCENTER": {
                                    opResult = CostObjectCalculateFunction.doMultiplyOnCostCenter(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                    break block16;
                                }
                                case "COSTOBJECT": {
                                    opResult = CostObjectCalculateFunction.doMultiplyOnCostObject(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                    break block16;
                                }
                                case "MATERIAL": {
                                    opResult = CostObjectCalculateFunction.doMultiplyOnMaterial(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                    break block16;
                                }
                            }
                            break;
                        }
                        switch (firstType) {
                            case "COSTCENTER": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doMulOnCostObjectToCenter(secondDs, firstDs, true);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doMultiplyOnDigToCostCenter(firstDs, secondValue, true);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                break;
                            }
                            case "COSTOBJECT": {
                                if (COSTCENTER.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doMulOnCostObjectToCenter(firstDs, secondDs, false);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (MATERIAL.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doMulOnCostObjectToMaterial(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doMultiplyOnDigToCostObject(firstDs, secondValue, true);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                break;
                            }
                            case "MATERIAL": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doMulOnCostObjectToMaterial(secondDs, firstDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doMulOnDigToMaterial(firstDs, secondValue, true);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                break;
                            }
                            case "DIGITAL": {
                                if (COSTCENTER.equals(secondType)) {
                                    opResult = this.doMultiplyOnDigToCostCenter(secondDs, firstValue, false);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                }
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = this.doMultiplyOnDigToCostObject(secondDs, firstValue, false);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!MATERIAL.equals(secondType)) break;
                                opResult = this.doMulOnDigToMaterial(secondDs, firstValue, false);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                break;
                            }
                        }
                        break;
                    }
                    case "/": {
                        if (this.isSameType(firstType, secondType)) {
                            switch (firstType) {
                                case "COSTCENTER": {
                                    opResult = CostObjectCalculateFunction.doDivideOnCostCenter(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                    break block16;
                                }
                                case "COSTOBJECT": {
                                    opResult = CostObjectCalculateFunction.doDivisideOnCostObject(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                    break block16;
                                }
                                case "MATERIAL": {
                                    opResult = CostObjectCalculateFunction.doDivisideOnMaterial(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                                    break block16;
                                }
                            }
                            break;
                        }
                        switch (firstType) {
                            case "COSTCENTER": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doDivOnCostCenterToObject(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doDivideOnDigToCostCenter(firstDs, secondValue);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTCENTER);
                                break;
                            }
                            case "COSTOBJECT": {
                                if (COSTCENTER.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doDivOnCostObjectToCenter(firstDs, secondDs);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (MATERIAL.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doDivOnCostObjectToMaterial(firstDs, secondDs, false);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doDivideOnDigToCostObject(firstDs, secondValue);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                break;
                            }
                            case "MATERIAL": {
                                if (COSTOBJECT.equals(secondType)) {
                                    opResult = CostObjectCalculateFunction.doDivOnCostObjectToMaterial(secondDs, firstDs, true);
                                    opResultTypeMap = CostObjectCalculateFunction.buildResultType(COSTOBJECT);
                                }
                                if (!DIGITAL.equals(secondType)) break;
                                opResult = this.doDivideOnDigToMaterial(firstDs, secondValue);
                                opResultTypeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
                            }
                        }
                        break;
                    }
                }
                if (opResult == null) continue;
                opDsStack.push(opResult);
                opTypeAndNumberStack.add(opResultTypeMap);
                continue;
            }
            Map<String, Double> typeMap = new HashMap<String, Double>(16);
            if (CostObjectCalculateFunction.isInteger(number) && materials.contains(number)) {
                String algoKey = "kd.macc.sca.algox.alloc.function.CostObjectCalculateFunction.reduce";
                ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                filters.add(orgFilter);
                filters.add(new QFilter("appnum", "=", (Object)appId));
                filters.add(new QFilter("costdriver.id", "=", (Object)Long.parseLong(number)));
                filters.add(new QFilter("effectperiod", "!=", (Object)0L));
                filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
                filters.add(MatAllocHelper.getEffectDateFilter(periodId));
                diyCostDriverDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)ENTITY_DIYCOSTDRIVER, (String)"costdriver,org,entryentity.matnum as material,entryentity.matauxpty as materialauxpty,entryentity.entryqty as value", (QFilter[])filters.toArray(new QFilter[0]), null);
                diyCostDriverDs = diyCostDriverDs.executeSql("select costdriver,org,material,materialauxpty,sum(value) value group by costdriver,org,material,materialauxpty");
                typeMap = CostObjectCalculateFunction.buildResultType(MATERIAL);
            } else {
                diyCostDriverDs = ds.copy().filter("costdriver = " + number);
                boolean isExist = false;
                if (CostObjectCalculateFunction.isInteger(number)) {
                    isExist = QueryServiceHelper.exists((String)"cad_costdriver", (Object)Long.parseLong(number));
                }
                if (isExist) {
                    QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(number));
                    DynamicObject costDriverObject = QueryServiceHelper.queryOne((String)"cad_costdriver", (String)"allocclass", (QFilter[])qFilter.toArray());
                    if (costDriverObject != null) {
                        String allocClass = costDriverObject.getString("allocclass");
                        typeMap = CostObjectCalculateFunction.buildResultType(allocClass);
                    }
                } else if (CostObjectCalculateFunction.isNumeric(number)) {
                    typeMap.put(DIGITAL, Double.parseDouble(number));
                }
            }
            opTypeAndNumberStack.push(typeMap);
            opDsStack.push(diyCostDriverDs);
        }
        if (opResult != null) {
            for (Row row : opResult) {
                RowX targetRow = new RowX(this.rowMeta.getFieldCount());
                targetRow.set(this.rowMeta.getFieldIndex("org"), row.get("org"));
                targetRow.set(this.rowMeta.getFieldIndex("costcenter"), row.get("costcenter"));
                targetRow.set(this.rowMeta.getFieldIndex("costobject"), row.get("costobject"));
                targetRow.set(this.rowMeta.getFieldIndex("material"), row.get("material"));
                targetRow.set(this.rowMeta.getFieldIndex("value"), (Object)(row.getBigDecimal("value") == null ? BigDecimal.ZERO : row.getBigDecimal("value")));
                collector.collect(targetRow);
            }
        }
    }

    public static boolean isInteger(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]*");
        return pattern.matcher(str).matches();
    }

    private boolean isSameType(String firstType, String secondType) {
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{firstType, secondType})) {
            return StringUtils.equals((CharSequence)firstType, (CharSequence)secondType);
        }
        return false;
    }

    private static Map<String, Double> buildResultType(String type) {
        HashMap<String, Double> resultType = new HashMap<String, Double>();
        switch (type) {
            case "COSTCENTER": {
                resultType.put(COSTCENTER, 0.0);
                break;
            }
            case "COSTOBJECT": {
                resultType.put(COSTOBJECT, 0.0);
                break;
            }
            case "MATERIAL": {
                resultType.put(MATERIAL, 0.0);
                break;
            }
        }
        return resultType;
    }

    private DataSet doDivideOnDigToMaterial(DataSet opDs, double opValue) {
        DataSet opResult = opValue != 0.0 ? opDs.executeSql("select org, material,materialauxpty, firstValue / " + opValue + " as value") : opDs.executeSql("select org, material,materialauxpty, 0 as value");
        return opResult;
    }

    private DataSet doDivideOnDigToCostObject(DataSet opDs, double opValue) {
        DataSet opResult = opValue != 0.0 ? opDs.executeSql("select org, costcenter, costobject, material,materialauxpty, firstValue / " + opValue + " as value") : opDs.executeSql("select org, costcenter, costobject, material,materialauxpty, 0 as value");
        return opResult;
    }

    private DataSet doDivideOnDigToCostCenter(DataSet opDs, double opValue) {
        DataSet opResult = opValue != 0.0 ? opDs.executeSql("select org, costcenter, benefcostcenter,firstValue / " + opValue + " as value") : opDs.executeSql("select org, costcenter, benefcostcenter,0 as value");
        return opResult;
    }

    private DataSet doMulOnDigToMaterial(DataSet opDs, double opValue, boolean isReverse) {
        String sql = isReverse ? "select org, material,materialauxpty," + opValue + " * firstValue as value" : "select org, material,materialauxpty," + opValue + " * value as value";
        DataSet opResult = opDs.executeSql(sql);
        return opResult;
    }

    private DataSet doMultiplyOnDigToCostObject(DataSet opDs, double opValue, boolean isReverse) {
        String sql = isReverse ? "select org, costcenter, costobject, material,materialauxpty," + opValue + " * firstValue as value" : "select org, costcenter, costobject, material,materialauxpty," + opValue + " * value as value";
        DataSet opResult = opDs.executeSql(sql);
        return opResult;
    }

    private DataSet doMultiplyOnDigToCostCenter(DataSet opDs, double opValue, boolean isReverse) {
        String sql = isReverse ? "select org, costcenter, benefcostcenter," + opValue + " * firstValue as value" : "select org, costcenter, benefcostcenter," + opValue + " * value as value";
        DataSet opResult = opDs.executeSql(sql);
        return opResult;
    }

    private static DataSet doMultiplyOnMaterial(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "material", "materialauxpty", FIRST_MUL_VALUE}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "material", "materialauxpty", FIRST_MUL_VALUE}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doMultiplyOnCostObject(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", FIRST_MUL_VALUE}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", FIRST_MUL_VALUE}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doSubtractOnMaterial(DataSet firstDs, DataSet secondDs) {
        DataSet opResult = firstDs.leftJoin(secondDs).on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "material", "materialauxpty", "(case when (firstValue - value) != null then (firstValue - value) else firstValue end) as value"}).finish();
        return opResult;
    }

    private static DataSet doSubtractOnCostObject(DataSet firstDs, DataSet secondDs) {
        DataSet opResult = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "(case when (firstValue - value) != null then (firstValue - value) else firstValue end) as value"}).finish();
        return opResult;
    }

    private static DataSet doAddOnMaterial(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "material", "materialauxpty", "firstValue + value as value"}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "material", "materialauxpty", "firstValue + value as value"}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doAddOnCostObject(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "firstValue + value as value"}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", "firstValue + value as value"}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doMulOnCostObjectToMaterial(DataSet firstDs, DataSet secondDs) {
        String value = "(case when (value * firstValue) != null then (value * firstValue) else 0 end) as value";
        DataSet opResult = firstDs.leftJoin(secondDs).on("material", "material").on("materialauxpty", "materialauxpty").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", value}).finish();
        return opResult;
    }

    private static DataSet doMulOnCostObjectToCenter(DataSet firstDs, DataSet secondDs, boolean isSwitch) {
        String value = "(case when (value * firstValue) != null then (value * firstValue) else 0 end) as value";
        String sumStr = isSwitch ? "firstValue" : "value";
        secondDs = secondDs.groupBy(new String[]{"org", "benefcostcenter"}).sum(sumStr).finish();
        DataSet opResult = firstDs.leftJoin(secondDs).on("costcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", value}).finish();
        return opResult;
    }

    private static DataSet doDivOnCostObjectToMaterial(DataSet firstDs, DataSet secondDs, boolean isSwitch) {
        if (isSwitch) {
            firstDs = firstDs.executeSql("select org,costcenter,costobject,material,materialauxpty,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        } else {
            secondDs = secondDs.executeSql("select org,material,materialauxpty,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        }
        return CostObjectCalculateFunction.doMulOnCostObjectToMaterial(firstDs, secondDs);
    }

    private static DataSet doDivOnCostObjectToCenter(DataSet firstDs, DataSet secondDs) {
        secondDs = secondDs.executeSql("select org,costcenter,benefcostcenter,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        return CostObjectCalculateFunction.doMulOnCostObjectToCenter(firstDs, secondDs, false);
    }

    private static DataSet doDivOnCostCenterToObject(DataSet firstDs, DataSet secondDs) {
        secondDs = secondDs.executeSql("select org,costcenter,costobject,material,materialauxpty,(case when value != 0 and (1.0/value) != null then (1.0/value) else 0 end) as value");
        return CostObjectCalculateFunction.doMulOnCostObjectToCenter(secondDs, firstDs, true);
    }

    private static DataSet doDivisideOnMaterial(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("material", "material").select(new String[]{"org", "material", "materialauxpty", FIRST_DIV_VALUE}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("material", "material").select(new String[]{"org", "material", "materialauxpty", FIRST_DIV_VALUE}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doDivisideOnCostObject(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", FIRST_DIV_VALUE}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("costObject", "costObject").select(new String[]{"org", "costcenter", "costobject", "material", "materialauxpty", FIRST_DIV_VALUE}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doSubtractOnCostCenter(DataSet firstDs, DataSet secondDs) {
        DataSet opResult = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", "(case when (firstValue - value) != null then (firstValue - value) else firstValue end) as value"}).finish();
        return opResult;
    }

    private static DataSet doAddOnCostCenter(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", "firstValue + value  as value"}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", "firstValue + value as value"}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doMultiplyOnCostCenter(DataSet firstDs, DataSet secondDs) {
        DataSet leftDs = secondDs.leftJoin(firstDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", FIRST_MUL_VALUE}).finish();
        DataSet rightDs = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", FIRST_MUL_VALUE}).finish();
        DataSet opResult = leftDs.union(rightDs).distinct();
        return opResult;
    }

    private static DataSet doDivideOnCostCenter(DataSet firstDs, DataSet secondDs) {
        DataSet opResult = firstDs.leftJoin(secondDs).on("costcenter", "costcenter").on("benefcostcenter", "benefcostcenter").select(new String[]{"org", "costcenter", "benefcostcenter", FIRST_DIV_VALUE}).finish();
        return opResult;
    }
}

