/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.calc;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.enums.BillBaseEnum;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.BigDecimalUtils;
import kd.macc.sca.algox.utils.DataSetXHelper;

public class InProduceCostHelper {
    private static final Log logger = LogFactory.getLog(InProduceCostHelper.class);

    public static void importDataByHand(Long orgId, Long costaccountId, List<Long> manuorgId, Long periondId, String progressId) {
        InProduceCostHelper.refreshProgress(ResManager.loadKDString((String)"\u5220\u9664\u672a\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e", (String)"InProduceCostHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]), 1, 6, progressId);
        InProduceCostHelper.deleteInProduceBills(orgId, costaccountId, manuorgId, periondId);
        InProduceCostHelper.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u672c\u671f\u7684\u8ba1\u7b97\u7ed3\u679c\u5355-\u7efc\u5408\u9875\u7b7e\u6570\u636e", (String)"InProduceCostHelper_1", (String)"macc-sca-algox", (Object[])new Object[0]), 2, 6, progressId);
        DataSet calcResultDs = InProduceCostHelper.getCalcResult(orgId, costaccountId, manuorgId, periondId);
        InProduceCostHelper.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u672c\u671f\u7684\u8ba1\u7b97\u7ed3\u679c\u5355-\u672a\u5438\u6536\u9875\u7b7e\u6570\u636e", (String)"InProduceCostHelper_2", (String)"macc-sca-algox", (Object[])new Object[0]), 3, 6, progressId);
        DataSet calcUnabsorbDs = InProduceCostHelper.getCalcUnabsorbResult(orgId, costaccountId, manuorgId, periondId);
        InProduceCostHelper.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u672c\u671f\u672a\u5220\u9664\u7684\u6570\u636e", (String)"InProduceCostHelper_3", (String)"macc-sca-algox", (Object[])new Object[0]), 4, 6, progressId);
        DataSet existsInProduceDs = InProduceCostHelper.getExistsInProductResult(orgId, costaccountId, manuorgId, periondId);
        InProduceCostHelper.refreshProgress(ResManager.loadKDString((String)"\u5408\u5e76\u5dee\u5f02\u6570\u636e", (String)"InProduceCostHelper_4", (String)"macc-sca-algox", (Object[])new Object[0]), 5, 6, progressId);
        DataSet resultDs = InProduceCostHelper.datasetDeal(calcResultDs, calcUnabsorbDs, existsInProduceDs);
        InProduceCostHelper.refreshProgress(ResManager.loadKDString((String)"\u751f\u6210\u5728\u5236\u6210\u672c\u7ed3\u8f6c\u5355", (String)"InProduceCostHelper_5", (String)"macc-sca-algox", (Object[])new Object[0]), 6, 6, progressId);
        InProduceCostHelper.generateInProduceBills(resultDs);
    }

    private static DataSet datasetDeal(DataSet calcResultDs, DataSet calcUnabsorbDs, DataSet existsInProduceDs) {
        JobSession session = AlgoX.createSession((String)"InProduceCostHelper");
        DataSetX calcResultDsX = session.fromInput((Input)new DataSetInput(calcResultDs));
        DataSetX calcUnabsorbDsX = session.fromInput((Input)new DataSetInput(calcUnabsorbDs));
        DataSetX existsInProduceDsX = session.fromInput((Input)new DataSetInput(existsInProduceDs));
        DataSetX elementDsX = session.fromInput((Input)new DataSetInput(InProduceCostHelper.getElementDs()));
        DataSetX resutlDsx = DataSetXHelper.union(calcResultDsX, calcUnabsorbDsX);
        resutlDsx = DataSetXHelper.union(resutlDsx, existsInProduceDsX);
        resutlDsx = resutlDsx.groupBy(new String[]{"org", "costaccount", "costobject", "material", "baseunit", "auxpty", "currency", "costcenter", "manuorg", "period", "element", "subelement", "difftype"}).sum("amount");
        resutlDsx = resutlDsx.filter("amount!=0");
        resutlDsx = resutlDsx.leftJoin(elementDsX).on("subelement", "subelement").select(resutlDsx.getRowMeta().getFieldNames(), new String[]{"elementnum", "subelementnum"});
        resutlDsx = resutlDsx.orderBy(new String[]{"costobject", "difftype", "elementnum", "subelementnum"});
        DataSetOutput resultSet = new DataSetOutput(resutlDsx.getRowMeta());
        resutlDsx.output((Output)resultSet);
        try {
            long start = System.currentTimeMillis();
            session.commit(20, TimeUnit.MINUTES);
            logger.info("\u5dee\u5f02\u5bf9\u6570\u62a5\u8868\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("\u5dee\u5f02\u5bf9\u6570\u62a5\u8868\u51fa\u9519\uff1a", (Throwable)e);
            throw e;
        }
        return session.readDataSet(resultSet.getId());
    }

    public static DataSet getElementDs() {
        return QueryServiceHelper.queryDataSet((String)"cad_elementdetail", (String)"cad_elementdetail", (String)"subelement,subelement.number subelementnum, element,element.number elementnum", null, null);
    }

    private static void deleteInProduceBills(Long orgId, Long costaccountId, List<Long> manuorgId, Long periondId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        if (manuorgId != null) {
            filter.and("manuorg", "in", manuorgId);
        }
        filter.and("period", "=", (Object)periondId);
        filter.and("vouchernum", "in", (Object)new String[]{" ", ""});
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"queryExistInProduceBills", (String)"sca_inproducebill", (String)"id", (QFilter[])filter.toArray(), null);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Row row : resultDs) {
            ids.add(row.getLong("id"));
        }
        long start = System.currentTimeMillis();
        logger.info("\u5728\u5236\u6210\u672c\u7ed3\u8f6c\u5355-\u9700\u8981\u5220\u9664\u7684\u5355\u636e\u6570\u91cf\uff1a{}", (Object)ids.size());
        if (!ids.isEmpty()) {
            List splitLists = Lists.partition(new ArrayList(ids), (int)10000);
            for (List list : splitLists) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sca_inproducebill"), (Object[])list.toArray());
            }
        }
        logger.info("\u5728\u5236\u6210\u672c\u7ed3\u8f6c\u5355-\u5220\u9664\u5355\u636e\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
    }

    private static DataSet getCalcResult(Long orgId, Long costaccountId, List<Long> manuorgId, Long periondId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periondId);
        if (manuorgId != null) {
            filter.and("costobject.manuorg", "in", manuorgId);
        }
        filter.and("entryentity.datatype", "=", (Object)"2");
        filter.and("entryentity.producttype", "=", (Object)"C");
        filter.and("entryentity.pdendamount", "!=", (Object)BigDecimal.ZERO);
        return QueryServiceHelper.queryDataSet((String)"queryCostResultBills_fistpage", (String)"sca_calcresult", (String)InProduceCostHelper.getCalResultQueryFileName(), (QFilter[])filter.toArray(), null);
    }

    private static DataSet getCalcUnabsorbResult(Long orgId, Long costaccountId, List<Long> manuorgId, Long periondId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periondId);
        if (manuorgId != null) {
            filter.and("costobject.manuorg", "in", manuorgId);
        }
        filter.and("unabsorbentry.mfgprotype", "=", (Object)"C");
        filter.and("unabsorbentry.mfgpdendamt", "!=", (Object)BigDecimal.ZERO);
        filter.and("unabsorbentry.mfgtype", "=", (Object)"1");
        return QueryServiceHelper.queryDataSet((String)"queryCostResultBills_unabsorb", (String)"sca_calcresult", (String)InProduceCostHelper.getUnAbsorbQueryFieldName(), (QFilter[])filter.toArray(), null);
    }

    private static DataSet getExistsInProductResult(Long orgId, Long costaccountId, List<Long> manuorgId, Long periondId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periondId);
        if (manuorgId != null) {
            filter.and("manuorg", "in", manuorgId);
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)"queryExistInProduceBills", (String)"sca_inproducebill", (String)InProduceCostHelper.getExistInProduceName(), (QFilter[])filter.toArray(), null);
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(ds.getRowMeta().getFieldNames()));
        fieldNames.remove("amount");
        fieldNames.add("-amount as amount");
        return ds.select(fieldNames.toArray(new String[0]));
    }

    private static void generateInProduceBills(DataSet generateBillDataSet) {
        if (generateBillDataSet == null || generateBillDataSet.isEmpty()) {
            return;
        }
        int count = generateBillDataSet.copy().count("costobject", true);
        if (count == 0) {
            return;
        }
        logger.info("\u5728\u5236\u6210\u672c\u7ed3\u8f6c\u5355-\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u6570\u91cf\uff1a{}", (Object)count);
        String[] billNos = CodeRuleServiceHelper.getBatchNumber((String)"sca_inproducebill", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sca_inproducebill"), (String)"", (int)count);
        HashMap<Long, DynamicObject> resultBillsMap = new HashMap<Long, DynamicObject>(count);
        int useCount = 0;
        while (generateBillDataSet.hasNext()) {
            Row row = generateBillDataSet.next();
            Long costobject = row.getLong("costobject");
            if (CadEmptyUtils.isEmpty((Long)costobject)) continue;
            DynamicObject bill = null;
            boolean isExist = resultBillsMap.containsKey(costobject);
            bill = isExist ? (DynamicObject)resultBillsMap.get(costobject) : BusinessDataServiceHelper.newDynamicObject((String)"sca_inproducebill");
            if (bill == null) continue;
            if (!isExist) {
                bill.set("id", (Object)ID.genLongId());
                bill.set("period", (Object)row.getLong("period"));
                bill.set("org", (Object)row.getLong("org"));
                bill.set("costaccount", (Object)row.getLong("costaccount"));
                bill.set("costobject", (Object)costobject);
                bill.set("costcenter", (Object)row.getLong("costcenter"));
                bill.set("manuorg", (Object)row.getLong("manuorg"));
                bill.set("currency", (Object)row.getLong("currency"));
                bill.set("billno", (Object)billNos[useCount]);
                bill.set("material", (Object)row.getLong("material"));
                bill.set("auxpty", (Object)row.getLong("auxpty"));
                bill.set("unit", (Object)row.getLong("baseunit"));
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                Date date = TimeServiceHelper.now();
                bill.set("billstatus", (Object)BillBaseEnum.BILL_STATUS_AUDITED.getValue());
                bill.set("creator", (Object)userId);
                bill.set("createtime", (Object)date);
                bill.set("modifier", (Object)userId);
                bill.set("modifytime", (Object)date);
                bill.set("auditor", (Object)userId);
                bill.set("auditdate", (Object)date);
                bill.set("sumamount", (Object)BigDecimal.ZERO);
                ++useCount;
            }
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            DynamicObject billEntryRow = entryEntity.addNew();
            billEntryRow.set("element", (Object)row.getLong("element"));
            billEntryRow.set("subelement", (Object)row.getLong("subelement"));
            billEntryRow.set("amount", (Object)BigDecimalUtils.getBigDecimalOrZero(row.getBigDecimal("amount")));
            billEntryRow.set("difftype", (Object)row.getString("difftype"));
            bill.set("sumamount", (Object)bill.getBigDecimal("sumamount").add(billEntryRow.getBigDecimal("amount")));
            resultBillsMap.put(costobject, bill);
        }
        if (!CadEmptyUtils.isEmpty(resultBillsMap)) {
            long start = System.currentTimeMillis();
            SaveServiceHelper.save((DynamicObject[])resultBillsMap.values().toArray(new DynamicObject[0]));
            logger.info("\u5728\u5236\u6210\u672c\u7ed3\u8f6c\u5355-\u4fdd\u5b58\u5355\u636e\u6570\uff1a{}\uff0c\u8017\u65f6\uff1a{}", (Object)resultBillsMap.size(), (Object)(System.currentTimeMillis() - start));
        }
    }

    private static String getCalResultQueryFileName() {
        return "org,costaccount,costobject,costobject.material material,costobject.material.baseunit baseunit,costobject.auxpty auxpty,currency,costcenter,costobject.manuorg as manuorg,period,entryentity.element as element,entryentity.subelement as subelement,entryentity.pdendamount as amount,entryentity.difftype as difftype";
    }

    private static String getUnAbsorbQueryFieldName() {
        return "org,costaccount,costobject,costobject.material material,costobject.material.baseunit baseunit,costobject.auxpty auxpty,currency,costcenter,costobject.manuorg as manuorg,period,unabsorbentry.mfgelement as element,unabsorbentry.mfgsubelement as subelement,unabsorbentry.mfgpdendamt as amount,'4' as difftype";
    }

    private static String getExistInProduceName() {
        return "org,costaccount,costobject,costobject.material material,costobject.material.baseunit baseunit,costobject.auxpty auxpty,currency,costcenter,manuorg,period,entryentity.element as element,entryentity.subelement as subelement,entryentity.amount as amount,entryentity.difftype as difftype";
    }

    private static void refreshProgress(String opContent, int nowComplete, int total, String progressId) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        paramDto.setComplete(Integer.valueOf(nowComplete));
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"InProduceCostHelper_6", (String)"macc-sca-algox", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
    }
}

