/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.calc.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.alloc.function.AbstractCalcFunction;
import kd.macc.sca.algox.alloc.input.CalcMatCol;
import kd.macc.sca.algox.alloc.input.CostDiffRecord;
import kd.macc.sca.algox.alloc.input.DiffMatRecord;
import kd.macc.sca.algox.alloc.input.DirrectCalcMatCol;
import kd.macc.sca.algox.alloc.input.PublicCalcMatCol;
import kd.macc.sca.algox.alloc.input.SubMatWeight;
import kd.macc.sca.algox.utils.DiffCalcResultHelper;

@Deprecated
public class DiffAllocDealFunction
extends AbstractCalcFunction {
    private static final long serialVersionUID = 5L;
    private static final Log logger = LogFactory.getLog(DiffAllocDealFunction.class);
    private static Integer currencyPrecision = 2;

    @Override
    public RowMeta getResultRowMeta() {
        Field[] fields = new Field[]{new Field("costaccount", (DataType)DataType.LongType), new Field("org", (DataType)DataType.LongType), new Field("bizbillid", (DataType)DataType.LongType), new Field("bizbillentryid", (DataType)DataType.LongType), new Field("material", (DataType)DataType.LongType), new Field("mversion", (DataType)DataType.LongType), new Field("assist", (DataType)DataType.LongType), new Field("adjustamt", (DataType)DataType.BigDecimalType), new Field("costelement", (DataType)DataType.LongType), new Field("costsubelement", (DataType)DataType.LongType)};
        return new RowMeta(fields);
    }

    @Override
    protected Collection<DynamicObject> doCalculate(Iterable<RowX> iterable) {
        return null;
    }

    public void calculate(DataSet costRecord) {
        Map<DiffMatRecord, Set<CostDiffRecord>> costdiffData = this.getCostRecordData(costRecord);
        Map<String, Map<CalcMatCol, Set<DiffMatRecord>>> matCols = this.getMatCol(costdiffData);
        this.doMatAlloc(costdiffData, matCols);
    }

    private void doMatAlloc(Map<DiffMatRecord, Set<CostDiffRecord>> costdiffData, Map<String, Map<CalcMatCol, Set<DiffMatRecord>>> matCols) {
        DynamicObject dyo;
        Set<CostDiffRecord> diffcostelmentdata;
        ArrayList<DynamicObject> dyos = new ArrayList<DynamicObject>(10);
        currencyPrecision = this.args.getCurrency().getInt("amtprecision");
        Map<CalcMatCol, Set<DiffMatRecord>> dirrectCalcMatCol = matCols.get("dirrect");
        Map<CalcMatCol, Set<DiffMatRecord>> publicCalcMatCol = matCols.get("public");
        logger.info("\u5f00\u59cb\u76f4\u63a5\u6750\u6599\u5dee\u5f02\u8d39\u7528\u5206\u914d");
        for (Map.Entry<CalcMatCol, Set<DiffMatRecord>> entry : dirrectCalcMatCol.entrySet()) {
            Set<DiffMatRecord> diffMatRecords = entry.getValue();
            DirrectCalcMatCol dirrectMatCols = (DirrectCalcMatCol)entry.getKey();
            for (DiffMatRecord diffMatRecord : diffMatRecords) {
                diffcostelmentdata = costdiffData.get(diffMatRecord);
                dyo = this.createDiffAllocBillHead(diffMatRecord, dirrectMatCols);
                this.createDiffAllocBillEntry(diffcostelmentdata, dirrectMatCols, dyo);
                if (dyo.getDynamicObjectCollection("entryentity") == null) continue;
                dyos.add(dyo);
            }
        }
        logger.info("\u5f00\u59cb\u5171\u8017\u6750\u6599\u5dee\u5f02\u8d39\u7528\u5206\u914d");
        if (!publicCalcMatCol.isEmpty()) {
            for (Map.Entry<CalcMatCol, Set<DiffMatRecord>> entry : publicCalcMatCol.entrySet()) {
                PublicCalcMatCol publicMatCol = (PublicCalcMatCol)entry.getKey();
                Set<DiffMatRecord> diffMatRecords = entry.getValue();
                for (DiffMatRecord diffMatRecord : diffMatRecords) {
                    diffcostelmentdata = costdiffData.get(diffMatRecord);
                    dyo = this.createDiffAllocBillHead(diffMatRecord, publicMatCol);
                    this.createPublicMatDiffAllocBillEntry(diffcostelmentdata, publicMatCol, dyo);
                    if (dyo.getDynamicObjectCollection("entryentity") == null) continue;
                    dyos.add(dyo);
                }
            }
        }
        if (dyos.size() > 0) {
            List<List<DynamicObject>> splitList = DiffCalcResultHelper.splitList(dyos, 1000);
            for (List<DynamicObject> datas : splitList) {
                SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
            }
        }
        logger.info("\u751f\u6210\u5dee\u5f02\u5206\u914d\u5355\u6210\u529f");
    }

    protected Map<String, List<SubMatWeight>> getCostSubMatWeightData() {
        QFilter costAccount = new QFilter("costaccount.id", "=", (Object)this.args.getCostAccount());
        QFilter orgId = new QFilter("org.id", "=", (Object)this.args.getOrgId());
        String algoKey = "kd.macc.sca.algox.calc.function.DiffAllocDealFunction.getCostSubMatWeightData";
        String selectFields = "period.id as periodid,material.id material,version.id version,auxpty.id auxpty,difftype,entryentity,entryentity.element.id element,entryentity.subelement.id subelement,entryentity.subentryentity.lastmaterial AS lastmaterial,entryentity.subentryentity.lastversion AS lastversion,entryentity.subentryentity.lastauxpty lastauxpty,entryentity.subentryentity.weightvalue AS weightvalue";
        QFilter[] filters = new QFilter[]{orgId, costAccount};
        DataSet subMatds = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_costmatitemscale", (String)selectFields, (QFilter[])filters, (String)"period.id desc");
        logger.info("##############selectFields\u7684\u503c\uff1a" + selectFields);
        HashMap<String, List<SubMatWeight>> wmap = new HashMap<String, List<SubMatWeight>>();
        HashMap<Long, Long> matPeriodMap = new HashMap<Long, Long>(16);
        for (Row row : subMatds) {
            if (matPeriodMap.containsKey(row.getLong("material")) && ((Long)matPeriodMap.get(row.getLong("material"))).compareTo(row.getLong("periodid")) != 0) continue;
            matPeriodMap.put(row.getLong("material"), row.getLong("periodid"));
            logger.info("##############matPeriodMap\u7684size\uff1a" + matPeriodMap.size());
            Long materialId = row.getLong("material");
            Long versionId = row.getLong("version");
            Long auxptyId = row.getLong("auxpty");
            String difftype = row.getString("difftype");
            Long elementId = row.getLong("element");
            Long subelementId = row.getLong("subelement");
            Long lastmaterialId = row.getLong("lastmaterial");
            Long lastversionId = row.getLong("lastversion");
            Long lastauxptyId = row.getLong("lastauxpty");
            BigDecimal weightvalue = row.getBigDecimal("weightvalue");
            SubMatWeight smw = new SubMatWeight();
            smw.setLastMaterial(lastmaterialId);
            smw.setLastVersion(lastversionId);
            smw.setLastAuxpty(lastauxptyId);
            smw.setWeightValue(weightvalue);
            String wkey = materialId + "&" + versionId + "&" + auxptyId + "&" + difftype + "&" + elementId + "&" + subelementId;
            ArrayList<SubMatWeight> list = (ArrayList<SubMatWeight>)wmap.get(wkey);
            if (list != null) {
                list.add(smw);
            } else {
                list = new ArrayList<SubMatWeight>();
                list.add(smw);
            }
            wmap.put(wkey, list);
        }
        return wmap;
    }

    protected DynamicObject createDiffAllocBillHead(DiffMatRecord diffMatRecord, CalcMatCol matCols) {
        CalcMatCol dirrectCalcMatCols;
        Object costcenter = null;
        if (matCols instanceof DirrectCalcMatCol) {
            dirrectCalcMatCols = (DirrectCalcMatCol)matCols;
            costcenter = ((DirrectCalcMatCol)dirrectCalcMatCols).getCostCenter();
        } else {
            dirrectCalcMatCols = (PublicCalcMatCol)matCols;
            costcenter = ((PublicCalcMatCol)dirrectCalcMatCols).getCostCenter();
        }
        DynamicObject diffallocObj = BusinessDataServiceHelper.newDynamicObject((String)"sca_purchdiffalloc");
        diffallocObj.set("period", (Object)this.args.getPeriod());
        diffallocObj.set("org", (Object)this.args.getOrgId());
        diffallocObj.set("costaccount", (Object)this.args.getCostAccount());
        diffallocObj.set("currency", (Object)this.args.getCurrency());
        diffallocObj.set("costcenter", costcenter);
        diffallocObj.set("material", (Object)diffMatRecord.getMaterial());
        diffallocObj.set("version", (Object)0L);
        diffallocObj.set("auxpty", (Object)0L);
        diffallocObj.set("difftype", (Object)diffMatRecord.getCreatetype());
        diffallocObj.set("difftotal", (Object)diffMatRecord.getAdjustamt());
        diffallocObj.set("billstatus", (Object)"C");
        String userId = RequestContext.get().getUserId();
        diffallocObj.set("createtime", (Object)new Date());
        diffallocObj.set("creator", (Object)userId);
        diffallocObj.set("modifier", (Object)userId);
        diffallocObj.set("modifytime", (Object)new Date());
        diffallocObj.set("auditor", (Object)userId);
        diffallocObj.set("auditdate", (Object)new Date());
        diffallocObj.set("billno", (Object)this.genNumber(diffMatRecord));
        return diffallocObj;
    }

    protected String genNumber(DiffMatRecord diffMatRecord) {
        int seq = Integer.parseInt(diffMatRecord.getEntryseq().toString());
        seq = seq == 0 ? 1 : seq;
        String number = diffMatRecord.getBillno() + "_" + seq;
        return number;
    }

    private void createDiffAllocBillEntry(Set<CostDiffRecord> diffcostelmentdata, DirrectCalcMatCol dirrectMatCols, DynamicObject dyo) {
        DynamicObjectCollection allocEntry = dyo.getDynamicObjectCollection("entryentity");
        for (CostDiffRecord costDiffRecord : diffcostelmentdata) {
            DynamicObject allocObj = new DynamicObject(allocEntry.getDynamicObjectType());
            Object costObjid = dirrectMatCols.getCostObject();
            BigDecimal subadjustamt = costDiffRecord.getSubAdjustamt();
            if (currencyPrecision != null) {
                subadjustamt = subadjustamt.setScale((int)currencyPrecision, RoundingMode.HALF_UP);
            }
            allocObj.set("costobject", costObjid);
            allocObj.set("element", (Object)costDiffRecord.getCostElement());
            allocObj.set("subelement", (Object)costDiffRecord.getCostSubElement());
            allocObj.set("amount", (Object)subadjustamt);
            allocEntry.add((Object)allocObj);
        }
    }

    protected void createDiffAllocSubEntry(DynamicObject dyo, BigDecimal adjustamt, DynamicObjectCollection subdyos, List<SubMatWeight> subentryds) {
        if (subentryds == null) {
            DynamicObject subdyo = new DynamicObject(subdyos.getDynamicObjectType());
            subdyo.set("lastmaterial", dyo.get("material"));
            subdyo.set("lastversion", (Object)0L);
            subdyo.set("lastauxpty", (Object)0L);
            subdyo.set("adjamount", (Object)adjustamt);
            subdyo.set("weightvalue", (Object)BigDecimal.ONE);
        } else {
            BigDecimal totalSubCalcAmt = BigDecimal.ZERO;
            BigDecimal maxCalcAmt = null;
            DynamicObject maxdyo = null;
            for (SubMatWeight smw : subentryds) {
                Object lastmaterialid = smw.getLastMaterial();
                Object lastversion = smw.getLastVersion();
                Object lastauxpty = smw.getLastAuxpty();
                BigDecimal weightvalue = smw.getWeightValue();
                BigDecimal calcamt = weightvalue.multiply(adjustamt).setScale((int)currencyPrecision, RoundingMode.HALF_UP);
                DynamicObject subdyo = new DynamicObject(subdyos.getDynamicObjectType());
                subdyo.set("lastmaterial", lastmaterialid);
                subdyo.set("lastversion", lastversion);
                subdyo.set("lastauxpty", lastauxpty);
                subdyo.set("weightvalue", (Object)weightvalue);
                subdyo.set("adjamount", (Object)calcamt);
                totalSubCalcAmt = totalSubCalcAmt.add(calcamt);
                subdyos.add((Object)subdyo);
                if (maxCalcAmt != null && maxCalcAmt.compareTo(calcamt) >= 0) continue;
                maxCalcAmt = calcamt;
                maxdyo = subdyo;
            }
            if (maxdyo == null) {
                return;
            }
            if (adjustamt.compareTo(totalSubCalcAmt) != 0) {
                BigDecimal diffamt = adjustamt.subtract(totalSubCalcAmt);
                maxdyo.set("adjamount", (Object)maxdyo.getBigDecimal("adjamount").add(diffamt));
            }
        }
    }

    private void createPublicMatDiffAllocBillEntry(Set<CostDiffRecord> diffcostelmentdata, PublicCalcMatCol publicMatCol, DynamicObject dyo) {
        QFilter fmaterial;
        String selectFields = "entryentity,entryentity.costobejctentry AS costobejctentry,entryentity.qty AS qty,entryentity.subentryentity";
        QFilter fmatCol = new QFilter("matcollect", "in", (Object)publicMatCol.getEntryId());
        Map matAllocData = BusinessDataServiceHelper.loadFromCache((String)"sca_matalloc", (String)selectFields, (QFilter[])new QFilter[]{fmatCol, fmaterial = new QFilter("material", "=", (Object)publicMatCol.getMaterial())});
        if (null == matAllocData || matAllocData.size() == 0) {
            String error = String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u5b58\u5728\u5dee\u5f02\u5f52\u96c6\u5355\u636e\uff0c\u4f46\u672c\u671f\u4e0d\u5b58\u5728\u6750\u6599\u8d39\u7528\u5206\u914d\u6570\u636e\uff0c\u5dee\u5f02\u5206\u914d\u4e0d\u6210\u529f\u3002", (String)"DiffAllocDealFunction_2", (String)"macc-sca-algox", (Object[])new Object[0]), publicMatCol.getMaterial());
            throw new KDBizException(error);
        }
        Collection matAlloc = matAllocData.values();
        HashMap<Object, BigDecimal> costMaterialMap = new HashMap<Object, BigDecimal>();
        BigDecimal totalQty = BigDecimal.ZERO;
        for (DynamicObject mat : matAlloc) {
            DynamicObjectCollection allocentry = mat.getDynamicObjectCollection("entryentity");
            for (DynamicObject en : allocentry) {
                BigDecimal qty = en.getBigDecimal("qty");
                DynamicObject costObject = en.getDynamicObject("costobejctentry");
                BigDecimal result = costMaterialMap.computeIfAbsent(costObject.getPkValue(), v -> BigDecimal.ZERO).add(qty);
                costMaterialMap.put(costObject.getPkValue(), result);
                totalQty = totalQty.add(qty);
            }
        }
        HashMap totalAllocedDiffAmt = new HashMap(16);
        HashMap totalDiffAmt = new HashMap(16);
        HashMap maxDiffAmt = new HashMap(16);
        HashMap adjustdyo = new HashMap(16);
        for (Map.Entry centry : costMaterialMap.entrySet()) {
            DynamicObjectCollection allocEntry = dyo.getDynamicObjectCollection("entryentity");
            Object costObjId = centry.getKey();
            BigDecimal standardQty = (BigDecimal)centry.getValue();
            BigDecimal weighValue = standardQty.divide(totalQty, 10, RoundingMode.HALF_UP);
            diffcostelmentdata.forEach(dm -> {
                BigDecimal adjustamt = dm.getAdjustamt();
                BigDecimal amountUsage = weighValue.multiply(adjustamt).setScale((int)currencyPrecision, RoundingMode.HALF_UP);
                DynamicObject allocObj = new DynamicObject(allocEntry.getDynamicObjectType());
                allocObj.set("costobject", costObjId);
                allocObj.set("element", (Object)dm.getCostElement());
                allocObj.set("subelement", (Object)dm.getCostSubElement());
                allocObj.set("amount", (Object)amountUsage);
                allocObj.set("difamount", (Object)adjustamt);
                allocObj.set("weighvalue", (Object)weighValue);
                Long costElement = dm.getCostElement();
                BigDecimal elementSum = totalAllocedDiffAmt.computeIfAbsent(costElement, v -> BigDecimal.ZERO).add(amountUsage);
                totalAllocedDiffAmt.put(costElement, elementSum);
                totalDiffAmt.put(costElement, adjustamt);
                if (maxDiffAmt.containsKey(costElement)) {
                    BigDecimal maxEleDiffAmt = (BigDecimal)maxDiffAmt.get(costElement);
                    if (amountUsage.compareTo(maxEleDiffAmt) > 0) {
                        maxDiffAmt.put(costElement, amountUsage);
                        adjustdyo.put(costElement, allocObj);
                    }
                } else {
                    maxDiffAmt.put(costElement, amountUsage);
                    adjustdyo.put(costElement, allocObj);
                }
                allocEntry.add((Object)allocObj);
            });
            for (Map.Entry tdentry : totalDiffAmt.entrySet()) {
                BigDecimal allocedAmt;
                Object costelem = tdentry.getKey();
                BigDecimal totalAmt = (BigDecimal)tdentry.getValue();
                if (totalAmt.compareTo(allocedAmt = (BigDecimal)totalAllocedDiffAmt.get(costelem)) == 0) continue;
                BigDecimal adjamt = totalAmt.subtract(allocedAmt);
                DynamicObject dynamicObject = (DynamicObject)adjustdyo.get(costelem);
                Optional<Object> elemdiffamt = Optional.ofNullable(dynamicObject.get("amount"));
                if (!elemdiffamt.isPresent()) continue;
                dynamicObject.set("amount", (Object)((BigDecimal)elemdiffamt.get()).add(adjamt));
                this.reCalcPublicDiffSubEntry(dynamicObject);
            }
        }
    }

    private Map<String, Map<CalcMatCol, Set<DiffMatRecord>>> getMatCol(Map<DiffMatRecord, Set<CostDiffRecord>> costdiffData) {
        HashSet<Long> bizBillIds = new HashSet<Long>(16);
        HashMap<CalcMatCol, Set> dirrectMatCols = new HashMap<CalcMatCol, Set>(16);
        HashMap<CalcMatCol, Set> publicMatCols = new HashMap<CalcMatCol, Set>(16);
        HashMap<String, Map<CalcMatCol, Set<DiffMatRecord>>> matCols = new HashMap<String, Map<CalcMatCol, Set<DiffMatRecord>>>(16);
        HashMap<String, Set> refmap = new HashMap<String, Set>(16);
        for (DiffMatRecord diffMatRecord : costdiffData.keySet()) {
            Long bizBillId = diffMatRecord.getBizBillId();
            Long bizBillEntryId = diffMatRecord.getBizBillEntryId();
            bizBillIds.add(bizBillId);
            String key = bizBillId + ";" + bizBillEntryId;
            refmap.computeIfAbsent(key, v -> new HashSet()).add(diffMatRecord);
        }
        String algoKey = "kd.macc.sca.algox.calc.function.DiffAllocDealFunction.getMatCol";
        String selectFields = "id,entryentity.id AS entryentityid,entryentity.material.masterid AS material,entryentity.matversion AS matversion,entryentity.auxpty AS auxpty,sourcebillid,costcenter.id AS costcenter,entryentity.sourcebillentryid AS sourcebillentryid,entryentity.costobject AS costObject ";
        QFilter qfSourceBill = new QFilter("sourcebillid", "in", bizBillIds);
        Date enddateafter = DateUtils.addDays((Date)this.args.getEndDate(), (int)1);
        QFilter orgId = new QFilter("org", "=", (Object)this.args.getOrgId());
        QFilter startDate = new QFilter("bookdate", ">=", (Object)this.args.getStartDate());
        QFilter endData = new QFilter("bookdate", "<", (Object)enddateafter);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)Character.valueOf('C'));
        DataSet matCol = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sca_matusecollect", (String)selectFields, (QFilter[])new QFilter[]{qfSourceBill, orgId, startDate, endData, statusFilter}, null);
        for (Row row : matCol) {
            Set diffMatRecords;
            CalcMatCol calcMatCol;
            Long costObject = row.getLong("costObject");
            Long sourcebillid = row.getLong("sourcebillid");
            Long sourcebillentryid = row.getLong("sourcebillentryid");
            Long material = row.getLong("material");
            Long matversion = row.getLong("matversion");
            Long auxpty = row.getLong("auxpty");
            if (costObject > 0L) {
                calcMatCol = new DirrectCalcMatCol();
                calcMatCol.setBizBill(row.getLong("sourcebillid"));
                calcMatCol.setBizBillEntry(row.getLong("sourcebillentryid"));
                calcMatCol.setId(row.getLong("id"));
                calcMatCol.setEntryId(row.getLong("entryentityid"));
                calcMatCol.setMaterial(material);
                ((DirrectCalcMatCol)calcMatCol).setMversion(matversion);
                ((DirrectCalcMatCol)calcMatCol).setAssist(auxpty);
                ((DirrectCalcMatCol)calcMatCol).setCostObject(costObject);
                ((DirrectCalcMatCol)calcMatCol).setCostCenter(row.getLong("costcenter"));
                diffMatRecords = (Set)refmap.get(sourcebillid + ";" + sourcebillentryid);
                if (diffMatRecords == null) continue;
                dirrectMatCols.put(calcMatCol, diffMatRecords);
                continue;
            }
            calcMatCol = new PublicCalcMatCol();
            calcMatCol.setBizBill(row.getLong("sourcebillid"));
            calcMatCol.setBizBillEntry(row.getLong("sourcebillentryid"));
            calcMatCol.setId(row.getLong("id"));
            calcMatCol.setEntryId(row.getLong("entryentityid"));
            calcMatCol.setMaterial(row.getLong("material"));
            ((PublicCalcMatCol)calcMatCol).setMversion(matversion);
            ((PublicCalcMatCol)calcMatCol).setAssist(auxpty);
            ((PublicCalcMatCol)calcMatCol).setCostCenter(row.getLong("costcenter"));
            diffMatRecords = (Set)refmap.get(sourcebillid + ";" + sourcebillentryid);
            if (diffMatRecords == null) continue;
            publicMatCols.put(calcMatCol, diffMatRecords);
        }
        matCols.put("dirrect", dirrectMatCols);
        matCols.put("public", publicMatCols);
        return matCols;
    }

    private Map<DiffMatRecord, Set<CostDiffRecord>> getCostRecordData(DataSet costRecord) {
        HashMap<String, DiffMatRecord> drs = new HashMap<String, DiffMatRecord>(16);
        HashMap<DiffMatRecord, Set<CostDiffRecord>> rtmap = new HashMap<DiffMatRecord, Set<CostDiffRecord>>(16);
        for (Row row : costRecord) {
            CostDiffRecord record = new CostDiffRecord();
            Long id = row.getLong("id");
            Long entryid = row.getLong("entryid");
            Long costaccount = row.getLong("costaccount");
            Long org = row.getLong("org");
            Long material = row.getLong("material");
            Long mversion = row.getLong("mversion");
            Long assist = row.getLong("assist");
            String createtype = row.getString("createtype");
            Long bizbillid = row.getLong("bizbillid");
            String billno = row.getString("billno");
            Object entryseq = row.get("entryseq");
            Long bizbillentryid = row.getLong("bizbillentryid");
            BigDecimal adjustamt = row.getBigDecimal("adjustamt");
            String key = id + ";" + entryid + ";" + costaccount + ";" + org + ";" + material + ";" + mversion + ";" + assist + ";" + createtype + ";" + bizbillid;
            record.setCostAccount(row.getLong("costaccount"));
            record.setOrg(org);
            record.setBizBillId(bizbillid);
            record.setBizBillEntryId(bizbillentryid);
            record.setMaterial(material);
            record.setMversion(mversion);
            record.setAssist(assist);
            record.setAdjustamt(row.getBigDecimal("adjustamt"));
            record.setCostElement(row.getLong("costelement"));
            record.setCostSubElement(row.getLong("costsubelement"));
            record.setElementProp(row.getString("elementProp"));
            record.setSubelementProp(row.getString("subelementProp"));
            record.setSubAdjustamt(row.getBigDecimal("subadjustamt"));
            record.setId(id);
            record.setCreatetype(createtype);
            if (!drs.containsKey(key)) {
                DiffMatRecord diffMatRecord = new DiffMatRecord();
                diffMatRecord.setCostAccount(costaccount);
                diffMatRecord.setOrg(org);
                diffMatRecord.setMaterial(material);
                diffMatRecord.setMversion(mversion);
                diffMatRecord.setAssist(assist);
                diffMatRecord.setAdjustamt(adjustamt);
                diffMatRecord.setId(id);
                diffMatRecord.setCreatetype(createtype);
                diffMatRecord.setBizBillEntryId(bizbillentryid);
                diffMatRecord.setBizBillId(bizbillid);
                diffMatRecord.setBillno(billno);
                diffMatRecord.setEntryseq(entryseq);
                HashSet<CostDiffRecord> costRecords = new HashSet<CostDiffRecord>(16);
                costRecords.add(record);
                drs.put(key, diffMatRecord);
                rtmap.put(diffMatRecord, costRecords);
                continue;
            }
            DiffMatRecord diffrc = (DiffMatRecord)drs.get(key);
            ((Set)rtmap.get(diffrc)).add(record);
        }
        return rtmap;
    }

    protected void reCalcPublicDiffSubEntry(DynamicObject dynamicObject) {
        DynamicObjectCollection matsubentryentity = dynamicObject.getDynamicObjectCollection("subentryentity");
        for (DynamicObject subdyo : matsubentryentity) {
            BigDecimal weightvalue = subdyo.getBigDecimal("weightvalue");
            BigDecimal amount = dynamicObject.getBigDecimal("amount");
            subdyo.set("adjamount", (Object)weightvalue.multiply(amount).setScale((int)currencyPrecision, RoundingMode.HALF_UP));
        }
    }
}

